/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.tptp.platform.agentcontroller.internal.Connection;
import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.BaseConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.BaseServerConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.DirectControlConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.DirectDataConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.NamedPipeConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.QueueFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.SharedMemoryConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.SocketControlConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.SocketDataConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.SocketServerConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class ConnectionFactoryImpl {
    private static int _numDirectControlConnections = 0;
    private static int _numDirectDataConnections = 0;
    private static Hashtable _connections = new Hashtable();

    public static DirectControlConnectionImpl createDirectControlConnection() {
        DirectControlConnectionImpl connection = new DirectControlConnectionImpl(_numDirectControlConnections++, QueueFactoryImpl.getInputControlQueue());
        connection.create();
        connection.setQueue(QueueFactoryImpl.getInputControlQueue());
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static DirectDataConnectionImpl createDirectDataConnection() {
        DirectDataConnectionImpl connection = new DirectDataConnectionImpl(_numDirectDataConnections++);
        connection.create();
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static NamedPipeConnectionImpl createNamedPipeConnection(String name, boolean isReader) {
        Queue queue = null;
        if (isReader) {
            queue = QueueFactoryImpl.getInputControlQueue();
        }
        NamedPipeConnectionImpl connection = new NamedPipeConnectionImpl(name, queue, isReader);
        connection.create();
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static SocketServerConnectionImpl createSocketServerConnection(int port) {
        SocketServerConnectionImpl connection = new SocketServerConnectionImpl(port);
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static SharedMemoryConnectionImpl createSharedMemoryConnection(String name, boolean isReader) {
        SharedMemoryConnectionImpl connection = new SharedMemoryConnectionImpl(name, null, isReader);
        connection.create();
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static SocketControlConnectionImpl createSocketControlConnection(String host, int port) {
        SocketControlConnectionImpl connection = new SocketControlConnectionImpl(host, port);
        connection.create();
        connection.setQueue(QueueFactoryImpl.getInputControlQueue());
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static SocketControlConnectionImpl createSocketControlConnection(Socket socket) {
        SocketControlConnectionImpl connection = new SocketControlConnectionImpl(socket);
        connection.create();
        connection.setQueue(QueueFactoryImpl.getInputControlQueue());
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static SocketDataConnectionImpl createSocketDataConnection() {
        SocketDataConnectionImpl connection = new SocketDataConnectionImpl();
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static SocketDataConnectionImpl createSocketDataConnection(int port) {
        SocketDataConnectionImpl connection = new SocketDataConnectionImpl(port);
        connection.create();
        _connections.put(connection.getConnectionId(), connection);
        return connection;
    }

    public static Connection getConnection(String id) {
        if (_connections.containsKey(id)) {
            return (Connection)_connections.get(id);
        }
        return null;
    }

    public static void removeConnection(String id) {
        if (id != null && _connections.containsKey(id)) {
            _connections.remove(id);
        }
    }

    public static void startAll() {
        Enumeration connections = _connections.elements();
        while (connections.hasMoreElements()) {
            Connection connection = (Connection)connections.nextElement();
            if (connection instanceof BaseConnectionImpl) {
                ((BaseConnectionImpl)connection).start();
                continue;
            }
            if (!(connection instanceof BaseServerConnectionImpl)) continue;
            ((BaseServerConnectionImpl)connection).start();
        }
    }

    public static void stopAll() {
        Enumeration connections = _connections.elements();
        while (connections.hasMoreElements()) {
            Connection connection = (Connection)connections.nextElement();
            TPTPLoggerImpl.log(3, "Destroying connection: " + connection.getConnectionId());
            connection.destroyConnection();
        }
        _connections.clear();
    }
}

