/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import org.eclipse.jst.j2ee.internal.J2EEStatus;

public class J2EEMultiStatus
extends J2EEStatus {
    private J2EEStatus[] children = new J2EEStatus[0];

    public void add(J2EEStatus status) {
        J2EEStatus[] result = new J2EEStatus[this.children.length + 1];
        System.arraycopy(this.children, 0, result, 0, this.children.length);
        result[result.length - 1] = status;
        this.children = result;
        int newSev = status.getSeverity();
        int currentSev = this.getSeverity();
        if (this.children.length == 1) {
            this.setSeverity(newSev);
        } else if (currentSev > 0 && currentSev < 3 && newSev == 0) {
            this.setSeverity(newSev);
        } else if (newSev > currentSev && (currentSev != 0 || newSev >= 3)) {
            this.setSeverity(newSev);
        }
    }

    public void addAll(J2EEStatus status) {
        if (status == null) {
            return;
        }
        J2EEStatus[] statuses = status.getChildren();
        for (int i = 0; i < statuses.length; ++i) {
            this.add(statuses[i]);
        }
    }

    public J2EEStatus[] getChildren() {
        return this.children;
    }

    public boolean isMultiStatus() {
        return true;
    }

    public void merge(J2EEStatus status) {
        if (status == null) {
            return;
        }
        if (!status.isMultiStatus()) {
            this.add(status);
        } else {
            this.addAll(status);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" children={");
        for (int i = 0; i < this.children.length; ++i) {
            if (i != 0) {
                buf.append("\n");
            }
            buf.append(this.children[i].toString());
        }
        buf.append("}");
        return buf.toString();
    }

    public J2EEStatus append(J2EEStatus aStatus) {
        if (aStatus != null) {
            this.merge(aStatus);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.children.length == 0;
    }
}

