/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;

public class ObjectInputStreamCustomResolver
extends ObjectInputStream {
    private ClassLoader cl;

    public ObjectInputStreamCustomResolver(InputStream is, ClassLoader loader) throws IOException, StreamCorruptedException {
        super(is);
        if (loader != null) {
            this.cl = loader;
        }
    }

    private Class getType(char type) {
        switch (type) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        String className = classDesc.getName();
        if (className.startsWith("[")) {
            Class<?> component2 = null;
            int dimNum = 1;
            while (className.charAt(dimNum) == '[') {
                if (className.charAt(dimNum) == 'L') {
                    component2 = this.cl.loadClass(className.substring(dimNum + 1, className.length() - 1));
                } else {
                    if (className.length() != dimNum + 1) {
                        throw new ClassNotFoundException(className);
                    }
                    component2 = this.getType(className.charAt(dimNum));
                }
                ++dimNum;
            }
            int[] dimensions = new int[dimNum];
            for (int i = 0; i < dimNum; ++i) {
                dimensions[i] = 0;
            }
            return Array.newInstance(component2, dimensions).getClass();
        }
        return this.cl.loadClass(className);
    }
}

