/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ConnectorModule;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.JavaClientModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootEJBJarDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootWarDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.Ear50NoDDSaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseModule;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigFactory;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigPackage;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class Ear50NoDDImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    private static final String className = Ear50NoDDImportStrategyImpl.class.getName();
    private static final boolean IS_EJB_MODULE = true;
    private static final String SEPARATOR = System.getProperty("file.separator");
    protected static Discriminator discriminator;

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return Ear50NoDDImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public EARFile getEARFile() {
        return (EARFile)this.getArchive();
    }

    public boolean isNoDDStrategy() {
        return true;
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    protected boolean allowNullResource() {
        return true;
    }

    public void loadDeploymentDescriptor() throws Exception {
        String methodName = "loadDeploymentDescriptor";
        String displayName = this.archive.getName();
        logger.logp(Level.FINER, className, methodName, "ENTRY Creating an application.xml for EAR [ {0} ]", displayName);
        ApplicationFactory appFactory = ApplicationFactory.eINSTANCE;
        Application app = appFactory.createApplication();
        app.setVersion("5");
        EARFile earFile = this.getEARFile();
        XMLResource resource = (XMLResource)earFile.makeDeploymentDescriptorResource();
        resource.setModuleVersionID(50);
        XMLResource xmlRes = (XMLResource)earFile.eResource();
        if (xmlRes != null) {
            xmlRes.setModuleVersionID(50);
        }
        this.versionCheck(app);
        EList modules = app.getModules();
        if (displayName.endsWith(".ear")) {
            displayName = displayName.substring(0, displayName.length() - 4);
        }
        app.setDisplayName(displayName);
        earFile.setDeploymentDescriptor(app);
        earFile.setGeneratedDD(true);
        Ear50NoDDSaveFilter saveFilter = new Ear50NoDDSaveFilter();
        earFile.setSaveFilter(saveFilter);
        LoadStrategy loadStrategy = earFile.getLoadStrategy();
        LooseApplication looseApplication = (LooseApplication)loadStrategy.getLooseArchive();
        boolean isLooseApplication = looseApplication != null;
        String earBinariesPath = null;
        logger.logp(Level.FINER, className, methodName, "loose application [ {0} ] ", Boolean.toString(isLooseApplication));
        try {
            earBinariesPath = this.getEARFile().getBinariesPath();
            logger.logp(Level.FINER, className, methodName, "EAR binaries path [ {0} ]", earBinariesPath);
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.FINER, className, methodName, "Ignoring FileNotFoundException while getting EAR's binaries path");
        }
        ArchiveTypeDiscriminator ejbDiscriminator = RootEJBJarDescriminatorImpl.singleton();
        ArchiveTypeDiscriminator warDiscriminator = RootWarDescriminatorImpl.singleton();
        List archiveList = earFile.getArchiveFiles();
        for (Archive a : archiveList) {
            String name = a.getURI();
            logger.logp(Level.FINER, className, methodName, "Examining archive [ {0} ]", a);
            if (name.startsWith("lib/")) {
                logger.logp(Level.FINER, className, methodName, "Skipping archive [ {0} ] as modules can't be in lib directory", a);
                continue;
            }
            if (name.endsWith(".jar")) {
                if (ejbDiscriminator.canImport(a)) {
                    EjbModule ejbMod = appFactory.createEjbModule();
                    ejbMod.setUri(name);
                    ejbMod.setApplication(app);
                    modules.add(ejbMod);
                    if (isLooseApplication) {
                        this.setLooseArchive(true, earBinariesPath, looseApplication, a.getLoadStrategy(), ejbMod);
                    }
                    logger.logp(Level.FINER, className, methodName, "Added archive [ {0} ] to list of EJB Modules", a);
                    logger.logp(Level.FINER, className, methodName, "Container for EJB Module is [ {0} ]", a.getContainer());
                    continue;
                }
                if (!Ear50NoDDImportStrategyImpl.isAppClientModule(a)) continue;
                JavaClientModule appClientMod = appFactory.createJavaClientModule();
                appClientMod.setUri(name);
                appClientMod.setApplication(app);
                modules.add(appClientMod);
                logger.logp(Level.FINER, className, methodName, "Added archive [ {0} ] to list of Application Client Modules", a);
                continue;
            }
            if (name.endsWith(".war")) {
                if (!warDiscriminator.canImport(a)) continue;
                WebModule webMod = appFactory.createWebModule();
                webMod.setUri(name);
                Archive arch = warDiscriminator.openArchive(a);
                logger.logp(Level.FINER, className, methodName, "Convert archive [ {0} ]", a);
                logger.logp(Level.FINER, className, methodName, "Converted  to archive [ {0} ]", arch);
                String contextRoot = null;
                if (arch != null && arch instanceof WARFileImpl) {
                    arch.setContainer(earFile);
                    contextRoot = ((WARFileImpl)arch).getContextRoot();
                }
                if (contextRoot == null) {
                    contextRoot = "/" + name.substring(0, name.length() - 4);
                }
                webMod.setContextRoot(contextRoot);
                webMod.setApplication(app);
                modules.add(webMod);
                if (isLooseApplication) {
                    this.setLooseArchive(false, earBinariesPath, looseApplication, a.getLoadStrategy(), webMod);
                }
                logger.logp(Level.FINER, className, methodName, "Added archive [ {0} ] to list of Web Modules", a);
                continue;
            }
            if (!name.endsWith(".rar")) continue;
            ConnectorModule connMod = appFactory.createConnectorModule();
            connMod.setUri(name);
            connMod.setApplication(app);
            modules.add(connMod);
            logger.logp(Level.FINER, className, methodName, "Added archive [ {0} ] to list of Connector Modules", a);
        }
        logger.logp(Level.FINER, className, methodName, "application.xml created for [ {0} ]", displayName);
        earFile.clearFiles();
        for (Archive a : archiveList) {
            logger.logp(Level.FINER, className, methodName, "Close archive file [ {0} ]", a.getURI());
            a.close();
        }
        earFile.getFiles();
        logger.exiting(className, methodName);
    }

    private static boolean isAppClientModule(Archive a) {
        String methodName = "isAppClientModule";
        String displayName = a.getName();
        logger.logp(Level.FINER, className, methodName, "ENTRY Checking [ {0} ]", displayName);
        boolean isApplicationClientModule = false;
        if (a.isSetCanImportAs(Archive.ModuleTypeEnum.CLIENT) && !a.getCanImportAs(Archive.ModuleTypeEnum.CLIENT)) {
            isApplicationClientModule = false;
        } else if (a.containsFile("META-INF/application-client.xml")) {
            isApplicationClientModule = true;
        } else {
            ArchiveManifest amf = a.getManifest();
            if (amf != null && amf.getMainClass() != null) {
                isApplicationClientModule = true;
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", Boolean.toString(isApplicationClientModule));
        return isApplicationClientModule;
    }

    private void setLooseArchive(boolean isEjbModule, String earBinariesPath, LooseApplication looseApplication, LoadStrategy loadStrategy, Module m) {
        EList archiveList;
        String methodName = "setLooseArchive";
        String aURI = m.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTRY", aURI);
        if (loadStrategy instanceof DirectoryLoadStrategyImpl && !(archiveList = looseApplication.getLooseArchives()).contains(m)) {
            LooseconfigFactory lcFactory = (LooseconfigFactory)LooseconfigPackage.eINSTANCE.getEFactoryInstance();
            LooseModule lm = isEjbModule ? lcFactory.createLooseModule() : lcFactory.createLooseWARFile();
            lm.setUri(m.getUri());
            lm.setAltDD(m.getAltDD());
            String path = looseApplication.getBinariesPath() + SEPARATOR + lm.getUri();
            lm.setBinariesPath(path);
            logger.logp(Level.FINER, className, methodName, "Set loose module binaries path [ {0} ]", path);
            String resourceURI = lm.getAltDD();
            if (resourceURI == null || resourceURI.length() == 0) {
                resourceURI = lm.getUri();
            }
            path = looseApplication.getResourcesPath() + SEPARATOR + resourceURI;
            lm.setResourcesPath(path);
            logger.logp(Level.FINER, className, methodName, "Set loose module resources path [ {0} ]", path);
            looseApplication.getLooseArchives().add(lm);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        private static final String className = Discriminator.class.getName();

        public boolean canImport(Archive anArchive) {
            String methodName = "canImport";
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", anArchive);
            Archive.ModuleVersionEnum version = Archive.ModuleVersionEnum.EAR50;
            if (anArchive.isSetCanImportAs(version)) {
                boolean canImport = anArchive.getCanImportAs(version);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN cached EAR50 value [ {0} ]", Boolean.toString(canImport));
                return canImport;
            }
            boolean canImport = this.hasEarContents(anArchive);
            anArchive.setCanImportAs(version, canImport);
            anArchive.closeArchiveZipFile();
            anArchive.closeChildArchiveZipFiles();
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN EAR50 [ {0} ]", Boolean.toString(canImport));
            return canImport;
        }

        private boolean hasEarContents(Archive anArchive) {
            String archiveURI = anArchive.getURI();
            String methodName = "hasEarContents";
            XmlBasedImportStrategyImpl.logger.entering(className, methodName);
            if (!archiveURI.endsWith(".ear")) {
                boolean isDirectory = anArchive.getLoadStrategy() instanceof DirectoryArchiveLoadStrategyImpl;
                if (!isDirectory) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false - file archive [ {0} ] does not end with the .ear file extension", archiveURI);
                    return false;
                }
                if (XmlBasedImportStrategyImpl.hasBlockingExtension(archiveURI, Archive.ModuleTypeEnum.EAR)) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN Blocked by other file extension");
                    return false;
                }
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "No blocking extensions");
            LooseApplication looseapp = LooseConfigRegister.singleton().findLooseApplication(archiveURI);
            if (looseapp != null) {
                anArchive.getLoadStrategy().setLooseArchive(looseapp);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN true - Archive [ {0} ] is a loose application", archiveURI);
                return true;
            }
            if (XmlBasedImportStrategyImpl.containsBlockingDescriptor(anArchive, Archive.ModuleTypeEnum.EAR)) {
                XmlBasedImportStrategyImpl.logger.exiting(className, methodName, "RETURN false - Blocked by other descriptor");
                return false;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "No blocking descriptors");
            List archiveList = anArchive.getArchiveFiles();
            for (Archive a : archiveList) {
                String name = a.getURI();
                if (name.startsWith("lib/")) continue;
                if (name.endsWith(".war")) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN true - Archive is a Web module (WAR)");
                    return true;
                }
                if (name.endsWith(".rar")) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN true - Archive is a Connector module (RAR)");
                    return true;
                }
                if (!name.endsWith(".jar") || !Ear50NoDDImportStrategyImpl.isAppClientModule(a)) continue;
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN true - Archive is an Application Client module (JAR)");
                return true;
            }
            ArchiveTypeDiscriminator ejbDiscriminator = RootEJBJarDescriminatorImpl.singleton();
            for (Archive a : archiveList) {
                String name = a.getURI();
                if (name.startsWith("lib/") || !ejbDiscriminator.canImport(a)) continue;
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN true - Archive is an EJB module (JAR)");
                return true;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false - Could not find anything in archive contents to indicate that it is an EAR file");
            if (XmlBasedImportStrategyImpl.logger.isLoggable(Level.FINEST)) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINEST, className, methodName, "Debug data for archive with no EAR contents\n" + Thread.currentThread().getStackTrace());
            }
            return false;
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            return new Ear50NoDDImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.EAR_File, "META-INF/application.xml");
        }

        public Archive createConvertedArchive() {
            return Ear50NoDDImportStrategyImpl.getArchiveFactory().createEARFile();
        }
    }
}

