/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIteratorImpl;

public class NestedArchiveIteratorDirect
extends FileIteratorImpl {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = NestedArchiveIteratorDirect.class.getName();
    protected ZipInputStream zipInputStream;

    public NestedArchiveIteratorDirect(List files, ZipInputStream zipInputStream) {
        super(files);
        this.zipInputStream = zipInputStream;
        logger.logp(Level.FINER, CLASS_NAME, "Constructor", "ENTRY/RETURN [ {0} ]", this);
    }

    public InputStream getInputStream(File nextFile) throws IOException {
        String methodName = "getInputStream";
        String nextName = nextFile.getURI();
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY [ {0} ]", nextName);
        if (nextFile.isArchive()) {
            Archive archiveFile = (Archive)nextFile;
            if (archiveFile.getLoadStrategy().getLooseArchive() != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN input stream from loose archive");
                return nextFile.getInputStream();
            }
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Handling archive as simple file entry");
        }
        boolean foundMatch = false;
        while (!foundMatch) {
            ZipEntry currentEntry = this.zipInputStream.getNextEntry();
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Moved to archive entry [ {0} ]", currentEntry.getName());
            foundMatch = !currentEntry.isDirectory() && nextName.equals(currentEntry.getName());
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN (match found)");
        return new WrapperInputStream(this.zipInputStream);
    }

    public void closeInputStream() throws IOException {
        String methodName = "closeInputStream";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY [ {0} ]", this);
        this.zipInputStream.close();
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN");
    }

    protected void finalize() throws Throwable, IOException {
        super.finalize();
        this.close();
    }

    static class WrapperInputStream
    extends FilterInputStream {
        public WrapperInputStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }
}

