/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.java.adapters.IJavaClassAdaptor;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.ReadAdaptor;
import org.eclipse.jem.internal.java.beaninfo.IIntrospectionAdapter;
import org.eclipse.jem.internal.java.instantiation.IInstantiationInstance;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.InheritanceCycleException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.java.internal.impl.JavaRefFactoryImpl;

public class JavaClassImpl
extends EClassImpl
implements JavaClass {
    protected static final TypeKind KIND_EDEFAULT = TypeKind.UNDEFINED_LITERAL;
    protected TypeKind kind = KIND_EDEFAULT;
    protected static final boolean PUBLIC_EDEFAULT = false;
    protected static final int PUBLIC_EFLAG = 1024;
    protected static final boolean FINAL_EDEFAULT = false;
    protected static final int FINAL_EFLAG = 2048;
    protected EList implementsInterfaces = null;
    protected EList classImport = null;
    protected EList packageImports = null;
    protected EList fields = null;
    protected EList methods = null;
    protected EList initializers = null;
    protected EList declaredClasses = null;
    protected JavaClass declaringClass = null;
    protected EList events = null;
    private static final int NOT_REFLECTED = 0;
    private static final int REFLECTED_BASE = 1;
    private static final int REFLECTED_METHODS = 2;
    private static final int REFLECTED_FIELDS = 4;
    protected int reflectionStatus = 0;
    private EList allEvents;
    private EList allProperties;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    protected JavaClassImpl() {
    }

    public EList getEAnnotationsInternal() {
        return super.getEAnnotations();
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.eINSTANCE.getJavaClass();
    }

    protected void collectFieldsExtended(List fields) {
        fields.addAll(this.getFields());
        Iterator it = this.getExtendedLookupIterator();
        while (it.hasNext()) {
            ((JavaClassImpl)it.next()).collectFieldsExtended(fields);
        }
    }

    protected void collectMethodsExtended(Map methods, boolean onlyPublic, List excludedClasses, List excludedMethods) {
        Iterator it2 = this.getExtendedLookupIterator();
        while (it2.hasNext()) {
            JavaClassImpl javaClass = (JavaClassImpl)it2.next();
            if (excludedClasses.contains(javaClass)) continue;
            javaClass.collectMethodsExtended(methods, onlyPublic, excludedClasses, excludedMethods);
        }
        Iterator it1 = onlyPublic ? this.getPublicMethods().iterator() : this.getMethods().iterator();
        while (it1.hasNext()) {
            Method nextMethod = (Method)it1.next();
            if (excludedMethods.contains(nextMethod)) continue;
            methods.put(nextMethod.getMethodElementSignature(), nextMethod);
        }
    }

    public static JavaClass createClassRef(String targetName) {
        return JavaRefFactory.eINSTANCE.createClassRef(targetName);
    }

    protected Method findClassMethodExtended(String methodName, List parameterTypes) {
        Method method = this.getMethod(methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        JavaClassImpl mySuper = (JavaClassImpl)this.getSupertype();
        if (mySuper != null) {
            return mySuper.findClassMethodExtended(methodName, parameterTypes);
        }
        return null;
    }

    protected Method findInterfaceMethodExtended(String methodName, List parameterTypes) {
        Method method = this.getMethod(methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        EList list = this.getImplementsInterfaces();
        int i = 0;
        while (i < list.size()) {
            JavaClassImpl superInterface = (JavaClassImpl)list.get(i);
            method = superInterface.findInterfaceMethodExtended(methodName, parameterTypes);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public EList getAllSupertypes() {
        this.getESuperTypes();
        return super.getEAllSuperTypes();
    }

    public EList getClassImport() {
        this.reflectBase();
        return this.getClassImportGen();
    }

    public EList getEAllOperations() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return super.getEAllOperations();
        }
        if (this.eAllOperations == null) {
            this.eAllOperations = ia.getEAllOperations();
        }
        return this.eAllOperations;
    }

    public EList primGetEAllOperations() {
        return super.getEAllOperations();
    }

    public EList getEOperations() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEOperations();
        }
        return super.getEOperations();
    }

    public EList getEOperationsInternal() {
        return super.getEOperations();
    }

    public EList getEAnnotations() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            adapter.introspectIfNecessary();
        }
        return super.getEAnnotations();
    }

    public EList getEStructuralFeatures() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEStructuralFeatures();
        }
        return super.getEStructuralFeatures();
    }

    public EList getEStructuralFeaturesInternal() {
        return super.getEStructuralFeatures();
    }

    protected Iterator getExtendedLookupIterator() {
        if (this.isInterface()) {
            return this.getImplementsInterfaces().iterator();
        }
        return this.getESuperTypes().iterator();
    }

    public Field getField(String fieldName) {
        EList fields = this.getFields();
        int i = 0;
        while (i < fields.size()) {
            Field field = (Field)fields.get(i);
            if (field.getName().equals(fieldName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public Field getFieldExtended(String fieldName) {
        Field field = this.getFieldNamed(fieldName);
        if (field != null) {
            return field;
        }
        Iterator it = this.getExtendedLookupIterator();
        while (it.hasNext()) {
            Field result = ((JavaClass)it.next()).getFieldExtended(fieldName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Field getFieldNamed(String fieldName) {
        return this.getField(fieldName);
    }

    public EList getFields() {
        this.reflectFields();
        return this.getFieldsGen();
    }

    public List getFieldsExtended() {
        ArrayList fields = new ArrayList();
        this.collectFieldsExtended(fields);
        return fields;
    }

    public EList getImplementsInterfaces() {
        this.reflectBase();
        return this.getImplementsInterfacesGen();
    }

    protected synchronized IIntrospectionAdapter getIntrospectionAdapter() {
        return (IIntrospectionAdapter)EcoreUtil.getRegisteredAdapter(this, (Object)IIntrospectionAdapter.ADAPTER_KEY);
    }

    public String getJavaName() {
        return this.getQualifiedName();
    }

    public String getSimpleName() {
        return this.primGetName().replace('$', '.');
    }

    public JavaPackage getJavaPackage() {
        return (JavaPackage)this.getEPackage();
    }

    public Method getMethod(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, this.getMethods());
    }

    protected Method getMethod(String name, List parameterTypes, List methodList) {
        boolean found = false;
        int i = 0;
        while (i < methodList.size()) {
            JavaParameter[] params;
            Method method = (Method)methodList.get(i);
            if (method.getName().equals(name) && (params = method.listParametersWithoutReturn()).length == parameterTypes.size()) {
                found = true;
                int j = 0;
                while (j < params.length) {
                    JavaHelpers jh = (JavaHelpers)params[j].getEType();
                    if (!jh.getQualifiedName().equals(parameterTypes.get(j))) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    return method;
                }
            }
            ++i;
        }
        return null;
    }

    public List getMethodElementSignatures() {
        List methods = this.getMethodsExtended();
        ArrayList<String> sameNames = new ArrayList<String>();
        ArrayList<String> signatures = new ArrayList<String>(methods.size() + 1);
        signatures.add("*");
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method aMethod = (Method)it.next();
            String methodName = aMethod.getName();
            if (sameNames.contains(methodName)) {
                if (!signatures.contains(methodName)) {
                    signatures.add(methodName);
                }
            } else {
                sameNames.add(methodName);
            }
            signatures.add(aMethod.getMethodElementSignature());
        }
        Collections.sort(signatures);
        return signatures;
    }

    public Method getMethodExtended(String methodName, List parameterTypes) {
        if (this.isInterface()) {
            return this.findInterfaceMethodExtended(methodName, parameterTypes);
        }
        return this.findClassMethodExtended(methodName, parameterTypes);
    }

    public EList getMethods() {
        this.reflectMethods();
        return this.getMethodsGen();
    }

    public List getMethodsExtended() {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, false, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        return new ArrayList(methods.values());
    }

    public List getMethodsExtendedWithFilters(List excludedClasses, List excludedMethods) {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, false, excludedClasses, excludedMethods);
        return new ArrayList(methods.values());
    }

    public String getName() {
        String result = this.primGetName();
        if (result == null && this.eIsProxy()) {
            return JavaRefFactory.eINSTANCE.getTypeName(this.eProxyURI());
        }
        return result;
    }

    public List getOnlySpecificMethods(String aMethodNamePrefix, List excludedNames) {
        List methods = this.getMethodsExtended();
        ArrayList<Method> specific = new ArrayList<Method>(methods.size());
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method aMethod = (Method)it.next();
            String methodName = aMethod.getName();
            if (aMethodNamePrefix == null || !methodName.startsWith(aMethodNamePrefix) || excludedNames == null || excludedNames.contains(methodName)) continue;
            specific.add(aMethod);
        }
        return specific;
    }

    public EList getPackageImports() {
        this.reflectBase();
        return this.getPackageImportsGen();
    }

    public JavaDataType getPrimitive() {
        String primitiveName = this.getPrimitiveName();
        if (primitiveName != null) {
            Resource res = this.eResource();
            return (JavaDataType)JavaClassImpl.reflect(primitiveName, res.getResourceSet());
        }
        return null;
    }

    public int getPrimitiveID() {
        String myName = this.getQualifiedName();
        if (myName.equals("java.lang.Integer")) {
            return 6;
        }
        if (myName.equals("java.lang.Boolean")) {
            return 1;
        }
        if (myName.equals("java.lang.Byte")) {
            return 3;
        }
        if (myName.equals("java.lang.Short")) {
            return 8;
        }
        if (myName.equals("java.lang.Long")) {
            return 7;
        }
        if (myName.equals("java.lang.Float")) {
            return 5;
        }
        if (myName.equals("java.lang.Double")) {
            return 4;
        }
        if (myName.equals("java.lang.Character")) {
            return 2;
        }
        return 0;
    }

    protected String getPrimitiveName() {
        String myName = this.getQualifiedName();
        if (myName.equals("java.lang.Integer")) {
            return "int";
        }
        if (myName.equals("java.lang.Boolean")) {
            return "boolean";
        }
        if (myName.equals("java.lang.Byte")) {
            return "byte";
        }
        if (myName.equals("java.lang.Short")) {
            return "short";
        }
        if (myName.equals("java.lang.Long")) {
            return "long";
        }
        if (myName.equals("java.lang.Float")) {
            return "float";
        }
        if (myName.equals("java.lang.Double")) {
            return "double";
        }
        if (myName.equals("java.lang.Character")) {
            return "char";
        }
        return null;
    }

    public Method getPublicMethod(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, this.getPublicMethods());
    }

    public Method getPublicMethodExtended(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, this.getPublicMethodsExtended());
    }

    public List getPublicMethods() {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        EList theMethods = this.getMethods();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (JavaVisibilityKind.PUBLIC_LITERAL == m.getJavaVisibility()) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    public List getPublicMethodsExtended() {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, true, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        return new ArrayList(methods.values());
    }

    public List getPublicMethodsExtendedNamed(String name) {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        List theMethods = this.getPublicMethodsExtended();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (m.getName().equals(name)) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    public List getPublicMethodsNamed(String name) {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        List theMethods = this.getPublicMethods();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (m.getName().equals(name)) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    public String getQualifiedName() {
        String result = null;
        result = this.eIsProxy() ? JavaRefFactory.eINSTANCE.getFullTypeName(this.eProxyURI()) : this.primGetQualifiedName();
        if (result != null) {
            result = result.replace('$', '.');
        }
        return result;
    }

    public String getQualifiedNameForReflection() {
        return this.primGetQualifiedName();
    }

    protected synchronized ReadAdaptor getReadAdapter() {
        return (ReadAdaptor)EcoreUtil.getRegisteredAdapter(this, (Object)"JavaReflection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectBase() {
        ReadAdaptor readAdaptor = null;
        JavaClassImpl javaClassImpl = this;
        synchronized (javaClassImpl) {
            if ((this.reflectionStatus & 1) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = readAdaptor.reflectValuesIfNecessary();
            JavaClassImpl javaClassImpl2 = this;
            synchronized (javaClassImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectFields() {
        ReadAdaptor readAdaptor = null;
        JavaClassImpl javaClassImpl = this;
        synchronized (javaClassImpl) {
            if ((this.reflectionStatus & 4) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = ((IJavaClassAdaptor)((Object)readAdaptor)).reflectFieldsIfNecessary();
            JavaClassImpl javaClassImpl2 = this;
            synchronized (javaClassImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 5;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectMethods() {
        ReadAdaptor readAdaptor = null;
        JavaClassImpl javaClassImpl = this;
        synchronized (javaClassImpl) {
            if ((this.reflectionStatus & 2) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = ((IJavaClassAdaptor)((Object)readAdaptor)).reflectMethodsIfNecessary();
            JavaClassImpl javaClassImpl2 = this;
            synchronized (javaClassImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 3;
                }
            }
        }
    }

    public JavaClass getSupertype() {
        if (this.isInterface()) {
            return null;
        }
        EList list = this.getESuperTypes();
        return !list.isEmpty() ? (JavaClass)list.get(0) : null;
    }

    public JavaClass getWrapper() {
        return this;
    }

    public boolean implementsInterface(JavaClass interfaceType) {
        if (this == interfaceType) {
            return true;
        }
        EList implemented = this.getImplementsInterfaces();
        int i = 0;
        while (i < implemented.size()) {
            JavaClass anInterface = (JavaClass)implemented.get(i);
            if (anInterface.implementsInterface(interfaceType)) {
                return true;
            }
            ++i;
        }
        if (this.getSupertype() != null) {
            return this.getSupertype().implementsInterface(interfaceType);
        }
        return false;
    }

    public String infoString() {
        EList methods;
        StringBuffer out = new StringBuffer();
        this.reflectBase();
        out.append("Java class: " + this.getQualifiedName() + "\n");
        out.append("  superclass: " + this.getSupertype() + "\n");
        EList fields = this.getFields();
        if (fields.size() > 0) {
            out.append("  Fields:\n");
            int i = 0;
            while (i < fields.size()) {
                Field field = (Field)fields.get(i);
                out.append("    " + ((JavaHelpers)field.getEType()).getJavaName() + " " + field.getName() + "\n");
                ++i;
            }
        }
        if ((methods = this.getMethods()).size() > 0) {
            out.append("  Methods:\n");
            int i = 0;
            while (i < methods.size()) {
                Method method = (Method)methods.get(i);
                method.isStatic();
                if (method.getReturnType() != null) {
                    out.append("    " + method.getReturnType().getJavaName() + " ");
                } else {
                    out.append("    void ");
                }
                out.append(String.valueOf(method.getName()) + "(");
                EList parms = method.getParameters();
                if (parms.size() > 0) {
                    int ii = 0;
                    while (ii < parms.size()) {
                        JavaParameter parm = (JavaParameter)parms.get(ii);
                        out.append(String.valueOf(((JavaHelpers)parm.getEType()).getJavaName()) + " " + parm.getName());
                        if (ii < parms.size() - 1) {
                            out.append(", ");
                        }
                        ++ii;
                    }
                }
                out.append(")\n");
                ++i;
            }
        }
        return out.toString();
    }

    public boolean inheritsFrom(JavaClass javaClass) {
        if (this == javaClass) {
            return true;
        }
        if (this.getSupertype() != null) {
            return this.getSupertype().inheritsFrom(javaClass);
        }
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAssignableFrom(EClassifier aClass) {
        if (aClass instanceof JavaClass) {
            JavaClass theClass = (JavaClass)aClass;
            if (this.getKind() == TypeKind.UNDEFINED_LITERAL || theClass.getKind() == TypeKind.UNDEFINED_LITERAL) {
                return false;
            }
            if (this.getKind() != TypeKind.INTERFACE_LITERAL) {
                if (theClass.getKind() != TypeKind.INTERFACE_LITERAL) {
                    return theClass.inheritsFrom(this);
                }
                return this.getQualifiedName().equals("java.lang.Object");
            }
            return theClass.implementsInterface(this);
        }
        return false;
    }

    public boolean isExistingType() {
        return ((JavaReflectionAdaptor)this.getReadAdapter()).hasReflectionSource();
    }

    public boolean isInstance(Object o) {
        return o instanceof IInstantiationInstance ? this.isAssignableFrom(((IInstantiationInstance)o).getJavaType()) : false;
    }

    public boolean isInterface() {
        return this.getKind() == TypeKind.INTERFACE_LITERAL;
    }

    public boolean isNested() {
        return this.getDeclaringClass() != null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public Field[] listFieldExtended() {
        List fields = this.getFieldsExtended();
        Field[] result = new Field[fields.size()];
        fields.toArray(result);
        return result;
    }

    public Method[] listMethodExtended() {
        List methods = this.getMethodsExtended();
        Method[] result = new Method[methods.size()];
        methods.toArray(result);
        return result;
    }

    public String primGetName() {
        return super.getName();
    }

    public String primGetQualifiedName() {
        JavaPackage pack;
        String result = "";
        result = this.eIsProxy() ? JavaRefFactory.eINSTANCE.getFullTypeName(this.eProxyURI()) : ((pack = this.getJavaPackage()) != null && pack.getPackageName().length() != 0 ? String.valueOf(pack.getPackageName()) + "." + ((JavaRefFactoryImpl)JavaRefFactory.eINSTANCE).primGetTypeName(this.primGetName()) : this.getName());
        return result;
    }

    public static JavaHelpers reflect(String aQualifiedName, EObject relatedObject) {
        return JavaRefFactory.eINSTANCE.reflectType(aQualifiedName, relatedObject);
    }

    public static JavaHelpers reflect(String aQualifiedName, ResourceSet set) {
        return JavaRefFactory.eINSTANCE.reflectType(aQualifiedName, set);
    }

    public static JavaHelpers reflect(String aPackageName, String aClassName, ResourceSet set) {
        return JavaRefFactory.eINSTANCE.reflectType(aPackageName, aClassName, set);
    }

    public void setSupertype(JavaClass aJavaClass) throws InheritanceCycleException {
        this.validateSupertype(aJavaClass);
        EList s = super.getESuperTypes();
        s.clear();
        if (aJavaClass != null) {
            s.add(aJavaClass);
        }
    }

    protected void validateSupertype(JavaClass aJavaClass) throws InheritanceCycleException {
        if (!this.isValidSupertype(aJavaClass)) {
            throw new InheritanceCycleException(this, aJavaClass);
        }
    }

    public boolean isValidSupertype(JavaClass aJavaClass) {
        if (aJavaClass != null) {
            if (this.equals(aJavaClass)) {
                return false;
            }
            return this.extendedIsValidSupertype(this.getSubtypes(), aJavaClass);
        }
        return true;
    }

    private boolean extendedIsValidSupertype(List subtypes, JavaClass aJavaClass) {
        if (!this.basicIsValidSupertype(subtypes, aJavaClass)) {
            return false;
        }
        int i = 0;
        while (i < subtypes.size()) {
            JavaClass subtype = (JavaClass)subtypes.get(i);
            if (!subtype.isValidSupertype(aJavaClass)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean basicIsValidSupertype(List subtypes, JavaClass aJavaClass) {
        int i = 0;
        while (i < subtypes.size()) {
            JavaClass subtype = (JavaClass)subtypes.get(i);
            if (subtype.equals(aJavaClass)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected List getSubtypes() {
        return this.getESuperAdapter().getSubclasses();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.getQualifiedName() + ")";
    }

    public TypeKind getKind() {
        this.reflectBase();
        return this.getKindGen();
    }

    public void setKind(TypeKind newKind) {
        TypeKind oldKind = this.kind;
        TypeKind typeKind = this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldKind, (Object)this.kind));
        }
    }

    public boolean isPublic() {
        this.reflectBase();
        return this.isPublicGen();
    }

    public void setPublic(boolean newPublic) {
        boolean oldPublic;
        boolean bl = oldPublic = (this.eFlags & 0x400) != 0;
        this.eFlags = newPublic ? (this.eFlags |= 0x400) : (this.eFlags &= 0xFFFFFBFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 21, oldPublic, newPublic));
        }
    }

    public boolean isFinal() {
        this.reflectBase();
        return this.isFinalGen();
    }

    public void setFinal(boolean newFinal) {
        boolean oldFinal;
        boolean bl = oldFinal = (this.eFlags & 0x800) != 0;
        this.eFlags = newFinal ? (this.eFlags |= 0x800) : (this.eFlags &= 0xFFFFF7FF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 22, oldFinal, newFinal));
        }
    }

    public TypeKind getKindGen() {
        return this.kind;
    }

    public boolean isPublicGen() {
        return (this.eFlags & 0x400) != 0;
    }

    public boolean isFinalGen() {
        return (this.eFlags & 0x800) != 0;
    }

    public EList getInitializers() {
        if (this.initializers == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jem.java.Initializer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.initializers = new EObjectContainmentWithInverseEList(clazz, this, 28, 1);
        }
        return this.initializers;
    }

    public void setDeclaringClass(JavaClass newDeclaringClass) {
        if (newDeclaringClass != this.declaringClass) {
            NotificationChain msgs = null;
            if (this.declaringClass != null) {
                InternalEObject internalEObject = (InternalEObject)((Object)this.declaringClass);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.jem.java.JavaClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseRemove(this, 29, clazz, msgs);
            }
            if (newDeclaringClass != null) {
                InternalEObject internalEObject = (InternalEObject)((Object)newDeclaringClass);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.jem.java.JavaClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd(this, 29, clazz, msgs);
            }
            if ((msgs = this.basicSetDeclaringClass(newDeclaringClass, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 30, (Object)newDeclaringClass, (Object)newDeclaringClass));
        }
    }

    public JavaClass getDeclaringClass() {
        if (this.declaringClass != null && this.declaringClass.eIsProxy()) {
            JavaClass oldDeclaringClass = this.declaringClass;
            this.declaringClass = (JavaClass)this.eResolveProxy((InternalEObject)((Object)this.declaringClass));
            if (this.declaringClass != oldDeclaringClass && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 30, (Object)oldDeclaringClass, (Object)this.declaringClass));
            }
        }
        return this.declaringClass;
    }

    public JavaClass basicGetDeclaringClass() {
        return this.declaringClass;
    }

    public NotificationChain basicSetDeclaringClass(JavaClass newDeclaringClass, NotificationChain msgs) {
        JavaClass oldDeclaringClass = this.declaringClass;
        this.declaringClass = newDeclaringClass;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 30, (Object)oldDeclaringClass, (Object)newDeclaringClass);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public EList getDeclaredClasses() {
        this.reflectBase();
        return this.getDeclaredClassesGen();
    }

    public EList getDeclaredClassesGen() {
        if (this.declaredClasses == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jem.java.JavaClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declaredClasses = new EObjectWithInverseResolvingEList(clazz, this, 29, 30);
        }
        return this.declaredClasses;
    }

    public EList getProperties() {
        return this.getEStructuralFeatures();
    }

    public EList getEvents() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEvents();
        }
        return this.getEventsGen();
    }

    public EList getEventsGen() {
        if (this.events == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jem.java.JavaEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.events = new EObjectContainmentEList(clazz, this, 32);
        }
        return this.events;
    }

    public EList getAllEvents() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return ECollections.EMPTY_ELIST;
        }
        this.allEvents = ia.getAllEvents();
        return this.allEvents;
    }

    public EList getAllEventsGen() {
        return this.allEvents;
    }

    public EList getAllProperties() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return ECollections.EMPTY_ELIST;
        }
        this.allProperties = ia.getAllProperties();
        return this.allProperties;
    }

    public EList getAllPropertiesGen() {
        return this.allProperties;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return INSTANCE_CLASS_NAME_EDEFAULT == null ? this.instanceClassName != null : !INSTANCE_CLASS_NAME_EDEFAULT.equals(this.instanceClassName);
            }
            case 3: {
                return INSTANCE_CLASS_EDEFAULT == null ? this.getInstanceClass() != null : !INSTANCE_CLASS_EDEFAULT.equals(this.getInstanceClass());
            }
            case 4: {
                return DEFAULT_VALUE_EDEFAULT == null ? this.getDefaultValue() != null : !DEFAULT_VALUE_EDEFAULT.equals(this.getDefaultValue());
            }
            case 5: {
                return this.getEPackage() != null;
            }
            case 6: {
                return (this.eFlags & 0x100) != 0;
            }
            case 7: {
                return (this.eFlags & 0x200) != 0;
            }
            case 8: {
                return this.eSuperTypes != null && !this.eSuperTypes.isEmpty();
            }
            case 9: {
                return this.eOperations != null && !this.eOperations.isEmpty();
            }
            case 10: {
                return !this.getEAllAttributes().isEmpty();
            }
            case 11: {
                return !this.getEAllReferences().isEmpty();
            }
            case 12: {
                return !this.getEReferences().isEmpty();
            }
            case 13: {
                return !this.getEAttributes().isEmpty();
            }
            case 14: {
                return !this.getEAllContainments().isEmpty();
            }
            case 15: {
                return !this.getEAllOperations().isEmpty();
            }
            case 16: {
                return !this.getEAllStructuralFeatures().isEmpty();
            }
            case 17: {
                return !this.getEAllSuperTypes().isEmpty();
            }
            case 18: {
                return this.getEIDAttribute() != null;
            }
            case 19: {
                return this.eStructuralFeatures != null && !this.eStructuralFeatures.isEmpty();
            }
            case 20: {
                return this.kind != KIND_EDEFAULT;
            }
            case 21: {
                return (this.eFlags & 0x400) != 0;
            }
            case 22: {
                return (this.eFlags & 0x800) != 0;
            }
            case 23: {
                return this.implementsInterfaces != null && !this.implementsInterfaces.isEmpty();
            }
            case 24: {
                return this.classImport != null && !this.classImport.isEmpty();
            }
            case 25: {
                return this.packageImports != null && !this.packageImports.isEmpty();
            }
            case 26: {
                return this.fields != null && !this.fields.isEmpty();
            }
            case 27: {
                return this.methods != null && !this.methods.isEmpty();
            }
            case 28: {
                return this.initializers != null && !this.initializers.isEmpty();
            }
            case 29: {
                return this.declaredClasses != null && !this.declaredClasses.isEmpty();
            }
            case 30: {
                return this.declaringClass != null;
            }
            case 31: {
                return this.basicGetJavaPackage() != null;
            }
            case 32: {
                return this.events != null && !this.events.isEmpty();
            }
            case 33: {
                return !this.getAllEvents().isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setInstanceClassName((String)newValue);
                return;
            }
            case 6: {
                this.setAbstract((Boolean)newValue);
                return;
            }
            case 7: {
                this.setInterface((Boolean)newValue);
                return;
            }
            case 8: {
                this.getESuperTypes().clear();
                this.getESuperTypes().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getEOperations().clear();
                this.getEOperations().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.getEStructuralFeatures().clear();
                this.getEStructuralFeatures().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.setKind((TypeKind)newValue);
                return;
            }
            case 21: {
                this.setPublic((Boolean)newValue);
                return;
            }
            case 22: {
                this.setFinal((Boolean)newValue);
                return;
            }
            case 23: {
                this.getImplementsInterfaces().clear();
                this.getImplementsInterfaces().addAll((Collection)newValue);
                return;
            }
            case 24: {
                this.getClassImport().clear();
                this.getClassImport().addAll((Collection)newValue);
                return;
            }
            case 25: {
                this.getPackageImports().clear();
                this.getPackageImports().addAll((Collection)newValue);
                return;
            }
            case 26: {
                this.getFields().clear();
                this.getFields().addAll((Collection)newValue);
                return;
            }
            case 27: {
                this.getMethods().clear();
                this.getMethods().addAll((Collection)newValue);
                return;
            }
            case 28: {
                this.getInitializers().clear();
                this.getInitializers().addAll((Collection)newValue);
                return;
            }
            case 29: {
                this.getDeclaredClasses().clear();
                this.getDeclaredClasses().addAll((Collection)newValue);
                return;
            }
            case 30: {
                this.setDeclaringClass((JavaClass)newValue);
                return;
            }
            case 32: {
                this.getEvents().clear();
                this.getEvents().addAll((Collection)newValue);
                return;
            }
            case 33: {
                this.getAllEvents().clear();
                this.getAllEvents().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setInstanceClassName(INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setAbstract(false);
                return;
            }
            case 7: {
                this.setInterface(false);
                return;
            }
            case 8: {
                this.getESuperTypes().clear();
                return;
            }
            case 9: {
                this.getEOperations().clear();
                return;
            }
            case 19: {
                this.getEStructuralFeatures().clear();
                return;
            }
            case 20: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 21: {
                this.setPublic(false);
                return;
            }
            case 22: {
                this.setFinal(false);
                return;
            }
            case 23: {
                this.getImplementsInterfaces().clear();
                return;
            }
            case 24: {
                this.getClassImport().clear();
                return;
            }
            case 25: {
                this.getPackageImports().clear();
                return;
            }
            case 26: {
                this.getFields().clear();
                return;
            }
            case 27: {
                this.getMethods().clear();
                return;
            }
            case 28: {
                this.getInitializers().clear();
                return;
            }
            case 29: {
                this.getDeclaredClasses().clear();
                return;
            }
            case 30: {
                this.setDeclaringClass(null);
                return;
            }
            case 32: {
                this.getEvents().clear();
                return;
            }
            case 33: {
                this.getAllEvents().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public EList getImplementsInterfacesGen() {
        if (this.implementsInterfaces == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jem.java.JavaClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.implementsInterfaces = new EObjectResolvingEList(clazz, this, 23){
                private static final long serialVersionUID = 1L;

                public Object get(int index) {
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().get(index);
                    }
                    return super.get(index);
                }

                public void clear() {
                    super.clear();
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().clear();
                    }
                }

                public Object remove(int index) {
                    Object result = super.remove(index);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().remove(index);
                    }
                    return result;
                }

                public boolean removeAll(Collection collection) {
                    boolean result = super.removeAll(collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().removeAll(collection);
                    }
                    return result;
                }

                public void add(int index, Object object) {
                    super.add(index, object);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().add(index, object);
                    }
                }

                public boolean add(Object object) {
                    boolean result = super.add(object);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().add(object);
                    }
                    return result;
                }

                public boolean addAll(Collection collection) {
                    boolean result = super.addAll(collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().addAll(collection);
                    }
                    return result;
                }

                public boolean addAll(int index, Collection collection) {
                    boolean result = super.addAll(index, collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().addAll(index, collection);
                    }
                    return result;
                }
            };
        }
        return this.implementsInterfaces;
    }

    private EList getInterfaceSuperTypes() {
        return super.getESuperTypes();
    }

    public EList getClassImportGen() {
        if (this.classImport == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jem.java.JavaClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.classImport = new EObjectResolvingEList(clazz, this, 24);
        }
        return this.classImport;
    }

    public EList getEAllSuperTypes() {
        this.reflectBase();
        return super.getEAllSuperTypes();
    }

    public EList getESuperTypes() {
        this.reflectBase();
        return super.getESuperTypes();
    }

    public EList primGetESuperTypes() {
        return super.getESuperTypes();
    }

    public EList getPackageImportsGen() {
        if (this.packageImports == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.jem.java.JavaPackage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.packageImports = new EObjectResolvingEList(clazz, this, 25);
        }
        return this.packageImports;
    }

    public EList getFieldsGen() {
        if (this.fields == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.jem.java.Field");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fields = new EObjectContainmentWithInverseEList(clazz, this, 26, 14);
        }
        return this.fields;
    }

    public EList getMethodsGen() {
        if (this.methods == null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.jem.java.Method");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.methods = new EObjectContainmentWithInverseEList(clazz, this, 27, 21);
        }
        return this.methods;
    }

    public JavaPackage getJavaPackageGen() {
        JavaPackage javaPackage = this.basicGetJavaPackage();
        return javaPackage == null ? null : (JavaPackage)this.eResolveProxy((InternalEObject)((Object)javaPackage));
    }

    public JavaPackage basicGetJavaPackage() {
        return this.getJavaPackage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        block14: {
            if (featureID < 0) break block14;
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
                }
                case 5: {
                    if (this.eContainer == null) return this.eBasicSetContainer(otherEnd, 5, msgs);
                    msgs = this.eBasicRemoveFromContainer(msgs);
                    return this.eBasicSetContainer(otherEnd, 5, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getEOperations()).basicAdd(otherEnd, msgs);
                }
                case 19: {
                    return ((InternalEList)this.getEStructuralFeatures()).basicAdd(otherEnd, msgs);
                }
                case 26: {
                    return ((InternalEList)this.getFields()).basicAdd(otherEnd, msgs);
                }
                case 27: {
                    return ((InternalEList)this.getMethods()).basicAdd(otherEnd, msgs);
                }
                case 28: {
                    return ((InternalEList)this.getInitializers()).basicAdd(otherEnd, msgs);
                }
                case 29: {
                    return ((InternalEList)this.getDeclaredClasses()).basicAdd(otherEnd, msgs);
                }
                case 30: {
                    if (this.declaringClass == null) return this.basicSetDeclaringClass((JavaClass)((Object)otherEnd), msgs);
                    InternalEObject internalEObject = (InternalEObject)((Object)this.declaringClass);
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jem.java.JavaClass");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    msgs = internalEObject.eInverseRemove(this, 29, clazz, msgs);
                    return this.basicSetDeclaringClass((JavaClass)((Object)otherEnd), msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer == null) return this.eBasicSetContainer(otherEnd, featureID, msgs);
        msgs = this.eBasicRemoveFromContainer(msgs);
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
                }
                case 5: {
                    return this.eBasicSetContainer(null, 5, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getEOperations()).basicRemove(otherEnd, msgs);
                }
                case 19: {
                    return ((InternalEList)this.getEStructuralFeatures()).basicRemove(otherEnd, msgs);
                }
                case 26: {
                    return ((InternalEList)this.getFields()).basicRemove(otherEnd, msgs);
                }
                case 27: {
                    return ((InternalEList)this.getMethods()).basicRemove(otherEnd, msgs);
                }
                case 28: {
                    return ((InternalEList)this.getInitializers()).basicRemove(otherEnd, msgs);
                }
                case 29: {
                    return ((InternalEList)this.getDeclaredClasses()).basicRemove(otherEnd, msgs);
                }
                case 30: {
                    return this.basicSetDeclaringClass(null, msgs);
                }
                case 32: {
                    return ((InternalEList)this.getEvents()).basicRemove(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 5: {
                    Class<?> clazz = class$6;
                    if (clazz == null) {
                        try {
                            clazz = class$6 = Class.forName("org.eclipse.emf.ecore.EPackage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove(this, 5, clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove(this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getInstanceClassName();
            }
            case 3: {
                return this.getInstanceClass();
            }
            case 4: {
                return this.getDefaultValue();
            }
            case 5: {
                return this.getEPackage();
            }
            case 6: {
                return this.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isInterface() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getESuperTypes();
            }
            case 9: {
                return this.getEOperations();
            }
            case 10: {
                return this.getEAllAttributes();
            }
            case 11: {
                return this.getEAllReferences();
            }
            case 12: {
                return this.getEReferences();
            }
            case 13: {
                return this.getEAttributes();
            }
            case 14: {
                return this.getEAllContainments();
            }
            case 15: {
                return this.getEAllOperations();
            }
            case 16: {
                return this.getEAllStructuralFeatures();
            }
            case 17: {
                return this.getEAllSuperTypes();
            }
            case 18: {
                return this.getEIDAttribute();
            }
            case 19: {
                return this.getEStructuralFeatures();
            }
            case 20: {
                return this.getKind();
            }
            case 21: {
                return this.isPublic() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 22: {
                return this.isFinal() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 23: {
                return this.getImplementsInterfaces();
            }
            case 24: {
                return this.getClassImport();
            }
            case 25: {
                return this.getPackageImports();
            }
            case 26: {
                return this.getFields();
            }
            case 27: {
                return this.getMethods();
            }
            case 28: {
                return this.getInitializers();
            }
            case 29: {
                return this.getDeclaredClasses();
            }
            case 30: {
                if (resolve) {
                    return this.getDeclaringClass();
                }
                return this.basicGetDeclaringClass();
            }
            case 31: {
                if (resolve) {
                    return this.getJavaPackage();
                }
                return this.basicGetJavaPackage();
            }
            case 32: {
                return this.getEvents();
            }
            case 33: {
                return this.getAllEvents();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public String toStringGen() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (kind: ");
        result.append(this.kind);
        result.append(", public: ");
        result.append((this.eFlags & 0x400) != 0);
        result.append(", final: ");
        result.append((this.eFlags & 0x800) != 0);
        result.append(')');
        return result.toString();
    }

    public synchronized void setReflected(boolean aBoolean) {
        if (!aBoolean) {
            this.reflectionStatus = 0;
        }
    }

    public Object getReflectionType() {
        JavaReflectionAdaptor ja = (JavaReflectionAdaptor)this.getReadAdapter();
        return ja != null ? ja.getReflectionSource() : null;
    }
}

