/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.AgentQueryStateCommand;
import org.eclipse.hyades.internal.execution.local.common.AttachToAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DetachFromAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.ErrorCommand;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestCommand;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestPortCommand;
import org.eclipse.hyades.internal.execution.local.common.MultiplexedDataServer;
import org.eclipse.hyades.internal.execution.local.common.RegisterAgentInterestCommand;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.common.StartMonitoringRemoteAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.StopMonitorCommand;
import org.eclipse.hyades.internal.execution.local.common.TCPDataServer;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.AgentPeerListener;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.LocalConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.tptp.platform.agentcontroller.internal.DataConnection;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConnectionFactoryImpl;

public class AgentImpl
implements Agent,
ProcessListener,
ConnectionListener {
    protected String _name = null;
    protected String _type = null;
    protected String _uuid = null;
    protected Process _process = null;
    protected AgentConfiguration _config;
    protected boolean _autoAttach = false;
    protected boolean _isMonitored = false;
    protected boolean _isActive = false;
    protected boolean _isAttached = false;
    protected TCPDataServer _server = null;
    protected MultiplexedDataServer _server_mux = null;
    protected String _profileFile = null;
    protected Vector _listeners = new Vector(10);
    private Object _lock = new Object();
    private boolean _isLocal = false;

    public AgentImpl(Process process, String name) {
        this(process, name, null);
    }

    public AgentImpl(Process process, String name, String type) {
        this(process, name, type, false);
    }

    public AgentImpl(Process process, String name, String type, boolean active) {
        this._process = process;
        this._name = name;
        this._type = type;
        this._isActive = active;
        process.addProcessListener(this);
        try {
            Connection _connection = process.getNode().getConnection();
            if (_connection == null) {
                throw new UncheckedNotConnectedException();
            }
            _connection.addConnectionListener(this);
            if (_connection instanceof LocalConnectionImpl) {
                this._isLocal = true;
                _connection.addConnectionListener(this);
            }
        }
        catch (InactiveProcessException inactiveProcessException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentListener(AgentListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgentListener(AgentListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(listener)) {
                this._listeners.remove(listener);
            }
        }
    }

    public Process getProcess() {
        return this._process;
    }

    public void setAutoAttach(boolean auto) {
        this._autoAttach = auto;
        Process proc = this.getProcess();
        if (proc != null && proc.isActive()) {
            ControlMessage message = new ControlMessage();
            RegisterAgentInterestCommand command = new RegisterAgentInterestCommand();
            command.setAgentName(this._name);
            try {
                command.setProcessId(new Long(proc.getProcessId()));
                message.appendCommand(command);
                proc.getNode().getConnection().sendMessage(message, new CommandHandler(){

                    public void incommingCommand(Node node, CommandElement element) {
                        AgentImpl.this.handleCommand(element);
                    }
                });
            }
            catch (InactiveProcessException inactiveProcessException) {
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isAutoAttach() {
        return this._autoAttach;
    }

    public void attach() throws InactiveAgentException, InactiveProcessException {
        this.setAttached(true);
        ControlMessage message = new ControlMessage();
        AttachToAgentCommand command = new AttachToAgentCommand();
        command.setAgentName(this._name);
        command.setProcessId(Long.valueOf(this.getProcess().getProcessId()));
        message.appendCommand(command);
        try {
            this._process.getNode().getConnection().sendMessage(message, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement command) {
                    AgentImpl.this.handleCommand(command);
                }
            });
        }
        catch (IOException iOException) {}
    }

    public void detach() throws InactiveAgentException, InactiveProcessException {
        this.setAttached(false);
        this.stopMonitoring();
        this._server = null;
        this._server_mux = null;
        ControlMessage message = new ControlMessage();
        DetachFromAgentCommand command = new DetachFromAgentCommand();
        command.setAgentName(this._name);
        command.setProcessId(Long.valueOf(this.getProcess().getProcessId()));
        message.appendCommand(command);
        try {
            this._process.getNode().getConnection().sendMessage(message, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement command) {
                    AgentImpl.this.handleCommand(command);
                }
            });
        }
        catch (IOException iOException) {}
    }

    public String getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getUUID() {
        return this._uuid;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public boolean isMonitored() {
        return this._isMonitored;
    }

    public boolean isAttached() {
        return this.isAttached(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(boolean remote) {
        if (!remote) {
            return this._isAttached;
        }
        ControlMessage message = new ControlMessage();
        AgentQueryStateCommand command = new AgentQueryStateCommand();
        Object object = this._lock;
        synchronized (object) {
            try {
                command.setAgentName(this._name);
                command.setProcessId(Long.valueOf(this.getProcess().getProcessId()));
                message.appendCommand(command);
                this._process.getNode().getConnection().sendMessage(message, new CommandHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void incommingCommand(Node node, CommandElement command) {
                        switch ((int)command.getTag()) {
                            case 44: {
                                AgentImpl.this.setAttached(true);
                                Object object = AgentImpl.this._lock;
                                synchronized (object) {
                                    AgentImpl.this._lock.notify();
                                    break;
                                }
                            }
                            case 45: {
                                AgentImpl.this.setAttached(false);
                                Object object = AgentImpl.this._lock;
                                synchronized (object) {
                                    AgentImpl.this._lock.notify();
                                    break;
                                }
                            }
                        }
                    }
                });
                this._lock.wait(5000L);
            }
            catch (InactiveProcessException inactiveProcessException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return this._isAttached;
    }

    public void startMonitoring(DataProcessor processor) throws InactiveAgentException {
        DataConnection dataConnection = null;
        int port = 0;
        if (!this._isAttached) {
            return;
        }
        if (this._isLocal) {
            dataConnection = ConnectionFactoryImpl.createDirectDataConnection();
            port = -Integer.parseInt(dataConnection.getConnectionName());
            if (this._server == null) {
                this._server = new TCPDataServer(dataConnection);
                try {
                    this._server.startServer(processor);
                }
                catch (Exception exception) {}
            } else {
                this._server.resumeServer(processor);
            }
        } else {
            dataConnection = ConnectionFactoryImpl.createSocketDataConnection();
            port = Integer.parseInt(dataConnection.getConnectionName());
            if (this._server == null) {
                this._server = new TCPDataServer(dataConnection);
                this._server_mux = new MultiplexedDataServer();
                this.addAgentListener(this._server_mux);
                try {
                    this._server.startServer(processor);
                    this._server_mux.startServer(processor);
                }
                catch (Exception exception) {}
            } else {
                this._server.resumeServer(processor);
            }
        }
        ControlMessage message = new ControlMessage();
        StartMonitoringRemoteAgentCommand command = new StartMonitoringRemoteAgentCommand();
        command.setAgentName(this._name);
        try {
            command.setInetAddress(InetAddress.getLocalHost());
        }
        catch (UnknownHostException unknownHostException) {}
        command.setPort((short)port);
        try {
            command.setProcessId(Long.parseLong(this._process.getProcessId()));
            message.appendCommand(command);
            this._process.getNode().getConnection().sendMessage(message, null);
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new InactiveAgentException();
        }
        catch (IOException iOException) {}
        this.setMonitored(true);
    }

    public void stopMonitoring() throws InactiveAgentException {
        if (this._server != null) {
            this._server.stopServer();
        }
        if (!this._isMonitored) {
            return;
        }
        ControlMessage message = new ControlMessage();
        StopMonitorCommand command = new StopMonitorCommand();
        command.setAgentName(this._name);
        try {
            command.setProcessId(Long.parseLong(this._process.getProcessId()));
            message.appendCommand(command);
            this._process.getNode().getConnection().sendMessage(message, null);
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new InactiveAgentException();
        }
        catch (IOException iOException) {}
        this.setMonitored(false);
    }

    public void setConfiguration(AgentConfiguration config) {
        this._config = config;
    }

    public AgentConfiguration getConfiguration() {
        if (this._config == null) {
            this._config = new AgentConfiguration();
        }
        return this._config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishConfiguration() throws InactiveAgentException {
        if (!this._isActive) {
            throw new InactiveAgentException();
        }
        if (this._config == null) {
            return;
        }
        int entryCount = 0;
        ControlMessage message = new ControlMessage();
        AgentConfiguration agentConfiguration = this._config;
        synchronized (agentConfiguration) {
            int i = 0;
            while (i < this._config.size()) {
                AgentConfigurationEntry entry = this._config.getEntryAt(i);
                if (entry != null && entry.isEnabled()) {
                    ++entryCount;
                    SetNVPairCommand command = new SetNVPairCommand();
                    try {
                        command.setProcessId(Long.parseLong(this._process.getProcessId()));
                    }
                    catch (InactiveProcessException inactiveProcessException) {
                        throw new InactiveAgentException();
                    }
                    command.setAgentName(this._name);
                    command.setType(entry.getType());
                    command.setName(entry.getName());
                    command.setValue(entry.getValue());
                    message.appendCommand(command);
                }
                ++i;
            }
        }
        if (entryCount > 0) {
            try {
                this._process.getNode().getConnection().sendMessage(message, null);
            }
            catch (InactiveProcessException inactiveProcessException) {
                throw new InactiveAgentException();
            }
            catch (IOException iOException) {}
        }
    }

    public void invokeCustomCommand(CustomCommand command) throws InactiveAgentException {
        if (!this._isActive) {
            throw new InactiveAgentException();
        }
        ControlMessage message = new ControlMessage();
        message.appendCommand(command);
        command.setAgentName(this._name);
        try {
            command.setProcessId(Long.parseLong(this._process.getProcessId()));
            this._process.getNode().getConnection().sendMessage(message, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement element) {
                    AgentImpl.this.handleCommand(element);
                }
            });
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new InactiveAgentException();
        }
        catch (IOException iOException) {}
    }

    public void setUUID(String uuid) {
        this._uuid = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(final CommandElement command) {
        switch ((int)command.getTag()) {
            case 35: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    this.setActive(true);
                    if (this._autoAttach) {
                        this.setAttached(true);
                    }
                    Enumeration elements = this._listeners.elements();
                    while (elements.hasMoreElements()) {
                        ((AgentListener)elements.nextElement()).agentActive(this);
                    }
                    break;
                }
            }
            case 36: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    this.setActive(false);
                    Enumeration elements = this._listeners.elements();
                    while (elements.hasMoreElements()) {
                        ((AgentListener)elements.nextElement()).agentInactive(this);
                    }
                    break;
                }
            }
            case 37: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration elements = this._listeners.elements();
                    while (elements.hasMoreElements()) {
                        ((AgentListener)elements.nextElement()).error(this, ((ErrorCommand)command).getErrorId(), ((ErrorCommand)command).getErrorString());
                    }
                    break;
                }
            }
            case 98: 
            case 102: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    try {
                        InetAddress address = ((MonitorPeerRequestCommand)command).getPeerNode();
                        if (address != null) {
                            final Node node = NodeFactory.createNode(address.getHostAddress());
                            if (!node.isConnected()) {
                                int port = command.getTag() == 102L ? (int)((MonitorPeerRequestPortCommand)command).getTargetPort() : 10002;
                                node.connect(port);
                            }
                            final AgentImpl agent = this;
                            Runnable delegate = new Runnable(){

                                public void run() {
                                    String peerProcessId = Long.toString(((MonitorPeerRequestCommand)command).getProcessId());
                                    Enumeration processes = null;
                                    try {
                                        processes = node.listProcesses();
                                    }
                                    catch (NotConnectedException notConnectedException) {}
                                    Process proc = null;
                                    while (processes.hasMoreElements()) {
                                        proc = (Process)processes.nextElement();
                                        try {
                                            if (proc.getProcessId().equals(peerProcessId)) break;
                                            proc = null;
                                        }
                                        catch (InactiveProcessException inactiveProcessException) {}
                                    }
                                    if (proc == null) {
                                        return;
                                    }
                                    Agent peer = proc.getAgent(((MonitorPeerRequestCommand)command).getAgentName());
                                    if (peer == null) {
                                        return;
                                    }
                                    Enumeration elements = AgentImpl.this._listeners.elements();
                                    while (elements.hasMoreElements()) {
                                        AgentListener listener = (AgentListener)elements.nextElement();
                                        if (!(listener instanceof AgentPeerListener)) continue;
                                        ((AgentPeerListener)listener).peerWaiting(agent, peer);
                                    }
                                }
                            };
                            Thread newThread = new Thread(delegate, "PeerDelegate");
                            newThread.start();
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                    catch (AgentControllerUnavailableException agentControllerUnavailableException) {}
                    break;
                }
            }
            case 41: {
                try {
                    ProcessImpl process = (ProcessImpl)this.getProcess();
                    if (process == null) break;
                    this.processExited(process);
                    process.handleCommand(command);
                }
                catch (ClassCastException classCastException) {}
                break;
            }
            default: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration elements = this._listeners.elements();
                    while (elements.hasMoreElements()) {
                        ((AgentListener)elements.nextElement()).handleCommand(this, command);
                    }
                    break;
                }
            }
        }
    }

    private void cleanup() {
        if (this._process != null) {
            try {
                this._process.getNode().getConnection().removeConnectionListener(this);
            }
            catch (InactiveProcessException inactiveProcessException) {}
            this._process = null;
        }
        if (this._listeners != null) {
            this._listeners.clear();
        }
        this._server = null;
        this._server_mux = null;
    }

    public void processLaunched(Process process) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExited(Process process) {
        if (this._server != null) {
            this._server.shutdownServer();
        }
        if (this._server_mux != null) {
            this._server_mux.shutdownServer();
        }
        this._server = null;
        this._server_mux = null;
        if (process == this._process && this._isActive) {
            Vector vector = this._listeners;
            synchronized (vector) {
                this.setActive(false);
                Enumeration elements = this._listeners.elements();
                while (elements.hasMoreElements()) {
                    ((AgentListener)elements.nextElement()).agentInactive(this);
                }
            }
        }
        this.cleanup();
    }

    public boolean isToProfileFile() {
        return this._profileFile != null && this._profileFile.trim().length() != 0;
    }

    public String getProfileFile() {
        return this._profileFile;
    }

    public void setProfileFile(String _profileFile) {
        this._profileFile = _profileFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        Vector vector = this._listeners;
        synchronized (vector) {
            this.setActive(false);
            Enumeration elements = this._listeners.elements();
            while (elements.hasMoreElements()) {
                ((AgentListener)elements.nextElement()).agentInactive(this);
            }
        }
    }

    public void setProcess(Process p) {
        this._process = p;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setActive(boolean isActive) {
        this._isActive = isActive;
        if (!isActive) {
            this.setMonitored(false);
            this.setAttached(false);
        }
    }

    public void setMonitored(boolean isMonitored) {
        this._isMonitored = isMonitored;
    }

    public void setAttached(boolean isAttached) {
        this._isAttached = isAttached;
    }

    public static class UncheckedNotConnectedException
    extends RuntimeException {
        private static final long serialVersionUID = 3579779634351360004L;
    }
}

