/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.hyades.execution.local.CommunicationDebug;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.common.ExtendedDataServerListener;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.tptp.platform.agentcontroller.internal.DataConnection;

public class TCPDataServer {
    private String MESSAGE_VALUE_ID = "messageValue";
    private DataConnection _dataConnection = null;
    private TCPDataProcessor _server = null;
    private BufferFlusher _flusher = null;
    private int _port;
    private boolean _isDataServerRunning = true;
    private static final short NUM_BUFFERS = 32;
    private SingleBuffer[] _bufferArray;
    private short _currentFullBuffers = 0;
    public static final byte BINARY_DATA = 0;
    public static final byte UTF8_STRING_DATA = 1;
    public static final byte UNICODE_STRING_DATA = 2;
    private int totalBytes = 0;
    public static final int BUFFER_SIZE = 64768;

    public TCPDataServer() {
    }

    public TCPDataServer(DataConnection connection) {
        this._dataConnection = connection;
    }

    public int getPort() {
        return this._port;
    }

    public void startLocalServer(DataProcessor processor) throws IOException {
        int instance = Integer.parseInt(this._dataConnection.getConnectionId());
        this.startServer(processor, -instance);
    }

    public void startServer(DataProcessor processor, int port) throws IOException {
        if (!CommunicationDebug.INSTANCE.debugUseOldDataServer) {
            this.startServerNew(processor, port);
        } else {
            this._bufferArray = new SingleBuffer[32];
            int i = 0;
            while (i < 32) {
                this._bufferArray[i] = new SingleBuffer();
                ++i;
            }
            this._port = this._dataConnection.getPort();
            this._server = new TCPDataProcessor();
            this._server.setName("TCPDataFiller");
            this._flusher = new BufferFlusher();
            this._flusher.setProcessor(processor);
            this._flusher.setName("TCPDataFlusher");
            this._server.setDaemon(true);
            this._flusher.setDaemon(true);
            this._flusher.setPriority(this._server.getPriority() + 3);
            this._server.start();
            this._flusher.start();
        }
    }

    private void startServerNew(DataProcessor processor, int port) throws IOException {
        this._bufferArray = new SingleBuffer[32];
        int i = 0;
        while (i < 32) {
            this._bufferArray[i] = new SingleBuffer();
            ++i;
        }
        this._server = new TCPDataProcessorNew();
        this._server.setName("TCPDataFiller");
        ((TCPDataProcessorNew)this._server).setProcessor(processor);
        this._server.setDaemon(true);
        this._server.start();
    }

    public void startServer(DataProcessor processor) throws IOException {
        this.startServer(processor, 0);
    }

    public boolean isProcessing() {
        return this._isDataServerRunning;
    }

    public void stopServer() {
        this._server.pauseProcessing();
    }

    public void resumeServer() {
        this._server.resumeProcessing();
    }

    public void resumeServer(DataProcessor processor) {
        if (!CommunicationDebug.INSTANCE.debugUseOldDataServer) {
            this.resumeServerNew(processor);
        } else {
            this._flusher.setProcessor(processor);
            this._server.resumeProcessing();
        }
    }

    private void resumeServerNew(DataProcessor processor) {
        this._server.resumeProcessing();
        ((TCPDataProcessorNew)this._server).setProcessor(processor);
    }

    public void shutdownServer() {
        if (!CommunicationDebug.INSTANCE.debugUseOldDataServer) {
            this.shutdownServerNew();
        } else {
            this._server.shutdown();
            this._flusher.shutdown();
        }
    }

    private void shutdownServerNew() {
        this._server.shutdown();
    }

    class BufferFlusher
    extends Thread
    implements Constants {
        private DataProcessor _processor = null;
        private byte[] _binaryForwardBuffer = new byte[8096];
        private char[] _stringForwardBuffer = new char[8096];
        private byte[] _messageHeader = new byte[10];
        private long _currentBufferSize = 8096L;
        private short _currentFlusherBuffer = 0;
        private int _currentHeaderOffset = 0;
        private int _bytesWritten = 0;

        BufferFlusher() {
        }

        public void setProcessor(DataProcessor processor) {
            this._processor = processor;
        }

        protected int loadMessageHeader(byte[] data, int offset, int limit) {
            while (offset < limit && this._currentHeaderOffset < 10) {
                this._messageHeader[this._currentHeaderOffset++] = data[offset++];
            }
            return offset;
        }

        protected long getMessageLength() {
            return Message.readRALongFromBuffer(this._messageHeader, 5);
        }

        protected byte getMessageType() {
            return this._messageHeader[9];
        }

        protected boolean checkMessageMagic() {
            return true;
        }

        /*
         * Unable to fully structure code
         */
        protected int processData(byte[] data, int offset, int limit, InetAddress addr) {
            current = offset;
            if (offset >= limit) {
                return limit;
            }
            if (this._currentHeaderOffset < 10) {
                if ((current = this.loadMessageHeader(data, current, limit)) == limit) {
                    return current;
                }
                if (this.getMessageLength() >= this._currentBufferSize) {
                    type = this.getMessageType();
                    if (type == 0 || type == 1) {
                        replacement = new byte[(int)this.getMessageLength()];
                        System.arraycopy(data, current, replacement, 0, limit - current);
                        this._bytesWritten = limit - current;
                        this._binaryForwardBuffer = replacement;
                    } else {
                        replacement = new char[(int)this.getMessageLength()];
                        i = 0;
                        while (i < limit - current + 1) {
                            try {
                                replacement[i] = (char)data[i + current];
                            }
                            catch (Exception e) {
                                System.out.println("BufferFlusher.processData(): replacement[i]=(char)data[i+current];");
                                System.out.println("BufferFlusher.processData(): repalcement.length=" + replacement.length + ", data.length=" + data.length + ", i=" + i + ", current=" + current);
                                e.printStackTrace(System.out);
                                throw new RuntimeException(e);
                            }
                            ++i;
                        }
                        this._bytesWritten = limit - current;
                        this._stringForwardBuffer = replacement;
                    }
                    return limit;
                }
            }
            if (!this.checkMessageMagic()) {
                System.out.println("BufferFlusher.processData(): Corrupt data");
                this._currentHeaderOffset = 0;
                return this.processData(data, offset + 1, limit, addr);
            }
            messageLength = this.getMessageLength();
            type = this.getMessageType();
            while (current < limit) {
                if (type == 0 || type == 1) {
                    while (current < limit && (long)this._bytesWritten < messageLength) {
                        this._binaryForwardBuffer[this._bytesWritten++] = data[current++];
                    }
                    if ((long)this._bytesWritten != messageLength) continue;
                    this._processor.incommingData(this._binaryForwardBuffer, this._bytesWritten, addr);
                    this._bytesWritten = 0;
                    this._currentHeaderOffset = 0;
                    current = this.processData(data, current, limit, addr);
                    continue;
                }
                if (type != 2) ** GOTO lbl60
                while (offset < limit && (long)this._bytesWritten < messageLength) {
                    this._stringForwardBuffer[this._bytesWritten >> 1] = (char)((char)data[current++] | (char)(data[current++] << 8));
                    this._bytesWritten += 2;
                }
                if ((long)this._bytesWritten != messageLength) continue;
                this._processor.incommingData(this._stringForwardBuffer, this._bytesWritten, addr);
                this._bytesWritten = 0;
                this._currentHeaderOffset = 0;
                current = this.processData(data, current, limit, addr);
                continue;
lbl-1000:
                // 1 sources

                {
                    this._binaryForwardBuffer[this._bytesWritten++] = data[current++];
lbl60:
                    // 2 sources

                    ** while (offset < limit && (long)this._bytesWritten < messageLength)
                }
lbl61:
                // 1 sources

                if ((long)this._bytesWritten != messageLength) continue;
                this._processor.incommingData(this._binaryForwardBuffer, this._bytesWritten, addr);
                this._bytesWritten = 0;
                this._currentHeaderOffset = 0;
                current = this.processData(data, current, limit, addr);
            }
            return current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (CommunicationDebug.INSTANCE.debugMessageValue) {
                TCPDataServer.this.MESSAGE_VALUE_ID = String.valueOf(TCPDataServer.this.MESSAGE_VALUE_ID) + "_" + this.hashCode();
            }
            block8: while (TCPDataServer.this.isProcessing() || TCPDataServer.this._currentFullBuffers != 0) {
                SingleBuffer singleBuffer;
                if (TCPDataServer.this._currentFullBuffers == 0) {
                    this._processor.waitingForData();
                    do {
                        singleBuffer = TCPDataServer.this._bufferArray[0];
                        synchronized (singleBuffer) {
                            try {
                                TCPDataServer.this._bufferArray[0].wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                        if (!TCPDataServer.this.isProcessing() && TCPDataServer.this._currentFullBuffers == 0) break block8;
                    } while (TCPDataServer.this._currentFullBuffers == 0);
                }
                if (((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length > 0) {
                    if (CommunicationDebug.INSTANCE.debugMessageValue) {
                        CommunicationDebug.INSTANCE.writeBinaryLog(TCPDataServer.this.MESSAGE_VALUE_ID, ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].data, 0, ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length);
                    }
                    this.processData(((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].data, 0, ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length, ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].addr);
                    ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFlusherBuffer].length = 0;
                }
                singleBuffer = TCPDataServer.this._bufferArray[0];
                synchronized (singleBuffer) {
                    TCPDataServer tCPDataServer = TCPDataServer.this;
                    tCPDataServer._currentFullBuffers = (short)(tCPDataServer._currentFullBuffers - 1);
                    this._currentFlusherBuffer = (short)(this._currentFlusherBuffer + 1);
                    if (this._currentFlusherBuffer == 32) {
                        this._currentFlusherBuffer = 0;
                    }
                    if (TCPDataServer.this._currentFullBuffers == 0) {
                        TCPDataServer.this._bufferArray[0].notifyAll();
                    }
                }
            }
            if (this._processor instanceof DataServerListener) {
                ((DataServerListener)this._processor).dataServerExited();
            }
        }

        public void shutdown() {
        }
    }

    class SingleBuffer
    implements Constants {
        public InetAddress addr;
        public int length = 0;
        public int size = 8096;
        public byte[] data = new byte[8096];

        SingleBuffer() {
        }
    }

    class TCPDataProcessor
    extends Thread
    implements Constants {
        boolean _processing = true;
        protected boolean _shutdown = false;
        protected short _currentFillerBuffer = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                this._processing = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pauseProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                this._processing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isProcessing() {
            TCPDataProcessor tCPDataProcessor = this;
            synchronized (tCPDataProcessor) {
                if (CommunicationDebug.INSTANCE.debug) {
                    System.out.println("TCPDataServer.isProcessing()=" + this._processing + " - " + this);
                }
                return this._processing;
            }
        }

        public void shutdown() {
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("TCPDataServer.shutdown() - " + this);
            }
            this._shutdown = true;
            this.pauseProcessing();
            this.interrupt();
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("TCPDataServer.shutdown(): after - " + this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TCPDataServer.this._isDataServerRunning = true;
            block15: while (!this._shutdown || TCPDataServer.this._currentFullBuffers != 0) {
                if (this.isProcessing()) {
                    InputStream is;
                    TCPDataServer.this._dataConnection.create();
                    do {
                        if ((is = TCPDataServer.this._dataConnection.getInputStream()) != null) continue;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } while (is == null);
                    while (true) {
                        block28: {
                            if (TCPDataServer.this._currentFullBuffers == 32) {
                                SingleBuffer e = TCPDataServer.this._bufferArray[0];
                                synchronized (e) {
                                    try {
                                        TCPDataServer.this._bufferArray[0].wait();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].addr = TCPDataServer.this._dataConnection.getAddress();
                            try {
                                int _bytes = ((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].length = is.read(((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].data);
                                TCPDataServer tCPDataServer = TCPDataServer.this;
                                tCPDataServer.totalBytes = tCPDataServer.totalBytes + _bytes;
                                if (_bytes != -1) break block28;
                                TCPDataServer.this._isDataServerRunning = false;
                            }
                            catch (InterruptedIOException e) {
                                if (CommunicationDebug.INSTANCE.debug) {
                                    e.printStackTrace(System.out);
                                }
                                if (this._shutdown && TCPDataServer.this._currentFullBuffers == 0) {
                                    this.pauseProcessing();
                                    TCPDataServer.this._isDataServerRunning = false;
                                    TCPDataServer.this._dataConnection.destroyConnection();
                                    break block15;
                                }
                            }
                            catch (IOException e) {
                                if (CommunicationDebug.INSTANCE.debug) {
                                    e.printStackTrace(System.out);
                                }
                                this.pauseProcessing();
                                TCPDataServer.this._isDataServerRunning = false;
                                TCPDataServer.this._dataConnection.destroyConnection();
                                break block15;
                            }
                        }
                        if (((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].length < 0) {
                            this.pauseProcessing();
                            TCPDataServer.this._isDataServerRunning = false;
                            TCPDataServer.this._dataConnection.destroyConnection();
                            break block15;
                        }
                        SingleBuffer singleBuffer = TCPDataServer.this._bufferArray[0];
                        synchronized (singleBuffer) {
                            if (((TCPDataServer)TCPDataServer.this)._bufferArray[this._currentFillerBuffer].length > 0) {
                                this._currentFillerBuffer = (short)(this._currentFillerBuffer + 1);
                                if (this._currentFillerBuffer == 32) {
                                    this._currentFillerBuffer = 0;
                                }
                                TCPDataServer tCPDataServer = TCPDataServer.this;
                                tCPDataServer._currentFullBuffers = (short)(tCPDataServer._currentFullBuffers + 1);
                                if (TCPDataServer.this._currentFullBuffers == 1) {
                                    TCPDataServer.this._bufferArray[0].notifyAll();
                                }
                            }
                        }
                    }
                }
                try {
                    if (CommunicationDebug.INSTANCE.debug) {
                        System.out.println("TCPDataProcessor.run() - Monitoring is stopped, keep this thread in sleep state !");
                    }
                    TCPDataProcessor.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class TCPDataProcessorNew
    extends TCPDataProcessor {
        protected ExtendedDataServerListener _extendedProcessor;
        protected DataProcessor _processor;
        protected InetAddress _currentBufferAddr;
        protected byte[] _currentBufferData;
        protected int _currentBufferLength;
        protected long _currentMessageLength;
        protected byte _currentMessageType;
        protected int _currentHeaderOffset;
        protected char[] _stringForwardBuffer;
        protected byte[] _binaryForwardBuffer;
        protected int _bytesWritten;
        protected int _bytesRead;
        protected boolean _useExtendedProcessor;
        protected int _processed;
        protected byte[] _copyBuffer;
        protected boolean crimsonParser;
        protected boolean breakOuter;
        protected byte[] _inputStreamModeBuffer;
        protected int _inputStreamModeBufferLength;
        protected int _inputStreamModeRecieverBufferLength;
        protected int _inputStreamModeBufferPos;

        public void run() {
            this.crimsonParser = this.isCrimsonParser();
            if (CommunicationDebug.INSTANCE.debugMessageValue) {
                TCPDataServer.this.MESSAGE_VALUE_ID = String.valueOf(TCPDataServer.this.MESSAGE_VALUE_ID) + "_newDataProcessor_debugMessageValue_" + this.hashCode();
            }
            TCPDataServer.this._isDataServerRunning = true;
            this._currentBufferData = new byte[64768];
            this.initLocalVariables();
            if (this._processor instanceof ExtendedDataServerListener) {
                this._useExtendedProcessor = true;
                this._extendedProcessor = (ExtendedDataServerListener)this._processor;
            } else {
                this._copyBuffer = new byte[64768];
            }
            block11: while (!this._shutdown && TCPDataServer.this._isDataServerRunning) {
                if (CommunicationDebug.INSTANCE.debug) {
                    System.out.println("TCPDataServerNew.run(): step outer while loop!");
                }
                if (this.isProcessing()) {
                    InputStream is;
                    TCPDataServer.this._dataConnection.create();
                    do {
                        if ((is = TCPDataServer.this._dataConnection.getInputStream()) != null) continue;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } while (!this._shutdown && is == null);
                    if (this._shutdown) {
                        return;
                    }
                    this._currentBufferAddr = TCPDataServer.this._dataConnection.getAddress();
                    if (!CommunicationDebug.INSTANCE.debugUseEventMode && this._useExtendedProcessor && !this.crimsonParser) {
                        this._inputStreamModeBuffer = new byte[64768];
                        InputStream delegatedInputStream = is;
                        InputStream isFiltered = new InputStream(this, delegatedInputStream){
                            byte[] oneByte;
                            final /* synthetic */ TCPDataProcessorNew this$1;
                            private final /* synthetic */ InputStream val$delegatedInputStream;
                            {
                                this.this$1 = tCPDataProcessorNew;
                                this.val$delegatedInputStream = inputStream;
                                this.oneByte = new byte[1];
                            }

                            public int available() throws IOException {
                                return this.val$delegatedInputStream.available();
                            }

                            public void close() throws IOException {
                                this.val$delegatedInputStream.close();
                            }

                            public synchronized void mark(int readlimit) {
                                this.val$delegatedInputStream.mark(readlimit);
                            }

                            public boolean markSupported() {
                                return this.val$delegatedInputStream.markSupported();
                            }

                            public int read(byte[] b) throws IOException {
                                return this.read(b, 0, b.length);
                            }

                            public synchronized void reset() throws IOException {
                                this.val$delegatedInputStream.reset();
                            }

                            public long skip(long n) throws IOException {
                                return this.val$delegatedInputStream.skip(n);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public synchronized int read(byte[] b, int off, int len) throws IOException {
                                while (true) {
                                    if (this.this$1._inputStreamModeBufferPos != this.this$1._inputStreamModeBufferLength) {
                                        return this.copyInputData(b, off, len);
                                    }
                                    this.this$1._inputStreamModeBufferPos = 0;
                                    this.this$1._inputStreamModeBufferLength = 0;
                                    if (this.this$1._currentBufferLength == this.this$1._currentBufferData.length) {
                                        this.this$1.breakOuter = false;
                                        TCPDataProcessorNew.access$0(this.this$1);
                                        if (this.this$1.breakOuter) {
                                            return -1;
                                        }
                                    }
                                    this.this$1._bytesRead = this.val$delegatedInputStream.read(this.this$1._currentBufferData, this.this$1._currentBufferLength, this.this$1._currentBufferData.length - this.this$1._currentBufferLength);
                                    if (this.this$1._bytesRead <= 0) break;
                                    if (CommunicationDebug.INSTANCE.debugMessageValue) {
                                        CommunicationDebug.INSTANCE.writeBinaryLog(TCPDataServer.access$7(TCPDataProcessorNew.access$2(this.this$1)), this.this$1._currentBufferData, this.this$1._currentBufferLength, this.this$1._bytesRead);
                                    }
                                    this.this$1._currentBufferLength += this.this$1._bytesRead;
                                    if (this.this$1._currentBufferLength <= 10) return 0;
                                    this.this$1.processCurrentBuffer();
                                    int ret = this.copyInputData(b, off, len);
                                    if (ret != 0) return ret;
                                }
                                if (this.this$1._bytesRead >= 0) return 0;
                                TCPDataProcessorNew.access$1(this.this$1, TCPDataServer.access$2(TCPDataProcessorNew.access$2(this.this$1)));
                                return -1;
                            }

                            protected int copyInputData(byte[] b, int off, int len) {
                                int ret = 0;
                                len = Math.min(len, this.this$1._inputStreamModeBufferLength - this.this$1._inputStreamModeBufferPos);
                                System.arraycopy(this.this$1._inputStreamModeBuffer, this.this$1._inputStreamModeBufferPos, b, off, len);
                                this.this$1._inputStreamModeBufferPos += len;
                                return ret + len;
                            }

                            public int read() throws IOException {
                                if (this.read(this.oneByte, 0, 1) == -1) {
                                    return -1;
                                }
                                return this.oneByte[0];
                            }
                        };
                        try {
                            this._extendedProcessor.incommingStream(isFiltered, this._currentBufferAddr);
                        }
                        catch (Exception e) {
                            if (CommunicationDebug.INSTANCE.debug) {
                                System.out.println("TCPDataProcessorNew.run() - _extendedProcessor.incommingStream ended with exception, " + this._extendedProcessor);
                                e.printStackTrace(System.out);
                            }
                            this.done(TCPDataServer.this._dataConnection);
                            break;
                        }
                        if (!CommunicationDebug.INSTANCE.debug) continue;
                        System.out.println("TCPDataProcessorNew.run() - _extendedProcessor.incommingStream ended, " + this._extendedProcessor);
                        continue;
                    }
                    while (true) {
                        try {
                            while (true) {
                                if (this._processed != 0 && this._currentMessageLength > Integer.MAX_VALUE) {
                                    this._currentHeaderOffset = 0;
                                    this.recover();
                                    continue;
                                }
                                if (this._currentBufferLength == this._currentBufferData.length) {
                                    this.breakOuter = false;
                                    this.extendBuffer();
                                    if (this.breakOuter) break block11;
                                }
                                this._bytesRead = is.read(this._currentBufferData, this._currentBufferLength, this._currentBufferData.length - this._currentBufferLength);
                                if (this._bytesRead > 0) {
                                    if (CommunicationDebug.INSTANCE.debugMessageValue) {
                                        CommunicationDebug.INSTANCE.writeBinaryLog(TCPDataServer.this.MESSAGE_VALUE_ID, this._currentBufferData, this._currentBufferLength, this._bytesRead);
                                    }
                                    this._currentBufferLength += this._bytesRead;
                                    if (this._currentBufferLength <= 10) continue;
                                    this._processed = 0;
                                    this.processCurrentBuffer();
                                    continue;
                                }
                                if (this._bytesRead < 0) break;
                            }
                            this.done(TCPDataServer.this._dataConnection);
                            break block11;
                        }
                        catch (InterruptedIOException e) {
                            if (CommunicationDebug.INSTANCE.debug) {
                                System.out.println("TCPDataProcessorNew.run() - timeout e.bytesTransferred=" + e.bytesTransferred);
                                e.printStackTrace(System.out);
                            }
                            if (e.bytesTransferred <= 0) continue;
                            this._bytesRead = e.bytesTransferred;
                            if (CommunicationDebug.INSTANCE.debugMessageValue) {
                                CommunicationDebug.INSTANCE.writeBinaryLog(TCPDataServer.this.MESSAGE_VALUE_ID, this._currentBufferData, this._currentBufferLength, this._bytesRead);
                            }
                            this._currentBufferLength += this._bytesRead;
                            if (this._currentBufferLength <= 10) continue;
                            this._processed = 0;
                            this.processCurrentBuffer();
                            continue;
                        }
                        catch (IOException e) {
                            if (CommunicationDebug.INSTANCE.debug) {
                                e.printStackTrace(System.out);
                            }
                            this.done(TCPDataServer.this._dataConnection);
                            break block11;
                        }
                        break;
                    }
                }
                try {
                    if (CommunicationDebug.INSTANCE.debug) {
                        System.out.println("TCPDataProcessorNew.run() - Monitoring is stopped, keep this thread in sleep state !");
                    }
                    TCPDataProcessorNew.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("TCPDataServerNew.run(): exited outter while loop!");
            }
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("TCPDataProcessorNew.run() - Close socket !");
            }
            TCPDataServer.this._dataConnection.destroyConnection();
            if (this._processor instanceof DataServerListener) {
                ((DataServerListener)this._processor).dataServerExited();
            }
            if (CommunicationDebug.INSTANCE.debugMessageValue) {
                try {
                    CommunicationDebug.INSTANCE.getBinaryLog(TCPDataServer.this.MESSAGE_VALUE_ID).flush();
                    CommunicationDebug.INSTANCE.removeBinaryLog(TCPDataServer.this.MESSAGE_VALUE_ID);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void extendBuffer() {
            int remainingData = this._currentBufferLength - this._currentHeaderOffset;
            if (this._currentMessageLength > (long)(this._currentBufferLength - 10)) {
                byte[] b = null;
                try {
                    b = new byte[(int)this._currentMessageLength + 10];
                }
                catch (Throwable e) {
                    if (CommunicationDebug.INSTANCE.debug) {
                        System.out.println("_currentHeaderOffset=" + this._currentHeaderOffset);
                        System.out.println("_currentBufferLength=" + this._currentBufferLength);
                        System.out.println("getMessageLength()=" + this.getMessageLength());
                        System.out.println("getMessageType()=" + this.getMessageType());
                        e.printStackTrace(System.out);
                        CommunicationDebug.INSTANCE.writeBinaryLog(String.valueOf(TCPDataServer.this.MESSAGE_VALUE_ID) + "_" + this._currentHeaderOffset, this._currentBufferData, 0, this._currentBufferLength);
                    }
                    this.breakOuter = true;
                    return;
                }
                System.arraycopy(this._currentBufferData, this._currentHeaderOffset, b, 0, this._currentBufferLength - this._currentHeaderOffset);
                this._currentBufferData = b;
            } else if (remainingData < this._currentHeaderOffset) {
                System.arraycopy(this._currentBufferData, this._currentHeaderOffset, this._currentBufferData, 0, remainingData);
            } else {
                int i = 0;
                while (i < remainingData) {
                    this._currentBufferData[i] = this._currentBufferData[i + this._currentHeaderOffset];
                    ++i;
                }
            }
            this._currentBufferLength = remainingData;
            this._currentHeaderOffset = 0;
        }

        protected boolean isCrimsonParser() {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser p = factory.newSAXParser();
                if (p != null && p.getClass().getName().equals("org.apache.crimson.jaxp.SAXParserImpl")) {
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }

        private void done(DataConnection connection) {
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("TCPDataServerNew.done(): entered - " + this);
            }
            this.pauseProcessing();
            TCPDataServer.this._isDataServerRunning = false;
            connection.destroyConnection();
            if (CommunicationDebug.INSTANCE.debug) {
                new Throwable("TCPDataServerNew.done(): Connection closed ! " + this).printStackTrace(System.out);
            }
        }

        protected int recover() {
            ++this._currentHeaderOffset;
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("TCPDataServerNew.recover(): _currentHeaderOffset = " + this._currentHeaderOffset);
            }
            if (this._currentHeaderOffset == this._currentBufferLength) {
                this.initLocalVariables();
                this._currentHeaderOffset = 0;
            } else {
                this._currentMessageLength = -1L;
                this._processed = 0;
                this.processCurrentBuffer();
            }
            return this._currentHeaderOffset;
        }

        private void initLocalVariables() {
            this._currentHeaderOffset = 0;
            this._currentMessageLength = -1L;
            this._bytesRead = 0;
            this._bytesWritten = 0;
            this._currentBufferLength = 0;
            this._processed = 0;
        }

        public void setProcessor(DataProcessor processor) {
            if (this._processor instanceof ExtendedDataServerListener) {
                this._useExtendedProcessor = true;
                this._extendedProcessor = (ExtendedDataServerListener)this._processor;
            } else {
                this._useExtendedProcessor = false;
                this._processor = processor;
                if (this._copyBuffer == null) {
                    this._copyBuffer = new byte[64768];
                }
            }
        }

        protected long getMessageLength() {
            return Message.readRALongFromBuffer(this._currentBufferData, this._currentHeaderOffset + 5);
        }

        protected byte getMessageType() {
            return this._currentBufferData[this._currentHeaderOffset + 9];
        }

        protected boolean checkMessageMagic() {
            if (this._currentBufferData[this._currentHeaderOffset] != -126) {
                return false;
            }
            if (this._currentBufferData[this._currentHeaderOffset + 1] != 101) {
                return false;
            }
            if (this._currentBufferData[this._currentHeaderOffset + 2] != 103) {
                return false;
            }
            return this._currentBufferData[this._currentHeaderOffset + 3] == -128;
        }

        protected void processCurrentBuffer() {
            if (this._currentBufferLength <= 0) {
                this._processed = 0;
                return;
            }
            int _stopProcessingMarker = this._currentBufferLength - 10;
            while (true) {
                if (this._currentMessageLength < 0L) {
                    while (true) {
                        if (this._currentHeaderOffset > _stopProcessingMarker) {
                            this._processed = 0;
                            return;
                        }
                        if (this.checkMessageMagic()) break;
                        if (CommunicationDebug.INSTANCE.debug) {
                            System.out.println("TCPDataServerNew.processCurrentBuffer() - Invalid magic number in header at: " + this._currentHeaderOffset);
                        }
                        ++this._currentHeaderOffset;
                    }
                    this._currentMessageLength = this.getMessageLength();
                    this._currentMessageType = this.getMessageType();
                }
                if ((long)this._currentHeaderOffset + this._currentMessageLength > (long)_stopProcessingMarker) break;
                this._bytesWritten = this.writeMessage(this._currentHeaderOffset, this._currentBufferData);
                this._processed += this._bytesWritten;
                this._currentHeaderOffset = this._currentHeaderOffset + 10 + this._bytesWritten;
            }
        }

        protected int writeMessage(int _currentHeaderOffset, byte[] _currentBufferData) {
            int _bytesWritten = 0;
            if (this._currentMessageType == 2) {
                int endOffset = _currentHeaderOffset + 10 + (int)this._currentMessageLength;
                int i = _currentHeaderOffset + 10;
                while (i < endOffset) {
                    this._stringForwardBuffer[_bytesWritten >> 1] = (char)((char)_currentBufferData[i++] | (char)(_currentBufferData[i++] << 8));
                    _bytesWritten += 2;
                }
                if ((long)_bytesWritten == this._currentMessageLength) {
                    this._processor.incommingData(this._stringForwardBuffer, _bytesWritten, this._currentBufferAddr);
                    this._currentMessageLength = -1L;
                }
            } else {
                _bytesWritten = (int)this._currentMessageLength;
                if (this._useExtendedProcessor) {
                    if (!CommunicationDebug.INSTANCE.debugUseEventMode && !this.crimsonParser) {
                        if (this._inputStreamModeBuffer.length - this._inputStreamModeBufferLength < _bytesWritten) {
                            byte[] temp = new byte[this._inputStreamModeBufferLength + _bytesWritten + 1024];
                            System.arraycopy(this._inputStreamModeBuffer, 0, temp, 0, this._inputStreamModeBufferLength);
                            this._inputStreamModeBuffer = temp;
                        }
                        System.arraycopy(_currentBufferData, _currentHeaderOffset + 10, this._inputStreamModeBuffer, this._inputStreamModeBufferLength, _bytesWritten);
                        this._inputStreamModeBufferLength += _bytesWritten;
                    } else {
                        this._extendedProcessor.incommingData(_currentBufferData, _currentHeaderOffset + 10, _bytesWritten, this._currentBufferAddr);
                    }
                } else {
                    if (this._copyBuffer.length < _bytesWritten) {
                        this._copyBuffer = new byte[_bytesWritten];
                    }
                    System.arraycopy(_currentBufferData, _currentHeaderOffset + 10, this._copyBuffer, 0, _bytesWritten);
                    this._processor.incommingData(this._copyBuffer, _bytesWritten, this._currentBufferAddr);
                }
                this._currentMessageLength = -1L;
            }
            return _bytesWritten;
        }

        public void shutdown() {
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("TCPDataServerNew.shutdown() - " + this);
            }
            this._shutdown = true;
            TCPDataServer.this._dataConnection.destroyConnection();
        }

        static /* synthetic */ void access$0(TCPDataProcessorNew tCPDataProcessorNew) {
            tCPDataProcessorNew.extendBuffer();
        }

        static /* synthetic */ void access$1(TCPDataProcessorNew tCPDataProcessorNew, DataConnection dataConnection) {
            tCPDataProcessorNew.done(dataConnection);
        }

        static /* synthetic */ TCPDataServer access$2(TCPDataProcessorNew tCPDataProcessorNew) {
            return tCPDataProcessorNew.TCPDataServer.this;
        }
    }
}

