/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;

public class LocalConsole
extends Console {
    private ConsoleOutReader _outReader = null;
    private ConsoleErrReader _errReader = null;
    private ConsoleWaitingThread _waitThread = null;
    private DataProcessor _processor = null;
    private boolean _done = false;
    private InputStream _stdout;
    private InputStream _stderr;
    private OutputStream _stdin;
    private int _bytesWritten = 0;
    private Object _processor_lock = new Object();
    private Object _stdin_lock = new Object();
    private Object _stdout_lock = new Object();
    private Object _stderr_lock = new Object();

    public LocalConsole() {
        this("Local Console");
    }

    public LocalConsole(String name) {
        super(name);
        this.setDaemon(true);
    }

    public LocalConsole(ThreadGroup group, String name) {
        super(group, name);
        this.setDaemon(true);
    }

    private synchronized int getConsoleBytesWritten() {
        return this._bytesWritten;
    }

    public long getIP() {
        return 0L;
    }

    public long getPort() {
        return 0L;
    }

    public ServerSocket getServerSocket() {
        return null;
    }

    public void run() {
        this._outReader = new ConsoleOutReader();
        this._outReader.start();
        this._errReader = new ConsoleErrReader();
        this._errReader.start();
        this._waitThread = new ConsoleWaitingThread();
        this._waitThread.start();
    }

    public void start() {
        this.run();
    }

    private synchronized void setConsoleBytesWritten(int bytes) {
        this._bytesWritten = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataProcessor(DataProcessor processor) {
        Object object = this._processor_lock;
        synchronized (object) {
            this._processor = processor;
            this._processor_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStdOut(InputStream stdout) {
        Object object = this._stdout_lock;
        synchronized (object) {
            this._stdout = stdout;
            this._stdout_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStdErr(InputStream stderr) {
        Object object = this._stderr_lock;
        synchronized (object) {
            this._stderr = stderr;
            this._stderr_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStdIn(OutputStream stdin) {
        Object object = this._stdin_lock;
        synchronized (object) {
            this._stdin = stdin;
            this._stdin_lock.notifyAll();
        }
    }

    public DataProcessor getDataProcessor() {
        return this._processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String data) {
        byte[] b;
        if (this._stdin == null) {
            Object object = this._stdin_lock;
            synchronized (object) {
                try {
                    this._stdin_lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
        try {
            b = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            b = data.getBytes();
        }
        try {
            this._stdin.write(b);
            this._stdin.flush();
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void close() {
        this._done = true;
        if (this._outReader != null) {
            this._outReader.interrupt();
        }
        if (this._errReader != null) {
            this._errReader.interrupt();
        }
        if (this._waitThread != null) {
            this._waitThread.interrupt();
        }
    }

    static /* synthetic */ Object access$0(LocalConsole localConsole) {
        return localConsole._stdout_lock;
    }

    static /* synthetic */ InputStream access$1(LocalConsole localConsole) {
        return localConsole._stdout;
    }

    static /* synthetic */ void access$3(LocalConsole localConsole, boolean bl) {
        localConsole._done = bl;
    }

    static /* synthetic */ Object access$7(LocalConsole localConsole) {
        return localConsole._stderr_lock;
    }

    static /* synthetic */ InputStream access$8(LocalConsole localConsole) {
        return localConsole._stderr;
    }

    class ConsoleErrReader
    extends Thread {
        private byte[] buffer = new byte[1024];

        public ConsoleErrReader() {
            this.setName("Console Error Reader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = LocalConsole.access$7(LocalConsole.this);
            synchronized (var1_1) {
                if (LocalConsole.access$8(LocalConsole.this) == null) {
                    try {
                        LocalConsole.access$7(LocalConsole.this).wait();
                    }
                    catch (InterruptedException v0) {}
                }
                // MONITOREXIT @DISABLED, blocks:[0, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                if (true) ** GOTO lbl40
            }
            do {
                byteRead = -1;
                try {
                    byteRead = LocalConsole.access$8(LocalConsole.this).read(this.buffer);
                }
                catch (IOException v2) {}
                if (byteRead == -1) {
                    LocalConsole.access$3(LocalConsole.this, true);
                    continue;
                }
                try {
                    var2_3 = LocalConsole.access$4(LocalConsole.this);
                    synchronized (var2_3) {
                        if (LocalConsole.access$5(LocalConsole.this) == null) {
                            try {
                                LocalConsole.access$4(LocalConsole.this).wait(30000L);
                            }
                            catch (InterruptedException v3) {}
                        }
                        if (LocalConsole.access$5(LocalConsole.this) != null) {
                            LocalConsole.access$5(LocalConsole.this).incommingData(this.buffer, byteRead, InetAddress.getLocalHost());
                            LocalConsole.access$6(LocalConsole.this, byteRead);
                        } else {
                            System.err.print(new String(this.buffer, 0, byteRead));
                        }
                    }
                }
                catch (UnknownHostException v5) {}
lbl40:
                // 5 sources

            } while (!LocalConsole.access$2(LocalConsole.this));
        }
    }

    class ConsoleOutReader
    extends Thread {
        private byte[] buffer = new byte[1024];

        public ConsoleOutReader() {
            this.setName("Console Output Reader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = LocalConsole.access$0(LocalConsole.this);
            synchronized (var1_1) {
                if (LocalConsole.access$1(LocalConsole.this) == null) {
                    try {
                        LocalConsole.access$0(LocalConsole.this).wait();
                    }
                    catch (InterruptedException v0) {}
                }
                // MONITOREXIT @DISABLED, blocks:[0, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                if (true) ** GOTO lbl40
            }
            do {
                byteRead = -1;
                try {
                    byteRead = LocalConsole.access$1(LocalConsole.this).read(this.buffer);
                }
                catch (IOException v2) {}
                if (byteRead == -1) {
                    LocalConsole.access$3(LocalConsole.this, true);
                    continue;
                }
                try {
                    var2_3 = LocalConsole.access$4(LocalConsole.this);
                    synchronized (var2_3) {
                        if (LocalConsole.access$5(LocalConsole.this) == null) {
                            try {
                                LocalConsole.access$4(LocalConsole.this).wait(30000L);
                            }
                            catch (InterruptedException v3) {}
                        }
                        if (LocalConsole.access$5(LocalConsole.this) != null) {
                            LocalConsole.access$5(LocalConsole.this).incommingData(this.buffer, byteRead, InetAddress.getLocalHost());
                            LocalConsole.access$6(LocalConsole.this, byteRead);
                        } else {
                            System.out.print(new String(this.buffer, 0, byteRead));
                        }
                    }
                }
                catch (UnknownHostException v5) {}
lbl40:
                // 5 sources

            } while (!LocalConsole.access$2(LocalConsole.this));
        }
    }

    class ConsoleWaitingThread
    extends Thread {
        public ConsoleWaitingThread() {
            this.setName("Console Waiting Notification");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!LocalConsole.this._done) {
                try {
                    ConsoleWaitingThread.sleep(3000L);
                }
                catch (Exception exception) {}
                if (LocalConsole.this.getConsoleBytesWritten() == 0) {
                    Object object = LocalConsole.this._processor_lock;
                    synchronized (object) {
                        if (LocalConsole.this._processor != null) {
                            LocalConsole.this._processor.waitingForData();
                        }
                        continue;
                    }
                }
                LocalConsole.this.setConsoleBytesWritten(0);
            }
        }
    }
}

