/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RAString;

public class AgentScopingInformationCommand
extends CommandElement
implements Constants {
    private long processId;
    private long messageProcessId;
    private RAString processUUID = new RAString();
    private RAString agentName = new RAString();
    private RAString agentUUID = new RAString();
    private RAString agentType = new RAString();
    private RAString nodeUUID = new RAString();

    public AgentScopingInformationCommand() {
        this._tag = 49L;
    }

    public int getSize() {
        int size = 0;
        size += super.getSize();
        size += 4;
        if (System.getProperty("os.name").startsWith("Linux")) {
            size += 4;
        }
        size += this.processUUID.getSize();
        size += this.agentName.getSize();
        size += this.agentUUID.getSize();
        size += this.agentType.getSize();
        return size += this.nodeUUID.getSize();
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = super.readFromBuffer(buffer, current);
        this.processId = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        if (System.getProperty("os.name").startsWith("Linux")) {
            this.messageProcessId = Message.readRALongFromBuffer(buffer, current);
            current += 4;
        }
        current = Message.readRAStringFromBuffer(buffer, current, this.processUUID);
        current = Message.readRAStringFromBuffer(buffer, current, this.agentName);
        current = Message.readRAStringFromBuffer(buffer, current, this.agentUUID);
        current = Message.readRAStringFromBuffer(buffer, current, this.agentType);
        current = Message.readRAStringFromBuffer(buffer, current, this.nodeUUID);
        return current;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = super.writeToBuffer(buffer, current);
        current = Message.writeRALongToBuffer(buffer, current, this.processId);
        if (System.getProperty("os.name").startsWith("Linux")) {
            current = Message.writeRALongToBuffer(buffer, current, this.messageProcessId);
        }
        current = Message.writeRAStringToBuffer(buffer, current, this.processUUID);
        current = Message.writeRAStringToBuffer(buffer, current, this.agentName);
        current = Message.writeRAStringToBuffer(buffer, current, this.agentUUID);
        current = Message.writeRAStringToBuffer(buffer, current, this.agentType);
        current = Message.writeRAStringToBuffer(buffer, current, this.nodeUUID);
        return current;
    }

    public RAString getAgentName() {
        return this.agentName;
    }

    public void setAgentName(RAString agentName) {
        this.agentName = agentName;
    }

    public RAString getAgentType() {
        return this.agentType;
    }

    public void setAgentType(RAString agentType) {
        this.agentType = agentType;
    }

    public RAString getAgentUUID() {
        return this.agentUUID;
    }

    public void setAgentUUID(RAString agentUUID) {
        this.agentUUID = agentUUID;
    }

    public long getMessageProcessId() {
        return this.messageProcessId;
    }

    public void setMessageProcessId(long messageProcessId) {
        this.messageProcessId = messageProcessId;
    }

    public RAString getNodeUUID() {
        return this.nodeUUID;
    }

    public void setNodeUUID(RAString nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    public RAString getProcessUUID() {
        return this.processUUID;
    }

    public void setProcessUUID(RAString processUUID) {
        this.processUUID = processUUID;
    }
}

