/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.file.defaults;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;
import org.eclipse.hyades.internal.execution.core.file.socket.SocketChannelFactory;
import org.eclipse.hyades.internal.execution.file.IConnectionHandler;
import org.eclipse.hyades.internal.execution.file.defaults.FileClientHandlerExtendedImpl;

class FileConnectionHandlerExtended
implements IConnectionHandler {
    private ThreadGroup workerGroup = new ThreadGroup("File Server Worker Thread Group");

    FileConnectionHandlerExtended() {
    }

    public void connectionAccepted(ISocketChannel clientChannel) {
        Thread worker = new Thread(this.workerGroup, this.createFileClientHandler(clientChannel));
        worker.setDaemon(true);
        worker.setName(clientChannel.toString());
        worker.start();
        Socket socket = clientChannel.getSocket();
        FileSystemServices.println("Accepted and established connection " + socket.getRemoteSocketAddress() + " -> " + socket.getLocalSocketAddress(), this);
    }

    private Runnable createFileClientHandler(ISocketChannel clientChannel) {
        return new FileClientHandlerExtendedImpl(clientChannel);
    }

    static class Adapter
    implements org.eclipse.hyades.execution.security.IConnectionHandler {
        private final FileConnectionHandlerExtended handler = new FileConnectionHandlerExtended();

        Adapter() {
        }

        public void connectionAccepted(Socket socket) {
            try {
                this.handler.connectionAccepted(SocketChannelFactory.getInstance().create(socket));
            }
            catch (IOException iOException) {}
        }
    }
}

