/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.dynamic;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.dynamic.AbstractFileTransferCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IGetFileCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

class GetFileCommand
extends AbstractFileTransferCommand
implements IGetFileCommand {
    static /* synthetic */ Class class$0;

    public GetFileCommand(String context, ISocketChannel channel) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.GetFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz);
        this.setState(new Server(channel));
    }

    GetFileCommand(String context, ISocketChannel channel, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.GetFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz, IFileManagerExtended.Cookie.NONE, localIdentifiers, remoteIdentifiers, options, monitor);
        this.setState(new Client(channel));
    }

    private class Client
    extends AbstractFileTransferCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            IFileManagerExtended.FileIdentifierList localIdentifiers = GetFileCommand.this.localIdentifiers;
            IFileManagerExtended.FileIdentifierList remoteIdentifiers = GetFileCommand.this.remoteIdentifiers;
            this.communicator.send(remoteIdentifiers.size());
            this.communicator.send(remoteIdentifiers.getArray());
            Iterator identifiers = localIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File localFile = new File(fileName);
                boolean readyToTransfer = true;
                if (!localFile.isAbsolute()) continue;
                File localDirectory = new File(localFile.getParent());
                if (!localDirectory.exists()) {
                    readyToTransfer = localDirectory.mkdirs();
                }
                if (!readyToTransfer) continue;
                localFile.createNewFile();
                this.communicator.receive(localFile);
            }
        }
    }

    private class Server
    extends AbstractFileTransferCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            IFileManagerExtended.FileIdentifierList remoteIdentifiers;
            super.execute();
            this.communicator.receiveInt();
            GetFileCommand.this.remoteIdentifiers = remoteIdentifiers = IFileManagerExtended.FileIdentifierList.create(this.communicator.receiveStrings());
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File remoteFile = new File(fileName);
                if (!remoteFile.isFile()) continue;
                this.communicator.send(remoteFile);
                FileSystemServices.println("Absolute file identifier " + remoteFile.getAbsolutePath() + " identified and file sent by server", this);
            }
        }
    }
}

