/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.dynamic;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.dynamic.AbstractFileManipulationCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IDeleteFileCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

class DeleteFileCommand
extends AbstractFileManipulationCommand
implements IDeleteFileCommand {
    static /* synthetic */ Class class$0;

    DeleteFileCommand(String context, IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, (Class)clazz, cookie, monitor);
    }

    public DeleteFileCommand(String context, ISocketChannel channel) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz);
        this.setState(new Server(channel));
    }

    DeleteFileCommand(String context, ISocketChannel channel, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, (Class)clazz, remoteIdentifiers, monitor);
        this.setState(new Client(channel));
    }

    private class Client
    extends AbstractFileManipulationCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            IFileManagerExtended.FileIdentifierList remoteIdentifiers = DeleteFileCommand.this.remoteIdentifiers;
            this.communicator.send(remoteIdentifiers.size());
            this.communicator.send(remoteIdentifiers.getArray());
        }
    }

    private class Server
    extends AbstractFileManipulationCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            IFileManagerExtended.FileIdentifierList remoteIdentifiers;
            super.execute();
            this.communicator.receiveInt();
            DeleteFileCommand.this.remoteIdentifiers = remoteIdentifiers = IFileManagerExtended.FileIdentifierList.create(this.communicator.receiveStrings());
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File remoteFile = new File(fileName);
                if (remoteFile.exists()) {
                    remoteFile.delete();
                    FileSystemServices.println("Absolute file identifier " + remoteFile.getAbsolutePath() + " identified and file removed on server", this);
                    continue;
                }
                FileSystemServices.println("Absolute file identifier " + remoteFile.getAbsolutePath() + " not identified and therefore ignoring delete request", this);
            }
        }
    }
}

