/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.dynamic;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.dynamic.AbstractFileManipulationCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IDeleteDirectoryCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

class DeleteDirectoryCommand
extends AbstractFileManipulationCommand
implements IDeleteDirectoryCommand {
    static /* synthetic */ Class class$0;

    DeleteDirectoryCommand(String context, IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteDirectoryCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, (Class)clazz, cookie, monitor);
    }

    public DeleteDirectoryCommand(String context, ISocketChannel channel) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteDirectoryCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz);
        this.setState(new Server(channel));
    }

    DeleteDirectoryCommand(String context, ISocketChannel channel, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.DeleteDirectoryCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, (Class)clazz, remoteIdentifiers, monitor);
        this.setState(new Client(channel));
    }

    private class Client
    extends AbstractFileManipulationCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            IFileManagerExtended.FileIdentifierList remoteIdentifiers = DeleteDirectoryCommand.this.remoteIdentifiers;
            this.communicator.send(remoteIdentifiers.size());
            this.communicator.send(remoteIdentifiers.getArray());
        }
    }

    private class Server
    extends AbstractFileManipulationCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        private void deleteDirectory(File directory) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    files[i].delete();
                } else {
                    this.deleteDirectory(files[i]);
                }
                ++i;
            }
            directory.delete();
        }

        public void execute() throws IOException {
            IFileManagerExtended.FileIdentifierList remoteIdentifiers;
            super.execute();
            this.communicator.receiveInt();
            DeleteDirectoryCommand.this.remoteIdentifiers = remoteIdentifiers = IFileManagerExtended.FileIdentifierList.create(this.communicator.receiveStrings());
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File remoteDir = new File(fileName);
                if (remoteDir.exists() && !remoteDir.isFile()) {
                    this.deleteDirectory(remoteDir);
                    FileSystemServices.println("Absolute file identifier " + remoteDir.getAbsolutePath() + " identified and directory removed on server", this);
                    continue;
                }
                FileSystemServices.println("Absolute file identifier " + remoteDir.getAbsolutePath() + " not identified and therefore ignoring delete request", this);
            }
        }
    }
}

