/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.AbstractFileTransferCommand;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.IPutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

class PutFileCommand
extends AbstractFileTransferCommand
implements IPutFileCommand {
    static /* synthetic */ Class class$0;

    public PutFileCommand(ISocketChannel channel) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.PutFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz);
        this.setState(new Server(channel));
    }

    PutFileCommand(ISocketChannel channel, IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.PutFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz, cookie, localIdentifiers, remoteIdentifiers, options, monitor);
        this.setState(new Client(channel));
    }

    private class Client
    extends AbstractFileTransferCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            IFileManagerExtended.FileIdentifierList localIdentifiers = PutFileCommand.this.localIdentifiers;
            IFileManagerExtended.FileIdentifierList remoteIdentifiers = PutFileCommand.this.remoteIdentifiers;
            this.send(localIdentifiers.size());
            this.send(remoteIdentifiers.getArray());
            Iterator identifiers = localIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File localFile = new File(fileName);
                if (!localFile.isFile()) continue;
                this.send(localFile);
            }
        }
    }

    private class Server
    extends AbstractFileTransferCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            IFileManagerExtended.FileIdentifierList remoteIdentifiers;
            super.execute();
            this.receiveInt();
            PutFileCommand.this.remoteIdentifiers = remoteIdentifiers = IFileManagerExtended.FileIdentifierList.create(this.receiveStrings());
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File remoteFile = new File(fileName);
                boolean readyToTransfer = true;
                if (!remoteFile.isAbsolute()) continue;
                File remoteDirectory = new File(remoteFile.getParent());
                if (!remoteDirectory.exists()) {
                    readyToTransfer = remoteDirectory.mkdirs();
                }
                if (readyToTransfer) {
                    remoteFile.createNewFile();
                    this.receive(remoteFile);
                }
                FileSystemServices.println("Absolute file identifier " + remoteFile.getAbsolutePath() + " identified and file received by server", this);
            }
        }
    }
}

