/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public final class FileSystemServices {
    private static long sequenceNumber = 0L;
    static /* synthetic */ Class class$0;

    private static String pad(long number, int width) {
        String value = String.valueOf(number);
        StringBuffer buffer = new StringBuffer(value);
        int i = 0;
        int j = value.length();
        while (i < width - j) {
            buffer.insert(0, ' ');
            ++i;
        }
        return buffer.toString();
    }

    public static void println(String text) {
        FileSystemServices.println(text, Options.SHOW_DEBUG.isEnabled());
    }

    public static void println(String text, boolean isEnabled) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.FileSystemServices");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FileSystemServices.println(text, isEnabled, clazz);
    }

    public static synchronized void println(String text, boolean isEnabled, Object caller) {
        if (isEnabled) {
            System.out.println("\r\n" + FileSystemServices.pad(++sequenceNumber, 15) + "\t" + Thread.currentThread() + " in " + caller + "\r\n\t\t" + text);
        }
    }

    public static void println(String text, Object caller) {
        FileSystemServices.println(text, Options.SHOW_DEBUG.isEnabled(), caller);
    }

    private FileSystemServices() {
    }

    public static final class Options {
        private static Properties environmentVariables;
        public static final Options SHOW_DEBUG;
        public static final Options SHOW_LOADING;
        public static final Options SHOW_TIMING;
        private boolean isEnabled = false;
        private String name;

        static {
            block5: {
                environmentVariables = new Properties();
                String os = System.getProperty("os.name").toLowerCase();
                Runtime runtime = Runtime.getRuntime();
                String command = null;
                try {
                    Process process;
                    File file = File.createTempFile("env", ".tmp");
                    file.deleteOnExit();
                    String fileName = file.getAbsolutePath();
                    if (os.indexOf("windows") > -1 || os.indexOf("nt") > -1) {
                        command = "cmd.exe /c set";
                        command = String.valueOf(command) + " > " + fileName;
                    }
                    if (command != null && (process = runtime.exec(command)) != null) {
                        int exitValue = process.waitFor();
                        if (exitValue == 0) {
                            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                            environmentVariables.load(inputStream);
                        }
                        process.destroy();
                        file.delete();
                    }
                }
                catch (Throwable throwable) {
                    if (environmentVariables == null) break block5;
                    environmentVariables.clear();
                }
            }
            SHOW_DEBUG = new Options("SHOW_DEBUG", false);
            SHOW_LOADING = new Options("SHOW_LOADING", false);
            SHOW_TIMING = new Options("SHOW_TIMING", false);
        }

        private Options(String name, boolean defaultEnablement) {
            this.name = name;
            String value = System.getProperty(this.name);
            if (value == null) {
                value = environmentVariables.getProperty(this.name);
            }
            this.isEnabled = value != null ? Boolean.valueOf(value) : defaultEnablement;
            FileSystemServices.println("File server option " + this.name + " is " + (this.isEnabled ? "" : "not ") + "enabled (use -D" + this.name + " = { TRUE | FALSE } to specify enablement setting)", this.isEnabled);
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }
    }
}

