/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.taglib;

import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.MethodExpressionActionListener;
import javax.faces.event.MethodExpressionValueChangeListener;
import javax.faces.validator.MethodExpressionValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIComponentELTagUtils {
    private static final Log log = LogFactory.getLog(UIComponentELTagUtils.class);

    private UIComponentELTagUtils() {
    }

    public static void setIntegerProperty(UIComponent component2, String propName, ValueExpression value) {
        UIComponentELTagUtils.setIntegerProperty(component2, propName, value, null);
    }

    public static void setIntegerProperty(UIComponent component2, String propName, ValueExpression value, Integer defaultValue) {
        if (value != null) {
            if (value.isLiteralText()) {
                component2.getAttributes().put(propName, Integer.valueOf(value.getExpressionString()));
            } else {
                component2.setValueExpression(propName, value);
            }
        } else if (defaultValue != null) {
            component2.getAttributes().put(propName, defaultValue);
        }
    }

    public static void setLongProperty(UIComponent component2, String propName, ValueExpression value) {
        UIComponentELTagUtils.setLongProperty(component2, propName, value, null);
    }

    public static void setLongProperty(UIComponent component2, String propName, ValueExpression value, Long defaultValue) {
        if (value != null) {
            if (value.isLiteralText()) {
                component2.getAttributes().put(propName, Long.valueOf(value.getExpressionString()));
            } else {
                component2.setValueExpression(propName, value);
            }
        } else if (defaultValue != null) {
            component2.getAttributes().put(propName, defaultValue);
        }
    }

    public static void setStringProperty(UIComponent component2, String propName, ValueExpression value) {
        UIComponentELTagUtils.setStringProperty(component2, propName, value, null);
    }

    public static void setStringProperty(UIComponent component2, String propName, ValueExpression value, String defaultValue) {
        if (value != null) {
            if (value.isLiteralText()) {
                component2.getAttributes().put(propName, value.getExpressionString());
            } else {
                component2.setValueExpression(propName, value);
            }
        } else if (defaultValue != null) {
            component2.getAttributes().put(propName, defaultValue);
        }
    }

    public static void setBooleanProperty(UIComponent component2, String propName, ValueExpression value) {
        UIComponentELTagUtils.setBooleanProperty(component2, propName, value, null);
    }

    public static void setBooleanProperty(UIComponent component2, String propName, ValueExpression value, Boolean defaultValue) {
        if (value != null) {
            if (value.isLiteralText()) {
                component2.getAttributes().put(propName, Boolean.valueOf(value.getExpressionString()));
            } else {
                component2.setValueExpression(propName, value);
            }
        } else if (defaultValue != null) {
            component2.getAttributes().put(propName, defaultValue);
        }
    }

    public static void setValueProperty(FacesContext context, UIComponent component2, ValueExpression value) {
        if (value != null) {
            if (!value.isLiteralText()) {
                component2.setValueExpression("value", value);
            } else if (component2 instanceof UICommand) {
                ((UICommand)component2).setValue(value.getExpressionString());
            } else if (component2 instanceof UIParameter) {
                ((UIParameter)component2).setValue(value.getExpressionString());
            } else if (component2 instanceof UISelectBoolean) {
                ((UISelectBoolean)component2).setValue(Boolean.valueOf(value.getExpressionString()));
            } else if (component2 instanceof UIGraphic) {
                ((UIGraphic)component2).setValue(value.getExpressionString());
            } else if (component2 instanceof ValueHolder) {
                ((ValueHolder)((Object)component2)).setValue(value.getExpressionString());
            } else {
                log.error((Object)("Component " + component2.getClass().getName() + " is no ValueHolder, cannot set value."));
            }
        }
    }

    public static void setConverterProperty(FacesContext context, UIComponent component2, ValueExpression value) {
        if (value != null) {
            if (component2 instanceof ValueHolder) {
                if (value.isLiteralText()) {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    Converter converter = facesContext.getApplication().createConverter(value.getExpressionString());
                    ((ValueHolder)((Object)component2)).setConverter(converter);
                } else {
                    component2.setValueExpression("converter", value);
                }
            } else {
                log.error((Object)("Component " + component2.getClass().getName() + " is no ValueHolder, cannot set value."));
            }
        }
    }

    public static void addValidatorProperty(FacesContext context, UIComponent component2, MethodExpression validator) {
        if (validator != null) {
            if (!(component2 instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " is no EditableValueHolder");
            }
            ((EditableValueHolder)((Object)component2)).addValidator(new MethodExpressionValidator(validator));
        }
    }

    public static void setValueBinding(FacesContext context, UIComponent component2, String propName, ValueExpression value) {
        if (value != null) {
            if (!value.isLiteralText()) {
                component2.setValueExpression(propName, value);
            } else {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " attribute " + propName + " must be a value reference, was " + value);
            }
        }
    }

    public static void setActionProperty(FacesContext context, UIComponent component2, MethodExpression action) {
        if (action != null) {
            if (!(component2 instanceof ActionSource2)) {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " is no ActionSource2");
            }
            ((ActionSource2)((Object)component2)).setActionExpression(action);
        }
    }

    public static void addActionListenerProperty(FacesContext context, UIComponent component2, MethodExpression actionListener) {
        if (actionListener != null) {
            if (!(component2 instanceof ActionSource2)) {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " is no ActionSource");
            }
            ((ActionSource2)((Object)component2)).addActionListener(new MethodExpressionActionListener(actionListener));
        }
    }

    public static void addValueChangedListenerProperty(FacesContext context, UIComponent component2, MethodExpression valueChangedListener) {
        if (valueChangedListener != null) {
            if (!(component2 instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component2.getClientId(context) + " is no EditableValueHolder");
            }
            ((EditableValueHolder)((Object)component2)).addValueChangeListener(new MethodExpressionValueChangeListener(valueChangedListener));
        }
    }

    public static Object evaluateValueExpression(ELContext elContext, ValueExpression valueExpression) {
        return valueExpression.isLiteralText() ? valueExpression.getExpressionString() : valueExpression.getValue(elContext);
    }

    public static Boolean getBooleanValue(ELContext elContext, ValueExpression valueExpression) {
        if (valueExpression.isLiteralText()) {
            return Boolean.valueOf(valueExpression.getExpressionString());
        }
        return (Boolean)valueExpression.getValue(elContext);
    }

    public static Integer getIntegerValue(ELContext elContext, ValueExpression valueExpression) {
        if (valueExpression.isLiteralText()) {
            return Integer.valueOf(valueExpression.getExpressionString());
        }
        return (Integer)valueExpression.getValue(elContext);
    }
}

