/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.util.ArrayUtils;
import org.apache.myfaces.shared_impl.util.StringUtils;

public class HtmlGridRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlGridRendererBase.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component2) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component2) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component2) throws IOException {
        int columns;
        RendererUtils.checkParamValidity(facesContext, component2, UIPanel.class);
        if (component2 instanceof HtmlPanelGrid) {
            columns = ((HtmlPanelGrid)component2).getColumns();
        } else {
            Integer i = (Integer)component2.getAttributes().get("columns");
            int n = columns = i != null ? i : 0;
        }
        if (columns <= 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Wrong columns attribute for PanelGrid " + component2.getClientId(facesContext) + ": " + columns));
            }
            columns = 1;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", component2);
        HtmlRendererUtils.writeIdIfNecessary(writer, component2, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, component2, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.flush();
        HtmlRendererUtils.renderTableCaption(facesContext, writer, component2);
        this.renderHeaderOrFooter(facesContext, writer, component2, columns, true);
        this.renderHeaderOrFooter(facesContext, writer, component2, columns, false);
        this.renderChildren(facesContext, writer, component2, columns);
        writer.endElement("table");
    }

    protected void renderHeaderOrFooter(FacesContext context, ResponseWriter writer, UIComponent component2, int columns, boolean header) throws IOException {
        String styleClass;
        UIComponent facet = component2.getFacet(header ? "header" : "footer");
        if (facet == null) {
            return;
        }
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.startElement(header ? "thead" : "tfoot", component2);
        writer.startElement("tr", component2);
        writer.startElement(header ? "th" : "td", component2);
        String string = component2 instanceof HtmlPanelGrid ? (header ? ((HtmlPanelGrid)component2).getHeaderClass() : ((HtmlPanelGrid)component2).getFooterClass()) : (styleClass = header ? (String)component2.getAttributes().get("headerClass") : (String)component2.getAttributes().get("footerClass"));
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, header ? "headerClass" : "footerClass");
        }
        if (header) {
            writer.writeAttribute("scope", "colgroup", null);
        }
        writer.writeAttribute("colspan", Integer.toString(columns), null);
        HtmlRendererUtils.writePrettyLineSeparator(context);
        RendererUtils.renderChild(context, facet);
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.endElement(header ? "th" : "td");
        writer.endElement("tr");
        writer.endElement(header ? "thead" : "tfoot");
    }

    protected int childAttributes(FacesContext context, ResponseWriter writer, UIComponent component2, int columnIndex) throws IOException {
        return columnIndex;
    }

    protected void renderChildren(FacesContext context, ResponseWriter writer, UIComponent component2, int columns) throws IOException {
        String rowClasses;
        String columnClasses;
        writer.startElement("tbody", component2);
        if (component2 instanceof HtmlPanelGrid) {
            columnClasses = ((HtmlPanelGrid)component2).getColumnClasses();
            rowClasses = ((HtmlPanelGrid)component2).getRowClasses();
        } else {
            columnClasses = (String)component2.getAttributes().get("columnClasses");
            rowClasses = (String)component2.getAttributes().get("rowClasses");
        }
        String[] columnClassesArray = columnClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnClasses, ','));
        int columnClassesCount = columnClassesArray.length;
        String[] rowClassesArray = rowClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowClasses, ','));
        int rowClassesCount = rowClassesArray.length;
        int childCount = this.getChildCount(component2);
        if (childCount > 0) {
            int columnIndex = 0;
            int rowClassIndex = 0;
            boolean rowStarted = false;
            for (UIComponent child : this.getChildren(component2)) {
                if (!child.isRendered()) continue;
                if (columnIndex == 0) {
                    if (rowStarted) {
                        writer.endElement("tr");
                        HtmlRendererUtils.writePrettyLineSeparator(context);
                    }
                    writer.startElement("tr", component2);
                    if (rowClassIndex < rowClassesCount) {
                        writer.writeAttribute("class", rowClassesArray[rowClassIndex], null);
                    }
                    rowStarted = true;
                    if (++rowClassIndex == rowClassesCount) {
                        rowClassIndex = 0;
                    }
                }
                writer.startElement("td", component2);
                if (columnIndex < columnClassesCount) {
                    writer.writeAttribute("class", columnClassesArray[columnIndex], null);
                }
                columnIndex = this.childAttributes(context, writer, child, columnIndex);
                RendererUtils.renderChild(context, child);
                writer.endElement("td");
                if (++columnIndex < columns) continue;
                columnIndex = 0;
            }
            if (rowStarted) {
                if (columnIndex > 0) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("PanelGrid " + component2.getClientId(context) + " has not enough children. Child count should be a multiple of the columns attribute."));
                    }
                    while (columnIndex < columns) {
                        writer.startElement("td", component2);
                        if (columnIndex < columnClassesCount) {
                            writer.writeAttribute("class", columnClassesArray[columnIndex], null);
                        }
                        writer.endElement("td");
                        ++columnIndex;
                    }
                }
                writer.endElement("tr");
                HtmlRendererUtils.writePrettyLineSeparator(context);
            }
        }
        writer.endElement("tbody");
    }
}

