/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;

public class HtmlFormRendererBase
extends HtmlRenderer {
    private static final String HIDDEN_SUBMIT_INPUT_SUFFIX = "_SUBMIT";
    private static final String HIDDEN_SUBMIT_INPUT_VALUE = "1";
    private static final String HIDDEN_COMMAND_INPUTS_SET_ATTR = UIForm.class.getName() + ".org.apache.myfaces.HIDDEN_COMMAND_INPUTS_SET";
    private static final String SCROLL_HIDDEN_INPUT = "org.apache.myfaces.SCROLL_HIDDEN_INPUT";

    public void encodeBegin(FacesContext facesContext, UIComponent component2) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component2, UIForm.class);
        UIForm htmlForm = (UIForm)component2;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = htmlForm.getClientId(facesContext);
        String acceptCharset = this.getAcceptCharset(htmlForm);
        String actionURL = this.getActionUrl(facesContext);
        writer.startElement("form", htmlForm);
        writer.writeAttribute("id", clientId, null);
        writer.writeAttribute("name", clientId, null);
        writer.writeAttribute("method", "post", null);
        if (acceptCharset != null) {
            writer.writeAttribute("accept-charset", acceptCharset, null);
        }
        writer.writeURIAttribute("action", facesContext.getExternalContext().encodeActionURL(actionURL), null);
        HtmlRendererUtils.renderHTMLAttributes(writer, htmlForm, HTML.FORM_PASSTHROUGH_ATTRIBUTES);
        writer.write("");
        this.beforeFormElementsStart(facesContext, component2);
        this.afterFormElementsStart(facesContext, component2);
    }

    protected String getActionUrl(FacesContext facesContext, UIForm form) {
        return this.getActionUrl(facesContext);
    }

    protected String getMethod(FacesContext facesContext, UIForm form) {
        return "post";
    }

    protected String getAcceptCharset(FacesContext facesContext, UIForm form) {
        return (String)form.getAttributes().get("acceptcharset");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component2) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        this.beforeFormElementsEnd(facesContext, component2);
        Set set = (Set)facesContext.getExternalContext().getRequestMap().get(HtmlFormRendererBase.getHiddenCommandInputsSetName(facesContext, component2));
        if (set != null && !set.isEmpty()) {
            HtmlRendererUtils.renderHiddenCommandFormParams(writer, set);
            String target = component2 instanceof HtmlForm ? ((HtmlForm)component2).getTarget() : (String)component2.getAttributes().get("target");
            HtmlRendererUtils.renderClearHiddenCommandFormParamsFunction(writer, component2.getClientId(facesContext), set, target);
        }
        writer.startElement("input", component2);
        writer.writeAttribute("type", "hidden", null);
        writer.writeAttribute("name", component2.getClientId(facesContext) + HIDDEN_SUBMIT_INPUT_SUFFIX, null);
        writer.writeAttribute("value", HIDDEN_SUBMIT_INPUT_VALUE, null);
        writer.endElement("input");
        HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(component2, facesContext, writer);
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        viewHandler.writeState(facesContext);
        this.afterFormElementsEnd(facesContext, component2);
        writer.endElement("form");
    }

    private static String getHiddenCommandInputsSetName(FacesContext facesContext, UIComponent form) {
        StringBuffer buf = new StringBuffer();
        buf.append(HIDDEN_COMMAND_INPUTS_SET_ATTR);
        buf.append("_");
        buf.append(form.getClientId(facesContext));
        return buf.toString();
    }

    private static String getScrollHiddenInputName(FacesContext facesContext, UIComponent form) {
        StringBuffer buf = new StringBuffer();
        buf.append(SCROLL_HIDDEN_INPUT);
        buf.append("_");
        buf.append(form.getClientId(facesContext));
        return buf.toString();
    }

    public void decode(FacesContext facesContext, UIComponent component2) {
        RendererUtils.checkParamValidity(facesContext, component2, UIForm.class);
        UIForm htmlForm = (UIForm)component2;
        Map<String, String> paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String submittedValue = paramMap.get(component2.getClientId(facesContext) + HIDDEN_SUBMIT_INPUT_SUFFIX);
        if (submittedValue != null && submittedValue.equals(HIDDEN_SUBMIT_INPUT_VALUE)) {
            htmlForm.setSubmitted(true);
        } else {
            htmlForm.setSubmitted(false);
        }
    }

    public static void addHiddenCommandParameter(FacesContext facesContext, UIComponent form, String paramName) {
        HashSet<String> set = (HashSet<String>)facesContext.getExternalContext().getRequestMap().get(HtmlFormRendererBase.getHiddenCommandInputsSetName(facesContext, form));
        if (set == null) {
            set = new HashSet<String>();
            facesContext.getExternalContext().getRequestMap().put(HtmlFormRendererBase.getHiddenCommandInputsSetName(facesContext, form), set);
        }
        set.add(paramName);
    }

    public static void renderScrollHiddenInputIfNecessary(UIComponent form, FacesContext facesContext, ResponseWriter writer) throws IOException {
        if (form == null) {
            return;
        }
        if (facesContext.getExternalContext().getRequestMap().get(HtmlFormRendererBase.getScrollHiddenInputName(facesContext, form)) == null) {
            if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll()) {
                HtmlRendererUtils.renderAutoScrollHiddenInput(facesContext, writer);
            }
            facesContext.getExternalContext().getRequestMap().put(HtmlFormRendererBase.getScrollHiddenInputName(facesContext, form), Boolean.TRUE);
        }
    }

    private String getAcceptCharset(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlForm) {
            return ((HtmlForm)uiComponent).getAcceptcharset();
        }
        return (String)uiComponent.getAttributes().get("acceptcharset");
    }

    protected void beforeFormElementsStart(FacesContext facesContext, UIComponent component2) throws IOException {
    }

    protected void afterFormElementsStart(FacesContext facesContext, UIComponent component2) throws IOException {
    }

    protected void beforeFormElementsEnd(FacesContext facesContext, UIComponent component2) throws IOException {
    }

    protected void afterFormElementsEnd(FacesContext facesContext, UIComponent component2) throws IOException {
    }
}

