/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.convert;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotWritableException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolverToELResolver
extends ELResolver {
    private PropertyResolver propertyResolver;
    private ExpressionFactory expressionFactory;

    public PropertyResolverToELResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, final Object value) throws NullPointerException, javax.el.PropertyNotFoundException, PropertyNotWritableException, ELException {
        this.invoke(context, base, property, new ResolverInvoker<Object>(){

            @Override
            public Object invoke(Object base, Object property) {
                if (PropertyResolverToELResolver.this.needsCoersion(base)) {
                    PropertyResolverToELResolver.this.propertyResolver.setValue(base, PropertyResolverToELResolver.this.coerceToInt(property), value);
                } else {
                    PropertyResolverToELResolver.this.propertyResolver.setValue(base, property, value);
                }
                return null;
            }
        });
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        return this.invoke(context, base, property, new ResolverInvoker<Boolean>(){

            @Override
            public Boolean invoke(Object base, Object property) {
                if (PropertyResolverToELResolver.this.needsCoersion(base)) {
                    return PropertyResolverToELResolver.this.propertyResolver.isReadOnly(base, PropertyResolverToELResolver.this.coerceToInt(property));
                }
                return PropertyResolverToELResolver.this.propertyResolver.isReadOnly(base, property);
            }

            @Override
            Boolean getValueIfBaseAndPropertyIsNull() {
                return true;
            }
        });
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        return this.invoke(context, base, property, new ResolverInvoker<Object>(){

            @Override
            Object invoke(Object base, Object property) {
                if (PropertyResolverToELResolver.this.needsCoersion(base)) {
                    return PropertyResolverToELResolver.this.propertyResolver.getValue(base, PropertyResolverToELResolver.this.coerceToInt(property));
                }
                return PropertyResolverToELResolver.this.propertyResolver.getValue(base, property);
            }
        });
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        return (Class)this.invoke(context, base, property, new ResolverInvoker<Class<?>>(){

            @Override
            Class<?> invoke(Object base, Object property) {
                if (PropertyResolverToELResolver.this.needsCoersion(base)) {
                    return PropertyResolverToELResolver.this.propertyResolver.getType(base, PropertyResolverToELResolver.this.coerceToInt(property));
                }
                return PropertyResolverToELResolver.this.propertyResolver.getType(base, property);
            }
        });
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private boolean needsCoersion(Object base) {
        return base instanceof List || base.getClass().isArray();
    }

    protected ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
            this.expressionFactory = appFactory.getApplication().getExpressionFactory();
        }
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    private int coerceToInt(Object property) {
        Integer coerced = (Integer)this.getExpressionFactory().coerceToType(property, Integer.class);
        return coerced;
    }

    private <T> T invoke(ELContext context, Object base, Object property, ResolverInvoker<T> invoker) throws javax.el.PropertyNotFoundException, ELException {
        if (base == null || property == null) {
            return invoker.getValueIfBaseAndPropertyIsNull();
        }
        try {
            context.setPropertyResolved(true);
            T value = invoker.invoke(base, property);
            context.setPropertyResolved(FacesContext.getCurrentInstance().getELContext().isPropertyResolved());
            return value;
        }
        catch (PropertyNotFoundException e) {
            context.setPropertyResolved(false);
            throw new javax.el.PropertyNotFoundException(e.getMessage(), e);
        }
        catch (EvaluationException e) {
            context.setPropertyResolved(false);
            throw new ELException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            context.setPropertyResolved(false);
            throw e;
        }
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ResolverInvoker<T> {
        private ResolverInvoker() {
        }

        abstract T invoke(Object var1, Object var2) throws javax.el.PropertyNotFoundException, EvaluationException, RuntimeException;

        T getValueIfBaseAndPropertyIsNull() {
            return null;
        }
    }
}

