/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import org.apache.myfaces.shared_impl.util.ClassUtils;

public class TreeStructureManager {
    public Object buildTreeStructureToSave(UIViewRoot viewRoot) {
        return this.internalBuildTreeStructureToSave(viewRoot);
    }

    private TreeStructComponent internalBuildTreeStructureToSave(UIComponent component2) {
        Map<String, UIComponent> facetMap;
        UIComponent child;
        TreeStructComponent structComp = new TreeStructComponent(component2.getClass().getName(), component2.getId());
        if (component2.getChildCount() > 0) {
            List<UIComponent> childList = component2.getChildren();
            ArrayList<TreeStructComponent> structChildList = new ArrayList<TreeStructComponent>();
            int len = childList.size();
            for (int i = 0; i < len; ++i) {
                child = childList.get(i);
                if (child.isTransient()) continue;
                TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child);
                structChildList.add(structChild);
            }
            TreeStructComponent[] childArray = structChildList.toArray(new TreeStructComponent[structChildList.size()]);
            structComp.setChildren(childArray);
        }
        if (!(facetMap = component2.getFacets()).isEmpty()) {
            ArrayList<Object[]> structFacetList = new ArrayList<Object[]>();
            for (Map.Entry<String, UIComponent> entry : facetMap.entrySet()) {
                child = entry.getValue();
                if (child.isTransient()) continue;
                String facetName = entry.getKey();
                TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child);
                structFacetList.add(new Object[]{facetName, structChild});
            }
            Object[] facetArray = structFacetList.toArray(new Object[structFacetList.size()]);
            structComp.setFacets(facetArray);
        }
        return structComp;
    }

    public UIViewRoot restoreTreeStructure(Object treeStructRoot) {
        if (treeStructRoot instanceof TreeStructComponent) {
            return (UIViewRoot)this.internalRestoreTreeStructure((TreeStructComponent)treeStructRoot);
        }
        throw new IllegalArgumentException("TreeStructure of type " + treeStructRoot.getClass().getName() + " is not supported.");
    }

    private UIComponent internalRestoreTreeStructure(TreeStructComponent treeStructComp) {
        Object[] facetArray;
        String compClass = treeStructComp.getComponentClass();
        String compId = treeStructComp.getComponentId();
        UIComponent component2 = (UIComponent)ClassUtils.newInstance(compClass);
        component2.setId(compId);
        TreeStructComponent[] childArray = treeStructComp.getChildren();
        if (childArray != null) {
            List<UIComponent> childList = component2.getChildren();
            int len = childArray.length;
            for (int i = 0; i < len; ++i) {
                UIComponent child = this.internalRestoreTreeStructure(childArray[i]);
                childList.add(child);
            }
        }
        if ((facetArray = treeStructComp.getFacets()) != null) {
            Map<String, UIComponent> facetMap = component2.getFacets();
            int len = facetArray.length;
            for (int i = 0; i < len; ++i) {
                Object[] tuple = (Object[])facetArray[i];
                String facetName = (String)tuple[0];
                TreeStructComponent structChild = (TreeStructComponent)tuple[1];
                UIComponent child = this.internalRestoreTreeStructure(structChild);
                facetMap.put(facetName, child);
            }
        }
        return component2;
    }

    public static class TreeStructComponent
    implements Serializable {
        private static final long serialVersionUID = 5069109074684737231L;
        private String _componentClass;
        private String _componentId;
        private TreeStructComponent[] _children = null;
        private Object[] _facets = null;

        TreeStructComponent(String componentClass, String componentId) {
            this._componentClass = componentClass;
            this._componentId = componentId;
        }

        public String getComponentClass() {
            return this._componentClass;
        }

        public String getComponentId() {
            return this._componentId;
        }

        void setChildren(TreeStructComponent[] children) {
            this._children = children;
        }

        TreeStructComponent[] getChildren() {
            return this._children;
        }

        Object[] getFacets() {
            return this._facets;
        }

        void setFacets(Object[] facets) {
            this._facets = facets;
        }
    }
}

