/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class _ComponentUtils {
    private _ComponentUtils() {
    }

    static UIComponent findParentNamingContainer(UIComponent component2, boolean returnRootIfNotFound) {
        UIComponent parent = component2.getParent();
        if (returnRootIfNotFound && parent == null) {
            return component2;
        }
        while (parent != null) {
            if (parent instanceof NamingContainer) {
                return parent;
            }
            if (returnRootIfNotFound) {
                UIComponent nextParent = parent.getParent();
                if (nextParent == null) {
                    return parent;
                }
                parent = nextParent;
                continue;
            }
            parent = parent.getParent();
        }
        return null;
    }

    static UIComponent getRootComponent(UIComponent component2) {
        UIComponent parent;
        while ((parent = component2.getParent()) != null) {
            component2 = parent;
        }
        return component2;
    }

    static UIComponent findComponent(UIComponent findBase, String id) {
        if (_ComponentUtils.idsAreEqual(id, findBase)) {
            return findBase;
        }
        Iterator<UIComponent> it = findBase.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent childOrFacet = it.next();
            if (!(childOrFacet instanceof NamingContainer)) {
                UIComponent find = _ComponentUtils.findComponent(childOrFacet, id);
                if (find == null) continue;
                return find;
            }
            if (!_ComponentUtils.idsAreEqual(id, childOrFacet)) continue;
            return childOrFacet;
        }
        return null;
    }

    private static boolean idsAreEqual(String id, UIComponent cmp) {
        if (id.equals(cmp.getId())) {
            return true;
        }
        if (cmp instanceof UIData) {
            UIData uiData = (UIData)cmp;
            if (uiData.getRowIndex() == -1) {
                return _ComponentUtils.dynamicIdIsEqual(id, cmp.getId());
            }
            return id.equals(cmp.getId() + ':' + uiData.getRowIndex());
        }
        return false;
    }

    private static boolean dynamicIdIsEqual(String dynamicId, String id) {
        return dynamicId.matches(id + ":[0-9]*");
    }

    static void callValidators(FacesContext context, UIInput input, Object convertedValue) {
        FacesMessage facesMessage;
        String validatorMessage;
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            try {
                validator.validate(context, input, convertedValue);
                continue;
            }
            catch (ValidatorException e) {
                input.setValid(false);
                validatorMessage = input.getValidatorMessage();
                if (validatorMessage != null) {
                    context.addMessage(input.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage));
                    continue;
                }
                facesMessage = e.getFacesMessage();
                if (facesMessage == null) continue;
                facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(input.getClientId(context), facesMessage);
            }
        }
        MethodBinding validatorBinding = input.getValidator();
        if (validatorBinding != null) {
            try {
                validatorBinding.invoke(context, new Object[]{context, input, convertedValue});
            }
            catch (EvaluationException e) {
                input.setValid(false);
                Throwable cause = e.getCause();
                if (cause instanceof ValidatorException) {
                    validatorMessage = input.getValidatorMessage();
                    if (validatorMessage != null) {
                        context.addMessage(input.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage));
                    } else {
                        facesMessage = ((ValidatorException)cause).getFacesMessage();
                        if (facesMessage != null) {
                            facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                            context.addMessage(input.getClientId(context), facesMessage);
                        }
                    }
                }
                throw e;
            }
        }
    }

    static String getStringValue(FacesContext context, ValueBinding vb) {
        Object value = vb.getValue(context);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    static <T> T getExpressionValue(UIComponent component2, String attribute, T overrideValue, T defaultValue) {
        if (overrideValue != null) {
            return overrideValue;
        }
        ValueExpression ve = component2.getValueExpression(attribute);
        if (ve != null) {
            return (T)ve.getValue(component2.getFacesContext().getELContext());
        }
        return defaultValue;
    }

    static String getPathToComponent(UIComponent component2) {
        StringBuffer buf = new StringBuffer();
        if (component2 == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        _ComponentUtils.getPathToComponent(component2, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component2, StringBuffer buf) {
        if (component2 == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component2.getClass().getName());
        if (component2 instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component2).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component2.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        _ComponentUtils.getPathToComponent(component2.getParent(), buf);
    }
}

