/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.ArrayList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIOutput;
import javax.faces.component._ComponentUtils;
import javax.faces.component._MessageUtils;
import javax.faces.component._SharedRendererUtils;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;

public class UIInput
extends UIOutput
implements EditableValueHolder {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String COMPONENT_TYPE = "javax.faces.Input";
    public static final String CONVERSION_MESSAGE_ID = "javax.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    public static final String UPDATE_MESSAGE_ID = "javax.faces.component.UIInput.UPDATE";
    private static final String ERROR_HANDLING_EXCEPTION_LIST = "org.apache.myfaces.errorHandling.exceptionList";
    private boolean _immediate;
    private boolean _immediateSet;
    private boolean _required;
    private boolean _requiredSet;
    private String _converterMessage;
    private String _requiredMessage;
    private MethodBinding _validator;
    private List<Validator> _validatorList;
    private static final Validator[] EMPTY_VALIDATOR_ARRAY = new Validator[0];
    private String _validatorMessage;
    private MethodBinding _valueChangeListener;
    private boolean _valid = true;
    private boolean _localValueSet = false;
    private Object _submittedValue;

    public UIInput() {
        this.setRendererType("javax.faces.Text");
    }

    public void setValue(Object value) {
        this.setLocalValueSet(true);
        super.setValue(value);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            try {
                this.validate(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        if (!this.isImmediate()) {
            try {
                this.validate(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void decode(FacesContext context) {
        this.setValid(true);
        super.decode(context);
    }

    public void broadcast(FacesEvent event2) throws AbortProcessingException {
        if (!(event2 instanceof ValueChangeEvent)) {
            throw new IllegalArgumentException("FacesEvent of class " + event2.getClass().getName() + " not supported by UIInput");
        }
        super.broadcast(event2);
        MethodBinding valueChangeListenerBinding = this.getValueChangeListener();
        if (valueChangeListenerBinding != null) {
            try {
                valueChangeListenerBinding.invoke(this.getFacesContext(), new Object[]{event2});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public void updateModel(FacesContext context) {
        if (!this.isValid()) {
            return;
        }
        if (!this.isLocalValueSet()) {
            return;
        }
        ValueExpression expression = this.getValueExpression("value");
        if (expression == null) {
            return;
        }
        try {
            expression.setValue(context.getELContext(), this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        catch (Exception e) {
            context.getExternalContext().log(e.getMessage(), e);
            _MessageUtils.addErrorMessage(context, this, UPDATE_MESSAGE_ID, new Object[]{_MessageUtils.getLabel(context, this)});
            this.setValid(false);
            this.queueExceptionInRequest(context, expression, e);
        }
    }

    private void queueExceptionInRequest(FacesContext context, ValueExpression expression, Exception e) {
        ArrayList<FacesException> li = (ArrayList<FacesException>)context.getExternalContext().getRequestMap().get(ERROR_HANDLING_EXCEPTION_LIST);
        if (null == li) {
            li = new ArrayList<FacesException>();
            context.getExternalContext().getRequestMap().put(ERROR_HANDLING_EXCEPTION_LIST, li);
            li.add(new FacesException("Exception while setting value for expression : " + expression.getExpressionString() + " of component with path : " + _ComponentUtils.getPathToComponent(this), e));
        }
    }

    protected void validateValue(FacesContext context, Object convertedValue) {
        boolean empty;
        boolean bl = empty = convertedValue == null || convertedValue instanceof String && ((String)convertedValue).length() == 0;
        if (this.isRequired() && empty) {
            if (this.getRequiredMessage() != null) {
                String requiredMessage = this.getRequiredMessage();
                context.addMessage(this.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessage, requiredMessage));
            } else {
                _MessageUtils.addErrorMessage(context, this, REQUIRED_MESSAGE_ID, new Object[]{_MessageUtils.getLabel(context, this)});
            }
            this.setValid(false);
            return;
        }
        if (!empty) {
            _ComponentUtils.callValidators(context, this, convertedValue);
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            Object submittedValue = this.getSubmittedValue();
            if (submittedValue == null) {
                return;
            }
            Object convertedValue = this.getConvertedValue(context, submittedValue);
            if (!this.isValid()) {
                return;
            }
            this.validateValue(context, convertedValue);
            if (!this.isValid()) {
                return;
            }
            Object previousValue = this.getValue();
            this.setValue(convertedValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previousValue, convertedValue)) {
                this.queueEvent(new ValueChangeEvent(this, previousValue, convertedValue));
            }
        }
        catch (Exception ex) {
            throw new FacesException("Exception while validating component with path : " + _ComponentUtils.getPathToComponent(this), ex);
        }
    }

    protected Object getConvertedValue(FacesContext context, Object submittedValue) {
        try {
            Converter converter;
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                return renderer.getConvertedValue(context, this, submittedValue);
            }
            if (submittedValue instanceof String && (converter = _SharedRendererUtils.findUIOutputConverter(context, this)) != null) {
                return converter.getAsObject(context, this, (String)submittedValue);
            }
        }
        catch (ConverterException e) {
            String converterMessage = this.getConverterMessage();
            if (converterMessage != null) {
                context.addMessage(this.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, converterMessage, converterMessage));
            } else {
                FacesMessage facesMessage = e.getFacesMessage();
                if (facesMessage != null) {
                    context.addMessage(this.getClientId(context), facesMessage);
                } else {
                    _MessageUtils.addErrorMessage(context, this, CONVERSION_MESSAGE_ID, new Object[]{_MessageUtils.getLabel(context, this)});
                }
            }
            this.setValid(false);
        }
        return submittedValue;
    }

    protected boolean compareValues(Object previous, Object value) {
        return previous == null ? value != null : !previous.equals(value);
    }

    public void resetValue() {
        this.setSubmittedValue(null);
        this.setValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public boolean isImmediate() {
        if (this._immediateSet) {
            return this._immediate;
        }
        ValueExpression expression = this.getValueExpression("immediate");
        if (expression != null) {
            return (Boolean)expression.getValue(this.getFacesContext().getELContext());
        }
        return false;
    }

    public void setImmediate(boolean immediate) {
        this._immediate = immediate;
        this._immediateSet = true;
    }

    public boolean isRequired() {
        if (this._requiredSet) {
            return this._required;
        }
        ValueExpression expression = this.getValueExpression("required");
        if (expression != null) {
            return (Boolean)expression.getValue(this.getFacesContext().getELContext());
        }
        return false;
    }

    public void setRequired(boolean required) {
        this._required = required;
        this._requiredSet = true;
    }

    public String getConverterMessage() {
        if (this._converterMessage != null) {
            return this._converterMessage;
        }
        ValueExpression expression = this.getValueExpression("converterMessage");
        if (expression != null) {
            return (String)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setConverterMessage(String converterMessage) {
        this._converterMessage = converterMessage;
    }

    public String getRequiredMessage() {
        if (this._requiredMessage != null) {
            return this._requiredMessage;
        }
        ValueExpression expression = this.getValueExpression("requiredMessage");
        if (expression != null) {
            return (String)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRequiredMessage(String requiredMessage) {
        this._requiredMessage = requiredMessage;
    }

    public MethodBinding getValidator() {
        if (this._validator != null) {
            return this._validator;
        }
        ValueExpression expression = this.getValueExpression("validator");
        if (expression != null) {
            return (MethodBinding)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setValidator(MethodBinding validator) {
        this._validator = validator;
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException("validator");
        }
        if (this._validatorList == null) {
            this._validatorList = new ArrayList<Validator>();
        }
        this._validatorList.add(validator);
    }

    public void removeValidator(Validator validator) {
        if (validator == null || this._validatorList == null) {
            return;
        }
        this._validatorList.remove(validator);
    }

    public Validator[] getValidators() {
        return this._validatorList == null ? EMPTY_VALIDATOR_ARRAY : this._validatorList.toArray(new Validator[this._validatorList.size()]);
    }

    public String getValidatorMessage() {
        if (this._validatorMessage != null) {
            return this._validatorMessage;
        }
        ValueExpression expression = this.getValueExpression("validatorMessage");
        if (expression != null) {
            return (String)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setValidatorMessage(String validatorMessage) {
        this._validatorMessage = validatorMessage;
    }

    public MethodBinding getValueChangeListener() {
        if (this._valueChangeListener != null) {
            return this._valueChangeListener;
        }
        ValueExpression expression = this.getValueExpression("valueChangeListener");
        if (expression != null) {
            return (MethodBinding)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setValueChangeListener(MethodBinding valueChangeListener) {
        this._valueChangeListener = valueChangeListener;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setValid(boolean valid) {
        this._valid = valid;
    }

    public boolean isLocalValueSet() {
        return this._localValueSet;
    }

    public void setLocalValueSet(boolean localValueSet) {
        this._localValueSet = localValueSet;
    }

    public Object getSubmittedValue() {
        return this._submittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this._submittedValue = submittedValue;
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener(listener);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[15];
        values[0] = super.saveState(facesContext);
        values[1] = this._immediate;
        values[2] = this._immediateSet;
        values[3] = this._required;
        values[4] = this._requiredSet;
        values[5] = this._converterMessage;
        values[6] = this._requiredMessage;
        values[8] = UIInput.saveAttachedState(facesContext, this._validatorList);
        values[9] = this._validatorMessage;
        values[10] = UIInput.saveAttachedState(facesContext, this._valueChangeListener);
        values[11] = this._valid;
        values[12] = this._localValueSet;
        values[13] = this._submittedValue;
        return values;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(facesContext, values[0]);
        this._immediate = (Boolean)values[1];
        this._immediateSet = (Boolean)values[2];
        this._required = (Boolean)values[3];
        this._requiredSet = (Boolean)values[4];
        this._converterMessage = (String)values[5];
        this._requiredMessage = (String)values[6];
        this._validatorList = (List)UIInput.restoreAttachedState(facesContext, values[8]);
        this._validatorMessage = (String)values[9];
        this._valueChangeListener = (MethodBinding)UIInput.restoreAttachedState(facesContext, values[10]);
        this._valid = (Boolean)values[11];
        this._localValueSet = (Boolean)values[12];
        this._submittedValue = values[13];
    }

    public String getFamily() {
        return "javax.faces.Input";
    }
}

