/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.security.PrivilegedAction;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;

class StateHolderSaver
implements Serializable {
    private static final long serialVersionUID = 6470180891722042701L;
    private String className = null;
    private Serializable savedState = null;
    private static boolean securityManager = System.getSecurityManager() != null;

    public StateHolderSaver(FacesContext context, Object toSave) {
        this.className = toSave.getClass().getName();
        if (toSave instanceof StateHolder) {
            if (!((StateHolder)toSave).isTransient()) {
                this.savedState = (Serializable)((StateHolder)toSave).saveState(context);
            } else {
                this.className = null;
            }
        } else if (toSave instanceof Serializable) {
            this.savedState = (Serializable)toSave;
            this.className = null;
        }
    }

    public Object restore(FacesContext context) throws IllegalStateException {
        Class toRestoreClass;
        Object result = null;
        if (null == this.className && null != this.savedState) {
            return this.savedState;
        }
        if (this.className == null) {
            return null;
        }
        try {
            toRestoreClass = StateHolderSaver.loadClass(this.className, this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (null != toRestoreClass) {
            try {
                result = toRestoreClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException a) {
                throw new IllegalStateException(a.getMessage());
            }
        }
        if (null != result && null != this.savedState && result instanceof StateHolder) {
            ((StateHolder)result).restoreState(context, this.savedState);
        }
        return result;
    }

    private static Class loadClass(String name, final Object fallbackClass) throws ClassNotFoundException {
        if (securityManager) {
            Object cl = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return fallbackClass.getClass().getClassLoader();
                    }
                });
            }
            return Class.forName(name, false, (ClassLoader)cl);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name, false, loader);
    }
}

