/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.Base64InputStream;
import com.sun.faces.io.Base64OutputStreamWriter;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;

public class ResponseStateManagerImpl
extends ResponseStateManager {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final String FACES_VIEW_STATE = "com.sun.faces.FACES_VIEW_STATE";
    private static final String FACES_VIEW_STRUCTURE = "com.sun.faces.FACES_VIEW_STRUCTURE";
    private static final char[] STATE_FIELD_START = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"javax.faces.ViewState\" value=\"".toCharArray();
    private static final char[] STATE_FIELD_END = "\" />".toCharArray();
    private SerializationProvider serialProvider;
    private WebConfiguration webConfig;
    private Boolean compressState;
    private ByteArrayGuard guard;
    private int csBuffSize;

    public ResponseStateManagerImpl() {
        this.init();
    }

    public Object getComponentStateToRestore(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(FACES_VIEW_STATE);
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey("javax.faces.ViewState");
    }

    public Object getTreeStructureToRestore(FacesContext context, String treeId) {
        Object s = context.getExternalContext().getRequestMap().get(FACES_VIEW_STRUCTURE);
        if (s != null) {
            return s;
        }
        StateManager stateManager = Util.getStateManager(context);
        String viewString = ResponseStateManagerImpl.getStateParam(context);
        if (viewString == null) {
            return null;
        }
        if (stateManager.isSavingStateInClient(context)) {
            Object object;
            ObjectInputStream ois = null;
            try {
                InputStream bis = this.guard != null ? new CipherInputStream(new Base64InputStream(viewString), this.guard.getDecryptionCipher()) : new Base64InputStream(viewString);
                ois = this.compressState != false ? this.serialProvider.createObjectInputStream(new GZIPInputStream(bis)) : this.serialProvider.createObjectInputStream(bis);
                long stateTime = 0L;
                if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout)) {
                    try {
                        stateTime = ois.readLong();
                    }
                    catch (IOException ioe) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Client state timeout is enabled, but unable to find the time marker in the serialized state.  Assuming state to be old and returning null.");
                        }
                        Object var11_14 = null;
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        return var11_14;
                    }
                }
                Object structure = ois.readObject();
                Object state = ois.readObject();
                if (stateTime != 0L && this.hasStateExpired(stateTime)) {
                    Object var12_17 = null;
                    return var12_17;
                }
                ResponseStateManagerImpl.storeStateInRequest(context, state);
                ResponseStateManagerImpl.storeStructureInRequest(context, structure);
                object = structure;
            }
            catch (OptionalDataException ode) {
                LOGGER.log(Level.SEVERE, ode.getMessage(), ode);
                throw new FacesException(ode);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.log(Level.SEVERE, cnfe.getMessage(), cnfe);
                throw new FacesException(cnfe);
            }
            catch (IOException iox) {
                LOGGER.log(Level.SEVERE, iox.getMessage(), iox);
                throw new FacesException(iox);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            return object;
        }
        return viewString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void writeState(FacesContext context, StateManager.SerializedView view) throws IOException {
        stateManager = Util.getStateManager(context);
        writer = context.getResponseWriter();
        writer.write(ResponseStateManagerImpl.STATE_FIELD_START);
        if (stateManager.isSavingStateInClient(context)) {
            oos = null;
            try {
                bos = new Base64OutputStreamWriter(this.csBuffSize, writer);
                base /* !! */  = this.guard != null ? new CipherOutputStream(bos, this.guard.getEncryptionCipher()) : bos;
                oos = this.compressState != false ? this.serialProvider.createObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(base /* !! */ ), 1024)) : this.serialProvider.createObjectOutputStream(new BufferedOutputStream(base /* !! */ , 1024));
                if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout)) {
                    oos.writeLong(System.currentTimeMillis());
                }
                oos.writeObject(view.getStructure());
                oos.writeObject(view.getState());
                oos.flush();
                oos.close();
                bos.finish();
                if (!ResponseStateManagerImpl.LOGGER.isLoggable(Level.FINE)) ** GOTO lbl28
                ResponseStateManagerImpl.LOGGER.fine("Client State: total number of characters written: " + bos.getTotalCharsWritten());
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        } else {
            writer.write(view.getStructure().toString());
        }
lbl28:
        // 3 sources

        writer.write(ResponseStateManagerImpl.STATE_FIELD_END);
        ResponseStateManagerImpl.writeRenderKitIdField(context, writer);
    }

    private boolean hasStateExpired(long stateTime) {
        if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout)) {
            int timeout;
            long elapsed = (System.currentTimeMillis() - stateTime) / 60000L;
            return elapsed > (long)(timeout = Integer.parseInt(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateTimeout)));
        }
        return false;
    }

    private static void storeStateInRequest(FacesContext context, Object state) {
        context.getExternalContext().getRequestMap().put(FACES_VIEW_STATE, state);
    }

    private static void storeStructureInRequest(FacesContext context, Object structure) {
        context.getExternalContext().getRequestMap().put(FACES_VIEW_STRUCTURE, structure);
    }

    private static void writeRenderKitIdField(FacesContext context, ResponseWriter writer) throws IOException {
        String result = context.getApplication().getDefaultRenderKitId();
        if (result != null && !"HTML_BASIC".equals(result)) {
            writer.startElement("input", context.getViewRoot());
            writer.writeAttribute("type", "hidden", "type");
            writer.writeAttribute("name", "javax.faces.RenderKitId", "name");
            writer.writeAttribute("value", result, "value");
            writer.endElement("input");
        }
    }

    private static String getStateParam(FacesContext context) {
        String pValue = context.getExternalContext().getRequestParameterMap().get("javax.faces.ViewState");
        if (pValue != null && pValue.length() == 0) {
            pValue = null;
        }
        return pValue;
    }

    private void init() {
        this.webConfig = WebConfiguration.getInstance();
        assert (this.webConfig != null);
        String pass = this.webConfig.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ClientStateSavingPassword);
        if (pass != null) {
            this.guard = new ByteArrayGuard(pass);
        }
        this.compressState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
        String size = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize);
        String defaultSize = WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getDefaultValue();
        try {
            this.csBuffSize = Integer.parseInt(size);
            if (this.csBuffSize % 2 != 0) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_div_two", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
                }
                this.csBuffSize = Integer.parseInt(defaultSize);
            } else {
                this.csBuffSize /= 2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using client state buffer size of " + this.csBuffSize);
                }
            }
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_not_integer", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
            }
            this.csBuffSize = Integer.parseInt(defaultSize);
        }
        if (this.serialProvider == null) {
            this.serialProvider = SerializationProviderFactory.createInstance(FacesContext.getCurrentInstance().getExternalContext());
        }
    }
}

