/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.token.CertCacheManager;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.wsspi.wssecurity.token.X509TokenGenerator;
import com.ibm.xml.soapsec.token.UserRegistry;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509TokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(X509TokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509TokenConsumer.class.getName();
    private static final String DEFAULT_CACHE_NAME = "WSSCertCache";
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final int DEFAULT_CACHE_TIMEOUT = 900;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + tokenConsumerConfig + "]."));
        }
        CertCacheManager certCacheManager = (CertCacheManager)map.get(CertCacheManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The CertCacheManager is " + (certCacheManager == null ? "null." : "not null,")));
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String string = (String)map.remove(Constants.WSSECURITY_KEYINFO_TYPE);
        if (string == null) {
            bl6 = false;
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
        } else {
            bl2 = ConfigUtil.isKeyInfoKeyname((String)string);
            bl3 = ConfigUtil.isKeyInfoKeyid((String)string);
            bl4 = ConfigUtil.isKeyInfoStrref((String)string);
            bl5 = ConfigUtil.isKeyInfoEmb((String)string);
            bl6 = ConfigUtil.isKeyInfoX509issuer((String)string);
        }
        boolean bl7 = bl = !bl2 && !bl3 && !bl4 && !bl5 && !bl6;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoType [" + string + "]."));
        }
        if (node.getNodeType() == 9) {
            if (bl5) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WARNING: Unexpected KeyInfo's type [" + string + "] was found."));
                }
            } else if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: The element to be consumed was not found.");
                }
            } else {
                X509TokenConsumer.invoke((Document)node, tokenConsumerConfig, certCacheManager, sOAPMessageContext, string, bl2, bl3, bl4, bl6, map);
            }
        } else if (node.getNodeType() == 1) {
            if (bl2 || bl3 || bl4 || bl6) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WARNING: Unexpected KeyInfo's type [" + string + "] was found."));
                }
            } else {
                X509TokenConsumer.invoke((Element)node, tokenConsumerConfig, certCacheManager, sOAPMessageContext, bl, bl5, map);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + node.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,Map context)");
        }
    }

    private static void invoke(Document document, TokenConsumerConfig tokenConsumerConfig, CertCacheManager certCacheManager, SOAPMessageContext sOAPMessageContext, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc,TokenConsumerConfig config,CertCacheManager cmanager,SOAPMessageContext messageContext,String keyInfoType[" + string + "]," + "boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isX509[" + bl4 + "]," + "Map context)"));
        }
        int n = 0;
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        if (bl3) {
            Token token;
            String string2 = (String)map.remove(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token identifier is [" + string2 + "]"));
            }
            if ((token = TokenManager.getToken((Map)map, (TokenConsumerConfig)tokenConsumerConfig, (String)string2)) == null) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: X509BSToken whose identifier is \"" + string2 + "\" was not found in the Subject."));
            } else {
                Tr.debug((TraceComponent)tc, (String)"There was the token that this X509TokenConsumer processed before in the Subject.");
            }
        } else {
            Object object;
            Object object2;
            Object object3;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(Constants.WSSECURITY_KEYINFO_TYPE, string);
            String string3 = null;
            if (bl2) {
                string3 = (String)map.remove(Constants.WSSECURITY_KEY_ID);
                hashMap.put(Constants.WSSECURITY_KEY_ID, string3);
                object3 = (QName)map.remove(Constants.WSSECURITY_KEY_IDTYPE);
                object2 = (QName)map.remove(Constants.WSSECURITY_KEY_ENCODING);
                object = (QName)map.remove(Constants.WSSECURITY_KEY_VALUETYPE);
                hashMap.put(Constants.WSSECURITY_KEY_IDTYPE, object3);
                hashMap.put(Constants.WSSECURITY_KEY_ENCODING, object2);
                hashMap.put(Constants.WSSECURITY_KEY_VALUETYPE, object);
            } else if (bl) {
                string3 = (String)map.remove(Constants.WSSECURITY_KEY_NAME);
                hashMap.put(Constants.WSSECURITY_KEY_NAME, string3);
            } else if (bl4) {
                object3 = (String)map.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
                object2 = (String)map.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
                hashMap.put(Constants.WSSECURITY_KEY_ISSUERNAME, object3);
                hashMap.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, object2);
                if (object3 != null && object2 != null) {
                    string3 = (String)object3 + ":" + (String)object2;
                }
            }
            object3 = (String)map.remove(Constants.WSSECURITY_KEY_TYPE);
            hashMap.put(Constants.WSSECURITY_KEY_TYPE, object3);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token identifier is [" + string3 + "]"));
                Tr.debug((TraceComponent)tc, (String)("The type of a key is [" + (String)object3 + "]."));
            }
            if ((object2 = (X509BSToken)TokenManager.getToken((Map)map, (TokenConsumerConfig)tokenConsumerConfig, (String)string3)) == null) {
                Object object4;
                object = object2 = new X509BSToken(string3, null, tokenConsumerConfig.getType());
                TokenConsumerConfig tokenConsumerConfig2 = tokenConsumerConfig;
                AccessController.doPrivileged(new PrivilegedAction((X509BSToken)object, tokenConsumerConfig2){
                    final /* synthetic */ X509BSToken val$tokenPrivSetUsedTokenConsumer;
                    final /* synthetic */ TokenConsumerConfig val$configPriv;
                    {
                        this.val$tokenPrivSetUsedTokenConsumer = x509BSToken;
                        this.val$configPriv = tokenConsumerConfig;
                    }

                    public Object run() {
                        this.val$tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(this.val$configPriv);
                        return null;
                    }
                });
                X509TokenConsumer.setTokenToSubject(map, (X509BSToken)object2);
                QName qName = tokenConsumerConfig.getType();
                if (!(com.ibm.ws.webservices.wssecurity.Constants.X509V3.equals(qName) || com.ibm.ws.webservices.wssecurity.Constants.X509V3_OLD.equals(qName) || com.ibm.ws.webservices.wssecurity.Constants.PKI_PATH.equals(qName) || com.ibm.ws.webservices.wssecurity.Constants.PKCS7.equals(qName))) {
                    throw new SoapSecurityException("Unsupported value type: " + qName);
                }
                if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS) || WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                    WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(map, "TokenId", string3);
                }
                X509Certificate x509Certificate = null;
                if (certCacheManager != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking the cached X509Certificate object with the key[" + string3 + "]."));
                    }
                    if ((object4 = certCacheManager.getCachedCert(string3)) == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"There is no cached certificiate.");
                        }
                    } else if (object4 instanceof X509Certificate) {
                        x509Certificate = (X509Certificate)object4;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The X509Certificate [" + x509Certificate.getSubjectDN().getName() + "] was found."));
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WARNING: The certificate [" + object4.getClass().getName() + "] was found, but it's not the X509Certificate object."));
                    }
                }
                if (x509Certificate == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Getting the X509Certificate object through the LoginModule.");
                    }
                    object4 = (KeyLocator)map.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
                    object4.getKey(hashMap, map);
                    x509Certificate = (X509Certificate)map.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
                    if (x509Certificate == null) {
                        throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01");
                    }
                    X509TokenConsumer.invokeLoginModule(tokenConsumerConfig, x509Certificate, null, sOAPMessageContext, map);
                    if (certCacheManager != null) {
                        certCacheManager.cacheCert(string3, (Certificate)x509Certificate);
                    }
                }
                object4 = object2;
                X509Certificate x509Certificate2 = x509Certificate;
                AccessController.doPrivileged(new PrivilegedAction((X509BSToken)object4, x509Certificate2){
                    final /* synthetic */ X509BSToken val$tokenPriv;
                    final /* synthetic */ X509Certificate val$x509Priv;
                    {
                        this.val$tokenPriv = x509BSToken;
                        this.val$x509Priv = x509Certificate;
                    }

                    public Object run() {
                        this.val$tokenPriv.setCert(this.val$x509Priv);
                        return null;
                    }
                });
                byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction((X509BSToken)object4){
                    final /* synthetic */ X509BSToken val$tokenPriv;
                    {
                        this.val$tokenPriv = x509BSToken;
                    }

                    public Object run() {
                        return this.val$tokenPriv.getBytes();
                    }
                });
                String string4 = Base64.encode((byte[])byArray);
                Element element = X509TokenGenerator.createTokenElement(document, null, tokenConsumerConfig.getType(), string4, null, n);
                ((WSSToken)object2).setElement(element);
                if (tokenConsumerConfig.getTrustedIDEvaluator() != null) {
                    String string5 = X509TokenConsumer.getSecurityName(x509Certificate);
                    boolean bl5 = tokenConsumerConfig.getTrustedIDEvaluator().evaluate(string5);
                    if (bl5) {
                        Tr.debug((TraceComponent)tc, (String)("SecurityName[" + string5 + "] is trusted."));
                    } else {
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{string5});
                    }
                    AccessController.doPrivileged(new PrivilegedAction((X509BSToken)object4, bl5){
                        final /* synthetic */ X509BSToken val$tokenPriv;
                        final /* synthetic */ boolean val$trusted;
                        {
                            this.val$tokenPriv = x509BSToken;
                            this.val$trusted = bl;
                        }

                        public Object run() {
                            this.val$tokenPriv.setTrusted(this.val$trusted);
                            return null;
                        }
                    });
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is " + object2 + "."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,TokenConsumerConfig config,CertCacheManager cmanager,SOAPMessageContext messageContext,String keyInfoType,boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isX509,Map context)");
        }
    }

    private static void invoke(Element element, TokenConsumerConfig tokenConsumerConfig, CertCacheManager certCacheManager, SOAPMessageContext sOAPMessageContext, boolean bl, boolean bl2, Map map) throws SoapSecurityException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Element target,TokenConsumerConfig config,CertCacheManager cmanager,SOAPMessageContext messageContext,boolean isNone[" + bl + "]," + "boolean isEmb[" + bl2 + "]," + "Map context)"));
        }
        String string = null;
        if (bl) {
            object2 = IdUtil.getInstance().getIdAttributeName(element);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + (String)object2 + "]."));
            }
            if (object2 != null) {
                string = element.getAttribute((String)object2);
            }
        } else if (bl2) {
            string = (String)map.remove(Constants.WSSECURITY_KEY_EMBID);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Its token identifier is [" + string + "]"));
        }
        object2 = new X509BSToken(string, null, tokenConsumerConfig.getType());
        Boolean bl3 = (Boolean)tokenConsumerConfig.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
        boolean bl4 = true;
        if (bl3 != null) {
            bl4 = bl3;
        }
        Element element2 = null;
        element2 = !bl4 ? element : DOMUtil.clone((Element)element);
        ((WSSToken)object2).setElement(element2);
        Object object3 = object2;
        TokenConsumerConfig tokenConsumerConfig2 = tokenConsumerConfig;
        AccessController.doPrivileged(new PrivilegedAction((X509BSToken)object3, tokenConsumerConfig2){
            final /* synthetic */ X509BSToken val$tokenPrivSetUsedTokenConsumer;
            final /* synthetic */ TokenConsumerConfig val$configPriv;
            {
                this.val$tokenPrivSetUsedTokenConsumer = x509BSToken;
                this.val$configPriv = tokenConsumerConfig;
            }

            public Object run() {
                this.val$tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(this.val$configPriv);
                return null;
            }
        });
        X509TokenConsumer.setTokenToSubject(map, (X509BSToken)object2);
        if (!bl && string == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken02");
        }
        QName qName = tokenConsumerConfig.getType();
        if (!(com.ibm.ws.webservices.wssecurity.Constants.X509V3.equals(qName) || com.ibm.ws.webservices.wssecurity.Constants.X509V3_OLD.equals(qName) || com.ibm.ws.webservices.wssecurity.Constants.PKI_PATH.equals(qName) || com.ibm.ws.webservices.wssecurity.Constants.PKCS7.equals(qName))) {
            throw new SoapSecurityException("Unsupported value type: " + qName);
        }
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS) || WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
            WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(map, "TokenId", string);
        }
        String string2 = DOMUtil.getStringValue((Node)element);
        X509Certificate x509Certificate = null;
        if (certCacheManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking the cached X509Certificate object with the key[" + string + "]."));
            }
            if ((object = certCacheManager.getCachedCert(string2)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is no cached certificiate.");
                }
            } else if (object instanceof X509Certificate) {
                x509Certificate = (X509Certificate)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The X509Certificate [" + x509Certificate.getSubjectDN().getName() + "] was found."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The certificate [" + object.getClass().getName() + "] was found, but it's not the X509Certificate object."));
            }
        }
        if (x509Certificate == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the X509Certificate object through the LoginModule.");
            }
            object = null;
            if (string2 != null) {
                object = Base64.decode((String)string2);
            }
            if (object == null) {
                throw SoapSecurityException.format("security.wssecurity.PkiPathCallbackHandler.s02");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Base64-decoded binary [" + object + "]"));
            }
            if ((x509Certificate = X509TokenConsumer.invokeLoginModule(tokenConsumerConfig, null, (byte[])object, sOAPMessageContext, map)) == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01");
            }
            if (certCacheManager != null) {
                certCacheManager.cacheCert(string2, (Certificate)x509Certificate);
            }
        }
        object = object2;
        X509Certificate x509Certificate2 = x509Certificate;
        AccessController.doPrivileged(new PrivilegedAction((X509BSToken)object, x509Certificate2){
            final /* synthetic */ X509BSToken val$tokenPriv;
            final /* synthetic */ X509Certificate val$x509Priv;
            {
                this.val$tokenPriv = x509BSToken;
                this.val$x509Priv = x509Certificate;
            }

            public Object run() {
                this.val$tokenPriv.setCert(this.val$x509Priv);
                return null;
            }
        });
        if (tokenConsumerConfig.getTrustedIDEvaluator() != null) {
            String string3 = X509TokenConsumer.getSecurityName(x509Certificate);
            boolean bl5 = tokenConsumerConfig.getTrustedIDEvaluator().evaluate(string3);
            if (bl5) {
                Tr.debug((TraceComponent)tc, (String)("SecurityName[" + string3 + "] is trusted."));
            } else {
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{string3});
            }
            AccessController.doPrivileged(new PrivilegedAction((X509BSToken)object, bl5){
                final /* synthetic */ X509BSToken val$tokenPriv;
                final /* synthetic */ boolean val$trusted;
                {
                    this.val$tokenPriv = x509BSToken;
                    this.val$trusted = bl;
                }

                public Object run() {
                    this.val$tokenPriv.setTrusted(this.val$trusted);
                    return null;
                }
            });
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Acquired token is " + object2 + "."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,TokenConsumerConfig config,CertCacheManager cmanager,SOAPMessageContext messageContext,boolean isNone,boolean isEmb,Map context)");
        }
    }

    private static X509Certificate invokeLoginModule(TokenConsumerConfig tokenConsumerConfig, X509Certificate x509Certificate, byte[] byArray, SOAPMessageContext sOAPMessageContext, final Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invokeLoginModule(TokenConsumerConfig config,X509Certificate cert,byte[] binary,SOAPMessageContext messageContext,Map context)");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (sOAPMessageContext != null) {
            hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", sOAPMessageContext);
        }
        if (tokenConsumerConfig.isTrustAnyCertificate()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Trusts any certificates.");
            }
            hashMap.put("com.ibm.wsspi.wssecurity.token.x509.trustAny", "true");
        }
        if (tokenConsumerConfig.getProvider() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provider is " + tokenConsumerConfig.getProvider() + "."));
            }
            hashMap.put("com.ibm.wsspi.wssecurity.token.x509.provider", tokenConsumerConfig.getProvider());
        }
        if (tokenConsumerConfig.getPKIXBuilderParameters() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("PKIXBuilderParameters is " + tokenConsumerConfig.getPKIXBuilderParameters() + "."));
            }
            hashMap.put("com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam", tokenConsumerConfig.getPKIXBuilderParameters());
        }
        if (tokenConsumerConfig.getJAASConfigProperties() != null) {
            hashMap.putAll(tokenConsumerConfig.getJAASConfigProperties());
        }
        if (x509Certificate != null) {
            hashMap.put("com.ibm.wsspi.wssecurity.token.x509.certificate", x509Certificate);
        }
        final String string = tokenConsumerConfig.getJAASConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JAAS config name is " + string + "."));
        }
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurityJAAS Config entry is missing. Check your configuration.");
        }
        WSCallbackHandlerFactoryImpl wSCallbackHandlerFactoryImpl = new WSCallbackHandlerFactoryImpl();
        wSCallbackHandlerFactoryImpl.setTokenBytes(byArray);
        wSCallbackHandlerFactoryImpl.setProperties(hashMap);
        final CallbackHandler callbackHandler = wSCallbackHandlerFactoryImpl.newCallbackHandler();
        if (tc.isDebugEnabled()) {
            if (callbackHandler != null) {
                Tr.debug((TraceComponent)tc, (String)("Callback handler (" + callbackHandler.getClass().getName() + ") " + callbackHandler + "."));
            } else {
                Tr.debug((TraceComponent)tc, (String)"Callback handler is null.");
            }
        }
        LoginContext loginContext = null;
        try {
            loginContext = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
                    return new LoginContext(string, subject, callbackHandler);
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Succeed to construct the login context.");
            }
            loginContext.login();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Succeed to login.");
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Object object;
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.ERROR)) {
                object = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.AUTHN_PRIVILEDGE_ACTION_EXCEPTION, privilegedActionException.toString());
                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object, "AuthnType", tokenConsumerConfig.getType().toString());
                WSSAuditEventGeneratorImpl.getInstance().addProviderData((Map)object, string, "FAILURE");
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
            }
            object = (LoginException)privilegedActionException.getCause();
            throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s01", (Throwable)object);
        }
        catch (LoginException loginException) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                Map map2 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, loginException.toString());
                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(map2, "AuthnType", tokenConsumerConfig.getType().toString());
                WSSAuditEventGeneratorImpl.getInstance().addProviderData(map2, string, "SUCCESS");
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
            }
            throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s02", (Throwable)loginException);
        }
        if (x509Certificate == null) {
            x509Certificate = (X509Certificate)hashMap.get(Constants.WSSECURITY_TOKEN_LOGININFO);
        }
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
            Map map3 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
            WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(map, "AuthnType", tokenConsumerConfig.getType().toString());
            String string2 = null;
            try {
                string2 = Base64.encode((byte[])x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                Tr.debug((TraceComponent)tc, (String)"CertificateEncodingException caught while processing cert for audit record");
            }
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(map3, "X509Cert", string2);
            WSSAuditEventGeneratorImpl.getInstance().addProviderData(map3, string, "SUCCESS");
            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Auditing SECURITY_AUTHN event not enabled.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invokeLoginModule(TokenConsumerConfig config,X509Certificate cert,byte[] binary,SOAPMessageContext messageContext,Map context)");
        }
        return x509Certificate;
    }

    private static void setTokenToSubject(Map map, X509BSToken x509BSToken) {
        TokenManager.setToken((Map)map, (Token)x509BSToken);
    }

    private static String getSecurityName(final X509Certificate x509Certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSecurityName(X509Certificate cert)");
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = UserRegistry.getInstance().mapCertificate(x509Certificate);
                return string;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("mappedName: " + string));
        }
        if (string == null || string.length() == 0) {
            string = KeyInfo.X509Data.encodeDName((String)x509Certificate.getSubjectDN().getName());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mappedName is null, so used the DN in the certificate: " + string));
            }
        } else {
            String string2 = KeyInfo.X509Data.encodeDName((String)string);
            if (string2 != null && string2.length() != 0) {
                string = string2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityName(X509Certificate cert) returns " + string));
        }
        return string;
    }
}

