/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import java.security.Permission;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPAToken
extends WSSToken {
    private static final TraceComponent tc = Tr.register(LTPAToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String compName = "security.wssecurity";
    private static final String setBytesPermission = "wssecurity.LTPAToken.setBytes";
    private static final String getBytesPermission = "wssecurity.LTPAToken.getBytes";
    private String uid = null;
    private byte[] _cred = null;
    private String _username = null;
    private char[] _password = null;
    private QName DEFAULT_VALUE_TYPE = Constants.LTPA_TOKEN;
    private WSCredential _wsCred = null;
    private volatile int hashCode = 0;
    private static final WebSphereRuntimePermission SETBYTES_PERM = new WebSphereRuntimePermission("wssecurity.LTPAToken.setBytes");
    private static final WebSphereRuntimePermission GETBYTES_PERM = new WebSphereRuntimePermission("wssecurity.LTPAToken.getBytes");

    public LTPAToken(String string, byte[] byArray, String string2, char[] cArray, Element element) {
        this._tokenId = string == null ? "" : string;
        this._cred = byArray;
        this._username = string2;
        this._password = cArray;
        this._tokenelem = element;
        this._vtype = this.DEFAULT_VALUE_TYPE;
    }

    public LTPAToken(String string, byte[] byArray) {
        this(string, byArray, null, null, null);
    }

    public void setBytes(byte[] byArray) {
        Tr.entry(tc, "setBytes");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETBYTES_PERM.toString());
            }
            securityManager.checkPermission((Permission)SETBYTES_PERM);
        }
        Tr.exit(tc, "setBytes");
        if (this.isReadOnly()) {
            return;
        }
        this._cred = byArray;
    }

    public byte[] getBytes() {
        Tr.entry(tc, "getBytes");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETBYTES_PERM.toString());
            }
            securityManager.checkPermission((Permission)GETBYTES_PERM);
        }
        Tr.exit(tc, "getBytes");
        if (this.isReadOnly()) {
            byte[] byArray = new byte[this._cred.length];
            System.arraycopy(this._cred, 0, byArray, 0, this._cred.length);
            return byArray;
        }
        return this._cred;
    }

    public boolean isValid() {
        return false;
    }

    public long getExpiration() {
        if (this._wsCred != null) {
            try {
                return this._wsCred.getExpiration();
            }
            catch (Exception exception) {
                Tr.error(tc, "security.wssecurity.WSEC0156E", exception);
                return -1L;
            }
        }
        return 0L;
    }

    public String getPrincipal() {
        if (this.isReadOnly()) {
            String string = new String(this._username);
            return string;
        }
        return this._username;
    }

    public String getUniqueID() {
        if (this.uid == null) {
            this.uid = String.valueOf(this.hashCode());
        }
        return this.uid;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this._cred != null && this._cred.length > 0) {
            String string = new String(this._cred);
            this.hashCode = string.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LTPAToken)) {
            return false;
        }
        LTPAToken lTPAToken = (LTPAToken)object;
        return lTPAToken.hashCode() == this.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LTPAToken[tokenId=[").append(this._tokenId);
        stringBuffer.append("], element=[").append(DOMUtil.getDisplayName((Node)this._tokenelem));
        stringBuffer.append("], username=[").append(this._username);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

