/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.request.HttpServletRequestProxy;
import com.ibm.websphere.servlet.response.HttpServletResponseProxy;
import com.ibm.websphere.servlet.response.StoredResponse;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletRequestWrapper;
import com.ibm.wsspi.webcontainer.servlet.IServletResponseWrapper;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;

public class ServletUtil {
    protected static Logger logger = Logger.getLogger("com.ibm.wsspi.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.ServletUtil";
    protected static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public static ServletRequest unwrapRequest(ServletRequest servletRequest) {
        return ServletUtil.unwrapRequest(servletRequest, IExtendedRequest.class);
    }

    public static ServletRequest unwrapRequest(ServletRequest servletRequest, Class clazz) {
        ServletRequest servletRequest2 = servletRequest;
        while (!clazz.isInstance(servletRequest2)) {
            if (servletRequest2 instanceof ServletRequestWrapper) {
                servletRequest2 = ((ServletRequestWrapper)servletRequest2).getRequest();
                continue;
            }
            if (servletRequest2 instanceof HttpServletRequestProxy) {
                servletRequest2 = ((HttpServletRequestProxy)servletRequest2).getRequest();
                continue;
            }
            if (servletRequest2 instanceof IServletRequestWrapper) {
                servletRequest2 = ((IServletRequestWrapper)((Object)servletRequest2)).getWrappedRequest();
                continue;
            }
            throw new RuntimeException("SRV.8.2: RequestWrapper objects must extend ServletRequestWrapper or HttpServletRequestWrapper");
        }
        return servletRequest2;
    }

    public static ServletRequest unwrapRequest(ServletRequest servletRequest, Class clazz, boolean bl) {
        ServletRequest servletRequest2 = servletRequest;
        while (!clazz.isInstance(servletRequest2)) {
            if (bl && logger.isLoggable(Level.WARNING)) {
                logger.logp(Level.WARNING, CLASS_NAME, "unwrapRequest", MessageFormat.format(nls.getString("servletrequestwrapper.is.not.an.instance.of.so.wrapped.logic.may.be.bypassed", "ServletRequestWrapper [{0}] is not an instance of [{1}] so wrapped logic may be bypassed."), servletRequest2, clazz));
            }
            if (servletRequest2 instanceof ServletRequestWrapper) {
                servletRequest2 = ((ServletRequestWrapper)servletRequest2).getRequest();
                continue;
            }
            if (servletRequest2 instanceof HttpServletRequestProxy) {
                servletRequest2 = ((HttpServletRequestProxy)servletRequest2).getRequest();
                continue;
            }
            if (servletRequest2 instanceof IServletRequestWrapper) {
                servletRequest2 = ((IServletRequestWrapper)((Object)servletRequest2)).getWrappedRequest();
                continue;
            }
            throw new RuntimeException("SRV.8.2: RequestWrapper objects must extend ServletRequestWrapper or HttpServletRequestWrapper");
        }
        return servletRequest2;
    }

    public static ServletResponse unwrapResponse(ServletResponse servletResponse) {
        return ServletUtil.unwrapResponse(servletResponse, Response.class);
    }

    public static ServletResponse unwrapResponse(ServletResponse servletResponse, Class clazz) {
        ServletResponse servletResponse2 = servletResponse;
        while (!clazz.isInstance(servletResponse2)) {
            if (servletResponse2 instanceof ServletResponseWrapper) {
                servletResponse2 = ((ServletResponseWrapper)servletResponse2).getResponse();
                continue;
            }
            if (servletResponse2 instanceof HttpServletResponseProxy) {
                servletResponse2 = ((HttpServletResponseProxy)servletResponse2).getResponse();
                continue;
            }
            if (servletResponse2 instanceof IServletResponseWrapper) {
                servletResponse2 = ((IServletResponseWrapper)((Object)servletResponse2)).getWrappedResponse();
                continue;
            }
            throw new RuntimeException("SRV.8.2: ResponseWrapper objects must extend either ServletResponseWrapper or HttpServletResponseWrapper");
        }
        return servletResponse2;
    }

    public static ServletResponse unwrapResponseKeepGoing(ServletResponse servletResponse, Class clazz) {
        ServletResponse servletResponse2 = servletResponse;
        ServletResponse servletResponse3 = null;
        while (servletResponse2 != null) {
            if (clazz.isInstance(servletResponse2)) {
                servletResponse3 = servletResponse2;
            }
            if (servletResponse2 instanceof ServletResponseWrapper) {
                servletResponse2 = ((ServletResponseWrapper)servletResponse2).getResponse();
                continue;
            }
            if (servletResponse2 instanceof HttpServletResponseProxy) {
                servletResponse2 = ((HttpServletResponseProxy)servletResponse2).getResponse();
                continue;
            }
            if (servletResponse2 instanceof IServletResponseWrapper) {
                servletResponse2 = ((IServletResponseWrapper)((Object)servletResponse2)).getWrappedResponse();
                continue;
            }
            return servletResponse3;
        }
        return servletResponse3;
    }

    public static void main(String[] stringArray) {
        StoredResponse storedResponse = new StoredResponse(new StoredResponse(null, true), true);
        ServletUtil.unwrapResponseKeepGoing(storedResponse, IExtendedResponse.class);
    }
}

