/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.annotation;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.annotation.WASAnnotationHelperManager;
import com.ibm.wsspi.webcontainer.annotation.AnnotationHelper;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public abstract class AnnotationHelperManager {
    private static final String CLASS_NAME = AnnotationHelperManager.class.getName();
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.annotation");
    private static HashMap<ServletContext, AnnotationHelperManager> annotationHelperManagers = new HashMap();
    private HashMap<String, AnnotationHelper> bcAnnotationHelpers = new HashMap();

    protected AnnotationHelperManager() {
    }

    public static synchronized AnnotationHelperManager getInstance(ServletContext servletContext) {
        IServletContext iServletContext = AnnotationHelperManager.unwrapServletContext(servletContext);
        AnnotationHelperManager annotationHelperManager = annotationHelperManagers.get(iServletContext);
        if (annotationHelperManager == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getInstance", "creating new AnnotationHelperManager instance for context --> [" + iServletContext + "]");
            }
            annotationHelperManager = new WASAnnotationHelperManager(iServletContext);
            annotationHelperManagers.put(iServletContext, annotationHelperManager);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInstance", "instance --> [" + annotationHelperManager + "]");
        }
        return annotationHelperManager;
    }

    public abstract AnnotationHelper getAnnotationHelper();

    @Deprecated
    public AnnotationHelper getAnnotationHelper(String string) {
        AnnotationHelper annotationHelper = this.bcAnnotationHelpers.get(string);
        if (annotationHelper == null) {
            try {
                Class<?> clazz = Class.forName(string);
                annotationHelper = (AnnotationHelper)clazz.getConstructor(AnnotationHelper.class).newInstance(this.getAnnotationHelper());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return annotationHelper;
    }

    public static void removeAnnotationHelperManager(ServletContext servletContext) {
        AnnotationHelperManager annotationHelperManager = annotationHelperManagers.remove(AnnotationHelperManager.unwrapServletContext(servletContext));
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            if (annotationHelperManager != null) {
                logger.logp(Level.FINE, CLASS_NAME, "removeAnnotationHelperManager", "removed annotation helper manager --> [" + annotationHelperManager + "]");
            } else {
                logger.logp(Level.FINE, CLASS_NAME, "removeAnnotationHelperManager", "unable to find annotation helper manager associated with servlet context --> [" + servletContext + "]");
            }
        }
    }

    private static IServletContext unwrapServletContext(ServletContext servletContext) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "unwrapServletContext", "original context->" + servletContext);
        }
        while (servletContext instanceof ServletContextFacade) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "unwrapServletContext", "nested context->" + servletContext);
            }
            servletContext = ((ServletContextFacade)servletContext).getIServletContext();
        }
        return (IServletContext)servletContext;
    }
}

