/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.profile.registry;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.wsspi.profile.WSProfileEmptyTemplate;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile {
    private String m_sProfileName = null;
    private File m_filePath = null;
    private File m_fileTemplate = null;
    private boolean m_fIsDefault = false;
    private boolean m_fIsAReservationTicket = false;
    private List<String> m_listAugmentors = null;
    private static final String S_COLON = ":";
    private static final Logger LOGGER = LoggerFactory.createLogger(Profile.class);
    private static final String S_CLASS_NAME = Profile.class.getName();

    public Profile(String sName, File filePath, File fileTemplate, boolean fIsDefault) {
        LOGGER.entering(this.getClass().getName(), "Profile");
        this.m_sProfileName = sName;
        this.m_filePath = FileUtils.getNormalizedPath(filePath);
        this.m_fileTemplate = FileUtils.getNormalizedPath(fileTemplate);
        this.m_fIsDefault = fIsDefault;
        this.m_listAugmentors = new Vector<String>();
        LOGGER.exiting(this.getClass().getName(), "Profile");
    }

    public Profile(String sName, File filePath, File fileTemplate, boolean fIsDefault, boolean fIsAReservationTicket) {
        this(sName, filePath, fileTemplate, fIsDefault);
        LOGGER.entering(this.getClass().getName(), "Profile");
        this.m_fIsAReservationTicket = fIsAReservationTicket;
        LOGGER.exiting(this.getClass().getName(), "Profile");
    }

    public Profile(String sName, File filePath, WSProfileTemplate wsptTemplate, boolean fIsDefault) {
        LOGGER.entering(this.getClass().getName(), "Profile");
        this.m_sProfileName = sName;
        this.m_filePath = FileUtils.getNormalizedPath(filePath);
        this.m_fileTemplate = wsptTemplate.getProfileTemplatePath();
        this.m_fIsDefault = fIsDefault;
        this.m_listAugmentors = new Vector<String>();
        LOGGER.exiting(this.getClass().getName(), "Profile");
    }

    public Profile(String sName, File filePath, WSProfileTemplate wsptTemplate, boolean fIsDefault, boolean fIsAReservationTicket) {
        this(sName, filePath, wsptTemplate, fIsDefault);
        LOGGER.entering(this.getClass().getName(), "Profile");
        this.m_fIsAReservationTicket = fIsAReservationTicket;
        LOGGER.exiting(this.getClass().getName(), "Profile");
    }

    public String toString() {
        LOGGER.entering(this.getClass().getName(), "toString");
        LOGGER.exiting(this.getClass().getName(), "toString");
        return this.m_sProfileName + S_COLON + this.m_filePath.getAbsolutePath() + S_COLON + this.m_fIsDefault + this.m_fIsAReservationTicket;
    }

    public boolean isDefault() {
        LOGGER.entering(this.getClass().getName(), "isDefault");
        LOGGER.exiting(this.getClass().getName(), "isDefault");
        return this.m_fIsDefault;
    }

    public void setDefault(boolean fIsDefault) {
        LOGGER.entering(this.getClass().getName(), "setDefault");
        this.m_fIsDefault = fIsDefault;
        LOGGER.exiting(this.getClass().getName(), "setDefault");
    }

    public boolean isAReservationTicket() {
        LOGGER.entering(this.getClass().getName(), "isAReservationTicket");
        LOGGER.exiting(this.getClass().getName(), "isAReservationTicket");
        return this.m_fIsAReservationTicket;
    }

    public void setAReservationTicket(boolean fIsAReservationTicket) {
        LOGGER.entering(this.getClass().getName(), "setAReservationTicket");
        this.m_fIsAReservationTicket = fIsAReservationTicket;
        LOGGER.exiting(this.getClass().getName(), "setAReservationTicket");
    }

    public String getName() {
        LOGGER.entering(this.getClass().getName(), "getName");
        LOGGER.exiting(this.getClass().getName(), "getName");
        return this.m_sProfileName;
    }

    public void setName(String sProfileName) {
        LOGGER.entering(this.getClass().getName(), "setName");
        this.m_sProfileName = sProfileName;
        LOGGER.exiting(this.getClass().getName(), "setName");
    }

    public File getPath() {
        LOGGER.entering(this.getClass().getName(), "getPath");
        LOGGER.exiting(this.getClass().getName(), "getPath");
        return this.m_filePath;
    }

    public void setPath(File fileProfilePath) {
        LOGGER.entering(this.getClass().getName(), "setPath");
        this.m_filePath = FileUtils.getNormalizedPath(fileProfilePath);
        LOGGER.exiting(this.getClass().getName(), "setPath");
    }

    public List getAugmentors() {
        LOGGER.entering(this.getClass().getName(), "getAugmentors");
        LOGGER.exiting(this.getClass().getName(), "getAugmentors");
        return this.m_listAugmentors;
    }

    public List<WSProfileTemplate> getAugmentationTemplates() throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "getAugmentationTemplates");
        Vector<WSProfileTemplate> listWsptAugmentors = new Vector<WSProfileTemplate>();
        for (String strCurrent : this.m_listAugmentors) {
            try {
                WSProfileTemplate wspt = new WSProfileTemplate(strCurrent);
                listWsptAugmentors.add(wspt);
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getAugmentationTemplates", "Augment template path failed validation");
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getAugmentationTemplates");
        return listWsptAugmentors;
    }

    public List<WSProfileTemplate> getAugmentationTemplatesRelaxed() {
        LOGGER.entering(this.getClass().getName(), "getAugmentationTemplates");
        Vector<WSProfileTemplate> listWsptAugmentors = new Vector<WSProfileTemplate>();
        for (String strCurrent : this.m_listAugmentors) {
            try {
                listWsptAugmentors.add(new WSProfileTemplate(strCurrent));
            }
            catch (WSProfileException wspe) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAugmentationTemplatesRelaxed", "The profile template located at " + strCurrent + " failed to instantiate. It is possible that the template" + " is not present on the file system, or the metadata is corrupt. ");
                listWsptAugmentors.add(new WSProfileEmptyTemplate(strCurrent));
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getAugmentationTemplates");
        return listWsptAugmentors;
    }

    public void addAugmentor(String sAugmentingTemplatePath) {
        LOGGER.entering(this.getClass().getName(), "addAugmentor");
        this.m_listAugmentors.add(FileUtils.getNormalizedPath(sAugmentingTemplatePath));
        LOGGER.exiting(this.getClass().getName(), "addAugmentor");
    }

    public void addAugmentor(WSProfileTemplate wsptAugmentor) {
        LOGGER.entering(this.getClass().getName(), "addAugmentor");
        this.m_listAugmentors.add(wsptAugmentor.getProfileTemplatePath().getAbsolutePath());
        LOGGER.exiting(this.getClass().getName(), "addAugmentor");
    }

    public void removeAugmentor(String sAugmentingTemplatePath) {
        LOGGER.entering(this.getClass().getName(), "removeAugmentor");
        this.m_listAugmentors.remove(FileUtils.getNormalizedPath(sAugmentingTemplatePath));
        LOGGER.exiting(this.getClass().getName(), "removeAugmentor");
    }

    public void removeAugmentor(WSProfileTemplate wsptAugmentor) {
        LOGGER.entering(this.getClass().getName(), "addAugmentor");
        this.m_listAugmentors.remove(wsptAugmentor.getProfileTemplatePath().getAbsolutePath());
        LOGGER.exiting(this.getClass().getName(), "addAugmentor");
    }

    public File getTemplate() {
        LOGGER.entering(this.getClass().getName(), "getTemplate");
        LOGGER.exiting(this.getClass().getName(), "getTemplate");
        return this.m_fileTemplate;
    }

    public WSProfileTemplate getWSProfileTemplate() throws WSProfileException {
        LOGGER.entering(this.getClass().getName(), "getTemplate");
        LOGGER.exiting(this.getClass().getName(), "getTemplate");
        return new WSProfileTemplate(this.m_fileTemplate);
    }

    public WSProfileTemplate getWSProfileTemplateRelaxed() {
        WSProfileTemplate wsptReturn;
        LOGGER.entering(this.getClass().getName(), "getTemplate");
        try {
            wsptReturn = new WSProfileTemplate(this.m_fileTemplate);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getWSProfileTemplateRelaxed", "The profile template located at " + this.m_fileTemplate + " failed to instantiate. It is possible that the template" + " is not present on the file system, or the metadata is corrupt. ");
            wsptReturn = new WSProfileEmptyTemplate(this.m_fileTemplate);
        }
        LOGGER.exiting(this.getClass().getName(), "getTemplate");
        return wsptReturn;
    }

    public boolean equals(Object o) {
        Profile profileIn;
        LOGGER.entering(this.getClass().getName(), "equals");
        if (o instanceof Profile && (profileIn = (Profile)o).getName().equals(this.getName()) && profileIn.getPath().equals(this.getPath()) && profileIn.getWSProfileTemplateRelaxed().equals(this.getWSProfileTemplateRelaxed()) && profileIn.isDefault() == this.isDefault()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "equals", this.toString() + " and " + o.toString() + " are equal");
            LOGGER.exiting(this.getClass().getName(), "equals");
            return true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "equals", this.toString() + " and " + o + " are not equal");
        LOGGER.exiting(this.getClass().getName(), "equals");
        return false;
    }

    public int hashCode() {
        LOGGER.entering(this.getClass().getName(), "hashCode");
        int nHash = 1;
        nHash = nHash * 31 + this.getName().hashCode();
        nHash = nHash * 31 + this.getPath().hashCode();
        nHash = nHash * 31 + this.getTemplate().hashCode();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "hashCode", this.toString() + ", hash code: " + nHash);
        LOGGER.exiting(this.getClass().getName(), "hashCode");
        return nHash;
    }

    public boolean isProfileValid() {
        LOGGER.entering(this.getClass().getName(), "hashCode");
        if (!this.m_filePath.exists()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isProfileValid", this.toString() + " is not a valid profile as it doesn't exist on the file system");
            return false;
        }
        if (!this.m_fileTemplate.exists()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isProfileValid", this.toString() + " is not a valid profile as its template doesn't exist on the file system");
            return false;
        }
        LOGGER.exiting(this.getClass().getName(), "hashCode");
        return true;
    }
}

