/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.profile;

import com.ibm.ws.install.configmanager.launcher.Launcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WSProfileConstants;
import com.ibm.ws.profile.WSProfileContext;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.registry.ProfileRegistryMarshaller;
import com.ibm.ws.profile.registry.ProfileRegistrySnippetMarshaller;
import com.ibm.ws.profile.utils.BackupProfileSnippetMarshallerUtils;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.SystemPropertiesUtils;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfileEmptyTemplate;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfile {
    public static final int N_SUCCESS = 0;
    public static final int N_PARTIAL_SUCCESS = 2;
    public static final int N_FAILURE = 1;
    private static final String S_EMPTY = "";
    private static final String S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY = "WSProfile.WSProfile.noProfileTemplateExistsAtGivenPath";
    private static final String S_DIR_EXISTS_NOT_EMPTY_KEY = "WSProfile.WSProfile.dirExistsNotEmpty";
    private static final String S_PATH_EXISTS_NOT_DIR_KEY = "WSProfile.WSProfile.pathExistsNotDirectory";
    private static final String S_PATH_NOT_WRITABLE_KEY = "WSProfile.WSProfile.pathNotWritable";
    private static final String S_PROFILE_NAME_EXISTS_KEY = "WSProfile.WSProfile.profileNameExists";
    private static final String S_RESERVATION_TICKET_NOT_AVAILABLE_KEY = "WSProfile.WSProfile.reservationTicketNotAvailableKey";
    private static final String S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY = "WSProfile.WSProfile.invalidProfileTemplateOperation";
    private static final String S_CANNOT_REPEAT_TEMPLATE_OPERATION_KEY = "WSProfile.WSProfile.cannotRepeatTemplateOperation";
    private static final String S_INVALID_PROFILE_TEMPLATE_KEY = "WSProfile.WSProfile.invalideProfileTemplate";
    private static final String S_UNSATISFIED_PREREQS_KEY = "WSProfile.WSProfile.augmentPrereqNotMet";
    private static final String S_PROFILE_BACKUP_INFO = "ProfileBackupInfo";
    private static final String S_REGISTRY_VALIDATION_FAILED = "WSProfile.WSProfile.registryValidationFailure";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfile.class);
    private static final String S_CLASS_NAME = WSProfile.class.getName();

    public static int create(String sProfileName, File fileProfilePath, File fileTemplatePath, String sNodeName, String sCellName, String sHostName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "create");
        LOGGER.exiting(WSProfile.class.getName(), "create");
        return WSProfile.create(sProfileName, fileProfilePath, fileTemplatePath, sNodeName, sCellName, sHostName, new HashMap());
    }

    public static int create(String sProfileName, File fileProfilePath, File fileTemplatePath, String sNodeName, String sCellName, String sHostName, Map mapOptionalArgMap) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "create");
        LOGGER.exiting(WSProfile.class.getName(), "create");
        return WSProfile.create(sProfileName, fileProfilePath, fileTemplatePath, sNodeName, sCellName, sHostName, mapOptionalArgMap, WSProfile.getRegistryFile());
    }

    public static int create(String sProfileName, File fileProfilePath, File fileTemplatePath, String sNodeName, String sCellName, String sHostName, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "create");
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(fileTemplatePath);
        WSProfileTemplate wsptTemplateThis = WSProfile.getWSProfileTemplate(fileTemplatePath);
        if (wsptTemplateThis.getPrereqTemplatePath() != null) {
            try {
                Vector v_wsptTemplates = (Vector)PrereqTemplateUtils.getTemplatesForStackCreation(wsptTemplateThis);
                return WSProfile.stackCreate(sProfileName, fileProfilePath, v_wsptTemplates, sNodeName, sCellName, sHostName, mapOptionalArgMap, fileRegistry);
            }
            catch (WSProfileException e) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "create", "Exception caught while attempting to perform profile creation-augmenation");
                return 1;
            }
        }
        WSProfile.validateDirectoryIsWritable(fileProfilePath);
        WSProfile.throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(fileProfilePath);
        WSProfile.throwExceptionIfTheGivenProfileIsAlreadyRegistered(sProfileName, fileProfilePath, fileTemplatePath, fileRegistry);
        WSProfile.validateProfileCreationTemplate(wsptTemplateThis);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "create", "Creating new profile " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + ", using registry file: " + fileRegistry.getAbsolutePath());
        boolean fIsDefaultProfile = mapOptionalArgMap.containsKey("isDefault");
        WSProfileTemplate wsptThis = new WSProfileTemplate(fileTemplatePath);
        Profile profileThis = new Profile(sProfileName, fileProfilePath, wsptThis, fIsDefaultProfile, true);
        int nReturnCode = WSProfile.doCreate(profileThis, wsptTemplateThis, sNodeName, sCellName, sHostName, mapOptionalArgMap, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "create");
        return nReturnCode;
    }

    private static int stackCreate(String sProfileName, File fileProfilePath, Vector v_wsptTemplates, String sNodeName, String sCellName, String sHostName, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "create");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "stackCreate", "Entering profile creation-augmentation mode. " + v_wsptTemplates.size() + " WSProfile operations will be performed.");
        PrereqTemplateUtils.validateListForCreation(v_wsptTemplates);
        File fileTemplatePath = ((WSProfileTemplate)v_wsptTemplates.get(0)).getProfileTemplatePath();
        WSProfile.validateDirectoryIsWritable(fileProfilePath);
        WSProfile.throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(fileProfilePath);
        WSProfile.throwExceptionIfTheGivenProfileIsAlreadyRegistered(sProfileName, fileProfilePath, fileTemplatePath, fileRegistry);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "stackCreate", "Creating new profile " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + ", using registry file: " + fileRegistry.getAbsolutePath());
        boolean fIsDefaultProfile = mapOptionalArgMap.containsKey("isDefault");
        WSProfileTemplate wsptThis = new WSProfileTemplate(fileTemplatePath);
        Profile profileThis = new Profile(sProfileName, fileProfilePath, wsptThis, fIsDefaultProfile, true);
        Map mapStackOptionalArgMap = WSProfile.replaceTemplatePathArg(mapOptionalArgMap, fileTemplatePath.getAbsolutePath());
        int nReturnCode = WSProfile.doCreate(profileThis, (WSProfileTemplate)v_wsptTemplates.get(0), sNodeName, sCellName, sHostName, mapStackOptionalArgMap, fileRegistry);
        int nTemplateIndex = 1;
        while (nReturnCode != 1 && nTemplateIndex < v_wsptTemplates.size()) {
            fileTemplatePath = ((WSProfileTemplate)v_wsptTemplates.get(nTemplateIndex)).getProfileTemplatePath();
            mapStackOptionalArgMap = WSProfile.replaceTemplatePathArg(mapOptionalArgMap, fileTemplatePath.getAbsolutePath());
            int nReturnCodeThis = WSProfile.doAugment(profileThis, (WSProfileTemplate)v_wsptTemplates.get(nTemplateIndex), mapStackOptionalArgMap, fileRegistry);
            ++nTemplateIndex;
            if (nReturnCodeThis == 2 && nReturnCode == 0) {
                nReturnCode = 2;
            }
            if (nReturnCodeThis != 1 || nReturnCode != 0 && nReturnCode != 2) continue;
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            WSProfile.unregister(sProfileName);
        }
        WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "create");
        return nReturnCode;
    }

    private static int doCreate(Profile profileThis, WSProfileTemplate wsptThis, String sNodeName, String sCellName, String sHostName, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "doCreate");
        WSProfile.registerPreCreate(profileThis, fileRegistry);
        String sProfileName = profileThis.getName();
        File fileProfilePath = profileThis.getPath();
        File fileTemplatePath = wsptThis.getProfileTemplatePath();
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(sProfileName, fileProfilePath.getAbsolutePath(), fileTemplatePath.getAbsolutePath(), sNodeName, sCellName, sHostName, mapOptionalArgMap, WSProfileDataStore.getDisabledActions(fileTemplatePath.getAbsolutePath()), new File(fileTemplatePath.getAbsolutePath(), "actionRegistry.xml"));
        int nReturnCode = Launcher.mainForInProcessCMTCallers();
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doCreate", "Creation of profile " + sProfileName + " at path " + fileProfilePath.getAbsolutePath() + " failed.");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doCreate", "Unregistering profile " + sProfileName);
            WSProfile.unregister(sProfileName, fileRegistry, true);
        } else {
            if (nReturnCode == 2) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doCreate", "Creation of profile " + sProfileName + " at path " + fileProfilePath.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
            }
            if (nReturnCode == 0) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "doCreate", "Creation of profile " + sProfileName + " at path " + fileProfilePath.getAbsolutePath() + " was successful.");
            }
            WSProfile.registerPostCreate(profileThis, fileRegistry);
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doCreate", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(mapOptionalArgMap);
        LOGGER.exiting(WSProfile.class.getName(), "doCreate");
        return nReturnCode;
    }

    public static int augment(String sProfileName, File fileTemplatePath, Map mapArgs) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "augment");
        LOGGER.exiting(WSProfile.class.getName(), "augment");
        return WSProfile.augment(sProfileName, fileTemplatePath, mapArgs, WSProfile.getRegistryFile());
    }

    public static int augment(String sProfileName, File fileTemplatePath, Map mapArgs, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "augment");
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        File fileProfilePath = profileThis.getPath();
        WSProfileTemplate wsptThis = WSProfile.getWSProfileTemplate(fileTemplatePath);
        if (wsptThis.getPrereqTemplatePath() != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "augment", "Prerequisite detected. Launching stack augment mode.");
            try {
                Vector v_wsptAugmentingTemplates = (Vector)PrereqTemplateUtils.getTemplatesForStackAugmentation(wsptThis, WSProfile.getProfile(sProfileName));
                return WSProfile.stackAugment(sProfileName, v_wsptAugmentingTemplates, mapArgs, fileRegistry);
            }
            catch (WSProfileException e) {
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_UNSATISFIED_PREREQS_KEY));
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "augment", e.getLocalizedMessage());
                return 1;
            }
        }
        WSProfile.setReservationTicketToRegistry(sProfileName, fileRegistry);
        try {
            WSProfile.validateAProfileTemplateExistsAtTheGivenPath(fileTemplatePath);
            WSProfile.validateDirectoryIsWritable(fileProfilePath);
            WSProfile.validateProfileAugmentationTemplate(profileThis, wsptThis);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "augment", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            throw wspe;
        }
        int nReturnCode = WSProfile.doAugment(profileThis, wsptThis, mapArgs, fileRegistry);
        WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "augment");
        return nReturnCode;
    }

    private static int stackAugment(String sProfileName, Vector v_wsptTemplates, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "augment");
        WSProfile.setReservationTicketToRegistry(sProfileName, fileRegistry);
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        File fileProfilePath = profileThis.getPath();
        int nTemplateIndex = 0;
        int nReturnCode = 0;
        File fileTemplatePath = null;
        Map mapStackOptionalArgMap = null;
        try {
            WSProfile.validateDirectoryIsWritable(fileProfilePath);
            PrereqTemplateUtils.validateListForAugmentation(v_wsptTemplates, profileThis);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "stackAugment", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            throw wspe;
        }
        while (nReturnCode != 1 && nTemplateIndex < v_wsptTemplates.size()) {
            fileTemplatePath = ((WSProfileTemplate)v_wsptTemplates.get(nTemplateIndex)).getProfileTemplatePath();
            mapStackOptionalArgMap = WSProfile.replaceTemplatePathArg(mapOptionalArgMap, fileTemplatePath.getAbsolutePath());
            int nReturnCodeThis = WSProfile.doAugment(profileThis, (WSProfileTemplate)v_wsptTemplates.get(nTemplateIndex), mapStackOptionalArgMap, fileRegistry);
            ++nTemplateIndex;
            if (nReturnCodeThis == 2 && nReturnCode == 0) {
                nReturnCode = 2;
            }
            if (nReturnCodeThis != 1 || nReturnCode != 0 && nReturnCode != 2) continue;
            nReturnCode = 1;
        }
        WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "augment");
        return nReturnCode;
    }

    private static int doAugment(Profile profileThis, WSProfileTemplate wsptTemplate, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "doAugment");
        String sProfileName = profileThis.getName();
        File fileProfilePath = profileThis.getPath();
        File fileTemplatePath = wsptTemplate.getProfileTemplatePath();
        String[] disabledActions = WSProfileDataStore.getDisabledActions(fileTemplatePath.getAbsolutePath());
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(sProfileName, fileProfilePath.getAbsolutePath(), fileTemplatePath.getAbsolutePath(), null, null, null, mapOptionalArgMap, disabledActions, new File(fileTemplatePath.getAbsolutePath(), "actionRegistry.xml"));
        int nReturnCode = Launcher.mainForInProcessCMTCallers();
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAugment", "Augmentation of profile " + sProfileName + " at path " + fileProfilePath.getAbsolutePath() + " using profile template " + fileTemplatePath + " failed.");
        }
        if (nReturnCode == 2) {
            profileThis = WSProfile.getProfile(profileThis.getName());
            profileThis.addAugmentor(new WSProfileTemplate(fileTemplatePath));
            WSProfile.unregister(sProfileName, fileRegistry);
            WSProfile.register(profileThis, fileRegistry);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAugment", "Augmentation of profile " + sProfileName + " at path " + fileProfilePath.getAbsolutePath() + " using profile template " + fileTemplatePath + " was successful, but some non-fatal config actions failed.");
        }
        if (nReturnCode == 0) {
            profileThis = WSProfile.getProfile(profileThis.getName());
            profileThis.addAugmentor(new WSProfileTemplate(fileTemplatePath));
            WSProfile.unregister(sProfileName, fileRegistry);
            WSProfile.register(profileThis, fileRegistry);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doAugment", "Augmentation of profile " + sProfileName + " at path " + fileProfilePath.getAbsolutePath() + " using profile template " + fileTemplatePath);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doAugment", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(mapOptionalArgMap);
        LOGGER.exiting(WSProfile.class.getName(), "doAugment");
        return nReturnCode;
    }

    public static int delete(String sProfileName, Map mapOptionalArgMap) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "delete");
        LOGGER.exiting(WSProfile.class.getName(), "delete");
        return WSProfile.delete(sProfileName, mapOptionalArgMap, WSProfile.getRegistryFile());
    }

    public static int delete(String sProfileName, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "delete");
        WSProfile.setReservationTicketToRegistry(sProfileName, fileRegistry);
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        File fileProfilePath = profileThis.getPath();
        File fileTemplatePath = profileThis.getWSProfileTemplateRelaxed().getProfileTemplatePath();
        List<WSProfileTemplate> augmentorList = profileThis.getAugmentationTemplatesRelaxed();
        int nReturnCode = 0;
        if (augmentorList.size() > 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "delete", sProfileName + " has " + augmentorList.size() + " augments applied. " + "Unaugmentation will be performed on each prior to deletion.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            for (int i = 0; i < augmentorList.size(); ++i) {
                int nReturnCodeThis = WSProfile.unaugment(sProfileName, mapOptionalArgMap, fileRegistry);
                if (nReturnCodeThis == 2 && nReturnCode == 0) {
                    nReturnCode = 2;
                }
                if (nReturnCodeThis != 1 || nReturnCode != 0 && nReturnCode != 2) continue;
                nReturnCode = 1;
            }
            WSProfile.setReservationTicketToRegistry(sProfileName, fileRegistry);
            if (nReturnCode == 1) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "delete", "Unaugmentation of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " failed.  Profile deletion will continue.");
            }
            if (nReturnCode == 2) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "delete", "Unaugmentation of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful, but some non-fatal config actions failed.  Profile deletion will continue.");
            }
            if (nReturnCode == 0) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "delete", "Unaugmentation of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful.  Profile deletion will continue.");
            }
        }
        try {
            WSProfile.validateDirectoryIsWritable(fileProfilePath);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "delete", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            throw wspe;
        }
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(sProfileName, fileProfilePath.getAbsolutePath(), fileTemplatePath.getAbsolutePath(), null, null, null, mapOptionalArgMap, null, new File(fileTemplatePath.getAbsolutePath(), "deleteRegistry.xml"));
        nReturnCode = 1;
        if (WSProfile.unregister(sProfileName, fileRegistry)) {
            nReturnCode = Launcher.mainForInProcessCMTCallers();
            if (nReturnCode == 0 && profileThis.getWSProfileTemplateRelaxed().isEmptyTemplate()) {
                nReturnCode = 2;
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doUnaugment", "Deletion of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful, " + "but no config actions were executed. The template " + profileThis.getWSProfileTemplateRelaxed().getProfileTemplatePath() + " might not be present on the file system or its metadata might be corrupt.");
            }
        } else {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "delete", "The profile " + sProfileName + " was not unregistered.  Likely cause is that it was not found in the registry.");
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "delete", "Deletion of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " failed.");
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "delete", "Deletion of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "delete", "Deletion of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful.");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "delete", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(mapOptionalArgMap);
        LOGGER.exiting(WSProfile.class.getName(), "delete");
        return nReturnCode;
    }

    public static int edit(String sProfileName, Map mapOptionalArgMap) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "edit");
        LOGGER.exiting(WSProfile.class.getName(), "edit");
        return WSProfile.edit(sProfileName, mapOptionalArgMap, WSProfile.getRegistryFile());
    }

    public static int edit(String sProfileName, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "edit");
        WSProfile.setReservationTicketToRegistry(sProfileName, fileRegistry);
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        File fileProfilePath = profileThis.getPath();
        File fileTemplatePath = profileThis.getWSProfileTemplate().getProfileTemplatePath();
        try {
            WSProfile.validateAProfileTemplateExistsAtTheGivenPath(fileTemplatePath);
            WSProfile.validateDirectoryIsWritable(fileProfilePath);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "edit", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            throw wspe;
        }
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(sProfileName, fileProfilePath.getAbsolutePath(), fileTemplatePath.getAbsolutePath(), null, null, null, mapOptionalArgMap, null, new File(fileTemplatePath.getAbsolutePath(), "editRegistry.xml"));
        int nReturnCode = Launcher.mainForInProcessCMTCallers();
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "edit", "Edit of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " failed.");
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "edit", "Edit of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "edit", "Edit of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful.");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "edit", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(mapOptionalArgMap);
        WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "edit");
        return nReturnCode;
    }

    public static int list(String sProfileName, Map mapOptionalArgMap) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "list");
        LOGGER.exiting(WSProfile.class.getName(), "list");
        return WSProfile.list(sProfileName, mapOptionalArgMap, WSProfile.getRegistryFile());
    }

    public static int list(String sProfileName, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "list");
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        File fileProfilePath = profileThis.getPath();
        File fileTemplatePath = profileThis.getWSProfileTemplate().getProfileTemplatePath();
        WSProfile.validateDirectoryIsWritable(fileProfilePath);
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(sProfileName, fileProfilePath.getAbsolutePath(), fileTemplatePath.getAbsolutePath(), null, null, null, mapOptionalArgMap, null, new File(fileTemplatePath.getAbsolutePath(), "listRegistry.xml"));
        int nReturnCode = Launcher.mainForInProcessCMTCallers();
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "list", "List of " + sProfileName + " details at " + fileProfilePath.getAbsolutePath() + " failed.");
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "list", "List of " + sProfileName + " details at " + fileProfilePath.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "list", "List of " + sProfileName + " details at " + fileProfilePath.getAbsolutePath() + " was successful.");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "list", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(mapOptionalArgMap);
        LOGGER.exiting(WSProfile.class.getName(), "list");
        return nReturnCode;
    }

    public static int unlock(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unlock");
        int nReturnCode = 0;
        try {
            WSProfile.getProfile(sProfileName, fileRegistry);
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "unlock", "Failed to unset reservation ticket in registry. The profile has not been modified.");
            nReturnCode = 1;
            throw wspe;
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "unlock", "Unlocking of " + sProfileName + " was successful.");
        }
        LOGGER.exiting(WSProfile.class.getName(), "unlock");
        return nReturnCode;
    }

    public static int unaugment(String sProfileName, Map mapOptionalArgMap) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unaugment");
        LOGGER.exiting(WSProfile.class.getName(), "unaugment");
        return WSProfile.unaugment(sProfileName, mapOptionalArgMap, WSProfile.getRegistryFile());
    }

    public static int unaugment(String sProfileName, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unaugment");
        int nLastAugmentorIndex = 0;
        WSProfile.setReservationTicketToRegistry(sProfileName, fileRegistry);
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        File fileProfilePath = profileThis.getPath();
        try {
            WSProfile.validateDirectoryIsWritable(fileProfilePath);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            throw wspe;
        }
        List<WSProfileTemplate> lwsptAugmentationTemplates = profileThis.getAugmentationTemplatesRelaxed();
        if (lwsptAugmentationTemplates.size() == 0) {
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            return 0;
        }
        nLastAugmentorIndex = lwsptAugmentationTemplates.size() - 1;
        String sAugmentingTemplatePath = lwsptAugmentationTemplates.get(nLastAugmentorIndex).getProfileTemplatePath().getPath();
        File fileAugmentingTemplatePath = new File(sAugmentingTemplatePath);
        int nReturnCode = WSProfile.doUnaugment(profileThis, fileAugmentingTemplatePath, mapOptionalArgMap, fileRegistry);
        WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "unaugment");
        return nReturnCode;
    }

    public static int unaugment(String sProfileName, File fileTemplatePath, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unaugment");
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        List<WSProfileTemplate> v_wsptAugmentors = profileThis.getAugmentationTemplates();
        WSProfileTemplate wsptThis = null;
        WSProfile.setReservationTicketToRegistry(sProfileName, fileRegistry);
        try {
            WSProfile.validateDirectoryIsWritable(profileThis.getPath());
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            throw wspe;
        }
        if (!v_wsptAugmentors.contains(new WSProfileTemplate(fileTemplatePath))) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", fileTemplatePath + " is not an augmentor to profile " + sProfileName + ". Profile unaugmentation cannot proceed.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            LOGGER.exiting(WSProfile.class.getName(), "unaugment");
            return 1;
        }
        for (int i = 0; i < v_wsptAugmentors.size(); ++i) {
            try {
                wsptThis = v_wsptAugmentors.get(i);
                if (wsptThis.getPrereqTemplatePath() == null || !wsptThis.getPrereqTemplatePath().equals(fileTemplatePath) || wsptThis.getProfileTemplatePath().equals(fileTemplatePath)) continue;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugment", fileTemplatePath + " is found to be a prerequisite " + "of " + wsptThis.getProfileTemplatePath() + ". Unaugmentation cannot proceed.");
                WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
                LOGGER.exiting(WSProfile.class.getName(), "unaugment");
                return 1;
            }
            catch (WSProfileException e) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "unaugment", "The augmentor " + v_wsptAugmentors.get(i).getProfileTemplatePath() + " cannot be found on the filesystem, so the prerequisite for this" + " augmentor cannot be determined. Unaugmentation cannot" + " continue with " + fileTemplatePath);
                WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
                LOGGER.exiting(WSProfile.class.getName(), "unaugment");
                return 1;
            }
        }
        int nReturnCode = WSProfile.doUnaugment(profileThis, fileTemplatePath, mapOptionalArgMap, fileRegistry);
        WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "unaugment");
        return nReturnCode;
    }

    public static int unaugmentAll(String sTemplatePath, Map mapOptionalArgMap) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unaugmentAll");
        LOGGER.exiting(WSProfile.class.getName(), "unaugmentAll");
        return WSProfile.unaugmentAll(new WSProfileTemplate(sTemplatePath), mapOptionalArgMap);
    }

    public static int unaugmentAll(WSProfileTemplate templateToUnaugment, Map mapOptionalArgMap) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unaugmentAll");
        if (WSProfile.validateRegistry().size() != 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugmentAll", "Validation of the current registry file located at " + WSProfile.getRegistryFile().toString() + " failed.");
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_VALIDATION_FAILED));
            return 1;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugmentAll", "Validation of the current registry file located at " + WSProfile.getRegistryFile().toString() + " was success.");
        int nReturnCode = 0;
        List listAllProfiles = WSProfile.getProfileList();
        Map mapProfilesToUnaugments = WSProfile.getMapOfProfilesToUnaugments(templateToUnaugment);
        String sUnaugPrereqs = (String)mapOptionalArgMap.get("unaugmentDependents");
        mapOptionalArgMap.remove("unaugmentDependents");
        if (sUnaugPrereqs == null || sUnaugPrereqs.equalsIgnoreCase("false")) {
            for (int i = 0; i < listAllProfiles.size(); ++i) {
                Profile currProfile = (Profile)listAllProfiles.get(i);
                List listOfUnaugmentsForCurrentProfile = (List)mapProfilesToUnaugments.get(currProfile);
                if (listOfUnaugmentsForCurrentProfile.size() <= 1 || !listOfUnaugmentsForCurrentProfile.contains(templateToUnaugment)) continue;
                nReturnCode = 1;
                return 1;
            }
        }
        nReturnCode = WSProfile.doUnaugmentAll(mapProfilesToUnaugments, mapOptionalArgMap);
        LOGGER.exiting(WSProfile.class.getName(), "unaugmentAll");
        return nReturnCode;
    }

    private static int doUnaugmentAll(Map mapProfilesToUnaugments, Map mapOptionalArgMap) throws WSProfileException {
        int nReturnCode = 0;
        int nCurrentReturnCode = 0;
        List listAllProfiles = WSProfile.getProfileList();
        for (int i = 0; i < listAllProfiles.size(); ++i) {
            Profile currProfile = (Profile)listAllProfiles.get(i);
            List listOfUnaugmentsForCurrentProfile = (List)mapProfilesToUnaugments.get(currProfile);
            if (listOfUnaugmentsForCurrentProfile.isEmpty()) continue;
            for (int j = listOfUnaugmentsForCurrentProfile.size() - 1; j >= 0; --j) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugmentAll", "Trying to unaugment a template located at " + ((WSProfileTemplate)listOfUnaugmentsForCurrentProfile.get(j)).getProfileTemplatePath() + " from profile " + currProfile.getName());
                nCurrentReturnCode = WSProfile.unaugment(currProfile.getName(), ((WSProfileTemplate)listOfUnaugmentsForCurrentProfile.get(j)).getProfileTemplatePath(), mapOptionalArgMap, WSProfile.getRegistryFile());
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unaugmentAll", "Result of unaugmentation was " + nCurrentReturnCode);
                if (nCurrentReturnCode == 1) {
                    nReturnCode = 1;
                    continue;
                }
                if (nCurrentReturnCode != 2 || nReturnCode == 1) continue;
                nReturnCode = 2;
            }
        }
        return nReturnCode;
    }

    public static Map getMapOfProfilesToUnaugments(WSProfileTemplate templateToUnaugment) throws WSProfileException {
        Hashtable<Profile, Vector> mapProfilesToUnaugments = new Hashtable<Profile, Vector>();
        List listAllProfiles = WSProfile.getProfileList();
        for (int i = 0; i < listAllProfiles.size(); ++i) {
            Profile currProfile = (Profile)listAllProfiles.get(i);
            Vector listOfUnaugmentsForCurrentProfile = (Vector)PrereqTemplateUtils.getListOfDependantTemplates(currProfile.getName(), templateToUnaugment);
            mapProfilesToUnaugments.put(currProfile, listOfUnaugmentsForCurrentProfile);
        }
        return mapProfilesToUnaugments;
    }

    private static int doUnaugment(Profile profileThis, File fileTemplatePath, Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        WSProfileTemplate wsptToRemove;
        LOGGER.entering(WSProfile.class.getName(), "doUnaugment");
        String sProfileName = profileThis.getName();
        File fileProfilePath = profileThis.getPath();
        String sTemplatePath = fileTemplatePath.getAbsolutePath();
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(sProfileName, fileProfilePath.getAbsolutePath(), fileTemplatePath.getAbsolutePath(), null, null, null, mapOptionalArgMap, null, new File(fileTemplatePath.getAbsolutePath(), "deleteRegistry.xml"));
        try {
            wsptToRemove = new WSProfileTemplate(sTemplatePath);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "create", "The profile template pointed by " + sTemplatePath + " might not exists on the file system or its metadata might be corrupt. " + "The unaugment action will proceed but some configuration steps might not be " + "performed.");
            wsptToRemove = new WSProfileEmptyTemplate(sTemplatePath);
        }
        profileThis.removeAugmentor(wsptToRemove);
        int nReturnCode = Launcher.mainForInProcessCMTCallers();
        if (nReturnCode == 0 && wsptToRemove.isEmptyTemplate()) {
            nReturnCode = 2;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doUnaugment", "Unaugmentation of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful, " + "but no config actions were executed. The template " + wsptToRemove.getProfileTemplatePath() + " might not be present on the file system.");
        }
        if (nReturnCode == 1) {
            WSProfile.unregister(sProfileName, fileRegistry);
            WSProfile.register(profileThis, fileRegistry);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doUnaugment", "Unaugmentation of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " failed.");
        }
        if (nReturnCode == 2) {
            WSProfile.unregister(sProfileName, fileRegistry);
            WSProfile.register(profileThis, fileRegistry);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doUnaugment", "Unaugmentation of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful, but some non-fatal config actions failed.");
        }
        if (nReturnCode == 0) {
            WSProfile.unregister(sProfileName, fileRegistry);
            WSProfile.register(profileThis, fileRegistry);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doUnaugment", "Unaugmentation of " + sProfileName + " at " + fileProfilePath.getAbsolutePath() + " was successful.");
        }
        LOGGER.exiting(WSProfile.class.getName(), "doUnaugment");
        return nReturnCode;
    }

    public static int deleteAll(Map mapOptionalArgMap) throws WSProfileException {
        return WSProfile.deleteAll(mapOptionalArgMap, WSProfile.getRegistryFile());
    }

    public static int deleteAll(Map mapOptionalArgMap, File fileRegistry) throws WSProfileException {
        List listsAllProfilesInThisRegistry = WSProfile.listProfileNames(fileRegistry);
        int nReturnCode = 0;
        for (int i = 0; i < listsAllProfilesInThisRegistry.size(); ++i) {
            String sProfileNameThis = listsAllProfilesInThisRegistry.get(i).toString();
            int nReturnCodeThis = WSProfile.delete(sProfileNameThis, mapOptionalArgMap, fileRegistry);
            if (nReturnCodeThis == 2 && nReturnCode == 0) {
                nReturnCode = 2;
            }
            if (nReturnCodeThis != 1 || nReturnCode != 0 && nReturnCode != 2) continue;
            nReturnCode = 1;
        }
        return nReturnCode;
    }

    public static int backup(String sProfileName, Map optionalArgMap) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "backup");
        LOGGER.exiting(WSProfile.class.getName(), "backup");
        return WSProfile.backup(sProfileName, optionalArgMap, WSProfile.getRegistryFile());
    }

    public static int backup(String sProfileName, Map mapOptionalArgs, File fileRegistry) throws WSProfileException {
        File parentDir;
        LOGGER.entering(WSProfile.class.getName(), "backup");
        WSProfile.setReservationTicketToRegistry(sProfileName, fileRegistry);
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        File fileProfilePath = profileThis.getPath();
        File fileProfileTemplatePath = profileThis.getWSProfileTemplate().getProfileTemplatePath();
        try {
            WSProfile.validateDirectoryIsWritable(profileThis.getPath());
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "backup", "Validation failed, unsetting reservation ticket in registry. The profile has not been modified.");
            WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
            throw wspe;
        }
        int nReturnCode = 1;
        String sBackupFile = mapOptionalArgs.get("backupFile").toString();
        sBackupFile = sBackupFile.substring(1, sBackupFile.length() - 1);
        File backupFile = new File(sBackupFile);
        try {
            parentDir = new File(backupFile.getParent());
        }
        catch (NullPointerException e) {
            parentDir = null;
        }
        boolean parentExists = false;
        if (parentDir != null) {
            parentExists = parentDir.exists();
        }
        if (!parentExists && parentDir != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "backup", "The path " + parentDir.getAbsolutePath() + " does not exist.");
            parentExists = parentDir.mkdirs();
            if (parentExists) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "backup", "The path " + parentDir.getAbsolutePath() + " was successfully created.");
            }
        }
        if (parentDir == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "backup", "The path " + sBackupFile + " is not valid, ensure an absolute file path is being used.");
            nReturnCode = 1;
        } else if (parentExists) {
            BackupProfileSnippetMarshallerUtils.writeInformationToSnippetFile(profileThis, S_PROFILE_BACKUP_INFO, new File(profileThis.getPath(), "profileBackupSnippet.xml"));
            ProfileRegistrySnippetMarshaller.writeProfileToRegistrySnippetFile(profileThis, new File(profileThis.getPath(), "profileRegistrySnippet.xml"));
            SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(sProfileName, fileProfilePath.getAbsolutePath(), fileProfileTemplatePath.getAbsolutePath(), null, null, null, mapOptionalArgs, null, new File(profileThis.getWSProfileTemplate().getProfileTemplatePath(), "backupRegistry.xml"));
            nReturnCode = Launcher.mainForInProcessCMTCallers();
        } else {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "backup", "The path " + parentDir.getAbsolutePath() + " could not be created.");
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "backup", "Backup of profile " + sProfileName + " failed.");
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "backup", "Backup of profile " + sProfileName + " was succssful," + "but some non-fatal config actions failed.");
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "backup", "Backup of profile " + sProfileName + " was succssful.");
        }
        BackupProfileSnippetMarshallerUtils.deleteFile(new File(profileThis.getPath(), "profileBackupSnippet.xml"));
        ProfileRegistrySnippetMarshaller.deleteProfileRegistrySnippet(new File(profileThis.getPath(), "profileRegistrySnippet.xml"));
        WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "backup", "Resetting the system properties to remove custom properties");
        SystemPropertiesUtils.resetJavaSystemPropertiesForConfigManagerProfileCreationOrDeletion(mapOptionalArgs);
        LOGGER.exiting(WSProfile.class.getName(), "backup");
        return nReturnCode;
    }

    public static int restore(File fileBackup, Map mapOptionalArgs) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "restore");
        LOGGER.exiting(WSProfile.class.getName(), "restore");
        return WSProfile.restore(fileBackup, mapOptionalArgs, WSProfile.getRegistryFile());
    }

    public static int restore(File fileBackup, Map mapOptionalArgs, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "restore");
        InputStream is = FileUtils.getInputStreamFromZipFile(fileBackup.getPath(), "profileRegistrySnippet.xml");
        Profile profileThis = ProfileRegistrySnippetMarshaller.readProfileFromRegistrySnippetInputStream(is);
        String sProfileName = profileThis.getName();
        File fileProfilePath = profileThis.getPath();
        File fileTemplatePath = profileThis.getWSProfileTemplate().getProfileTemplatePath();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "restore", " The profile to be restored is: " + profileThis.getName());
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(fileTemplatePath);
        WSProfile.validateDirectoryIsWritable(fileProfilePath);
        WSProfile.throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(fileProfilePath);
        List<WSProfileTemplate> lwsptAugmentors = profileThis.getAugmentationTemplates();
        for (WSProfileTemplate wsptThis : lwsptAugmentors) {
            WSProfile.validateAProfileTemplateExistsAtTheGivenPath(wsptThis.getProfileTemplatePath());
        }
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        if (prm.isThisProfileAlreadyRegistered(profileThis)) {
            prm.deleteProfileFromRegistry(profileThis);
        }
        profileThis.setAReservationTicket(true);
        profileThis.setDefault(false);
        WSProfile.register(profileThis, fileRegistry);
        SystemPropertiesUtils.setJavaSystemPropertiesForConfigManagerBasedOnActionRegistry(sProfileName, fileProfilePath.getAbsolutePath(), fileTemplatePath.getAbsolutePath(), null, null, null, mapOptionalArgs, null, new File(fileTemplatePath.getAbsolutePath(), "restoreRegistry.xml"));
        int nReturnCode = Launcher.mainForInProcessCMTCallers();
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "restore", "Profile restore from backup file " + fileBackup.getAbsolutePath() + " failed.");
            WSProfile.unregister(sProfileName);
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "restore", "Profile restore from backup file " + fileBackup.getAbsolutePath() + " was successful, " + "but some non-fatal config actions failed.");
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "restore", "Profile restore from backup file " + fileBackup.getAbsolutePath() + " was successful. ");
        }
        BackupProfileSnippetMarshallerUtils.deleteFile(new File(profileThis.getPath(), "profileBackupSnippet.xml"));
        ProfileRegistrySnippetMarshaller.deleteProfileRegistrySnippet(new File(fileProfilePath, "profileRegistrySnippet.xml"));
        WSProfile.unsetReservationTicketFromRegistry(sProfileName, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "restore");
        return nReturnCode;
    }

    public static boolean unregister(String sProfileName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unregister");
        LOGGER.exiting(WSProfile.class.getName(), "unregister");
        return WSProfile.unregister(sProfileName, WSProfile.getRegistryFile());
    }

    public static boolean unregister(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unregister");
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        boolean rv = WSProfile.unregister(profileThis, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "unregister");
        return rv;
    }

    public static boolean unregister(Profile profile, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unregister");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        boolean rv = prm.deleteProfileFromRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "unregister");
        return rv;
    }

    public static boolean unregister(String sProfileName, File fileRegistry, boolean f_include_invalid) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unregister");
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry, f_include_invalid);
        boolean rv = WSProfile.unregister(profileThis, fileRegistry);
        LOGGER.exiting(WSProfile.class.getName(), "unregister");
        return rv;
    }

    public static void register(String sProfileName, File fileProfilePath, File fileTemplatePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        LOGGER.exiting(WSProfile.class.getName(), "register");
        WSProfile.register(sProfileName, fileProfilePath, fileTemplatePath, WSProfile.getRegistryFile());
    }

    public static void register(String sProfileName, File fileProfilePath, File fileTemplatePath, File fileRegistryFile) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        WSProfile.register(sProfileName, fileProfilePath, fileTemplatePath, fileRegistryFile, false);
        LOGGER.exiting(WSProfile.class.getName(), "register");
    }

    public static void register(String sProfileName, File fileProfilePath, File fileTemplatePath, File fileRegistryFile, boolean fIsDefault) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        WSProfileTemplate wsptThis = new WSProfileTemplate(fileTemplatePath);
        Profile profileThis = new Profile(sProfileName, fileProfilePath, wsptThis, fIsDefault);
        WSProfile.register(profileThis, fileRegistryFile);
        LOGGER.exiting(WSProfile.class.getName(), "register");
    }

    public static void register(String sProfileName, File fileProfilePath, File fileTemplatePath, File fileRegistryFile, boolean fIsDefault, boolean fIsAReservationTicket) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        WSProfileTemplate wsptThis = new WSProfileTemplate(fileTemplatePath);
        Profile profileThis = new Profile(sProfileName, fileProfilePath, wsptThis, fIsDefault, fIsAReservationTicket);
        WSProfile.register(profileThis, fileRegistryFile);
        LOGGER.exiting(WSProfile.class.getName(), "register");
    }

    public static void register(Profile profile, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "register");
        if (!profile.getWSProfileTemplateRelaxed().isEmptyTemplate()) {
            WSProfile.validateAProfileTemplateExistsAtTheGivenPath(profile.getWSProfileTemplate().getProfileTemplatePath());
        }
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        prm.addProfileToRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "register");
    }

    public static void registerPreCreate(Profile profile, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "registerPreCreate");
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(profile.getWSProfileTemplate().getProfileTemplatePath());
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        prm.preCreateAddProfileToRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "registerPreCreate");
    }

    public static void registerPostCreate(Profile profile, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "registerPostCreate");
        WSProfile.validateAProfileTemplateExistsAtTheGivenPath(profile.getWSProfileTemplate().getProfileTemplatePath());
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        prm.postCreateAddProfileToRegistry(profile);
        LOGGER.exiting(WSProfile.class.getName(), "registerPostCreate");
    }

    public static List listAllProfileNames() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "listAllProfileNames");
        LOGGER.exiting(WSProfile.class.getName(), "listAllProfileNames");
        return WSProfile.listAllProfileNames(WSProfile.getRegistryFile());
    }

    public static List listAllProfileNames(File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "listAllProfileNames");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        List listProfiles = prm.listAllProfilesInRegistry();
        Vector<String> vsProfileNames = new Vector<String>();
        for (int i = 0; i < listProfiles.size(); ++i) {
            Profile profileThis = (Profile)listProfiles.get(i);
            vsProfileNames.add(profileThis.getName());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "listAllProfileNames", "Profiles found: " + vsProfileNames);
        LOGGER.exiting(WSProfile.class.getName(), "listAllProfileNames");
        return vsProfileNames;
    }

    public static List listProfileNames() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "listProfileNames");
        LOGGER.exiting(WSProfile.class.getName(), "listProfileNames");
        return WSProfile.listProfileNames(WSProfile.getRegistryFile());
    }

    public static List listProfileNames(File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "listProfileNames");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        if (prm.isProfileRegistryEmpty()) {
            LOGGER.exiting(WSProfile.class.getName(), "listProfileNames");
            return new Vector();
        }
        List listProfiles = prm.listProfilesInRegistry();
        Vector<String> vsProfileNames = new Vector<String>();
        for (int i = 0; i < listProfiles.size(); ++i) {
            Profile profileThis = (Profile)listProfiles.get(i);
            vsProfileNames.add(profileThis.getName());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "listProfileNames", "Profiles found: " + vsProfileNames);
        LOGGER.exiting(WSProfile.class.getName(), "listProfileNames");
        return vsProfileNames;
    }

    public static List listAugments(String sProfileName) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "listAugments");
        LOGGER.exiting(S_CLASS_NAME, "listAugments");
        return WSProfile.listAugments(sProfileName, WSProfile.getRegistryFile());
    }

    public static List listAugments(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "listAugments");
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        LOGGER.exiting(S_CLASS_NAME, "listAugments");
        return WSProfile.listAugments(profileThis);
    }

    public static List listAugments(Profile profile) throws WSProfileException {
        LOGGER.entering(S_CLASS_NAME, "listAugments");
        List<WSProfileTemplate> listAugments = profile.getAugmentationTemplates();
        Vector<String> vsAugments = new Vector<String>();
        for (int i = 0; i < listAugments.size(); ++i) {
            WSProfileTemplate wsptThisAugment = listAugments.get(i);
            vsAugments.add(FileUtils.getNormalizedPath(wsptThisAugment.getProfileTemplatePath().getPath()));
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "listAugments", "Augments found on " + profile.getName() + ": " + vsAugments);
        LOGGER.exiting(S_CLASS_NAME, "listAugments");
        return vsAugments;
    }

    public static List updateRegistry() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "updateRegistry");
        LOGGER.exiting(WSProfile.class.getName(), "updateRegistry");
        return WSProfile.updateRegistry(WSProfile.getRegistryFile());
    }

    public static List updateRegistry(File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "updateRegistry");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        List listprofilesRet = prm.purgeInvalidEntries();
        prm.ensureThereIsOnlyASingleDefaultProfileInTheProfileRegistry();
        LOGGER.exiting(WSProfile.class.getName(), "updateRegistry");
        return listprofilesRet;
    }

    public static List updateAndBackupRegistry(File fileBackupFile) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "updateAndBackupRegistry");
        LOGGER.exiting(WSProfile.class.getName(), "updateAndBackupRegistry");
        return WSProfile.updateAndBackupRegistry(fileBackupFile, WSProfile.getRegistryFile());
    }

    public static List updateAndBackupRegistry(File fileBackupFile, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "updateAndBackupRegistry");
        List listRet = WSProfile.updateRegistry(fileRegistry);
        try {
            FileUtils.copyFile(fileRegistry, fileBackupFile);
        }
        catch (FileNotFoundException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "updateAndBackupRegistry", "List of invalid profiles: " + listRet);
        LOGGER.exiting(WSProfile.class.getName(), "updateAndBackupRegistry");
        return listRet;
    }

    public static List validateRegistry() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateRegistry");
        LOGGER.exiting(WSProfile.class.getName(), "validateRegistry");
        return WSProfile.validateRegistry(WSProfile.getRegistryFile());
    }

    public static List validateRegistry(File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateRegistry");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "validateRegistry");
        return prm.getInvalidProfiles();
    }

    public static String getProfileName(File fileProfilePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileName");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileName");
        return WSProfile.getProfileName(fileProfilePath, WSProfile.getRegistryFile());
    }

    public static String getProfileName(File fileProfilePath, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileName");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "getProfileName");
        return prm.getProfile(fileProfilePath).getName();
    }

    public static void setProfileName(String sProfileName, String nProfileName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setProfileName");
        WSProfile.setProfileName(sProfileName, nProfileName, WSProfile.getRegistryFile());
        LOGGER.exiting(WSProfile.class.getName(), "setProfileName");
    }

    public static void setProfileName(String sProfileName, String nProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setProfileName");
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        WSProfile.throwExceptionIfTheGivenProfileNameIsAlreadyRegistered(nProfileName, fileRegistry);
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        prm.deleteProfileFromRegistry(profileThis);
        profileThis.setName(nProfileName);
        prm.addProfileToRegistry(profileThis);
        LOGGER.exiting(WSProfile.class.getName(), "setProfileName");
    }

    public static File getProfileLocation(String sProfileName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileLocation");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileLocation");
        return WSProfile.getProfileLocation(sProfileName, WSProfile.getRegistryFile());
    }

    public static File getProfileLocation(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileLocation");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileLocation");
        return WSProfile.getProfile(sProfileName, fileRegistry).getPath();
    }

    public static void setProfileLocation(String sProfileName, File fileProfilePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setProfileLocation");
        WSProfile.setProfileLocation(sProfileName, fileProfilePath, WSProfile.getRegistryFile());
        LOGGER.exiting(WSProfile.class.getName(), "setProfileLocation");
    }

    public static void setProfileLocation(String sProfileName, File fileProfilePath, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setProfileLocation");
        WSProfile.validateDirectoryIsWritable(fileProfilePath);
        WSProfile.throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(fileProfilePath);
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        prm.deleteProfileFromRegistry(profileThis);
        profileThis.setPath(fileProfilePath);
        prm.addProfileToRegistry(profileThis);
        LOGGER.exiting(WSProfile.class.getName(), "setProfileLocation");
    }

    public static File getProfileTemplateLocation(String sProfileName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileTemplateLocation");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileTemplateLocation");
        return WSProfile.getProfileTemplateLocation(sProfileName, WSProfile.getRegistryFile());
    }

    public static File getProfileTemplateLocation(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileTemplateLocation");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileTemplateLocation");
        return WSProfile.getProfile(sProfileName, fileRegistry).getWSProfileTemplate().getProfileTemplatePath();
    }

    public static List getProfileList() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileList");
        LOGGER.exiting(WSProfile.class.getName(), "getProfileList");
        return WSProfile.getProfileList(WSProfile.getRegistryFile());
    }

    public static List getProfileList(File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfileList");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "getProfileList");
        return prm.listProfilesInRegistry();
    }

    public static void setDefaultProfile(String sProfileName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setDefaultProfile");
        WSProfile.setDefaultProfile(sProfileName, WSProfile.getRegistryFile());
        LOGGER.exiting(WSProfile.class.getName(), "setDefaultProfile");
    }

    public static void setDefaultProfile(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setDefaultProfile");
        Profile profileThis = WSProfile.getProfile(sProfileName, fileRegistry);
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        prm.markProfileDefault(profileThis);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setDefaultProfile", "Default profile has been reset to: " + sProfileName);
        LOGGER.exiting(WSProfile.class.getName(), "setDefaultProfile");
    }

    public static Profile getDefaultProfile() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getDefaultProfile");
        LOGGER.exiting(WSProfile.class.getName(), "getDefaultProfile");
        return WSProfile.getDefaultProfile(WSProfile.getRegistryFile());
    }

    public static Profile getDefaultProfile(File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getDefaultProfile");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "getDefaultProfile");
        return prm.getDefaultProfile();
    }

    public static Profile getProfile(String sName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfile");
        LOGGER.exiting(WSProfile.class.getName(), "getProfile");
        return WSProfile.getProfile(sName, WSProfile.getRegistryFile());
    }

    public static Profile getProfile(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfile");
        LOGGER.exiting(WSProfile.class.getName(), "getProfile");
        return WSProfile.getProfile(sProfileName, fileRegistry, false);
    }

    public static Profile getProfile(String sProfileName, File fileRegistry, boolean b_including_invalid) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getProfile");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        LOGGER.exiting(WSProfile.class.getName(), "getProfile");
        if (!b_including_invalid) {
            return prm.getProfile(sProfileName);
        }
        return prm.getProfile(sProfileName, true);
    }

    public static File getRegistryFile() throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getRegistryFile");
        String sWASHome = null;
        sWASHome = System.getProperty("WAS_HOME");
        if (sWASHome == null) {
            sWASHome = System.getProperty("was.install.root");
        }
        LOGGER.exiting(WSProfile.class.getName(), "getRegistryFile");
        return WSProfile.getRegistryFile(sWASHome);
    }

    public static File getRegistryFile(String sWASHome) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getRegistryFile");
        WSProfileContext wspc = new WSProfileContext();
        try {
            wspc.saveCurrentContext();
            wspc.switchContext(sWASHome);
            File fileProfileRegistry = new File(new WSProfileProperties().getProperty("WS_PROFILE_REGISTRY"));
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getRegistryFile", "Return profile registry location as: " + fileProfileRegistry.getAbsolutePath());
            LOGGER.exiting(WSProfile.class.getName(), "getRegistryFile");
            File file = fileProfileRegistry;
            return file;
        }
        catch (FileNotFoundException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        finally {
            if (wspc != null) {
                wspc.restoreSavedContext();
            }
        }
    }

    public static List getAllAugmentationProfileTemplate(File profilePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        return WSProfile.getAllAugmentationProfileTemplates(WSProfile.getProfileName(profilePath));
    }

    public static List getAllAugmentationProfileTemplates(String sProfileName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        return WSProfile.getAllAugmentationProfileTemplates(WSProfile.getProfile(sProfileName));
    }

    public static List getAllAugmentationProfileTemplates(Profile profile) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllAugmentationProfileTemplates");
        return profile.getAugmentationTemplates();
    }

    public static List getAllProfileTemplates(File profilePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllProfileTemplates");
        return WSProfile.getAllProfileTemplates(WSProfile.getProfileName(profilePath));
    }

    public static List getAllProfileTemplates(String sProfileName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllProfileTemplates");
        LOGGER.exiting(WSProfile.class.getName(), "getAllProfileTemplates");
        return WSProfile.getAllProfileTemplates(WSProfile.getProfile(sProfileName));
    }

    public static List getAllProfileTemplates(Profile profile) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getAllProfileTemplates");
        Vector listWSProfileTemplates = (Vector)WSProfile.getAllAugmentationProfileTemplates(profile);
        listWSProfileTemplates.add(WSProfile.getCreateProfileTemplate(profile));
        LOGGER.exiting(WSProfile.class.getName(), "getAllProfileTemplates");
        return listWSProfileTemplates;
    }

    public static WSProfileTemplate getCreateProfileTemplate(File fileProfilePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getCreateProfileTemplate");
        LOGGER.exiting(WSProfile.class.getName(), "getCreateProfileTemplate");
        return WSProfile.getCreateProfileTemplate(WSProfile.getProfileName(fileProfilePath));
    }

    public static WSProfileTemplate getCreateProfileTemplate(String sProfileName) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getCreateProfileTemplate");
        LOGGER.exiting(WSProfile.class.getName(), "getCreateProfileTemplate");
        return WSProfile.getCreateProfileTemplate(WSProfile.getProfile(sProfileName));
    }

    public static WSProfileTemplate getCreateProfileTemplate(Profile profile) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "getCreateProfileTemplate");
        LOGGER.exiting(WSProfile.class.getName(), "getCreateProfileTemplate");
        return profile.getWSProfileTemplate();
    }

    private static void throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate(File fileProfilePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate");
        if (fileProfilePath.exists()) {
            if (!fileProfilePath.isDirectory()) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate", "Profile path " + fileProfilePath.toString() + " is an existing file");
                throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PATH_EXISTS_NOT_DIR_KEY, fileProfilePath.toString()), ResourceBundleUtils.getLocaleString(S_PATH_EXISTS_NOT_DIR_KEY, fileProfilePath.getPath()), true);
            }
            if (fileProfilePath.list().length != 0) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate", "Profile path " + fileProfilePath.toString() + " is a non-empty directory");
                throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_DIR_EXISTS_NOT_EMPTY_KEY, fileProfilePath.toString()), ResourceBundleUtils.getLocaleString(S_DIR_EXISTS_NOT_EMPTY_KEY, fileProfilePath.getPath().toString()), true);
            }
        }
        LOGGER.exiting(WSProfile.class.getName(), "throwExceptionIfTheGivenTargetProfilePathIsInvalidForCreate");
    }

    private static void validateDirectoryIsWritable(File filePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateDirectoryIsWritable");
        if (!FileUtils.isDirectoryWritable(filePath)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateDirectoryIsWritable", filePath.toString() + " is not writable");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PATH_NOT_WRITABLE_KEY, filePath.toString()), ResourceBundleUtils.getLocaleString(S_PATH_NOT_WRITABLE_KEY, filePath.getPath()), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "validateDirectoryIsWritable");
    }

    private static void validateAProfileTemplateExistsAtTheGivenPath(File filePath) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateProfileTemplateExists");
        if (!filePath.exists()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateAProfileTemplateExistsAtTheGivenPath", "Profile template " + filePath.toString() + " does not exist");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY, filePath.toString()), ResourceBundleUtils.getLocaleString(S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY, filePath.getPath()), true);
        }
        File fileActionRegistry = new File(filePath, "actionRegistry.xml");
        if (!fileActionRegistry.exists()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateAProfileTemplateExistsAtTheGivenPath", "Profile template " + filePath.toString() + " is not a valid profile template");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY, filePath.toString()), ResourceBundleUtils.getLocaleString(S_NO_PROFILE_TEMPLATE_EXISTS_AT_GIVEN_PATH_KEY, filePath.getPath().toString()), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "validateProfileTemplateExists");
    }

    private static void throwExceptionIfTheGivenProfileIsAlreadyRegistered(String sProfileName, File fileProfilePath, File fileTemplatePath, File fileRegistry) throws WSProfileException {
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        WSProfileTemplate wsptThis = new WSProfileTemplate(fileTemplatePath);
        Profile profileThis = new Profile(sProfileName, fileProfilePath, wsptThis, false);
        prm.throwExceptionIfTheGivenProfileIsAlreadyRegistered(profileThis);
    }

    private static void throwExceptionIfTheGivenProfileNameIsAlreadyRegistered(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "throwExceptionIfTheGivenProfileNameIsAlreadyRegistered");
        List profileNames = WSProfile.listProfileNames(fileRegistry);
        for (int i = 0; i < profileNames.size(); ++i) {
            if (!profileNames.get(i).equals(sProfileName)) continue;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "throwExceptionIfTheGivenProfileNameIsAlreadyRegistered", "Profile name " + sProfileName + " already exists in the profile registry");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_PROFILE_NAME_EXISTS_KEY, sProfileName), ResourceBundleUtils.getLocaleString(S_PROFILE_NAME_EXISTS_KEY, sProfileName), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "throwExceptionIfTheGivenProfileNameIsAlreadyRegistered");
    }

    private static void setReservationTicketToRegistry(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "setReservationTicket");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        if (!prm.markProfileReservationTicket(sProfileName)) {
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_RESERVATION_TICKET_NOT_AVAILABLE_KEY, sProfileName), ResourceBundleUtils.getLocaleString(S_RESERVATION_TICKET_NOT_AVAILABLE_KEY, sProfileName), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "setReservationTicket");
    }

    private static void unsetReservationTicketFromRegistry(String sProfileName, File fileRegistry) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "unsetReservationTicket");
        ProfileRegistryMarshaller prm = new ProfileRegistryMarshaller(fileRegistry.getAbsolutePath());
        prm.unmarkProfileReservationTicket(sProfileName);
        LOGGER.exiting(WSProfile.class.getName(), "unsetReservationTicket");
    }

    private static void validateProfileCreationTemplate(WSProfileTemplate wsptTemplate) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateProfileCreationTemplate");
        if (!wsptTemplate.isCreateTemplate()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateProfileCreationTemplate", "The profile tmeplate " + wsptTemplate.getProfileTemplatePath() + " cannot be used to create a template.");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY, wsptTemplate.getProfileTemplatePath().toString()), ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY, wsptTemplate.getProfileTemplatePath().toString()), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "validateProfileCreationTemplate");
    }

    private static void validateProfileAugmentationTemplate(Profile profileThis, WSProfileTemplate wsptTemplate) throws WSProfileException {
        LOGGER.entering(WSProfile.class.getName(), "validateProfileAugmentationTemplate");
        if (!wsptTemplate.isAugmentTemplate()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateProfileAugmentationTemplate", "The profile template " + wsptTemplate.getProfileTemplatePath() + " cannot be used to create a template.");
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY, wsptTemplate.getProfileTemplatePath().toString()), ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_OPERATION_KEY, wsptTemplate.getProfileTemplatePath().toString()), true);
        }
        Vector v_augmentors = (Vector)profileThis.getAugmentationTemplates();
        String sAugmentorPath = S_EMPTY;
        for (int i = 0; i < v_augmentors.size(); ++i) {
            sAugmentorPath = ((WSProfileTemplate)v_augmentors.elementAt(i)).getProfileTemplatePath().getPath();
            if (wsptTemplate.getProfileTemplatePath().equals(new File(sAugmentorPath))) {
                throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_CANNOT_REPEAT_TEMPLATE_OPERATION_KEY, wsptTemplate.getProfileTemplatePath().toString()), ResourceBundleUtils.getLocaleString(S_CANNOT_REPEAT_TEMPLATE_OPERATION_KEY, wsptTemplate.getProfileTemplatePath().toString()), true);
            }
            sAugmentorPath = S_EMPTY;
        }
        LOGGER.exiting(WSProfile.class.getName(), "validateProfileAugmentationTemplate");
    }

    private static WSProfileTemplate getWSProfileTemplate(File fileTemplatePath) throws WSProfileException {
        WSProfileTemplate wsptThis;
        LOGGER.entering(WSProfile.class.getName(), "getWSProfileTemplate");
        try {
            wsptThis = new WSProfileTemplate(fileTemplatePath);
        }
        catch (WSProfileException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getWSProfileTemplate", e.getMessage());
            throw new WSProfileException(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_KEY, fileTemplatePath.toString()), ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_TEMPLATE_KEY, fileTemplatePath.toString()), true);
        }
        LOGGER.exiting(WSProfile.class.getName(), "getWSProfileTemplate");
        return wsptThis;
    }

    private static Map replaceTemplatePathArg(Map optionalArgMap, String sNewTemplatePath) {
        Hashtable returnOptionalArgs = new Hashtable((Hashtable)optionalArgMap);
        Vector<String> v_sValues = new Vector<String>();
        if (returnOptionalArgs.containsKey("templatePath")) {
            v_sValues.add(sNewTemplatePath);
            returnOptionalArgs.put("templatePath", v_sValues);
        }
        return returnOptionalArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWasprofilePropertiesAvailable(String sWAS_Home) {
        LOGGER.entering(WSProfile.class.getName(), "isValidWASHome");
        boolean f_passed = true;
        WSProfileContext wspc = new WSProfileContext();
        try {
            wspc.saveCurrentContext();
            wspc.switchContext(sWAS_Home);
            new WSProfileProperties();
        }
        catch (FileNotFoundException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isWasprofilePropertiesAvailable", "wasprofile.properties unavailable for WAS_HOME [" + sWAS_Home + "]");
            LogUtils.logException(LOGGER, e);
            f_passed = false;
        }
        catch (IOException e) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "isWasprofilePropertiesAvailable", "wasprofile.properties unavailable for WAS_HOME [" + sWAS_Home + "]");
            LogUtils.logException(LOGGER, e);
            f_passed = false;
        }
        finally {
            if (wspc != null) {
                wspc.restoreSavedContext();
            }
        }
        LOGGER.exiting(WSProfile.class.getName(), "isValidWASHome");
        return f_passed;
    }

    public static List getAllValidAugmentors(String sProfileName, List listAugmentTemplates, boolean fDoRepeatableCheck) {
        LOGGER.entering(WSProfile.class.getName(), "getAllValidAugmentors");
        Vector<File> listValidAugmentors = new Vector<File>();
        try {
            Profile thisProfile = WSProfile.getProfile(sProfileName);
            Vector v_wsptTemplateStack = (Vector)thisProfile.getAugmentationTemplates();
            v_wsptTemplateStack.add(0, thisProfile.getWSProfileTemplate());
            List<WSProfileTemplate> l_wsptAugmentTemplates = WSProfileUtils.convertFileListToWSProfileTemplateList(listAugmentTemplates);
            for (int i = 0; i < l_wsptAugmentTemplates.size(); ++i) {
                WSProfileTemplate wsptThisAugmentTemplate = l_wsptAugmentTemplates.get(i);
                if (!WSProfile.isValidAugmentor(wsptThisAugmentTemplate, v_wsptTemplateStack, fDoRepeatableCheck)) continue;
                listValidAugmentors.add(wsptThisAugmentTemplate.getProfileTemplatePath());
            }
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getAllValidAugmentors", "Could not retrieve all of the valid augmentors for profile " + sProfileName + ". Returning empty list.");
            LOGGER.exiting(WSProfile.class.getName(), "getAllValidAugmentors");
            return new Vector();
        }
        LOGGER.exiting(WSProfile.class.getName(), "getAllValidAugmentors");
        return listValidAugmentors;
    }

    public static List getAllValidAugmentors(String sProfileName, List listAugmentTemplates) {
        LOGGER.entering(WSProfile.class.getName(), "getAllValidAugmentors");
        LOGGER.exiting(WSProfile.class.getName(), "getAllValidAugmentors");
        return WSProfile.getAllValidAugmentors(sProfileName, listAugmentTemplates, true);
    }

    public static boolean isValidAugmentor(WSProfileTemplate wsptAugmentTemplatePath, Vector<WSProfileTemplate> vwsptTemplateStack, boolean fDoRepeatableCheck) {
        LOGGER.entering(WSProfile.class.getName(), "isValidAugmentor");
        boolean fIsValid = true;
        try {
            boolean bl = fIsValid = fIsValid && PrereqTemplateUtils.isValidToAugment(wsptAugmentTemplatePath, vwsptTemplateStack.firstElement());
            if (fDoRepeatableCheck) {
                fIsValid = fIsValid && (!vwsptTemplateStack.contains(wsptAugmentTemplatePath) || wsptAugmentTemplatePath.isRepeatable());
            }
        }
        catch (WSProfileException wspe) {
            fIsValid = false;
        }
        LOGGER.exiting(WSProfile.class.getName(), "isValidAugmentor");
        return fIsValid;
    }

    public static boolean isValidAugmentor(String sProfileName, File fileTemplatePath, boolean fDoRepeatableCheck) {
        boolean fIsValid;
        LOGGER.entering(WSProfile.class.getName(), "isValidAugmentor");
        try {
            WSProfileTemplate wsptAugmentor;
            Vector vStackAugmentTemplates = (Vector)PrereqTemplateUtils.getTemplatesForStackAugmentation(fileTemplatePath, WSProfile.getProfile(sProfileName));
            fIsValid = fDoRepeatableCheck ? vStackAugmentTemplates.contains(wsptAugmentor = new WSProfileTemplate(fileTemplatePath)) : true;
        }
        catch (WSProfileException wspEx) {
            fIsValid = false;
        }
        LOGGER.exiting(WSProfile.class.getName(), "isValidAugmentor");
        return fIsValid;
    }

    public static List<WSProfileTemplate> getAllValidWSProfileTemplateAugmentors(String sProfileName, List<WSProfileTemplate> listAugmentTemplates, boolean fDoRepeatableCheck) {
        LOGGER.entering(WSProfile.class.getName(), "getAllValidWSProfileTemplateAugmentors");
        Vector<WSProfileTemplate> listValidAugmentors = new Vector<WSProfileTemplate>();
        try {
            Profile thisProfile = WSProfile.getProfile(sProfileName);
            Vector v_wsptTemplateStack = (Vector)thisProfile.getAugmentationTemplates();
            v_wsptTemplateStack.add(0, thisProfile.getWSProfileTemplate());
            for (int i = 0; i < listAugmentTemplates.size(); ++i) {
                WSProfileTemplate wsptThisAugmentTemplate = listAugmentTemplates.get(i);
                if (!WSProfile.isValidWSProfileTemplateAugmentor(wsptThisAugmentTemplate, v_wsptTemplateStack, fDoRepeatableCheck)) continue;
                listValidAugmentors.add(wsptThisAugmentTemplate);
            }
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getAllValidWSProfileTemplateAugmentors", "Could not retrieve all of the valid augmentors for profile " + sProfileName + ". Returning empty list.");
            LOGGER.exiting(WSProfile.class.getName(), "getAllValidWSProfileTemplateAugmentors");
            return new Vector<WSProfileTemplate>();
        }
        LOGGER.exiting(WSProfile.class.getName(), "getAllValidWSProfileTemplateAugmentors");
        return listValidAugmentors;
    }

    public static List<WSProfileTemplate> getAllValidWSProfileTemplateAugmentors(String sProfileName, List<WSProfileTemplate> listAugmentTemplates) {
        LOGGER.entering(WSProfile.class.getName(), "getAllValidWSProfileTemplateAugmentors");
        LOGGER.exiting(WSProfile.class.getName(), "getAllValidWSProfileTemplateAugmentors");
        return WSProfile.getAllValidWSProfileTemplateAugmentors(sProfileName, listAugmentTemplates, true);
    }

    public static boolean isValidWSProfileTemplateAugmentor(WSProfileTemplate wsptAugmentTemplatePath, Vector<WSProfileTemplate> vwsptTemplateStack, boolean fDoRepeatableCheck) {
        LOGGER.entering(WSProfile.class.getName(), "isValidWSProfileTemplateAugmentor");
        boolean fIsValid = true;
        try {
            boolean bl = fIsValid = fIsValid && PrereqTemplateUtils.isValidToAugment(wsptAugmentTemplatePath, vwsptTemplateStack.firstElement());
            if (fDoRepeatableCheck) {
                fIsValid = fIsValid && (!vwsptTemplateStack.contains(wsptAugmentTemplatePath) || wsptAugmentTemplatePath.isRepeatable());
            }
        }
        catch (WSProfileException wspe) {
            fIsValid = false;
        }
        LOGGER.exiting(WSProfile.class.getName(), "isValidWSProfileTemplateAugmentor");
        return fIsValid;
    }

    public static boolean isValidWSProfileTemplateAugmentor(String sProfileName, WSProfileTemplate wsptAugmentingTemplate, boolean fDoRepeatableCheck) {
        boolean fIsValid;
        LOGGER.entering(WSProfile.class.getName(), "isValidWSProfileTemplateAugmentor");
        try {
            Vector vStackAugmentTemplates = (Vector)PrereqTemplateUtils.getTemplatesForStackAugmentation(wsptAugmentingTemplate, WSProfile.getProfile(sProfileName));
            fIsValid = fDoRepeatableCheck ? vStackAugmentTemplates.contains(wsptAugmentingTemplate) : true;
        }
        catch (WSProfileException wspEx) {
            fIsValid = false;
        }
        LOGGER.exiting(WSProfile.class.getName(), "isValidWSProfileTemplateAugmentor");
        return fIsValid;
    }

    public static boolean isAllMode(String sMode) {
        LOGGER.entering(WSProfile.class.getName(), "isValidAugmentor");
        for (int i = 0; i < WSProfileConstants.S_ALL_TYPE_MODES.length; ++i) {
            if (!WSProfileConstants.S_ALL_TYPE_MODES[i].equals(sMode)) continue;
            LOGGER.exiting(WSProfile.class.getName(), "isValidAugmentor");
            return true;
        }
        LOGGER.exiting(WSProfile.class.getName(), "isValidAugmentor");
        return false;
    }
}

