/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.portletcontainer;

import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import java.util.HashMap;
import java.util.Map;

public class PortletWindowIdentifierAdapter
implements PortletWindowIdentifier {
    private String contextRoot;
    private String portletName;
    private Map scopeToIdMap;
    private static final IdentifierNamespace[] NAMESPACES = new IdentifierNamespace[]{IdentifierNamespace.REQUEST, IdentifierNamespace.SESSION, IdentifierNamespace.MARKUP, IdentifierNamespace.URL, IdentifierNamespace.LOGGING};

    public PortletWindowIdentifierAdapter(String contextRoot, String portletName, ObjectID id) {
        this.contextRoot = contextRoot;
        this.portletName = portletName;
        this.scopeToIdMap = new HashMap();
        int i = 0;
        while (i < NAMESPACES.length) {
            this.scopeToIdMap.put(NAMESPACES[i++], id);
        }
    }

    public PortletWindowIdentifierAdapter(String contextRoot, String portletName, Map scopeToIdMap) {
        this.contextRoot = contextRoot;
        this.portletName = portletName;
        this.scopeToIdMap = scopeToIdMap;
        int i = 0;
        while (i < NAMESPACES.length) {
            if (scopeToIdMap.containsKey(NAMESPACES[i++])) continue;
            throw new IllegalArgumentException("Parameter scopeToIdMap does not contain all IdentifierNamespace scopes.");
        }
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public ObjectID getId(IdentifierNamespace scopeId) {
        return (ObjectID)this.scopeToIdMap.get(scopeId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PortletWindowIdentifier)) {
            return false;
        }
        PortletWindowIdentifier pii = (PortletWindowIdentifier)obj;
        boolean equal = true;
        for (int i = 0; i < NAMESPACES.length && equal; ++i) {
            equal = this.getId(NAMESPACES[i]).equals(pii.getId(NAMESPACES[i]));
        }
        return equal && this.portletName.equals(pii.getPortletName()) && this.contextRoot.equals(pii.getContextRoot());
    }

    public String toString() {
        return "PortletWindowIdentifier[" + this.getId(IdentifierNamespace.LOGGING) + ", " + this.contextRoot + ", " + this.portletName + "]";
    }
}

