/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.collaborator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.cmdframework.CommandMgrInitException;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public class AgentProxyCollaborator
extends RuntimeCollaborator
implements NotificationListener,
RoutingListener,
InvocationHandler {
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS(resBundleName);
    private static TraceComponent tc = Tr.register(AgentProxyCollaborator.class, "Admin", resBundleName);
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private static Method getProxyMethod;
    private Class intf;
    private ObjectName savedTargetON;
    private Proxy proxy = null;
    private AdminClient savedAdminClient;
    private static int INITIALIZE;
    private static int WORKING;
    private static int CLOSED;
    private int state = INITIALIZE;
    private ModelMBeanInfo mbeanInfo;

    public AgentProxyCollaborator(Class intf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AgentProxyCollaborator constructor :" + intf.getName());
        }
        this.intf = intf;
        RoutingTable.getInstance().addRoutingListener(this);
        this.proxy = (Proxy)Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AgentProxyCollaborator constructor:" + intf.getName());
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void bindMBean(ModelMBeanInfo info, ModelMBean bean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMBean for " + this.intf.getName(), new Object[]{info, bean});
        }
        this.mbeanInfo = info;
        this.modelMBean = bean;
        this.modelMBean.setManagedResource(this.proxy, "ObjectReference");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindMBean for" + this.intf.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String msg;
        Class<?> declaringClass = method.getDeclaringClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke: interface: " + this.intf.getName() + " method: " + method.getName() + " declaring class:" + declaringClass.getName());
        }
        if (declaringClass == Object.class) {
            if (method.equals(hashCodeMethod)) {
                return this.proxyHashCode(proxy);
            }
            if (method.equals(equalsMethod)) {
                return this.proxyEquals(proxy, args[0]);
            }
            if (method.equals(toStringMethod)) {
                return this.proxyToString(proxy);
            }
            msg = nls.getFormattedMessage("ADMN1212E", new Object[]{method.getName(), this.intf.getName()}, "ADMN1212E: Internal Error: MBean proxy unable process method {0} for interface {1}");
            AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg, null, true);
        }
        if (declaringClass == this.getClass()) {
            if (method.equals(getProxyMethod)) {
                return proxy;
            }
            msg = nls.getFormattedMessage("ADMN1212E", new Object[]{method.getName(), this.intf.getName()}, "ADMN1212E: Internal Error: MBean proxy unable process method {0} for interface {1}");
            AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg, null, true);
        }
        if (declaringClass == this.intf) {
            String msg2;
            int curState;
            ObjectName sourceON = this.getObjectName();
            if (sourceON == null || this.mbeanInfo == null) {
                String msg3 = nls.getFormattedMessage("ADMN1213E", new Object[]{this.intf.getName()}, "ADMN1213E: Internal Error: MBean proxy for interface {1} has not been activated");
                AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg3, null, true);
            }
            AdminClient adminClient = null;
            ObjectName destON = null;
            Exception initException = null;
            AgentProxyCollaborator agentProxyCollaborator = this;
            synchronized (agentProxyCollaborator) {
                try {
                    this.initialize();
                }
                catch (Exception ex) {
                    initException = ex;
                }
                curState = this.state;
                adminClient = this.savedAdminClient;
                destON = this.savedTargetON;
            }
            if (initException != null || curState != WORKING) {
                msg2 = nls.getFormattedMessage("ADMN1211E", new Object[]{method.getName(), this.intf.getName()}, "ADMN1211E: Unable to open connector to admin agent while processing method {0} for interface {1}");
                AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg2, initException, true);
            }
            if (adminClient == null) {
                msg2 = nls.getFormattedMessage("ADMN1211E", new Object[]{method.getName(), this.intf.getName()}, "ADMN1211E: Unable to open connector to admin agent while processing method {0} for interface {1}");
                AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg2, null, true);
            }
            if (destON == null) {
                msg2 = nls.getFormattedMessage("ADMN1214E", new Object[]{sourceON}, "ADMN1214E: Internal Error: MBean proxy {1} unable to locate corresponding MBean on admin agent");
                AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg2, null, true);
            }
            String methodName = method.getName();
            Class<?>[] signatureClasses = method.getParameterTypes();
            String[] signatures = new String[signatureClasses.length];
            for (int i = 0; i < signatureClasses.length; ++i) {
                signatures[i] = signatureClasses[i].getName();
            }
            if (tc.isDebugEnabled()) {
                String info = "AgentProxyCollaborator for interface " + this.intf.getName() + "." + methodName + "(";
                for (int i = 0; i < signatures.length; ++i) {
                    if (i > 0) {
                        info = info + ", ";
                    }
                    info = info + signatures[i];
                }
                info = info + ")";
                Tr.debug(tc, info);
            }
            try {
                return adminClient.invoke(destON, methodName, args, signatures);
            }
            catch (Exception ex) {
                String msg4 = nls.getFormattedMessage("ADMN1215E", new Object[]{sourceON, method.getName()}, "ADMN1215E: MBean proxy {1} caught exception while calling method {2} on the corresponding MBean on the admin agent.");
                AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg4, ex, false);
            }
        }
        msg = nls.getFormattedMessage("ADMN1212E", new Object[]{method.getName(), this.intf.getName()}, "ADMN1212E: Internal Error: MBean proxy unable process method {0} for interface {1}");
        AgentProxyCollaborator.mapAndThrowException(this.intf, method, msg, null, true);
        return null;
    }

    private void initialize() throws ConnectorException, AdminException, InstanceNotFoundException, MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AgentProxyCollaborator.initialize");
        }
        if (this.state == CLOSED || this.state == WORKING) {
            return;
        }
        this.savedAdminClient = RoutingTable.getInstance().getParent();
        if (this.savedAdminClient == null) {
            return;
        }
        ObjectName on = this.getObjectName();
        if (on != null) {
            Set result;
            ObjectName serverON = this.savedAdminClient.getServerMBean();
            String process = serverON.getKeyProperty("process");
            String type = on.getKeyProperty("type");
            String name = on.getKeyProperty("name");
            ObjectName query = new ObjectName("*:type=" + type + ",name=" + name + ",process=" + process + ",*");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "query for target MBean with query: " + query);
            }
            if ((result = this.savedAdminClient.queryNames(query, null)).size() == 1) {
                this.savedTargetON = (ObjectName)result.iterator().next();
            } else {
                throw new AdminException("AgentProxyCollaborator found too many MBeans for query " + query + ",  query result " + result);
            }
        }
        if (this.savedAdminClient != null && this.savedTargetON != null) {
            try {
                this.savedAdminClient.removeNotificationListener(this.savedTargetON, this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.savedAdminClient.addNotificationListener(this.savedTargetON, this, null, null);
            this.state = WORKING;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AgentProxyCollaborator.initialize exit", this.savedTargetON);
        }
    }

    public void childAdded(ServerInfo serverInfo) {
    }

    public void childRemoved(ServerInfo serverInfo) {
    }

    public synchronized void parentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentAdded");
        }
        Tr.exit(tc, "AgentProxyCollaborator.initialize exit", this.savedTargetON);
        try {
            if (this.state == WORKING && this.savedAdminClient != null && this.savedTargetON != null) {
                this.savedAdminClient.removeNotificationListener(this.savedTargetON, this);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.collaborator.AgentProxyCollaborator.parentRemoved", (String)"247");
        }
        this.savedAdminClient = null;
        this.state = INITIALIZE;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentAdded");
        }
    }

    public synchronized void parentRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentRemoved");
        }
        try {
            if (this.state == WORKING && this.savedAdminClient != null && this.savedTargetON != null) {
                this.savedAdminClient.removeNotificationListener(this.savedTargetON, this);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.collaborator.AgentProxyCollaborator.parentRemoved", (String)"262");
        }
        this.state = CLOSED;
        this.savedAdminClient = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentRemoved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleNotification(Notification notification, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification for interface: " + this.intf.getName(), notification);
        }
        try {
            try {
                this.sendNotification(notification);
            }
            catch (MBeanException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.collaborator.AgentProxyCollaborator.handleNotification", (String)"295", (Object)this);
                Object var5_4 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "handleNotification for interface: " + this.intf.getName());
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "handleNotification for interface: " + this.intf.getName());
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "handleNotification for interface: " + this.intf.getName());
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    static void mapAndThrowException(Class intf, Method method, String msg, Throwable ex, boolean createWrapper) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapAndThrowException " + intf.getName() + " method: " + method.getName() + " message: " + msg + " Throwable: " + ex);
        }
        Class<?>[] exClasses = method.getExceptionTypes();
        boolean throwsConnectorException = false;
        boolean throwsConfigServiceException = false;
        boolean throwsAdminException = false;
        boolean throwsCommandMgrInitException = false;
        for (int i = 0; i < exClasses.length; ++i) {
            Class<WsException> exClass = exClasses[i];
            if (!createWrapper && ex != null && exClass.isInstance(ex)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapAndThrowException throwing:" + ex);
                }
                throw ex;
            }
            if (exClass.isAssignableFrom(ConnectorException.class)) {
                throwsConnectorException = true;
                continue;
            }
            if (exClass.isAssignableFrom(ConfigServiceException.class)) {
                throwsConfigServiceException = true;
                continue;
            }
            if (exClass.isAssignableFrom(AdminException.class)) {
                throwsAdminException = true;
                continue;
            }
            if (!CommandMgrInitException.class.isInstance(ex)) continue;
            throwsCommandMgrInitException = true;
        }
        Exception newex = ex == null ? (throwsConfigServiceException ? new ConfigServiceException(msg) : (throwsAdminException ? new AdminException(msg) : (throwsConnectorException ? new ConnectorException(msg) : (throwsCommandMgrInitException ? new CommandMgrInitException(msg) : new RuntimeException(msg))))) : (throwsConfigServiceException ? new ConfigServiceException(ex, msg) : (throwsAdminException ? new AdminException(ex, msg) : (throwsConnectorException ? new ConnectorException(msg, ex) : (throwsCommandMgrInitException ? new CommandMgrInitException(ex, msg) : new RuntimeException(msg, ex)))));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapAndThrowException throwing:" + newex);
        }
        throw newex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleServantNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleServantNotification for interface: " + this.intf.getName(), notification);
        }
        try {
            try {
                this.sendNotification(notification);
            }
            catch (MBeanException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.collaborator.AgentProxyCollaborator.handleNotification", (String)"513", (Object)this);
                Object var4_3 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "handleServantNotification for interface: " + this.intf.getName());
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "handleServantNotification for interface: " + this.intf.getName());
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "handleServantNotification for interface: " + this.intf.getName());
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", null);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", null);
            getProxyMethod = AgentProxyCollaborator.class.getMethod("getProxy", null);
        }
        catch (NoSuchMethodException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.collaborator.AgentProxyCollaborator", (String)"30");
            throw new NoSuchMethodError(e.getMessage());
        }
        INITIALIZE = 0;
        WORKING = 1;
        CLOSED = 2;
    }
}

