/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.providers.transformer;

import com.ibm.wsdl.extensions.transformer.TransformerOperation;
import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsif.WSIFCorrelationId;
import com.ibm.wsif.WSIFException;
import com.ibm.wsif.WSIFMessage;
import com.ibm.wsif.WSIFOperation;
import com.ibm.wsif.WSIFResponseHandler;
import com.ibm.wsif.jca.log.JCAResource;
import com.ibm.wsif.logging.Trc;
import com.ibm.wsif.providers.transformer.TransformerMessage;
import java.io.StringWriter;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Element;

public class WSIFOperation_Transformer
implements WSIFOperation {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2002, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final long serialVersionUID = 5L;
    private Binding fieldBinding;
    private BindingOperation fieldBindingOperation;
    private Operation fieldOperation;
    private Definition fieldDefinition;
    private TransformerOperation transformerOperation;

    public WSIFOperation_Transformer(Definition definition, Binding binding, BindingOperation bindingOperation, Operation operation) {
        this.fieldDefinition = definition;
        this.fieldBinding = binding;
        this.fieldOperation = operation;
        this.fieldBindingOperation = bindingOperation;
    }

    public WSIFMessage createFaultMessage() {
        Message message = null;
        if (this.fieldOperation.getFaults() != null && !this.fieldOperation.getFaults().values().isEmpty()) {
            message = ((Fault)this.fieldOperation.getFaults().values().iterator().next()).getMessage();
        }
        return new TransformerMessage(this.fieldDefinition, this.fieldBinding, message);
    }

    public WSIFMessage createFaultMessage(String string) {
        Message message = null;
        Fault fault = this.fieldOperation.getFault(string);
        if (fault != null) {
            message = fault.getMessage();
        }
        TransformerMessage transformerMessage = new TransformerMessage(this.fieldDefinition, this.fieldBinding, message);
        transformerMessage.setName(string);
        return transformerMessage;
    }

    public WSIFMessage createInputMessage() {
        Message message = null;
        Input input = this.fieldOperation.getInput();
        if (input != null) {
            message = input.getMessage();
        }
        return new TransformerMessage(this.fieldDefinition, this.fieldBinding, message);
    }

    public WSIFMessage createInputMessage(String string) {
        Message message = null;
        Input input = this.fieldOperation.getInput();
        if (input != null) {
            message = input.getMessage();
        }
        TransformerMessage transformerMessage = new TransformerMessage(this.fieldDefinition, this.fieldBinding, message);
        transformerMessage.setName(string);
        return transformerMessage;
    }

    public WSIFMessage createOutputMessage() {
        Message message = null;
        Output output = this.fieldOperation.getOutput();
        if (output != null) {
            message = output.getMessage();
        }
        return new TransformerMessage(this.fieldDefinition, this.fieldBinding, message);
    }

    public WSIFMessage createOutputMessage(String string) {
        Message message = null;
        Output output = this.fieldOperation.getOutput();
        if (output != null) {
            message = output.getMessage();
        }
        TransformerMessage transformerMessage = new TransformerMessage(this.fieldDefinition, this.fieldBinding, message);
        transformerMessage.setName(string);
        return transformerMessage;
    }

    public void executeInputOnlyOperation(WSIFMessage wSIFMessage) throws WSIFException {
        throw new WSIFException(JCAResource.get("IWAA0112E"));
    }

    public boolean executeRequestResponseOperation(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Trc.entry((Object)this, (Object)wSIFMessage, (Object)wSIFMessage2, (Object)wSIFMessage3);
        try {
            SAXSource sAXSource = ((TransformerMessage)wSIFMessage).getSAXSource();
            SAXResult sAXResult = new SAXResult(((TransformerMessage)wSIFMessage2).getContentHandler());
            this.getTransformer().transform(sAXSource, sAXResult);
            Trc.exit();
            return true;
        }
        catch (Throwable throwable) {
            Trc.exception((Throwable)throwable);
            throw new WSIFException(JCAResource.get("IWAA0116E", throwable.getLocalizedMessage()));
        }
    }

    private Transformer getTransformer() throws WSIFException {
        Trc.entry((Object)this);
        TransformerOperation transformerOperation = this.getTransformerOperation();
        if (transformerOperation != null) {
            Element element = transformerOperation.getMappingElement();
            Trc.event((Object)this, (Object)("Element: ['" + element.hashCode() + "']\n"));
            try {
                DOMSource dOMSource = new DOMSource(element);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = null;
                Element element2 = element;
                synchronized (element2) {
                    transformer = transformerFactory.newTransformer(dOMSource);
                }
                Trc.exit((Object)transformer);
                return transformer;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                StringWriter stringWriter = new StringWriter();
                DOM2Writer.serializeAsXML(element, stringWriter);
                Trc.event((Object)this, (Object)("Element: [<" + element.hashCode() + "> + " + stringWriter.toString() + " ]\n"));
                Trc.exception((Throwable)transformerConfigurationException);
                throw new WSIFException(JCAResource.get("IWAA0115E", transformerConfigurationException.getLocalizedMessage()));
            }
        }
        throw new WSIFException(JCAResource.get("IWAA0113E"));
    }

    private TransformerOperation getTransformerOperation() {
        if (this.transformerOperation == null && this.fieldBindingOperation != null && this.fieldBindingOperation.getExtensibilityElements() != null) {
            Iterator iterator = this.fieldBindingOperation.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                if (!(extensibilityElement instanceof TransformerOperation)) continue;
                this.transformerOperation = (TransformerOperation)extensibilityElement;
                break;
            }
        }
        return this.transformerOperation;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage, WSIFResponseHandler wSIFResponseHandler) throws WSIFException {
        return null;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage) throws WSIFException {
        return null;
    }

    public void fireAsyncResponse(Object object) throws WSIFException {
    }

    public void processAsyncResponse(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
    }

    public void setContext(WSIFMessage wSIFMessage) {
    }

    public WSIFMessage getContext() {
        return null;
    }
}

