/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasMessageImpl2;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.ras.RasMessage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.management.ServantNotificationHandler;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class RasLoggingServiceMBeanProxy
extends RuntimeCollaborator
implements WsHandler,
ServantNotificationHandler {
    public static final String NOTIFICATION_LOG_FATAL = "websphere.ras.fatal";
    public static final String NOTIFICATION_LOG_ERROR = "websphere.ras.error";
    public static final String NOTIFICATION_LOG_WARNING = "websphere.ras.warning";
    public static final String NOTIFICATION_LOG_AUDIT = "websphere.ras.audit";
    public static final String NOTIFICATION_LOG_SERVICE = "websphere.ras.service";
    public static final String NOTIFICATION_LOG_INFO = "websphere.ras.info";
    private static TraceComponent tc = Tr.register(RasLoggingServiceMBeanProxy.class, "RasLoggingService", null);
    private long ntfySeqNum = 0L;

    public void setObjectName(ObjectName name) {
        super.setObjectName(name);
        this.registerWithRas();
    }

    public String getMessageFilterLevel() {
        return ManagerAdmin.getMessageFilterLevel();
    }

    public void setMessageFilterLevel(String newLevel) {
        ManagerAdmin.setMessageFilterLevel(newLevel);
    }

    public Level getLevel() {
        return WsLevel.DETAIL;
    }

    public Boolean containsRASHeader(String filename) {
        Boolean returnVal = ManagerAdmin.containsRASHeader(filename);
        return returnVal;
    }

    public void processEvent(LogRecord event2) {
        int level = event2.getLevel().intValue();
        if (level < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        if (level >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[15]]) {
            this.sendEvent(NOTIFICATION_LOG_FATAL, event2);
        } else if (level >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]]) {
            this.sendEvent(NOTIFICATION_LOG_ERROR, event2);
        } else if (level >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]]) {
            this.sendEvent(NOTIFICATION_LOG_WARNING, event2);
        } else if (level >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[11]]) {
            this.sendEvent(NOTIFICATION_LOG_AUDIT, event2);
        } else {
            this.sendEvent(NOTIFICATION_LOG_INFO, event2);
        }
    }

    private void registerWithRas() {
        try {
            ManagerAdmin.addJmxListener(this);
        }
        catch (RasException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.RasLoggingServiceMBean.RasLoggingServiceMBean", (String)"48", (Object)this);
        }
    }

    private void sendEvent(String type, LogRecord event2) {
        try {
            RasMessageImpl2 rmi2 = RasLoggingServiceMBeanProxy.parseLogRec(event2);
            Notification notification = new Notification(type, this.getObjectName(), this.ntfySeqNum++);
            notification.setUserData(rmi2);
            this.sendNotification(notification);
        }
        catch (MBeanException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RasLoggingServiceMBeanProxy.sendEvent", (String)"168", (Object)this);
        }
    }

    private static RasMessageImpl2 parseLogRec(LogRecord event2) {
        CommonBaseEvent cbe;
        String threadId = Integer.toHexString(event2.getThreadID());
        String messageSeverity = RasMessageImpl2.convertSeverity(event2.getLevel().intValue());
        Locale currentLocale = Locale.getDefault();
        String localizedMsg = TraceLogFormatter.formatMessage(event2, currentLocale, 0);
        String diagnosticProviderId = null;
        if (event2 instanceof CommonBaseEventLogRecord && (cbe = ((CommonBaseEventLogRecord)event2).getCommonBaseEvent()) != null) {
            diagnosticProviderId = CBEHelper.getExtendedDataElementString(cbe, "DiagnosticProvider");
        }
        return new RasMessageImpl2(event2.getMillis(), threadId, messageSeverity, event2.getMessage(), event2.getParameters(), event2.getResourceBundleName(), event2.getLoggerName(), localizedMsg, currentLocale.toString(), diagnosticProviderId);
    }

    public void handleServantNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleServantNotification", notification);
        }
        long ctlSeqNum = this.ntfySeqNum++;
        if (tc.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Servant Ras notification; source = " + notification.getSource());
            buf.append(", type = " + notification.getType());
            buf.append(", servant sequence number = " + notification.getSequenceNumber());
            buf.append(", control sequence number = " + ctlSeqNum);
            Object userData = notification.getUserData();
            if (userData instanceof RasMessage) {
                RasMessage event2 = (RasMessage)userData;
                buf.append(", user data msg = " + event2.getLocalizedMessage(null));
                buf.append(", user data severity = " + event2.getMessageSeverity());
            }
            Tr.debug(tc, buf.toString());
        }
        try {
            Notification notif = new Notification(notification.getType(), (Object)this, ctlSeqNum, notification.getMessage());
            notif.setUserData(notification.getUserData());
            this.sendNotification(notif);
        }
        catch (MBeanException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.RasLoggingServiceMBean.handleServantNotification", (String)"195", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleServantNotification");
        }
    }
}

