/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.toad.cfparse.ClassFile;
import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.MethodInfo;
import com.ibm.toad.cfparse.MethodInfoList;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.attributes.ExceptionAttrInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.descriptor.MBeanDescriptorManager;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class DynamicProxyInterfaceGenerator {
    private static final TraceComponent tc = Tr.register(DynamicProxyInterfaceGenerator.class, "MBeanFactory", "com.ibm.ws.management.resources.adminservice");
    protected DynamicProxyClassLoader dpCL = null;
    protected String packageName = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java DynamicProxyInterfaceGenerator <mbean_descriptor_name>");
            return;
        }
        try {
            MBeanDescriptorManager mbdm = MBeanDescriptorManager.getInstance();
            ModelMBeanInfo mbeanInfo = mbdm.getDescriptor(args[0], null);
            System.out.println("YJY: created ModelMBeanInfo of MBean type ==> " + args[0] + " <==");
            System.out.println("====================================================================");
            System.out.println(DynamicProxyInterfaceGenerator.printModelMBeanInfo(mbeanInfo));
            System.out.println("--------------------------------------------------------------------");
            String packageName = "com.ibm.ws.management.descriptor.dynamicproxy";
            DynamicProxyInterfaceGenerator dpig = new DynamicProxyInterfaceGenerator(packageName);
            Class dynamicProxyClass = dpig.generate(mbeanInfo);
            if (dynamicProxyClass == null) {
                System.out.println("FAILED to create dynamic proxy class!");
            } else {
                System.out.println("====================================================================");
                System.out.println(DynamicProxyInterfaceGenerator.printClassInfo(dynamicProxyClass));
                System.out.println("--------------------------------------------------------------------");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws390.management.proxy.DynamicProxyInterfaceGenerator.main", (String)"144");
            e.printStackTrace();
        }
    }

    public DynamicProxyInterfaceGenerator(String package_name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", package_name);
        }
        this.packageName = package_name;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this.packageName);
        }
    }

    public Class generate(ModelMBeanInfo info) throws Exception {
        try {
            Descriptor mBeanDescriptor = info.getMBeanDescriptor();
            String mbeanType = (String)mBeanDescriptor.getFieldValue("type");
            if (mbeanType == null) {
                mbeanType = (String)mBeanDescriptor.getFieldValue("j2eeType");
            }
            if (mbeanType == null) {
                String mbeanName = (String)mBeanDescriptor.getFieldValue("name");
                String uuid = AdminHelper.getPlatformHelper().getUniqueId();
                mbeanType = mbeanName + uuid;
            }
            String className = this.packageName + "." + mbeanType;
            String since = (String)mBeanDescriptor.getFieldValue("since");
            if (since == null) {
                since = "5.0";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "generate: ", "classname ==|" + className + "|==");
            }
            if (this.dpCL == null) {
                this.dpCL = new DynamicProxyClassLoader(Thread.currentThread().getContextClassLoader());
            }
            Class proxyClass = null;
            try {
                proxyClass = this.dpCL.loadClass(className);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "generate: ", "class is FOUND in cache ==> " + proxyClass + " <== proceeding...");
                }
                return proxyClass;
            }
            catch (ClassNotFoundException cnfe) {
                MBeanAttributeInfo[] attrInfo;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "generate: ", "class is NOT found ==> " + cnfe.getMessage() + " <== proceeding...");
                }
                ClassFile cFile = new ClassFile();
                ConstantPool cPool = cFile.getCP();
                cFile.setName(className);
                cFile.setAccess(1537);
                MBeanOperationInfo[] opInfo = info.getOperations();
                MBeanParameterInfo[] params = null;
                StringBuffer mSignature = null;
                String mSigStr = null;
                MethodInfo mInfo = null;
                MethodInfoList mInfoList = cFile.getMethods();
                AttrInfoList exceptAttrInfoList = new AttrInfoList(cPool, 1);
                ExceptionAttrInfo exceptAttrInfo = (ExceptionAttrInfo)exceptAttrInfoList.add("Exceptions");
                exceptAttrInfo.add("java.lang.Throwable");
                HashMap<String, MethodInfo> mHT = new HashMap<String, MethodInfo>(23);
                if (opInfo != null && opInfo.length > 0) {
                    for (int i = 0; i < opInfo.length; ++i) {
                        mSignature = new StringBuffer("public abstract ");
                        if (opInfo[i].getReturnType() == null || opInfo[i].getReturnType().equals("")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generate: ", "return type for " + mbeanType + "." + opInfo[i].getName() + " is NULL. Using \"void\" as its return type.");
                            }
                            mSignature.append("void");
                        } else {
                            mSignature.append(DynamicProxyInterfaceGenerator.fixArrayType(opInfo[i].getReturnType()));
                        }
                        mSignature.append(' ');
                        mSignature.append(opInfo[i].getName());
                        mSignature.append('(');
                        params = opInfo[i].getSignature();
                        for (int j = 0; j < params.length; ++j) {
                            mSignature.append(DynamicProxyInterfaceGenerator.fixArrayType(params[j].getType()));
                            mSignature.append(' ');
                            mSignature.append("arg_name");
                            if (j >= params.length - 1) continue;
                            mSignature.append(',');
                        }
                        mSignature.append(')');
                        mSigStr = mSignature.toString();
                        if (mHT.get(mSigStr) == null) {
                            mInfo = mInfoList.add(mSigStr);
                            mHT.put(mSigStr, mInfo);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "generate: ", "[" + i + "] DUPLICATE ==> " + mSignature + " <==");
                        }
                        mInfo.setAttrs(exceptAttrInfoList);
                    }
                }
                if ((attrInfo = info.getAttributes()) != null && attrInfo.length > 0) {
                    for (int i = 0; i < attrInfo.length; ++i) {
                        String attrName = attrInfo[i].getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "generate: ", "attrInfo[" + i + "] name ==> " + attrName + " <==");
                        }
                        mSignature = new StringBuffer("public abstract ");
                        if (attrInfo[i].isReadable()) {
                            mSignature.append(DynamicProxyInterfaceGenerator.fixArrayType(attrInfo[i].getType()));
                            mSignature.append(' ');
                            ModelMBeanAttributeInfo modelAttrInfo = info.getAttribute(attrName);
                            Descriptor attrDesc = modelAttrInfo.getDescriptor();
                            String getMethod = (String)attrDesc.getFieldValue("getMethod");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generate: ", "attrInfo[" + i + "] getMethod ==> " + getMethod + " <==");
                            }
                            mSignature.append(getMethod);
                            mSignature.append("()");
                            mSigStr = mSignature.toString();
                            if (mHT.get(mSigStr) == null) {
                                mInfo = mInfoList.add(mSigStr);
                                mHT.put(mSigStr, mInfo);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "generate: ", "attrInfo[" + i + "] NEW GETTER        ==> " + mSignature + " <==");
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generate: ", "attrInfo[" + i + "] GETTER DUPLICATE ==> " + mSignature + " <==");
                            }
                            mInfo.setAttrs(exceptAttrInfoList);
                        }
                        if (!attrInfo[i].isWritable()) continue;
                        StringBuffer prefixBuff1 = new StringBuffer("public abstract void ");
                        StringBuffer prefixBuff2 = new StringBuffer("public abstract java.lang.Void ");
                        StringBuffer prefixBuff3 = new StringBuffer("public abstract Void ");
                        mSignature = new StringBuffer();
                        ModelMBeanAttributeInfo modelAttrInfo = info.getAttribute(attrName);
                        Descriptor attrDesc = modelAttrInfo.getDescriptor();
                        String setMethod = (String)attrDesc.getFieldValue("setMethod");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "generate: ", "attrInfo[" + i + "] setMethod ==> " + setMethod + " <==");
                        }
                        mSignature.append(setMethod);
                        mSignature.append('(');
                        mSignature.append(DynamicProxyInterfaceGenerator.fixArrayType(attrInfo[i].getType()));
                        mSignature.append(' ');
                        mSignature.append("arg_name");
                        mSignature.append(')');
                        mSigStr = prefixBuff1.toString() + mSignature.toString();
                        String mSigStr2 = prefixBuff2.toString() + mSignature.toString();
                        String mSigStr3 = prefixBuff3.toString() + mSignature.toString();
                        Object tryPrefix1 = mHT.get(mSigStr);
                        Object tryPrefix2 = mHT.get(mSigStr2);
                        Object tryPrefix3 = mHT.get(mSigStr3);
                        if (tryPrefix1 == null && tryPrefix2 == null && tryPrefix3 == null) {
                            mInfo = mInfoList.add(mSigStr);
                            mHT.put(mSigStr, mInfo);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generate: ", "attrInfo[" + i + "] NEW SETTER        ==> " + mSignature + " <==");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "generate: ", "attrInfo[" + i + "] SETTER DUPLICATE ==> (" + tryPrefix1 + ") (" + tryPrefix2 + ") (" + tryPrefix3 + ")  <==");
                        }
                        Tr.debug(tc, "generate: ", "{" + i + "} " + mSignature + " <==");
                        mInfo.setAttrs(exceptAttrInfoList);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                DataOutputStream dos = new DataOutputStream(baos);
                cFile.write(dos);
                byte[] classBytes = baos.toByteArray();
                try {
                    proxyClass = this.dpCL.loadClass(className);
                }
                catch (ClassNotFoundException cnfe2) {
                    proxyClass = this.dpCL.defineClass(className, classBytes);
                }
                return proxyClass;
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws390.management.proxy.DynamicProxyInterfaceGenerator.generate", (String)"504", (Object)this);
            t.printStackTrace();
            return null;
        }
    }

    public static String printClassInfo(Class info) {
        StringBuffer retStr = new StringBuffer();
        String className = info.getName();
        retStr.append("\nClass info for " + className);
        try {
            Method[] methods = info.getDeclaredMethods();
            retStr.append("\n\n" + methods.length + " methods are declared:");
            for (int i = 0; i < methods.length; ++i) {
                retStr.append("\n\n[" + i + "] " + methods[i]);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws390.management.proxy.DynamicProxyInterfaceGenerator.printClassInfo", (String)"530");
            t.printStackTrace();
        }
        return retStr.toString();
    }

    public static String printModelMBeanInfo(ModelMBeanInfo info) {
        StringBuffer retStr = new StringBuffer();
        retStr.append("\nMBeanInfo for ModelMBean is:");
        retStr.append("\nCLASSNAME: \t" + info.getClassName());
        retStr.append("\nDESCRIPTION: \t" + info.getDescription());
        try {
            retStr.append("\nMBEAN DESCRIPTOR: \t" + info.getMBeanDescriptor());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.MBeanFactoryImpl.printModelMBeanInfo", (String)"313");
            retStr.append("\nMBEAN DESCRIPTOR: \t is invalid");
        }
        retStr.append("\n\nATTRIBUTES");
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        if (attrInfo != null && attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                retStr.append("\n    ** NAME: \t" + attrInfo[i].getName());
                retStr.append("    DESCR: \t" + attrInfo[i].getDescription());
                retStr.append("    TYPE: \t" + attrInfo[i].getType());
                retStr.append("\tREAD: " + attrInfo[i].isReadable());
                retStr.append("\tWRITE: " + attrInfo[i].isWritable());
                retStr.append("    DESCRIPTOR: " + ((ModelMBeanAttributeInfo)attrInfo[i]).getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No attributes **");
        }
        retStr.append("\n\nCONSTRUCTORS");
        MBeanConstructorInfo[] constrInfo = info.getConstructors();
        if (constrInfo != null && constrInfo.length > 0) {
            for (int i = 0; i < constrInfo.length; ++i) {
                retStr.append("\n    ** NAME: \t" + constrInfo[i].getName());
                retStr.append("    DESCR: \t" + constrInfo[i].getDescription());
                retStr.append("    PARAM: \t" + constrInfo[i].getSignature().length + " parameter(s)");
                retStr.append("    DESCRIPTOR: " + ((ModelMBeanConstructorInfo)constrInfo[i]).getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No Constructors **");
        }
        retStr.append("\n\nOPERATIONS");
        MBeanOperationInfo[] opInfo = info.getOperations();
        if (opInfo != null && opInfo.length > 0) {
            for (int i = 0; i < opInfo.length; ++i) {
                retStr.append("\n    ** NAME: \t" + opInfo[i].getName());
                retStr.append("    DESCR: \t" + opInfo[i].getDescription());
                retStr.append("    PARAM: \t" + opInfo[i].getSignature().length + " parameter(s)");
                retStr.append("    DESCRIPTOR: " + ((ModelMBeanOperationInfo)opInfo[i]).getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No operations ** ");
        }
        retStr.append("\n\nNOTIFICATIONS");
        MBeanNotificationInfo[] notifInfo = info.getNotifications();
        if (notifInfo != null && notifInfo.length > 0) {
            for (int i = 0; i < notifInfo.length; ++i) {
                retStr.append("\n    ** NAME: \t" + notifInfo[i].getName());
                retStr.append("    DESCR: \t" + notifInfo[i].getDescription());
                retStr.append("    DESCRIPTOR: " + ((ModelMBeanNotificationInfo)notifInfo[i]).getDescriptor().toString());
            }
        } else {
            retStr.append(" ** No notifications **");
        }
        retStr.append(" ** ModelMBean: End of MBeanInfo ** ");
        return retStr.toString();
    }

    public static String fixArrayType(String inputType) {
        if (inputType == null) {
            return null;
        }
        char initial_char = inputType.charAt(0);
        if (initial_char != '[') {
            return inputType;
        }
        int array_dimension = 0;
        while (inputType.charAt(array_dimension) == '[') {
            ++array_dimension;
        }
        StringBuffer retval = new StringBuffer();
        initial_char = (inputType = inputType.substring(array_dimension)).charAt(0);
        if (DynamicProxyInterfaceGenerator.isBaseType(initial_char)) {
            retval.append(DynamicProxyInterfaceGenerator.getBaseTypeStr(initial_char));
        } else if (DynamicProxyInterfaceGenerator.isObjectType(initial_char)) {
            retval.append(DynamicProxyInterfaceGenerator.parseObjectType(inputType));
        } else {
            System.out.print("ERROR: com.ibm.ws390.metadata.archive.JavaMethod.fixArrayType: ");
            System.out.println("found BAD inputType ==| " + inputType + "|==");
        }
        for (int i = 0; i < array_dimension; ++i) {
            retval.append("[]");
        }
        return retval.toString();
    }

    private static boolean isBaseType(char input_char) {
        switch (input_char) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    private static String getBaseTypeStr(char input_char) {
        switch (input_char) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
        }
        return null;
    }

    private static boolean isObjectType(char input_char) {
        return input_char == 'L';
    }

    private static String parseObjectType(String objectType) {
        int semi_colon_index = objectType.indexOf(59);
        return objectType.substring(1, semi_colon_index);
    }

    class DynamicProxyClassLoader
    extends ClassLoader {
        public DynamicProxyClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(String name, byte[] classbytes) throws ClassFormatError {
            return super.defineClass(name, classbytes, 0, classbytes.length);
        }
    }
}

