/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.ServantNotificationHandler;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.rasdiag.DiagnosticProviderRegistration;
import com.ibm.ws.rasdiag.DiagnosticProviderRegistry;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvoker;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import com.ibm.wsspi.rasdiag.DiagnosticConfigHome;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.AttributeInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.TestInfo;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class DiagnosticServiceMBeanProxy
extends ProxyMBeanSupport
implements ServantNotificationHandler {
    private static final String sThisClass = DiagnosticServiceMBeanProxy.class.getName();
    private static Logger sDiagnosticServiceProxyLogger = Logger.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");
    private DiagnosticProviderRegistry iDiagnosticProviderRegistry = DiagnosticProviderRegistry.getInstance();
    private static AdminService sAdminSvc = AdminServiceFactory.getAdminService();
    private static DiagnosticConfigHome sDiagnosticConfigHome = DiagnosticConfigHome.getInstance();
    private static final int NumStrings = 2;
    private static Locale dfltLocale = null;
    private static ResourceBundle dfltBundle = null;
    private static String[] dfltStrings = new String[2];
    private ServantMBeanInvoker mbeanInvoker = null;

    public DiagnosticServiceMBeanProxy() {
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "constructor", "Constructing DiagnosticServiceMBeanProxy");
        this.mbeanInvoker = this.getInvoker();
    }

    public String getDiagnosticProviderNameById(String aDPid) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDiagnosticProviderNameById", "RasDiag.All.NullParm");
            return null;
        }
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "getDiagnosticProviderNameById", "Invoked method w/aDPid: " + aDPid);
        return this.iDiagnosticProviderRegistry.getDiagnosticProviderNameById(aDPid);
    }

    public String[] queryDPNames(String aDPNameRegExp) {
        if (aDPNameRegExp == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "queryDPNames", "RasDiag.All.NullParm");
            return null;
        }
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "queryDPNames", "Invoked w/DPNames: " + aDPNameRegExp);
        return this.iDiagnosticProviderRegistry.queryDPNames(aDPNameRegExp);
    }

    public ObjectName[] queryDPids(String aDPNameRegExp) {
        if (aDPNameRegExp == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "queryDPids", "RasDiag.All.NullParm");
            return null;
        }
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "queryDPids", "Invoked w/DPNames: " + aDPNameRegExp);
        return this.iDiagnosticProviderRegistry.queryDPids(aDPNameRegExp);
    }

    public String[] getRegisteredConfig(String aDPName) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getRegisteredConfig", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "getRegisteredConfig", "InDP: " + aDPName + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getRegistryInternal(lCurObj, 1);
    }

    public String[] getRegisteredConfigById(String aDPid) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getRegisteredConfigById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "getRegisteredConfigById", "Inid: " + aDPid + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getRegistryInternal(lCurObj, 1);
    }

    public String[] getRegisteredState(String aDPName) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getRegisteredState", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "getRegisteredState", "InDP: " + aDPName + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getRegistryInternal(lCurObj, 2);
    }

    public String[] getRegisteredStateById(String aDPid) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getRegisteredStateById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "getRegisteredStateById", "Inid: " + aDPid + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getRegistryInternal(lCurObj, 2);
    }

    public String[] getRegisteredSelfDiagnostics(String aDPName) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getRegisteredSelfDiagnostics", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "getRegisteredSelfDiagnostics", "InDP: " + aDPName + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getSDRegistryInternal(lCurObj, 3);
    }

    public String[] getRegisteredSelfDiagnosticsById(String aDPid) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getRegisteredSelfDiagnosticsById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "getRegisteredSelfDiagnosticsById", "InId: " + aDPid + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getSDRegistryInternal(lCurObj, 2);
    }

    private String[] getRegistryInternal(ObjectName aObjNm, int aType) {
        AttributeInfo[] attrInfo;
        DiagnosticProviderInfo dpInfo = this.getDPInfo(aObjNm);
        if (dpInfo == null) {
            return null;
        }
        AttributeInfo[] attributeInfoArray = attrInfo = aType == 1 ? dpInfo.configInfo.attributeInfo : dpInfo.stateInfo.attributeInfo;
        if (attrInfo == null) {
            String CfgType = aType == 1 ? "Configuration" : "State";
            sDiagnosticServiceProxyLogger.logp(Level.INFO, sThisClass, "getRegistryInternal", "RasDiag.DSrv.NoCfgData", CfgType + " ObjNm: " + aObjNm);
            return null;
        }
        String[] returnArray = new String[attrInfo.length];
        for (int i = 0; i < attrInfo.length; ++i) {
            returnArray[i] = attrInfo[i].id;
        }
        return returnArray;
    }

    private String[] getSDRegistryInternal(ObjectName aObjNm, int aType) {
        DiagnosticProviderInfo dpInfo = this.getDPInfo(aObjNm);
        if (dpInfo == null) {
            return null;
        }
        TestInfo[] testInfo = dpInfo.selfDiagnosticInfo.testInfo;
        if (testInfo == null) {
            sDiagnosticServiceProxyLogger.logp(Level.INFO, sThisClass, "getSDRegistryInternal", "RasDiag.DSrv.NoCfgData", "SelfDiag: ObjNm: " + aObjNm);
            return null;
        }
        String[] returnArray = new String[testInfo.length];
        for (int i = 0; i < testInfo.length; ++i) {
            returnArray[i] = testInfo[i].id;
        }
        return returnArray;
    }

    private DiagnosticProviderInfo getDPInfo(final ObjectName aObjNm) {
        if (aObjNm == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDPInfo", "RasDiag.All.NullParm");
            return null;
        }
        sDiagnosticServiceProxyLogger.entering(sThisClass, "getDPInfo", aObjNm);
        DiagnosticProviderInfo dpInfo = null;
        try {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = DiagnosticProviderHelper.callJmxServer(sAdminSvc, aObjNm, "getRegisteredDiagnostics", new Object[0], new String[0]);
                        return this.returnValue;
                    }
                    catch (Exception e) {
                        sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", e);
                        return null;
                    }
                }
            };
            dpInfo = (DiagnosticProviderInfo)SecurityContext.runAsSystem((PrivilegedExceptionAction)action);
        }
        catch (Exception e) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDPInfo", "RasDiag.All.JmxInfo", new Object[]{aObjNm, "", "", ""});
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDPInfo", "RasDiag.DS.JMXCallIssue", e);
        }
        if (dpInfo == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDPInfo", "RasDiag.DS.JmxInfo", new Object[]{"Null Diagnostic Provider Info back thru JMX layer", "", "", ""});
        }
        sDiagnosticServiceProxyLogger.exiting(sThisClass, "getDPInfo");
        return dpInfo;
    }

    public DiagnosticEvent[] configDump(String aDPName, String aAttributeIdSpec, boolean aRegisteredOnly) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "configDump", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "configDump", "InDP: " + aDPName + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getDPDumpInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly, "configDump");
    }

    public DiagnosticEvent[] configDumpById(String aDPid, String aAttributeIdSpec, boolean aRegisteredOnly) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "configDumpById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "configDumpById", "InId: " + aDPid + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getDPDumpInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly, "configDump");
    }

    public String[] configDumpFormatted(String aDPName, String aAttributeIdSpec, boolean aRegisteredOnly, Locale aLocale) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "configDumpFormatted", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "configDumpFormatted", "InDP: " + aDPName + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        DiagnosticEvent[] configDumpDE = this.getDPDumpInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly, "configDump");
        return this.formatDiagnosticEvent(lCurObj, configDumpDE, aLocale);
    }

    public String[] configDumpFormattedById(String aDPid, String aAttributeIdSpec, boolean aRegisteredOnly, Locale aLocale) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "configDumpFromattedById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "configDumpFormattedById", "InId: " + aDPid + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        DiagnosticEvent[] configDumpDE = this.getDPDumpInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly, "configDump");
        return this.formatDiagnosticEvent(lCurObj, configDumpDE, aLocale);
    }

    public DiagnosticEvent[] stateDump(String aDPName, String aAttributeIdSpec, boolean aRegisteredOnly) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "stateDump", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "stateDump", "InDP: " + aDPName + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getDPDumpInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly, "stateDump");
    }

    public DiagnosticEvent[] stateDumpById(String aDPid, String aAttributeIdSpec, boolean aRegisteredOnly) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "stateDumpById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "stateDumpById", "InId: " + aDPid + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getDPDumpInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly, "stateDump");
    }

    public String[] stateDumpFormatted(String aDPName, String aAttributeIdSpec, boolean aRegisteredOnly, Locale aLocale) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "stateDumpFormatted", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "stateDumpFormatted", "InDP: " + aDPName + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        DiagnosticEvent[] stateDumpDE = this.getDPDumpInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly, "stateDump");
        return this.formatDiagnosticEvent(lCurObj, stateDumpDE, aLocale);
    }

    public String[] stateDumpFormattedById(String aDPid, String aAttributeIdSpec, boolean aRegisteredOnly, Locale aLocale) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "stateDumpFormattedById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "stateDumpFormattedById", "InId: " + aDPid + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        DiagnosticEvent[] stateDumpDE = this.getDPDumpInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly, "stateDump");
        return this.formatDiagnosticEvent(lCurObj, stateDumpDE, aLocale);
    }

    public DiagnosticEvent[] selfDiagnostic(String aDPName, String aAttributeIdSpec, boolean aRegisteredOnly) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "selfDiagnostic", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "selfDiagnostic", "InDP: " + aDPName + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getSelfDiagnosticInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly);
    }

    public DiagnosticEvent[] selfDiagnosticById(String aDPid, String aAttributeIdSpec, boolean aRegisteredOnly) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "selfDiagnosticById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "selfDiagnosticById", "InId: " + aDPid + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        return this.getSelfDiagnosticInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly);
    }

    public String[] selfDiagnosticFormatted(String aDPName, String aAttributeIdSpec, boolean aRegisteredOnly, Locale aLocale) {
        if (aDPName == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "selfDiagnosticFormatted", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "selfDiagnosticFormatted", "InDP: " + aDPName + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        DiagnosticEvent[] selfDiagDE = this.getSelfDiagnosticInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly);
        return this.formatDiagnosticEvent(lCurObj, selfDiagDE, aLocale);
    }

    public String[] selfDiagnosticFormattedById(String aDPid, String aAttributeIdSpec, boolean aRegisteredOnly, Locale aLocale) {
        if (aDPid == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "selfDiagnosticFormattedById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "selfDiagnosticFormattedById", "InId: " + aDPid + " AttributeIdSpec: " + aAttributeIdSpec + " RegOnly: " + aRegisteredOnly + " ObjNm: " + lCurObj);
        if (lCurObj == null) {
            return null;
        }
        DiagnosticEvent[] selfDiagDE = this.getSelfDiagnosticInternal(lCurObj, aAttributeIdSpec, aRegisteredOnly);
        return this.formatDiagnosticEvent(lCurObj, selfDiagDE, aLocale);
    }

    private DiagnosticEvent[] getDPDumpInternal(final ObjectName aObjNm, final String aAttributeId, final boolean aRegisteredOnly, final String aMethod) {
        if (sDiagnosticServiceProxyLogger.isLoggable(Level.FINER)) {
            sDiagnosticServiceProxyLogger.entering(sThisClass, "getDPDumpInternal", new Object[]{aMethod, aObjNm, aAttributeId, new Boolean(aRegisteredOnly)});
        }
        DiagnosticEvent[] configDumpDE = null;
        try {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = DiagnosticProviderHelper.callJmxServer(sAdminSvc, aObjNm, aMethod, new Object[]{aAttributeId, new Boolean(aRegisteredOnly)}, new String[]{"java.lang.String", "boolean"});
                        return this.returnValue;
                    }
                    catch (Exception e) {
                        sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", e);
                        return null;
                    }
                }
            };
            configDumpDE = (DiagnosticEvent[])SecurityContext.runAsSystem((PrivilegedExceptionAction)action);
        }
        catch (Exception e) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDPDumpInternal", "RasDiag.All.JmxInfo", new Object[]{aObjNm, "", "", ""});
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDPDumpInternal", "RasDiag.DS.JMXCallIssue", e);
        }
        sDiagnosticServiceProxyLogger.exiting(sThisClass, "getDPDumpInternal");
        return configDumpDE;
    }

    private DiagnosticEvent[] getSelfDiagnosticInternal(final ObjectName aObjNm, final String aAttributeId, final boolean aRegisteredOnly) {
        if (sDiagnosticServiceProxyLogger.isLoggable(Level.FINER)) {
            sDiagnosticServiceProxyLogger.entering(sThisClass, "getSelfDiagnosticInternal", new Object[]{aObjNm.toString(), aAttributeId});
        }
        DiagnosticEvent[] selfDiagDE = null;
        try {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = DiagnosticProviderHelper.callJmxServer(sAdminSvc, aObjNm, "selfDiagnostic", new Object[]{aAttributeId, new Boolean(aRegisteredOnly)}, new String[]{"java.lang.String", "boolean"});
                        return this.returnValue;
                    }
                    catch (Exception e) {
                        sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", e);
                        return null;
                    }
                }
            };
            selfDiagDE = (DiagnosticEvent[])SecurityContext.runAsSystem((PrivilegedExceptionAction)action);
        }
        catch (Exception e) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getSelfDiagnosticInternal", "RasDiag.All.JmxInfo", new Object[]{aObjNm, "", "", ""});
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getSelfDiagnosticInternal", "RasDiag.DS.JMXCallIssue", e);
        }
        sDiagnosticServiceProxyLogger.exiting(sThisClass, "getSelfDiagnosticInternal");
        return selfDiagDE;
    }

    public void setStateCollectionSpec(String aCollectionSpec) {
        sDiagnosticConfigHome.setStateCollectionSpec(aCollectionSpec);
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "setStateCollectionSpec", "Spec: " + aCollectionSpec);
        this.driveAllServants("setStateCollectionSpec", new Object[]{aCollectionSpec}, new String[]{"java.lang.String"});
    }

    public String getStateCollectionSpec() {
        return sDiagnosticConfigHome.getStateCollectionSpec();
    }

    public void refreshRegistrations() {
        this.iDiagnosticProviderRegistry.refreshRegistrations();
    }

    public String[] listRegistrations() {
        return this.iDiagnosticProviderRegistry.listRegistrations();
    }

    public String[] localize(String aDPName, String[] aKeys, Locale aLocale) {
        if (aDPName == null || aKeys == null || aLocale == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "localize", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getDPid4DPName(aDPName);
        if (lCurObj == null) {
            return null;
        }
        return this.localizeInternal(lCurObj, aKeys, aLocale);
    }

    public String[] localizeById(String aDPid, String[] aKeys, Locale aLocale) {
        if (aDPid == null || aKeys == null || aLocale == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "localizeById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName lCurObj = this.iDiagnosticProviderRegistry.getObjNameFromDPid(aDPid);
        if (lCurObj == null) {
            return null;
        }
        return this.localizeInternal(lCurObj, aKeys, aLocale);
    }

    private String[] localizeInternal(final ObjectName aObjNm, final String[] aKeys, final Locale aLocale) {
        if (sDiagnosticServiceProxyLogger.isLoggable(Level.FINER)) {
            sDiagnosticServiceProxyLogger.entering(sThisClass, "localizeInternal", new Object[]{aObjNm, aKeys, aLocale});
        }
        String[] localizedStrings = null;
        if (aObjNm == null) {
            return null;
        }
        try {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = DiagnosticProviderHelper.callJmxServer(sAdminSvc, aObjNm, "localize", new Object[]{aKeys, aLocale}, new String[]{"[Ljava.lang.String;", "java.util.Locale"});
                        return this.returnValue;
                    }
                    catch (Exception e) {
                        sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", e);
                        return null;
                    }
                }
            };
            localizedStrings = (String[])SecurityContext.runAsSystem((PrivilegedExceptionAction)action);
        }
        catch (Exception e) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "localizeInternal", "RasDiag.All.JmxInfo", new Object[]{aObjNm, aLocale, "", ""});
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "localizeInternal", "RasDiag.DS.JMXCallIssue", e);
        }
        sDiagnosticServiceProxyLogger.exiting(sThisClass, "localizeInternal");
        sDiagnosticServiceProxyLogger.logp(Level.FINER, "DiagnosticService", "localizeInternal", "First string to localize: " + aKeys[0] + " Locd: " + localizedStrings[0]);
        return localizedStrings;
    }

    private String[] formatDiagnosticEvent(ObjectName aCurObj, DiagnosticEvent[] aDiagEvent, Locale aLocale) {
        if (dfltLocale == null) {
            this.loadStrings();
        }
        if (aDiagEvent == null || aDiagEvent.length == 0) {
            String iMsg = aDiagEvent == null ? "Null DiagEventArray" : "Empty DiagEventArray";
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "formatDiagnosticEvent", "RasDiag.All.InvalidParm", iMsg);
            return null;
        }
        if (aLocale == null) {
            aLocale = dfltLocale;
        }
        String[] returnString = new String[aDiagEvent.length];
        for (int i = 0; i < aDiagEvent.length; ++i) {
            StringBuffer sb = new StringBuffer(4096);
            short contentType = aDiagEvent[i].getContentType();
            String aDPid = aDiagEvent[i].getDiagnosticProviderId();
            String eventType = aDiagEvent[i].getEventType();
            String msgKey = aDiagEvent[i].getMessageKey();
            String resourceBundleName = aDiagEvent[i].getResourceBundleName();
            String sourceClass = aDiagEvent[i].getSourceClass();
            String sourceMethod = aDiagEvent[i].getSourceMethod();
            String compCell = aDiagEvent[i].getCellName();
            String compNode = aDiagEvent[i].getNodeName();
            String compServer = aDiagEvent[i].getServerName();
            String compSrvDetail = aDiagEvent[i].getServerDetail();
            if (aLocale == dfltLocale) {
                sb.append(TraceNLS.getFormattedMessageFromLocalizedMessage(dfltStrings[0], new Object[]{aDPid, eventType, msgKey, resourceBundleName, sourceClass, sourceMethod, compCell, compNode, compServer, compSrvDetail, new Short(contentType)}, false));
                sb.append("\n\n" + dfltStrings[1] + "\n");
            } else {
                sb.append(TraceNLS.getFormattedMessage("com.ibm.ws.rasdiag.resources.RasDiagLocalization", "RasDiag.DEFormat.Msg0", aLocale, new Object[]{aDPid, eventType, msgKey, resourceBundleName, sourceClass, sourceMethod, compCell, compNode, compServer, compSrvDetail, new Short(contentType)}, "Formatting error", false));
                sb.append("\n\n" + TraceNLS.getStringFromBundle("com.ibm.ws.rasdiag.resources.RasDiagLocalization", "RasDiag.DEFormat.Msg1", aLocale) + "\n");
            }
            sDiagnosticServiceProxyLogger.logp(Level.FINE, sThisClass, "formatDiagnosticEvent", "Current generic Return Value: " + sb);
            ArrayList attributeIds = new ArrayList(64);
            ArrayList valTypes = new ArrayList(64);
            ArrayList values = new ArrayList(64);
            ArrayList msgKeyList = new ArrayList(64);
            int ArrSize = DiagnosticServiceMBeanProxy.getDiagFormatInfo(aDiagEvent[i], attributeIds, valTypes, values, msgKeyList);
            String[] msgKeys = new String[ArrSize];
            msgKeys = msgKeyList.toArray(msgKeys);
            for (int j = 0; j < ArrSize; ++j) {
                sb.append("\n" + String.format(" %1$-50s = %2$-5s", attributeIds.get(j), values.get(j)));
            }
            returnString[i] = sb.toString();
        }
        return returnString;
    }

    private void loadStrings() {
        dfltLocale = Locale.getDefault();
        dfltBundle = TraceNLS.getResourceBundle("com.ibm.ws.rasdiag.resources.RasDiagLocalization", dfltLocale);
        for (int i = 0; i < 2; ++i) {
            DiagnosticServiceMBeanProxy.dfltStrings[i] = dfltBundle.getString("RasDiag.DEFormat.Msg" + i);
            sDiagnosticServiceProxyLogger.logp(Level.FINE, sThisClass, "loadStrings", " MJCDS: CvtdMsg: RasDiag.DEFormat.Msg" + i + " to: " + dfltStrings[i]);
        }
    }

    public static int getDiagFormatInfo(DiagnosticEvent diagnosticEvent, ArrayList attributeIds, ArrayList valTypes, ArrayList values, ArrayList msgKeys) {
        if (diagnosticEvent == null || attributeIds == null || valTypes == null || values == null || msgKeys == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDiagFormatInfo", "RasDiag.All.NullParm");
            return 0;
        }
        TreeMap diagnosticData = (TreeMap)diagnosticEvent.getDiagnosticData();
        if (diagnosticData == null) {
            return 0;
        }
        return DiagnosticServiceMBeanProxy.getDiagFormatInfoRecurse(diagnosticData, "", attributeIds, valTypes, values, msgKeys, 0);
    }

    private static int getDiagFormatInfoRecurse(TreeMap diagnosticData, String prefix, ArrayList attributeIds, ArrayList valTypes, ArrayList values, ArrayList msgKeys, int curIdx) {
        Set keySet = diagnosticData.keySet();
        for (String valName : keySet) {
            Object valObj = diagnosticData.get(valName);
            if (valObj instanceof DiagnosticTypedValue) {
                DiagnosticTypedValue dtv = (DiagnosticTypedValue)valObj;
                attributeIds.add(curIdx, prefix + valName);
                valTypes.add(curIdx, DiagnosticTypedValue.sTypeNames[dtv.tvType]);
                values.add(curIdx, dtv.tvString);
                msgKeys.add(curIdx, dtv.tvMsgKey);
                ++curIdx;
                continue;
            }
            if (valObj instanceof TreeMap) {
                curIdx = DiagnosticServiceMBeanProxy.getDiagFormatInfoRecurse((TreeMap)valObj, prefix + valName, attributeIds, valTypes, values, msgKeys, curIdx);
                continue;
            }
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "getDiagFormatInfoRecurse", "RasDiag.All.InvMapType", valObj.getClass().getName());
        }
        return curIdx;
    }

    private ArrayList driveAllServants(String aMethod, Object[] aParms, String[] aSignature) {
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), aMethod, aParms, aSignature);
        if (results == null) {
            return null;
        }
        ArrayList<Object> aggResults = new ArrayList<Object>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.elementAt(i);
            if (data.resultThrowable()) {
                sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "aggregateResults", "RasDiag.DSP.ZJmxInvoke", data.getResult());
                continue;
            }
            aggResults.add(data.getResult());
        }
        return aggResults;
    }

    private Set getServantsAndAdjuncts() {
        HashSet returnSet = new HashSet(this.currentServants());
        int setSz = returnSet.size();
        returnSet.addAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "getServantsAndAdjuncts", "Servants: " + setSz + " Total (Servants+Adjuncts): " + returnSet.size());
        return returnSet;
    }

    public void handleServantNotification(Notification notification) {
        if (notification == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "handleServantNotification", "RasDiag.All.NullParm");
            return;
        }
        String type = notification.getType();
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "handleServantNotification", "Notification Type: " + type);
        if (type.equals("DiagnosticProvider.registration")) {
            DiagnosticProviderRegistration dpr = (DiagnosticProviderRegistration)notification.getUserData();
            if (dpr.isRegistration()) {
                DiagnosticProviderRegistry.register((String)dpr.getDPName(), (ObjectName)dpr.getObjName());
            } else {
                DiagnosticProviderRegistry.deregister((String)dpr.getDPName(), (ObjectName)dpr.getObjName(), (boolean)true);
            }
            sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "handleServantNotification", "Registering DPNm: " + dpr.getDPName() + " DPid: " + dpr.getObjName() + " RegIfTrue: " + dpr.isRegistration());
        }
    }

    protected void handleInternalNotification(Notification notification) {
        if (notification == null) {
            sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "handleInternalNotification", "RasDiag.All.NullParm");
            return;
        }
        String eventType = notification.getType();
        sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "handleInternalNotification", "Notification Type: " + eventType);
        ServantMBeanStatus status = (ServantMBeanStatus)notification.getUserData();
        String stoken = status.getServantStoken();
        if ("websphere.ws390.servant.started".equals(eventType)) {
            HandleNewServant servantHandler = new HandleNewServant(stoken, sDiagnosticConfigHome.getStateCollectionSpec());
            Thread thread = new Thread(servantHandler);
            thread.start();
        }
    }

    protected boolean prepareToUnregister() {
        return false;
    }

    private class HandleNewServant
    implements Runnable {
        private String stoken = null;
        private String collectionSpec = null;
        private String sSubClass = HandleNewServant.class.getName();

        public HandleNewServant(String aStoken, String aCollectionSpec) {
            if (aStoken == null || aCollectionSpec == null) {
                sDiagnosticServiceProxyLogger.logp(Level.WARNING, this.sSubClass, "constructor", "RasDiag.All.NullParm");
                return;
            }
            sDiagnosticServiceProxyLogger.logp(Level.FINE, this.sSubClass, "constructor", "Came into constructor in HandleNewServant");
            this.stoken = aStoken;
            this.collectionSpec = aCollectionSpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Subject savedSubject = null;
            Subject subject = null;
            sDiagnosticServiceProxyLogger.logp(Level.FINE, this.sSubClass, "run", "Came into run in HandleNewServant");
            try {
                try {
                    subject = SecurityHelper.getServerSubject();
                    if (subject != null) {
                        savedSubject = SecurityHelper.pushInvocationSubject(subject);
                    }
                    DiagnosticServiceMBeanProxy.this.mbeanInvoker.invokeSpecificServant(this.stoken, DiagnosticServiceMBeanProxy.this.getObjectName(), "setStateCollectionSpec", new Object[]{this.collectionSpec}, new String[]{"java.lang.String"});
                    ServantMBeanInvokerData data = DiagnosticServiceMBeanProxy.this.mbeanInvoker.invokeSpecificServant(this.stoken, DiagnosticServiceMBeanProxy.this.getObjectName(), "listRegistrations", new Object[0], new String[0]);
                    sDiagnosticServiceProxyLogger.logp(Level.FINE, this.sSubClass, "run", "Drove listRegistrations in HandleNewServant and data =: " + data + " Throwable: " + data.resultThrowable());
                    if (data == null || data.resultThrowable()) {
                        sDiagnosticServiceProxyLogger.logp(Level.WARNING, this.sSubClass, "run.1", "RasDiag.DSP.ZJmxInvoke", data);
                    }
                    sDiagnosticServiceProxyLogger.logp(Level.FINE, this.sSubClass, "run", "Driving registerProviders in HandleNewServant");
                    this.registerProviders((String[])data.getResult());
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws390.management.proxy.DiagnosticServiceMBeanProxy.run", (String)"1140", (Object)this);
                    sDiagnosticServiceProxyLogger.logp(Level.WARNING, this.sSubClass, "run.2", "RasDiag.DSP.ZJmxInvoke");
                    sDiagnosticServiceProxyLogger.logp(Level.WARNING, this.sSubClass, "run.2", "RasDiag.All.JmxInfo", new Object[]{"NoObjNameHere", "Caught following exception"});
                    sDiagnosticServiceProxyLogger.logp(Level.WARNING, this.sSubClass, "run.2", "RasDiag.All.JmxInfo", t);
                    Object var5_6 = null;
                    if (subject == null) return;
                    SecurityHelper.popInvocationSubject(savedSubject);
                    return;
                }
                Object var5_5 = null;
                if (subject == null) return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (subject == null) throw throwable;
                SecurityHelper.popInvocationSubject(savedSubject);
                throw throwable;
            }
            SecurityHelper.popInvocationSubject(savedSubject);
        }

        private void registerProviders(String[] registeredProviders) {
            int maxLen = registeredProviders.length / 2;
            sDiagnosticServiceProxyLogger.logp(Level.FINE, this.sSubClass, "registerProviders", "Into registerProviders w/maxlen: " + maxLen);
            for (int i = 1; i < maxLen; ++i) {
                sDiagnosticServiceProxyLogger.logp(Level.FINE, this.sSubClass, "registerProviders", "regdProviders[" + i + "] = " + registeredProviders[i]);
                int keyLoc = registeredProviders[i].indexOf("Key:");
                if (keyLoc < 0 || keyLoc > registeredProviders[i].length() - 10) {
                    sDiagnosticServiceProxyLogger.logp(Level.WARNING, this.sSubClass, "registerProviders:Key", "RasDiag.DS.RegistryIssue", registeredProviders[i]);
                    continue;
                }
                int pidLoc = registeredProviders[i].indexOf("DPid:", keyLoc + 4);
                if (pidLoc < 0 || pidLoc > registeredProviders[i].length() - 7) {
                    sDiagnosticServiceProxyLogger.logp(Level.WARNING, this.sSubClass, "registerProviders:DPid", "RasDiag.DS.RegistryIssue", registeredProviders[i]);
                    continue;
                }
                String DPName = registeredProviders[i].substring(keyLoc + 4, pidLoc).trim();
                String DPid = registeredProviders[i].substring(pidLoc + 5).trim();
                try {
                    DiagnosticProviderHelper.registerMBeanWithDiagnosticService(DPName, new ObjectName(DPid));
                    continue;
                }
                catch (Exception e) {
                    sDiagnosticServiceProxyLogger.logp(Level.WARNING, this.sSubClass, "registerProviders:DPid", "RasDiag.DS.RegistryIssue", e);
                }
            }
        }
    }

    private static class SelfListener
    implements NotificationListener {
        public SelfListener() {
            try {
                AdminService admin = AdminServiceFactory.getAdminService();
                String node = admin.getNodeName();
                String proc = admin.getProcessName();
                String query = "WebSphere:*,type=DiagnosticService,node=" + node + ",process=" + proc;
                ObjectName work = new ObjectName(query);
                NotificationFilterSupport filter = new NotificationFilterSupport();
                admin.addNotificationListenerExtended(work, this, filter, null);
            }
            catch (Exception e) {
                sDiagnosticServiceProxyLogger.logp(Level.WARNING, sThisClass, "SelfListener", "RasDiag.DPReg.RegFail", e);
            }
        }

        public void handleNotification(Notification notification, Object obj) {
            sDiagnosticServiceProxyLogger.logp(Level.FINER, sThisClass, "handleNotification", "Came into DiagnosticServiceMBeanProxy->selfListener->handleNotification");
        }
    }
}

