/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.ComponentDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AttributeDeserializer
extends ComponentDeserializer {
    protected Map propertyMap = null;
    protected BeanDesc beanDesc = null;
    protected HashMap deferredAttributesMap = null;

    protected AttributeDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    public AttributeDeserializer(Class clazz, QName qName, BeanDesc beanDesc, Map map) {
        super(clazz, qName);
        this.beanDesc = beanDesc;
        this.propertyMap = map;
    }

    void setup(BeanDesc beanDesc, Map map) {
        this.beanDesc = beanDesc;
        this.propertyMap = map;
    }

    public boolean recycle() {
        boolean bl = super.recycle();
        if (bl) {
            this.deferredAttributesMap = null;
        }
        return bl;
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (this.deferredAttributesMap == null) {
            return;
        }
        Set set = this.deferredAttributesMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FieldDesc fieldDesc = (FieldDesc)entry.getKey();
            Object v = entry.getValue();
            BeanPropertyDescriptor beanPropertyDescriptor = fieldDesc.getPropertyDescriptor();
            if (!beanPropertyDescriptor.isWriteable() || beanPropertyDescriptor.isIndexed()) continue;
            try {
                beanPropertyDescriptor.set(this.value, v);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer.onEndElement", (String)"115", (Object)this);
                throw new SAXException(exception);
            }
        }
    }

    protected void processAttributes(Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext, boolean bl) throws SAXException {
        if (this.beanDesc == null || this.propertyMap == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            BeanPropertyDescriptor beanPropertyDescriptor;
            String string;
            String string2 = attributes.getURI(i);
            FieldDesc fieldDesc = this.beanDesc.getFieldDesc(string2, string = attributes.getLocalName(i));
            if (fieldDesc == null || fieldDesc.isElement()) continue;
            String string3 = attributes.getValue(i);
            if (!bl && this.tryAttributeSetFromString(fieldDesc.getXmlName(), string3) || (beanPropertyDescriptor = fieldDesc.getPropertyDescriptor()) == null || !beanPropertyDescriptor.isWriteable() || beanPropertyDescriptor.isIndexed()) continue;
            Deserializer deserializer = this.getCachedDeserializer(fieldDesc, deserializationContext);
            Deserializer deserializer2 = deserializer = deserializer != null ? deserializer : this.getDeserializer(null, fieldDesc.getJavaType(), null, deserializationContext);
            if (deserializer == null) {
                throw new SAXException(Messages.getMessage((String)"noDeser00", (String)beanPropertyDescriptor.getType().toString()));
            }
            if (!(deserializer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage((String)"AttrNotSimpleType00", (String)beanPropertyDescriptor.getName(), (String)beanPropertyDescriptor.getType().toString()));
            }
            deserializer.onStartElement(string2, string, "", (Attributes)NullAttributes.singleton, mappingScope, deserializationContext);
            deserializer.characters(string3);
            deserializer.endElement(string2, string, deserializationContext);
            Object object = deserializer.getValue();
            deserializer.relinquish();
            if (bl) {
                if (this.deferredAttributesMap == null) {
                    this.deferredAttributesMap = new HashMap();
                }
                this.deferredAttributesMap.put(fieldDesc, object);
                continue;
            }
            try {
                beanPropertyDescriptor.set(this.value, object);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer.processAttributes", (String)"187", (Object)this);
                throw new SAXException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer.processAttributes", (String)"190", (Object)this);
                throw new SAXException(illegalAccessException);
            }
        }
    }

    protected final Deserializer getCachedDeserializer(FieldDesc fieldDesc, DeserializationContext deserializationContext) {
        Deserializer deserializer = fieldDesc.getDeserializer();
        if (deserializer != null) {
            return deserializer;
        }
        DeserializerFactory deserializerFactory = null;
        try {
            deserializerFactory = (DeserializerFactory)deserializationContext.getTypeMapping().getDeserializer(fieldDesc.getJavaType(), fieldDesc.getXmlType());
        }
        catch (JAXRPCException jAXRPCException) {
            FFDCFilter.processException((Throwable)jAXRPCException, (String)"com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.getCachedDeserializer", (String)"152", (Object)this);
            log.error((Object)Messages.getMessage((String)"noFactory00", (String)fieldDesc.getXmlType().toString()));
        }
        if (deserializerFactory != null) {
            fieldDesc.setDeserializerFactory(deserializerFactory);
            deserializer = fieldDesc.getDeserializer();
        }
        return deserializer;
    }

    protected boolean tryAttributeSetFromString(QName qName, String string) {
        return false;
    }
}

