/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.SRTRequestContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.util.UnsynchronizedStack;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public abstract class WebAppDispatcherContext
implements Cloneable,
IWebAppDispatcherContext {
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.webapp");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext";
    protected UnsynchronizedStack _servletReferenceStack = new UnsynchronizedStack();
    private UnsynchronizedStack _exceptionStack = new UnsynchronizedStack();
    protected IExtendedRequest _request;
    protected SRTRequestContext reqContext = null;
    private WebAppDispatcherContext parentContext = null;
    private String relativeUri;
    private String _servletPath;
    private String _pathInfo;
    private String _requestUri;
    private String _contextPath = null;
    private String queryString = null;
    private boolean _useParent = false;
    private boolean enforceSecurity = true;
    private boolean _isInclude = false;
    private boolean isForward = false;
    private String decodedReqUri;
    private static final boolean redirectWithPathInfo = WCCustomProperties.REDIRECT_WITH_PATH_INFO;
    private static final boolean removeServletPathSlash = WCCustomProperties.REMOVE_TRAILING_SERVLET_PATH_SLASH;
    private boolean possibleSlashStarMapping = true;
    protected WebApp _webapp;
    private boolean fireRequestEvents;

    public void setParentContext(WebAppDispatcherContext parent) {
        this.parentContext = parent;
    }

    public void finish() {
        this.resetObject();
    }

    public void setIsInclude(boolean isInclude) {
        this._isInclude = isInclude;
    }

    public void setUseParent(boolean useParent) {
        this._useParent = useParent;
    }

    public WebApp getWebApp() {
        return this._webapp;
    }

    public void initForNextDispatch(IExtendedRequest req) {
        this._request = req;
        if (req != null) {
            this.reqContext = ((SRTServletRequest)this._request).getRequestContext();
        }
    }

    public void pushServletReference(IServletWrapper ref) {
        this._servletReferenceStack.push(ref);
    }

    public void popServletReference() {
        this._servletReferenceStack.pop();
    }

    public IServletWrapper getCurrentServletReference() {
        return (IServletWrapper)this._servletReferenceStack.peek();
    }

    public Throwable getCurrentException() {
        if (this._exceptionStack.size() == 0) {
            return null;
        }
        return (Throwable)this._exceptionStack.peek();
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public IExtendedResponse getResponse() {
        return this._request.getResponse();
    }

    void resetObject() {
        this._servletReferenceStack.clear();
        this._exceptionStack.clear();
        this._isInclude = false;
        this._pathInfo = null;
        this._servletPath = null;
        this._webapp = null;
        this.relativeUri = null;
        this.queryString = null;
        this._requestUri = null;
        this.isForward = false;
        this.fireRequestEvents = false;
        this.enforceSecurity = true;
    }

    private IHttpSessionContext getSessionContext() {
        return this._webapp.getSessionContext();
    }

    public String getRequestedSessionId() {
        return this.getSessionContext().getRequestedSessionId((HttpServletRequest)((Object)this._request));
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getSessionContext().isRequestedSessionIdFromCookie((HttpServletRequest)((Object)this._request));
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getSessionContext().isRequestedSessionIdFromUrl((HttpServletRequest)((Object)this._request));
    }

    public void sessionPreInvoke() {
        this.reqContext.sessionPreInvoke(this._webapp);
    }

    public void sessionPostInvoke() {
        try {
            this.reqContext.sessionPostInvoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String encodeURL(String arg0) {
        return this.reqContext.encodeURL(this._webapp, (HttpServletRequest)((Object)this._request), arg0);
    }

    public String getRelativeUri() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getRelativeUri();
        }
        return this.relativeUri;
    }

    public void setRelativeUri(String relativeUri) {
        this.relativeUri = relativeUri;
    }

    public String getRealPath(String path) {
        return this.getWebApp().getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        String newPath;
        String pathInfo;
        String servletPath;
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.getWebApp().getFacade().getRequestDispatcher(path);
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        if ((servletPath = (String)this._request.getAttribute("javax.servlet.include.servlet_path")) == null) {
            pathInfo = this.getPathInfo();
            newPath = this.getServletPath();
            if (pathInfo != null) {
                newPath = newPath + pathInfo;
            }
        } else {
            pathInfo = (String)this._request.getAttribute("javax.servlet.include.path_info");
            newPath = servletPath;
            if (pathInfo != null) {
                newPath = newPath + pathInfo;
            }
        }
        int pathElementIndex = newPath.indexOf(59);
        newPath = pathElementIndex == -1 ? newPath.substring(0, newPath.lastIndexOf("/")) : newPath.substring(0, newPath.lastIndexOf("/", pathElementIndex));
        path = newPath + '/' + path;
        return this.getWebApp().getFacade().getRequestDispatcher(path);
    }

    public abstract Principal getUserPrincipal();

    public abstract boolean isUserInRole(String var1, HttpServletRequest var2);

    public String getPathInfo() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getPathInfo();
        }
        return this._pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public String getRequestURI() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getRequestURI();
        }
        return this._requestUri;
    }

    public String getContextPath() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getContextPath();
        }
        String cp = null;
        cp = this._contextPath != null ? this._contextPath : this.getWebApp().getContextPath();
        if (cp.equals("/")) {
            return "";
        }
        return cp;
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getWebApp().getRealPath(pathInfo);
    }

    public String getServletPath() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getServletPath();
        }
        return this._servletPath;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public boolean isInclude() {
        return this._isInclude;
    }

    public void sendRedirect303(String location) throws IOException {
        this.sendRedirectWithStatusCode(location, 303);
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirectWithStatusCode(location, 302);
    }

    private void sendRedirectWithStatusCode(String location, int statusCode) throws IOException {
        HttpServletResponse response = (HttpServletResponse)((Object)this.getResponse());
        if (!response.isCommitted()) {
            if (location == null) {
                throw new IllegalArgumentException("Location cannot be null in javax.servlet.http.HttpServletResponse.sendRedirect(location)");
            }
        } else {
            throw new IllegalStateException();
        }
        response.resetBuffer();
        location = this.convertRelativeURIToURL(location);
        response.setHeader("Location", location);
        response.setStatus(statusCode);
        response.flushBuffer();
    }

    public void sendError(int sc) throws IOException {
        IServletWrapper ref = this.getCurrentServletReference();
        if (ref != null) {
            this.sendError(sc, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), ref.getServletName()));
        } else {
            this.sendError(sc, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), this.getWebApp().getConfiguration().getDisplayName()));
        }
    }

    public void sendError(int sc, String message) throws IOException {
        if (this.getResponse().isCommitted()) {
            throw new IllegalStateException("Response already committed.");
        }
        this.getResponse().resetBuffer();
        int status = sc;
        try {
            if (!this.getResponse().isCommitted()) {
                ((HttpServletResponse)((Object)this.getResponse())).setStatus(status);
            }
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.sendError", (String)"112", (Object)this);
        }
        WebApp webapp = this.getWebApp();
        WebAppErrorReport error = null;
        error = new WebAppErrorReport(message);
        error.setErrorCode(status);
        IServletWrapper ref = this.getCurrentServletReference();
        if (ref != null) {
            error.setTargetServletName(ref.getServletName());
        }
        this.getWebApp().sendError((HttpServletRequest)((Object)this._request), (HttpServletResponse)((Object)this.getResponse()), error);
        this.getResponse().flushBuffer();
    }

    private String convertRelativeURIToURL(String relativeURI) {
        block18: {
            int indexOfQueryString;
            if (relativeURI == null) {
                throw new IllegalStateException();
            }
            String tmpURI = relativeURI;
            int indexOfSchemeDelimiter = (relativeURI = relativeURI.trim()).indexOf("://");
            if (indexOfSchemeDelimiter != -1 && ((indexOfQueryString = relativeURI.indexOf(63)) == -1 || indexOfSchemeDelimiter < indexOfQueryString)) {
                return relativeURI;
            }
            String webAppRootURI = null;
            boolean relativeToRootURI = false;
            try {
                webAppRootURI = this.getWebApp().getContextPath().trim();
                if (!webAppRootURI.startsWith("/")) {
                    webAppRootURI = "/" + webAppRootURI;
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", (String)"184", (Object)this);
                webAppRootURI = "/";
            }
            try {
                relativeToRootURI = relativeURI.startsWith("/");
                if (relativeURI.startsWith("./")) {
                    relativeURI = relativeURI.substring(2);
                }
                IExtendedRequest request = this._request;
                String urlScheme = request.getScheme();
                int urlPort = request.getServerPort();
                StringBuffer url = new StringBuffer(urlScheme);
                url.append("://");
                url.append(request.getServerName());
                if (urlScheme.equals("http") && urlPort != 80 || urlScheme.equals("https") && urlPort != 443) {
                    url.append(":");
                    url.append(urlPort);
                }
                String redirectURL = null;
                if (relativeToRootURI) {
                    if (WebContainerSystemProps.getSendRedirectCompatibilty()) {
                        url.append(webAppRootURI);
                        url.append(relativeURI);
                    } else {
                        url.append(relativeURI);
                    }
                    redirectURL = url.toString();
                } else {
                    String requestString = HttpUtils.getRequestURL((HttpServletRequest)((Object)request)).toString();
                    String pathInfo = request.getPathInfo();
                    if (pathInfo != null && pathInfo.length() > 0) {
                        if (!pathInfo.startsWith("/")) {
                            pathInfo = "/" + pathInfo;
                        }
                        requestString = redirectWithPathInfo ? requestString.substring(0, requestString.lastIndexOf("/")) : requestString.substring(0, requestString.lastIndexOf(pathInfo));
                        redirectURL = requestString + "/" + relativeURI;
                    } else {
                        redirectURL = requestString.substring(0, requestString.lastIndexOf(47) + 1) + relativeURI;
                    }
                }
                if (redirectURL.indexOf("..") > -1) {
                    int skip = new String(urlScheme + "://").length();
                    int split = redirectURL.indexOf("/", skip);
                    String serverString = redirectURL.substring(0, split);
                    String uri = redirectURL.substring(split);
                    uri = this.getWebApp().normalize(uri);
                    if (uri != null) {
                        return serverString + uri;
                    }
                    break block18;
                }
                return redirectURL;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", (String)"256", (Object)this);
            }
        }
        return relativeURI;
    }

    public void callPage(String fileName, HttpServletRequest hreq) throws IOException, ServletException {
        ServletContext sc = this.getWebApp().getContext(fileName);
        WebApp webapp = (WebApp)sc;
        String relativePath = fileName.substring(webapp.getContextPath().length());
        RequestDispatcher rd = sc.getRequestDispatcher(relativePath);
        rd.forward(hreq, this.getResponse());
    }

    public void _include(String fileName, HttpServletRequest request) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(fileName);
        requestDispatcher.include(request, this.getResponse());
    }

    public void _forward(String fileName, HttpServletRequest request) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(fileName);
        requestDispatcher.forward(request, this.getResponse());
    }

    public boolean isAutoRequestEncoding() {
        return this.getWebApp().getConfiguration().isAutoResponseEncoding();
    }

    public void setRequestURI(String path) {
        if (path == null) {
            this._requestUri = path;
            return;
        }
        int qMark = path.indexOf("?");
        if (qMark != -1) {
            this.queryString = path.substring(qMark + 1);
            this._requestUri = path.substring(0, qMark);
        } else {
            this._requestUri = path;
        }
    }

    public void setPathElements(String servletPath, String pathInfo) {
        ((SRTServletRequest)this._request).resetPathElements();
        if (removeServletPathSlash) {
            boolean hasSlashStar = false;
            boolean isPossible = this.isPossibleSlashStarMapping();
            if (isPossible) {
                hasSlashStar = this.hasSlashStarMapping();
            }
            if (hasSlashStar) {
                this._servletPath = "";
                this._pathInfo = servletPath == null ? pathInfo : (pathInfo == null ? servletPath : servletPath + pathInfo);
            } else if (isPossible) {
                if (servletPath == null || servletPath.equals("")) {
                    this._servletPath = pathInfo;
                    this._pathInfo = null;
                } else {
                    this._servletPath = servletPath;
                    this._pathInfo = pathInfo;
                }
            } else {
                this._servletPath = servletPath;
                this._pathInfo = pathInfo;
            }
            if (this._servletPath != null && this._servletPath.length() > 1 && this._servletPath.endsWith("/")) {
                this._servletPath = this._servletPath.substring(0, this._servletPath.length() - 1);
                this._pathInfo = this._pathInfo == null ? "/" : "/" + this._pathInfo;
            }
        } else if (servletPath.length() == 1 && servletPath.charAt(0) == '/') {
            this._servletPath = "";
            this._pathInfo = pathInfo == null ? "/" : "/" + pathInfo;
        } else {
            this._servletPath = servletPath;
            this._pathInfo = pathInfo;
        }
        this.relativeUri = this._servletPath;
        if (this._pathInfo != null) {
            this.relativeUri = this.relativeUri + this._pathInfo;
        }
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean b) {
        this.isForward = b;
    }

    public String getQueryString() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getQueryString();
        }
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void pushException(Throwable th) {
        this._exceptionStack.push(th);
    }

    public void setWebApp(WebApp app) {
        this._webapp = app;
        if (this.reqContext != null) {
            this.reqContext.setCurrWebAppBoundary(app);
        }
    }

    public void setContextPath(String _contextPath) {
        this._contextPath = _contextPath;
    }

    public boolean isEnforceSecurity() {
        return this.enforceSecurity;
    }

    public void setEnforceSecurity(boolean enforceSecurity) {
        this.enforceSecurity = enforceSecurity;
    }

    public void setDecodedReqUri(String decodedURI) {
        this.decodedReqUri = decodedURI;
    }

    public String getDecodedReqUri() {
        return this.decodedReqUri;
    }

    public boolean isSecurityEnabledForApplication() {
        return SecurityContext.isSecurityEnabled();
    }

    public void dumpDispatchContextHierarchy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "dumpDispatchContextHierarchy", "current context -->" + this);
            WebAppDispatcherContext tmpParentContext = this.parentContext;
            while (tmpParentContext != null) {
                logger.logp(Level.FINE, CLASS_NAME, "dumpDispatchContextHierarchy", "parent context -->" + tmpParentContext);
                tmpParentContext = tmpParentContext.parentContext;
            }
        }
    }

    public Object clone(SRTServletRequest clonedRequest, SRTRequestContext clonedReqContext) throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", "clone entry");
        }
        WebAppDispatcherContext _cloneDispatchContext = (WebAppDispatcherContext)super.clone();
        _cloneDispatchContext._request = clonedRequest;
        _cloneDispatchContext.reqContext = clonedReqContext;
        if (this._servletReferenceStack != null) {
            _cloneDispatchContext._servletReferenceStack = (UnsynchronizedStack)this._servletReferenceStack.clone();
        }
        if (this._exceptionStack != null) {
            _cloneDispatchContext._exceptionStack = (UnsynchronizedStack)this._exceptionStack.clone();
        }
        if (this.parentContext != null) {
            _cloneDispatchContext.parentContext = (WebAppDispatcherContext)this.parentContext.clone(clonedRequest, clonedReqContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", "clone exit original -->" + this + " cloned -->" + _cloneDispatchContext);
        }
        return _cloneDispatchContext;
    }

    public boolean hasSlashStarMapping() {
        HashMap mappings;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "hasSlashStarMapping");
        }
        boolean isSlashStar = false;
        WebAppConfiguration webAppConfig = null;
        WebApp webApp = this._webapp;
        if (webApp != null) {
            webAppConfig = webApp.getConfiguration();
        }
        if (webAppConfig != null && (mappings = webAppConfig.getServletMappings()) != null) {
            Set keys = mappings.keySet();
            Iterator iter = keys.iterator();
            block0: while (iter.hasNext()) {
                List list = (List)mappings.get(iter.next());
                if (list == null) continue;
                for (ServletMapping map : list) {
                    if (map == null || !"/*".equals(map.getUrlPattern())) continue;
                    isSlashStar = true;
                    continue block0;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "hasSlashStarMapping isSlashStar: " + isSlashStar);
        }
        return isSlashStar;
    }

    public void setPossibleSlashStarMapping(boolean isPossible) {
        this.possibleSlashStarMapping = isPossible;
    }

    public boolean isPossibleSlashStarMapping() {
        return this.possibleSlashStarMapping;
    }

    public void setFireRequestEvents(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setFireRequestEvents", "setting to->" + b);
        }
        this.fireRequestEvents = b;
    }

    public boolean isFireRequestEvents() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isFireRequestEvents", "fireRequestEvents->" + this.fireRequestEvents + ", parentContext->" + this.parentContext + ", parentContext.parentContext->" + (this.parentContext == null ? null : this.parentContext.parentContext));
        }
        if (this.parentContext != null && this.parentContext.parentContext == null) {
            return this.parentContext.isFireRequestEvents();
        }
        return this.fireRequestEvents;
    }
}

