/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.sm.client.ui.NLS;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DirectoryBrowsingServlet
extends HttpServlet {
    private static final long serialVersionUID = 3258125864872195895L;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String title = "Index of ";
        String dirName = (String)req.getAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path");
        String reqURI = (String)req.getAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri");
        if (!reqURI.endsWith("/")) {
            reqURI = reqURI + '/';
        }
        title = title + reqURI;
        File dir = new File(dirName);
        if (!dir.canRead()) {
            resp.sendError(404, nls.getString("File.not.found", "File not found"));
        }
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println("<HTML><HEAD><TITLE>");
        out.println(title);
        out.println("</TITLE></HEAD><BODY>");
        out.println("<H1 align=\"left\">" + title + "</H1>");
        out.println("<HR size=\"3\"><TABLE cellpadding=\"2\"><TBODY><TR bgcolor=\"#d7ffff\">");
        out.println("<TH width=\"250\" nowrap><P align=\"left\">Name</P></TH>");
        out.println("<TH width=\"250\" nowrap><P align=\"left\">Last Modified</P></TH>");
        out.println("<TH width=\"150\" nowrap><P align=\"left\">Size</P></TH>");
        out.println("<TH width=\"300\" nowrap><P align=\"left\">Description</P></TH></TR>");
        this.fillTableRows(dir, reqURI, out);
        out.println("</TBODY></TABLE></BODY></HTML>");
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void fillTableRows(File dir, String reqURI, PrintWriter out) {
        File[] files = dir.listFiles();
        int fc = 0;
        while (fc < files.length) {
            Date date;
            if (files[fc].isDirectory()) {
                if (files[fc].getName().equalsIgnoreCase("META-INF") || files[fc].getName().equalsIgnoreCase("WEB-INF")) {
                    ++fc;
                    continue;
                }
                out.println("<TR><TD nowrap>");
                out.println("<A href=\"" + reqURI + files[fc].getName() + "\">");
                out.println("<B>" + files[fc].getName() + "</B></A></TD>");
                date = new Date(files[fc].lastModified());
                out.println("<TD nowrap>" + date.toString() + "</TD>");
                out.println("<TD nowrap>-</TD><TD nowrap>Directory</TD></TR>");
            } else {
                if (files[fc].getName().endsWith(".jsp") || files[fc].getName().endsWith(".jsv") || files[fc].getName().endsWith(".jsw")) {
                    ++fc;
                    continue;
                }
                out.println("<TR><TD nowrap>");
                out.println("<A href=\"" + reqURI + files[fc].getName() + "\">");
                out.println(files[fc].getName() + "</A></TD>");
                date = new Date(files[fc].lastModified());
                out.println("<TD nowrap>" + date.toString() + "</TD>");
                out.println("<TD nowrap>" + files[fc].length() + "</TD>");
                out.println("<TD nowrap>File</TD></TR>");
            }
            ++fc;
        }
    }
}

