/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.PersistenceContextRef;
import org.eclipse.jst.j2ee.common.PersistenceUnitRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.MethodParams;
import org.eclipse.jst.j2ee.ejb.NamedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WCCMHelper {
    private static final String CLASS_NAME = WCCMHelper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");

    public static String[] getJavaClassNames(List<JavaClass> classes) {
        String[] classNames = new String[classes.size()];
        int i = 0;
        for (JavaClass currentClass : classes) {
            classNames[i] = currentClass.getQualifiedName();
            ++i;
        }
        return classNames;
    }

    public static Method findMethod(NamedMethod beanMethod, Method[] allMethods) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findMethod");
        }
        String methodName = beanMethod.getMethodName();
        MethodParams parms = beanMethod.getMethodParams();
        List parmList = new ArrayList();
        if (parms != null) {
            EList list = parms.getMethodParam();
            parmList = list;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "NamedMethod method name = " + methodName + ", parameter list = " + parmList);
        }
        Method targetMethod = null;
        for (Method m : allMethods) {
            if (!m.getName().equals(methodName)) continue;
            targetMethod = m;
            Class<?>[] parmTypes = m.getParameterTypes();
            if (parmTypes.length != parmList.size()) {
                targetMethod = null;
            } else if (parmTypes.length > 0) {
                int i = 0;
                for (String s : parmList) {
                    String parmClassName;
                    Class<?> c;
                    if ((c = parmTypes[i++]).isArray()) {
                        c = c.getComponentType();
                    }
                    if (s.equals(parmClassName = c.isPrimitive() ? c.toString() : c.getName())) continue;
                    targetMethod = null;
                    break;
                }
            }
            if (targetMethod == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "returning: " + targetMethod.toGenericString());
            }
            return targetMethod;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, methodName + " not found, returning null");
        }
        return null;
    }

    public static String methodSignature(String methodName, List<String> parmList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "methodSignature", methodName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append(":");
        boolean appendComma = false;
        for (String parm : parmList) {
            if (appendComma) {
                sb.append(",");
            } else {
                appendComma = true;
            }
            sb.append(parm);
        }
        String signature = sb.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "methodSignature", signature);
        }
        return signature;
    }

    public static final String normalizeSignature(String deplDescriptorSignature) {
        StringBuilder theSignature = new StringBuilder(deplDescriptorSignature);
        int scanIndex = 0;
        while (scanIndex < theSignature.length()) {
            if (theSignature.charAt(scanIndex) == ' ') {
                char next = theSignature.charAt(scanIndex + 1);
                if (next == ' ' | next == '[' | next == ']') {
                    theSignature.deleteCharAt(scanIndex);
                    continue;
                }
                ++scanIndex;
                continue;
            }
            ++scanIndex;
        }
        return theSignature.toString();
    }

    public static ArrayList<PersistenceContextRef> addAllPersistenceContextEList(EList elist, ArrayList<PersistenceContextRef> alist) {
        int elistSize;
        ArrayList<PersistenceContextRef> refList = alist;
        int n = elistSize = elist != null ? elist.size() : 0;
        if (elistSize > 0) {
            if (refList == null) {
                refList = new ArrayList(elistSize);
            }
            EList list = elist;
            for (PersistenceContextRef ref : list) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAllPersistenceContextEList adding: " + ref);
                }
                refList.add(ref);
            }
        }
        return refList;
    }

    public static ArrayList<PersistenceUnitRef> addAllPersistenceUnitEList(EList elist, ArrayList<PersistenceUnitRef> aList) {
        int elistSize;
        ArrayList<PersistenceUnitRef> refList = aList;
        int n = elistSize = elist != null ? elist.size() : 0;
        if (elistSize > 0) {
            if (refList == null) {
                refList = new ArrayList(elistSize);
            }
            EList list = elist;
            for (PersistenceUnitRef ref : list) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAllPersistenceUnitEList adding: " + ref);
                }
                refList.add(ref);
            }
        }
        return refList;
    }

    public static ArrayList<EjbRef> addAllEjbRefEList(EList elist, ArrayList<EjbRef> aList) {
        int elistSize;
        ArrayList<EjbRef> refList = aList;
        int n = elistSize = elist != null ? elist.size() : 0;
        if (elistSize > 0) {
            if (refList == null) {
                refList = new ArrayList(elistSize);
            }
            EList list = elist;
            for (EjbRef ref : list) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAllEJBRefEList adding: " + ref);
                }
                refList.add(ref);
            }
        }
        return refList;
    }

    public static ArrayList<EJBLocalRef> addAllEJBLocalRefEList(EList eList, ArrayList<EJBLocalRef> aList) {
        int elistSize;
        ArrayList<EJBLocalRef> refList = aList;
        int n = elistSize = eList != null ? eList.size() : 0;
        if (elistSize > 0) {
            if (refList == null) {
                refList = new ArrayList(elistSize);
            }
            EList list = eList;
            for (EJBLocalRef ref : list) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAllEJBLocalRefEList adding: " + ref);
                }
                refList.add(ref);
            }
        }
        return refList;
    }

    public static ArrayList<ResourceRef> addAllResourceRefEList(EList eList, ArrayList<ResourceRef> aList) {
        int elistSize;
        ArrayList<ResourceRef> refList = aList;
        int n = elistSize = eList != null ? eList.size() : 0;
        if (elistSize > 0) {
            if (refList == null) {
                refList = new ArrayList(elistSize);
            }
            EList list = eList;
            for (ResourceRef ref : list) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAllResourceRefEList adding: " + ref);
                }
                refList.add(ref);
            }
        }
        return refList;
    }

    public static ArrayList<ResourceEnvRef> addAllResourceEnvRefEList(EList eList, ArrayList<ResourceEnvRef> aList) {
        int elistSize;
        ArrayList<ResourceEnvRef> refList = aList;
        int n = elistSize = eList != null ? eList.size() : 0;
        if (elistSize > 0) {
            if (refList == null) {
                refList = new ArrayList(elistSize);
            }
            EList list = eList;
            for (ResourceEnvRef ref : list) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAllResourceEnvRefEList adding: " + ref);
                }
                refList.add(ref);
            }
        }
        return refList;
    }

    public static ArrayList<MessageDestinationRef> addAllMessageDestinationRefEList(EList eList, ArrayList<MessageDestinationRef> aList) {
        int elistSize;
        ArrayList<MessageDestinationRef> refList = aList;
        int n = elistSize = eList != null ? eList.size() : 0;
        if (elistSize > 0) {
            if (refList == null) {
                refList = new ArrayList(elistSize);
            }
            EList list = eList;
            for (MessageDestinationRef ref : list) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAllMessageDestinationRefEList adding: " + ref);
                }
                refList.add(ref);
            }
        }
        return refList;
    }

    public static ArrayList<EnvEntry> addAllEnvEntries(EList eList, ArrayList<EnvEntry> aList) {
        int elistSize;
        ArrayList<EnvEntry> refList = aList;
        int n = elistSize = eList != null ? eList.size() : 0;
        if (elistSize > 0) {
            if (refList == null) {
                refList = new ArrayList(elistSize);
            }
            EList list = eList;
            for (EnvEntry ref : list) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addAllMessageDestinationRefEList adding: " + ref);
                }
                refList.add(ref);
            }
        }
        return refList;
    }

    public static EJBJar getDeploymentDescriptor(EJBJarFile ejbJarFile, boolean merged) {
        EJBJar ejbJar = null;
        if (ejbJarFile != null) {
            block11: {
                try {
                    EARFile earFile = ejbJarFile.getEARFile();
                    if (earFile != null) {
                        Module ejbModule = earFile.getModule(ejbJarFile.getURI());
                        ejbJar = (EJBJar)earFile.getDeploymentDescriptor(ejbModule, merged);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDeploymentDescriptor : no EARFile");
                    }
                }
                catch (FileNotFoundException fnfex) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDeploymentDescriptor : no DD : " + fnfex);
                    }
                }
                catch (Throwable ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getDeploymentDescriptor"), (String)"607", (Object)ejbJarFile);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "getDeploymentDescriptor : no DD : " + ex);
                }
            }
            if (ejbJar == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDeploymentDescriptor : obtaining from jar");
                }
                ejbJar = ejbJarFile.getDeploymentDescriptor(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getDeploymentDescriptor : " + ejbJar);
        }
        return ejbJar;
    }
}

