/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.ConflictingArgsAreNotSetValidator;
import com.ibm.ws.ssl.utils.ProfileKeystoreUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportCertKSTypeValidator
extends ConflictingArgsAreNotSetValidator {
    private final String S_KEY_INVALID_KEYSTORE_TYPE = "ImportCertKSTypeValidator.invalid.keystoreType";
    private static final Logger LOGGER = LoggerFactory.createLogger(ImportCertKSTypeValidator.class);
    private static final String S_CLASS_NAME = ImportCertKSTypeValidator.class.getName();

    public ImportCertKSTypeValidator() {
        if (this.getValidatorArgKey() != null) {
            if (this.getValidatorArgKey().equals("importPersonalCertKSType")) {
                this.m_asConflictingArgs = new String[]{"personalCertDN"};
            } else if (this.getValidatorArgKey().equals("importSigningCertKSType")) {
                this.m_asConflictingArgs = new String[]{"signingCertDN"};
            }
        }
        this.S_KEY_INVALID_KEYSTORE_TYPE = "ImportCertKSTypeValidator.invalid.keystoreType";
    }

    public boolean runValidator() {
        boolean result;
        block4: {
            LOGGER.entering(S_CLASS_NAME, "runValidator");
            result = false;
            try {
                ArrayList alValidKeyStoreTypes = ProfileKeystoreUtils.getKeyStoreTypes();
                if (this.sValidatorArgValue == null) break block4;
                for (int i = 0; i < alValidKeyStoreTypes.size(); ++i) {
                    if (!this.sValidatorArgValue.equals((String)alValidKeyStoreTypes.get(i))) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception ex) {
                result = false;
            }
        }
        if (!result) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("ImportCertKSTypeValidator.invalid.keystoreType", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        LOGGER.exiting(S_CLASS_NAME, "runValidator");
        return result;
    }
}

