/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.registry;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileEmptyTemplate;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileRegistrySnippetMarshaller {
    private static final String S_TAG_PROFILES = "profiles";
    private static final String S_TAG_PROFILE = "profile";
    private static final String S_TAG_AUGMENTOR = "augmentor";
    private static final String S_ATTR_IS_DEFAULT = "isDefault";
    private static final String S_ATTR_IS_A_RESERVATION_TICKET = "isAReservationTicket";
    private static final String S_ATTR_NAME = "name";
    private static final String S_ATTR_PATH = "path";
    private static final String S_ATTR_TEMPLATE = "template";
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";
    private static final String S_INVALID_NUMBER_OF_PROFILES_IN_SNIPPET = "An invalid number of profiles exist in the profile registry snippet.";
    private static final String S_INVALID_NUMBER_OF_PROFILES_IN_SNIPPET_KEY = "WSProfile.ProfileRegistrySnippetMarshaller.invalidNumberOfProfiles";
    private static final Logger LOGGER = LoggerFactory.createLogger(ProfileRegistrySnippetMarshaller.class);
    private static final String S_CLASS_NAME = ProfileRegistrySnippetMarshaller.class.getName();

    public static void writeProfileToRegistrySnippetFile(Profile profile, File fileRegistrySnippet) throws WSProfileException {
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
            Document document = documentbuilder.newDocument();
            Element elementRoot = document.createElement(S_TAG_PROFILES);
            Element elementProfile = ProfileRegistrySnippetMarshaller.marshallThisProfileToDOM(profile, document);
            elementRoot.appendChild(elementProfile);
            document.appendChild(elementRoot);
            ProfileRegistrySnippetMarshaller.saveDocumentToProfileRegistry(document, fileRegistrySnippet);
        }
        catch (ParserConfigurationException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    public static Profile readProfileFromRegistrySnippetInputStream(InputStream is) throws WSProfileException {
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        try {
            Document document = documentbuilderfactory.newDocumentBuilder().parse(is);
            Vector listProfiles = ProfileRegistrySnippetMarshaller.readProfileRegistryFromDOM(document);
            if (listProfiles.size() != 1) {
                throw new WSProfileException(S_INVALID_NUMBER_OF_PROFILES_IN_SNIPPET, ResourceBundleUtils.getLocaleString(S_INVALID_NUMBER_OF_PROFILES_IN_SNIPPET_KEY), true);
            }
            return (Profile)listProfiles.get(0);
        }
        catch (Exception e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    public static boolean deleteProfileRegistrySnippet(File fileRegistrySnippet) {
        return fileRegistrySnippet.delete();
    }

    private static Vector readProfileRegistryFromDOM(Document document) throws WSProfileException {
        NodeList nodelistProfiles = document.getElementsByTagName(S_TAG_PROFILE);
        return ProfileRegistrySnippetMarshaller.unmarshallProfilesFromDOM(nodelistProfiles);
    }

    private static Vector<Profile> unmarshallProfilesFromDOM(NodeList nodelistProfiles) {
        Vector<Profile> vprofiles = new Vector<Profile>();
        for (int i = 0; i < nodelistProfiles.getLength(); ++i) {
            WSProfileTemplate wspeCreate;
            Node nodeProfileThis = nodelistProfiles.item(i);
            boolean fIsDefault = Boolean.valueOf(nodeProfileThis.getAttributes().getNamedItem(S_ATTR_IS_DEFAULT).getNodeValue());
            Node node = nodeProfileThis.getAttributes().getNamedItem(S_ATTR_IS_A_RESERVATION_TICKET);
            boolean fIsAReservationTicket = Boolean.valueOf(node == null ? "false" : node.getNodeValue());
            String sName = nodeProfileThis.getAttributes().getNamedItem(S_ATTR_NAME).getNodeValue();
            String sPath = nodeProfileThis.getAttributes().getNamedItem(S_ATTR_PATH).getNodeValue();
            String sTemplate = nodeProfileThis.getAttributes().getNamedItem(S_ATTR_TEMPLATE).getNodeValue();
            try {
                wspeCreate = new WSProfileTemplate(sTemplate);
            }
            catch (WSProfileException wspe) {
                wspeCreate = new WSProfileEmptyTemplate(sTemplate);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallProfilesFromDOM", "The profile template located at " + sTemplate + " failed to instantiate. It is possible that the template" + " is not present on the file system, or the metadata is corrupt. The" + " registry will proceed to be read as usual");
            }
            Profile profileThis = new Profile(sName, new File(sPath), wspeCreate, fIsDefault, fIsAReservationTicket);
            ProfileRegistrySnippetMarshaller.unmarshallAugmentorsForThisProfile(nodeProfileThis, profileThis);
            vprofiles.add(profileThis);
        }
        return vprofiles;
    }

    private static Element marshallThisProfileToDOM(Profile profileThis, Document document) {
        Element elementProfile = document.createElement(S_TAG_PROFILE);
        elementProfile.setAttribute(S_ATTR_IS_DEFAULT, Boolean.toString(profileThis.isDefault()));
        elementProfile.setAttribute(S_ATTR_IS_A_RESERVATION_TICKET, Boolean.toString(profileThis.isAReservationTicket()));
        elementProfile.setAttribute(S_ATTR_NAME, profileThis.getName());
        elementProfile.setAttribute(S_ATTR_PATH, profileThis.getPath().getAbsolutePath());
        elementProfile.setAttribute(S_ATTR_TEMPLATE, profileThis.getWSProfileTemplateRelaxed().getProfileTemplatePath().getAbsolutePath());
        List<WSProfileTemplate> listAugmentors = profileThis.getAugmentationTemplatesRelaxed();
        for (WSProfileTemplate wsptThis : listAugmentors) {
            String sAugmentorPath = wsptThis.getProfileTemplatePath().getAbsolutePath();
            Element elementAugmentorThis = document.createElement(S_TAG_AUGMENTOR);
            elementAugmentorThis.setAttribute(S_ATTR_TEMPLATE, sAugmentorPath);
            elementProfile.appendChild(elementAugmentorThis);
        }
        return elementProfile;
    }

    private static void unmarshallAugmentorsForThisProfile(Node nodeProfileThis, Profile profileThis) {
        Element elementProfileThis = (Element)nodeProfileThis;
        NodeList nodelistAugmentors = elementProfileThis.getElementsByTagName(S_TAG_AUGMENTOR);
        for (int i = 0; i < nodelistAugmentors.getLength(); ++i) {
            WSProfileTemplate wspeAugment;
            Node nodeAugmentorThis = nodelistAugmentors.item(i);
            String sAugmentorPath = nodeAugmentorThis.getAttributes().getNamedItem(S_ATTR_TEMPLATE).getNodeValue();
            try {
                wspeAugment = new WSProfileTemplate(sAugmentorPath);
            }
            catch (WSProfileException wspe) {
                wspeAugment = new WSProfileEmptyTemplate(sAugmentorPath);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "unmarshallAugmentorsForThisProfile", "The profile template located at " + sAugmentorPath + " failed to instantiate. It is possible that the template" + " is not present on the file system, or the metadata is corrupt. The registry" + " will be read as usual.");
            }
            profileThis.addAugmentor(wspeAugment);
        }
    }

    private static void saveDocumentToProfileRegistry(Document document, File fileRegistrySnippet) throws WSProfileException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domsource = new DOMSource(document);
            StreamResult streamresult = new StreamResult(fileRegistrySnippet);
            transformer.setOutputProperty("indent", S_YES);
            transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
            transformer.transform(domsource, streamresult);
        }
        catch (TransformerConfigurationException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        catch (TransformerException e) {
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
    }
}

