/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.datastore.WSProfileJobGroupData;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValidateAndBuildTemplateStackPreProcessorTask
extends WSProfileProcessorTask {
    private boolean m_fIsNoJobGroupsOk = false;
    private static Logger LOGGER = LoggerFactory.createLogger(ValidateAndBuildTemplateStackPreProcessorTask.class);
    private static String S_CLASS_NAME = ValidateAndBuildTemplateStackPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileDataStore.getFlowControllingModeInvoker();
        Map<String, List> mSpecifiedArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        Vector vsProfileName = (Vector)mSpecifiedArgs.get("profileName");
        Vector vsTemplatePath = (Vector)mSpecifiedArgs.get("templatePath");
        String sProfileName = "";
        String sMode = wspclimiFlowControlling.getModeFlag();
        if (vsProfileName != null && vsProfileName.size() > 0) {
            sProfileName = (String)vsProfileName.get(0);
        }
        if (WSProfile.isAllMode(sMode)) {
            Hashtable htTemplateStacks = (Hashtable)PrereqTemplateUtils.getMapOfTemplatesForAllMode(sMode, vsTemplatePath);
            Enumeration enumOnTemplateStacks = htTemplateStacks.elements();
            Enumeration enumOnProfileName = htTemplateStacks.keys();
            while (enumOnProfileName.hasMoreElements() && enumOnTemplateStacks.hasMoreElements()) {
                WSProfileJobGroupData wspjgdNew = new WSProfileJobGroupData(CommandLineArgumentsUtils.createArgsForAllMode(sMode, (String)enumOnProfileName.nextElement(), vsTemplatePath, mSpecifiedArgs));
                wspjgdNew.setTemplateStack((Vector)enumOnTemplateStacks.nextElement());
                WSProfileDataStore.addJobGroup(wspjgdNew);
            }
            if (WSProfileDataStore.getNumberOfJobGroupsInDataStore() == 0) {
                block10: {
                    try {
                        Vector vsAllProfiles = (Vector)WSProfile.listProfileNames();
                        if (sMode.equals("deleteAll")) {
                            this.m_fIsNoJobGroupsOk = vsAllProfiles != null && vsAllProfiles.size() == 0;
                            break block10;
                        }
                        if (!sMode.equals("unaugmentAll")) break block10;
                        if (vsAllProfiles != null && vsAllProfiles.size() == 0) {
                            this.m_fIsNoJobGroupsOk = true;
                            break block10;
                        }
                        this.m_fIsNoJobGroupsOk = true;
                        for (int i = 0; i < vsAllProfiles.size(); ++i) {
                            if (!WSProfile.getProfile((String)vsAllProfiles.get(i)).getAugmentationTemplates().contains(new WSProfileTemplate(new File((String)WSProfileDataStore.getFlowControllingArgsAsMap().get("templatePath").get(0))))) continue;
                            this.m_fIsNoJobGroupsOk = false;
                            break;
                        }
                    }
                    catch (WSProfileException wspEx) {
                        LogUtils.logException(LOGGER, wspEx);
                        this.m_fIsNoJobGroupsOk = false;
                    }
                }
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "runProcessor", "The 'All' mode " + sMode + " has no job group" + " and the validity of this is: " + this.m_fIsNoJobGroupsOk);
            }
        } else {
            WSProfileJobGroupData wspjgdNew = new WSProfileJobGroupData(mSpecifiedArgs);
            wspjgdNew.setTemplateStack((Vector)PrereqTemplateUtils.getListOfTemplatesForMode(sMode, sProfileName, vsTemplatePath));
            WSProfileDataStore.addJobGroup(wspjgdNew);
        }
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    public boolean checkPostconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPostconditions");
        String sProfileName = new String();
        if (WSProfileDataStore.getNumberOfJobGroupsInDataStore() == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPostconditions", "checkPostconditions = " + this.m_fIsNoJobGroupsOk);
            LOGGER.exiting(S_CLASS_NAME, "checkPostconditions");
            return this.m_fIsNoJobGroupsOk;
        }
        for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
            Vector vwsptTemplateStack = (Vector)WSProfileDataStore.getJobGroup(i).getTemplateStack();
            if (vwsptTemplateStack != null && vwsptTemplateStack.size() > 0) continue;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "checkPostconditions", "Failed postcondition check: the stack of templates created was either null or empty for a particular group");
            WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileDataStore.getJobGroup(i).getCurrentModeInvoker();
            Map<String, List> mSpecifiedArgs = WSProfileDataStore.getJobGroup(i).getCurrentArgsAsMap();
            Vector vsProfileName = (Vector)mSpecifiedArgs.get("profileName");
            if (vsProfileName != null && vsProfileName.size() > 0) {
                sProfileName = (String)vsProfileName.get(0);
            }
            if (sProfileName == null || sProfileName.equals("")) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "checkPostconditions", "The profileName has not been specified.");
            } else if (sProfileName != null) {
                try {
                    WSProfile.getProfile(sProfileName);
                }
                catch (WSProfileException wspEx) {
                    LogUtils.logException(LOGGER, wspEx);
                }
            }
            if (wspclimiFlowControlling != null && wspclimiFlowControlling.getModeFlag().equals("augment")) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "checkPostconditions", "Current mode is:" + wspclimiFlowControlling.getModeFlag() + ".  It is possible that the augmenting template(s) being applied to [" + sProfileName + "] have already been applied or that the profile " + sProfileName + " does not exist.");
            } else if (wspclimiFlowControlling != null && wspclimiFlowControlling.getModeFlag().equals("unaugment")) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "checkPostconditions", "Current mode is:" + wspclimiFlowControlling.getModeFlag() + ".  It is possible that other augmented templates have dependencies on the " + "template being un-augmented or that the profile " + sProfileName + " does not exist.");
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPostconditions", "checkPostconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPostconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPostconditions", "checkPostconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPostconditions");
        return true;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileDataStore.getFlowControllingModeInvoker();
        Map<String, List> mSpecifiedArgs = WSProfileDataStore.getFlowControllingArgsAsMap();
        if (wspclimiFlowControlling == null || mSpecifiedArgs == null || mSpecifiedArgs.size() <= 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        WSProfileCLIModeInvoker wspclimiFlowControlling = WSProfileDataStore.getFlowControllingModeInvoker();
        if (!WSProfileDataStore.isHelpRequested() && wspclimiFlowControlling != null && wspclimiFlowControlling.isTemplateStackRequired()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = true");
            LOGGER.exiting(S_CLASS_NAME, "doIRun");
            return true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false");
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return false;
    }
}

