/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.WSProfileUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemplatePathDefaultingPreProcessorTask
extends WSProfileProcessorTask {
    private static final Logger LOGGER = LoggerFactory.createLogger(TemplatePathDefaultingPreProcessorTask.class);
    private static final String S_CLASS_NAME = TemplatePathDefaultingPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        WSProfileCLIModeInvoker wspclimi = WSProfileDataStore.getFlowControllingModeInvoker();
        String[] saArgs = WSProfileDataStore.getFlowControllingArgsAsArray();
        String[] saTemplatePaths = WSProfileUtils.getValuesForParam(saArgs, "templatePath");
        String[] saNewArgs = new String[saArgs.length];
        saNewArgs = (saTemplatePaths == null || saTemplatePaths.length <= 0) && wspclimi.getModeFlag().equals("create") && !WSProfileDataStore.isArgSpecified("help") ? WSProfileUtils.addTemplatePathDefault(saArgs) : WSProfileUtils.convertTemplatePathShortFormToProperPath(saArgs);
        WSProfileDataStore.setFlowControllingArgs(saNewArgs);
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        boolean result = false;
        WSProfileCLIModeInvoker wspclimi = WSProfileDataStore.getFlowControllingModeInvoker();
        String[] saArgs = WSProfileDataStore.getFlowControllingArgsAsArray();
        if (WSProfileUtils.isTemplateDefaultingNecessary(wspclimi, saArgs)) {
            result = true;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = " + result);
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return result;
    }
}

