/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.datastore.WSProfileJobGroupData;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictCommandLineValidationPreProcessor
extends WSProfileProcessorTask {
    private static final String S_COLON = ":";
    private static final String S_TAB = "\t";
    private static final String S_NEWLINE = "\n";
    private static final String S_NOT_REGISTERED_ARGS = "strictCommandLineValidation.output";
    private static final String S_CLASS_NAME = StrictCommandLineValidationPreProcessor.class.getName();
    public static final Logger LOGGER = LoggerFactory.createLogger(StrictCommandLineValidationPreProcessor.class);

    @Override
    public boolean doIRun() {
        LOGGER.entering(StrictCommandLineValidationPreProcessor.class.getName(), "doIRun");
        boolean fReturn = true;
        if (!WSProfileDataStore.isArgSpecified("disableCommandLineValidation") && !WSProfileDataStore.isHelpRequested()) {
            for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
                WSProfileJobGroupData wspjgdForExecution = WSProfileDataStore.getJobGroup(i);
                List<WSProfileTemplate> lwsptTemplateStack = wspjgdForExecution.getTemplateStack();
                for (int j = 0; j < lwsptTemplateStack.size(); ++j) {
                    WSProfileTemplate wsptThis = lwsptTemplateStack.get(j);
                    fReturn = fReturn && wsptThis.isStrictCLIValidationFlagEnabled();
                }
            }
        } else {
            return false;
        }
        LOGGER.exiting(StrictCommandLineValidationPreProcessor.class.getName(), "doIRun");
        return fReturn;
    }

    @Override
    public boolean runProcessor() {
        LOGGER.entering(StrictCommandLineValidationPreProcessor.class.getName(), "runProcessor");
        Map<String, List> mapIncommingArgs = WSProfileDataStore.getIncomingArgsAsMap();
        Map<String, List> mNotRegisteredArgs = WSProfileDataStore.getIncomingArgsAsMap();
        Hashtable mapAllArgumentKeys = new Hashtable();
        if (WSProfileDataStore.isAllMode() || WSProfileDataStore.getNumberOfJobGroupsInDataStore() == 0) {
            Vector listFlowControllingArguments = WSProfileDataStore.getFlowControllingModeInvoker().getListOfAllCommandLineArguments();
            mapAllArgumentKeys.putAll((Hashtable)CommandLineArgument.convertCommandLineArgumentListToMap(listFlowControllingArguments));
        }
        if (WSProfileDataStore.isResponseFileSpecified()) {
            mapIncommingArgs.putAll(WSProfileDataStore.getResponseFileArgsAsMap());
            mNotRegisteredArgs.putAll(WSProfileDataStore.getResponseFileArgsAsMap());
            Vector listResponseFileArguments = WSProfileDataStore.getIncomingModeInvoker().getListOfAllCommandLineArguments();
            mapAllArgumentKeys.putAll((Hashtable)CommandLineArgument.convertCommandLineArgumentListToMap(listResponseFileArguments));
        }
        if (WSProfileDataStore.getNumberOfJobGroupsInDataStore() > 0) {
            for (int i = 0; i < WSProfileDataStore.getNumberOfJobGroupsInDataStore(); ++i) {
                WSProfileJobGroupData wspjgdForExecution = WSProfileDataStore.getJobGroup(i);
                WSProfileCLIModeInvoker wspclimiForExecution = wspjgdForExecution.getCurrentModeInvoker();
                Vector listAllCommandLineArguments = wspclimiForExecution.getListOfAllCommandLineArguments();
                mapAllArgumentKeys.putAll((Hashtable)CommandLineArgument.convertCommandLineArgumentListToMap(listAllCommandLineArguments));
            }
        }
        for (String sIncommingArgKey : mapIncommingArgs.keySet()) {
            if (!mapAllArgumentKeys.containsKey(sIncommingArgKey)) continue;
            mNotRegisteredArgs.remove(sIncommingArgKey);
        }
        mNotRegisteredArgs = this.removeAdditionalAllowableArguments(mNotRegisteredArgs);
        LOGGER.exiting(StrictCommandLineValidationPreProcessor.class.getName(), "runProcessor");
        return this.areAllArgumentsRegistered(mNotRegisteredArgs);
    }

    private boolean areAllArgumentsRegistered(Map<String, List> mapOfUnregisteredArgs) {
        LOGGER.entering(StrictCommandLineValidationPreProcessor.class.getName(), "areAllArgumentsRegistered");
        if (mapOfUnregisteredArgs.isEmpty()) {
            LOGGER.exiting(StrictCommandLineValidationPreProcessor.class.getName(), "areAllArgumentsRegistered");
            return true;
        }
        OutputStreamHandler.println(S_NEWLINE + ResourceBundleUtils.getLocaleString(S_NOT_REGISTERED_ARGS));
        for (String sIncommingArgKey : mapOfUnregisteredArgs.keySet()) {
            OutputStreamHandler.println(S_TAB + sIncommingArgKey + S_COLON);
        }
        LOGGER.exiting(StrictCommandLineValidationPreProcessor.class.getName(), "areAllArgumentsRegistered");
        return false;
    }

    private String[] getAdditionalAllowableCommandLineArguments() {
        LOGGER.entering(StrictCommandLineValidationPreProcessor.class.getName(), "getAdditionalAllowableCommandLineArguments");
        String sAdditionalArgs = "";
        try {
            sAdditionalArgs = new WSProfileProperties().getProperty("WS_WSPROFILE_ADDITIONAL_COMMAND_LINE_ARGUMENTS");
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String[] sAdditionalArgsList = sAdditionalArgs.split(";");
        LOGGER.exiting(StrictCommandLineValidationPreProcessor.class.getName(), "getAdditionalAllowableCommandLineArguments");
        return sAdditionalArgsList;
    }

    private Map<String, List> removeAdditionalAllowableArguments(Map<String, List> mNotRegisteredArgs) {
        LOGGER.entering(StrictCommandLineValidationPreProcessor.class.getName(), "removeAdditionalAllowableArguments");
        String[] saAllowableArgs = this.getAdditionalAllowableCommandLineArguments();
        for (int i = 0; i < saAllowableArgs.length; ++i) {
            if (!mNotRegisteredArgs.containsKey(saAllowableArgs[i])) continue;
            LOGGER.logp(Level.FINEST, S_CLASS_NAME, "removeAdditionalAllowableArguments", saAllowableArgs[i] + " was allowed as a generic argument");
            mNotRegisteredArgs.remove(saAllowableArgs[i]);
        }
        LOGGER.exiting(StrictCommandLineValidationPreProcessor.class.getName(), "removeAdditionalAllowableArguments");
        return mNotRegisteredArgs;
    }
}

