/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.actionengine.Environment;
import com.ibm.ws.install.configmanager.launcher.OutputStreamHandler;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.TargetPlatform;
import com.ibm.ws.install.configmanager.utils.CurrentEnvironment;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteEnvironmentPreProcessorTask
extends WSProfileProcessorTask {
    private static String S_ARG_REQUIRED = "arg.required";
    private static String S_ARG_CANNOT_BE_EMPTY = "arg.cannot.be.empty";
    private static String S_ARG_VALUE_NOT_RECOGNIZED = "arg.value.not.recognized";
    private static String S_COMMA = ",";
    private static String S_SPACE = " ";
    private static Logger LOGGER = LoggerFactory.createLogger(RemoteEnvironmentPreProcessorTask.class);
    private static String S_CLASS_NAME = RemoteEnvironmentPreProcessorTask.class.getName();

    public boolean runProcessor() throws IOException {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        if (WSProfileDataStore.isHelpRequested() || WSProfileDataStore.isArgSpecified("remote")) {
            System.setProperty("remoteOS", WSProfileDataStore.getFlowControllingArgumentValue("remoteOS"));
        }
        if (WSProfileDataStore.isArgSpecified("remote")) {
            System.setProperty("remote", WSProfileDataStore.getFlowControllingArgumentValue("remote"));
            if (!this.validateRemoteArg()) {
                return false;
            }
            if (!this.validateRemoteArgsAreSet()) {
                return false;
            }
            if (!this.validateRemoteOSArg()) {
                return false;
            }
            System.setProperty("remoteInstallPath", WSProfileDataStore.getFlowControllingArgumentValue("remoteInstallPath"));
            System.setProperty("remoteHostName", WSProfileDataStore.getFlowControllingArgumentValue("remoteHostName"));
            System.setProperty("remoteUserName", WSProfileDataStore.getFlowControllingArgumentValue("remoteUserName"));
            System.setProperty("remotePassword", WSProfileDataStore.getFlowControllingArgumentValue("remotePassword"));
        }
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    private boolean validateRemoteArgsAreSet() {
        LOGGER.entering(S_CLASS_NAME, "validateArgsAreSet");
        if (!(this.validateArgIsSet("remoteInstallPath") && this.validateArgIsSet("remoteHostName") && this.validateArgIsSet("remoteUserName") && this.validateArgIsSet("remotePassword") && this.validateArgIsSet("remoteOS"))) {
            LOGGER.exiting(S_CLASS_NAME, "validateArgsAreSet");
            return false;
        }
        LOGGER.exiting(S_CLASS_NAME, "validateArgsAreSet");
        return true;
    }

    private boolean validateArgIsSet(String key) {
        LOGGER.entering(S_CLASS_NAME, "validateArgIsSet");
        String value = WSProfileDataStore.getFlowControllingArgumentValue(key);
        if (value == null) {
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_ARG_REQUIRED, key));
            LOGGER.exiting(S_CLASS_NAME, "validateArgIsSet");
            return false;
        }
        if (value.equals("")) {
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_ARG_CANNOT_BE_EMPTY, key));
            LOGGER.exiting(S_CLASS_NAME, "validateArgIsSet");
            return false;
        }
        LOGGER.exiting(S_CLASS_NAME, "validateArgIsSet");
        return true;
    }

    private boolean validateRemoteOSArg() {
        LOGGER.entering(S_CLASS_NAME, "validateRemoteOSArg");
        if (TargetPlatform.getPlatform().equals((Object)TargetPlatform.Platform.UNKNOWN)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("remoteOS");
            params.add(WSProfileDataStore.getFlowControllingArgumentValue("remoteOS"));
            params.add(TargetPlatform.getValidPlatforms());
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_ARG_VALUE_NOT_RECOGNIZED, params.toArray(new String[params.size()])));
            LOGGER.exiting(S_CLASS_NAME, "validateRemoteOSArg");
            return false;
        }
        LOGGER.exiting(S_CLASS_NAME, "validateRemoteOSArg");
        return true;
    }

    private boolean validateRemoteArg() {
        LOGGER.entering(S_CLASS_NAME, "validateRemoteArg");
        if (CurrentEnvironment.getEnvironment().equals((Object)Environment.UNKNOWN) || CurrentEnvironment.getEnvironment().equals((Object)Environment.LOCAL)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("remote");
            params.add(WSProfileDataStore.getFlowControllingArgumentValue("remote"));
            params.add("connected" + S_COMMA + S_SPACE + "disconnected");
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_ARG_VALUE_NOT_RECOGNIZED, params.toArray(new String[params.size()])));
            LOGGER.exiting(S_CLASS_NAME, "validateRemoteArg");
            return false;
        }
        LOGGER.exiting(S_CLASS_NAME, "validateRemoteArg");
        return true;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        String[] saSpecifiedArgs = WSProfileDataStore.getIncomingArgsAsArray();
        if (saSpecifiedArgs == null || saSpecifiedArgs.length < 1) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            OutputStreamHandler.init();
            WSProfileCLIModeInvoker.doHelpMode(new String[0]);
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return true;
    }
}

