/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.processing.preprocessing;

import com.ibm.ws.install.configmanager.logging.LoggerContext;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.datastore.WSProfileJobGroupData;
import com.ibm.ws.profile.processing.WSProfileProcessorTask;
import com.ibm.ws.profile.utils.WSProfileUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogReInitializerPreProcessorTask
extends WSProfileProcessorTask {
    private static Logger LOGGER = LoggerFactory.createLogger(LogReInitializerPreProcessorTask.class);
    private static String S_CLASS_NAME = LogReInitializerPreProcessorTask.class.getName();

    public boolean runProcessor() throws Throwable {
        LOGGER.entering(S_CLASS_NAME, "runProcessor");
        WSProfileJobGroupData wspjgdFirstJobGroup = WSProfileDataStore.getJobGroup(0);
        String[] asRealArgs = wspjgdFirstJobGroup == null ? WSProfileDataStore.getIncomingArgsAsArray() : wspjgdFirstJobGroup.getCurrentArgsAsArray();
        LoggerContext lc = WSProfileDataStore.getCurrentLoggerContext();
        WSProfileUtils.reInitializeLogger(asRealArgs, lc);
        LOGGER.exiting(S_CLASS_NAME, "runProcessor");
        return true;
    }

    public boolean checkPreconditions() {
        LOGGER.entering(S_CLASS_NAME, "checkPreconditions");
        WSProfileJobGroupData wspjgdFirstJobGroup = WSProfileDataStore.getJobGroup(0);
        if (wspjgdFirstJobGroup == null) {
            if (WSProfileDataStore.getIncomingArgsAsArray() == null || WSProfileDataStore.getIncomingArgsAsArray().length == 0) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
                LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
                return false;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return true;
        }
        if (wspjgdFirstJobGroup.getCurrentArgsAsArray() == null || wspjgdFirstJobGroup.getCurrentArgsAsArray().length == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = false");
            LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
            return false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "checkPreconditions", "checkPreconditions = true");
        LOGGER.exiting(S_CLASS_NAME, "checkPreconditions");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(S_CLASS_NAME, "doIRun");
        WSProfileCLIModeInvoker wspclimiIncoming = WSProfileDataStore.getIncomingModeInvoker();
        Map<String, List> mapIncomingArgs = WSProfileDataStore.getIncomingArgsAsMap();
        if (WSProfileDataStore.isHelpRequested()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = false");
            LOGGER.exiting(S_CLASS_NAME, "doIRun");
            return false;
        }
        if (WSProfileDataStore.getJobGroup(0) != null) {
            WSProfileCLIModeInvoker wspclimiForFirstJob = WSProfileDataStore.getJobGroup(0).getCurrentModeInvoker();
            Map<String, List> mapFirstJobArgs = WSProfileDataStore.getJobGroup(0).getCurrentArgsAsMap();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = " + WSProfileUtils.isLogReInitializationNecessary(mapIncomingArgs, mapFirstJobArgs, wspclimiIncoming, wspclimiForFirstJob));
            LOGGER.exiting(S_CLASS_NAME, "doIRun");
            return WSProfileUtils.isLogReInitializationNecessary(mapIncomingArgs, mapFirstJobArgs, wspclimiIncoming, wspclimiForFirstJob);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "doIRun = true");
        LOGGER.exiting(S_CLASS_NAME, "doIRun");
        return false;
    }
}

