/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileCLIUnregisterProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = false;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("unregister", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_REGISTRY_CORRUPT_OR_INVALID_PATHS = "WSProfile.WSProfileCLIUnregisterProfileInvoker.registryCorruptOrInvalidProfile";
    private static final String S_SUCCESS_KEY = "WSProfile.WSProfileCLIUnregisterProfileInvoker.successMessage";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIUnregisterProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIUnregisterProfileInvoker.class.getName();

    @Override
    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "unregister";
    }

    @Override
    public void printOutExecutionResult(int nReturnCode, Map<String, List> mapArgs) {
        if (nReturnCode == 0) {
            String sExecutionMessage = ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath());
            if (!sExecutionMessage.equals(S_SUCCESS_KEY)) {
                OutputStreamHandler.println(sExecutionMessage);
            } else {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, sExecutionMessage, "A message for the key WSProfile.WSProfileCLIUnregisterProfileInvoker.successMessage does not exist in the resource bundle.");
            }
        }
    }

    @Override
    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String sProfileName = this.getArgumentValue("profileName");
        int nReturnCode = 0;
        try {
            WSProfile.unregister(sProfileName, this.getProfileRegistryPath());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY, sProfileName));
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_SUCCESS_KEY, sProfileName));
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
            OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_REGISTRY_CORRUPT_OR_INVALID_PATHS, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    @Override
    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector<CommandLineArgument> vclaRet = new Vector<CommandLineArgument>(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    @Override
    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }

    @Override
    public boolean isPublicMode() {
        return this.fIsPublic;
    }
}

