/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.WSProfileJob;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileCLIUnaugmentProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("unaugment", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("ignoreStack", V_EMPTY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("templatePath", V_SINGLE_ENTRY_VECTOR, false, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final String S_NO_TEMPLATE_FOUND_KEY = "WSProfile.WSProfileTemplate.templateNotFound";
    private static final String S_TEMPLATE_IS_NOT_ATTOP_OF_STACK = "WSProfile.WSProfileTemplate.templateNotAtTopOFStack";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIUnaugmentProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIUnaugmentProfileInvoker.class.getName();

    public WSProfileCLIUnaugmentProfileInvoker() {
        this.S_SUCCESS_KEY = "WSProfile.WSProfileCLIUnaugmentProfileInvoker.successMessage";
        this.S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIUnaugmentProfileInvoker.partialSuccessMessage";
        this.S_FAILURE_KEY = "WSProfile.WSProfileCLIUnaugmentProfileInvoker.failureMessage";
    }

    @Override
    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "unaugment";
    }

    @Override
    public boolean isTemplateStackRequired() {
        LOGGER.entering(this.getClass().getName(), "isTemplateStackRequired");
        LOGGER.exiting(this.getClass().getName(), "isTemplateStackRequired");
        return true;
    }

    @Override
    public boolean isValidationAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isValidationAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isValidationAllowed");
        return true;
    }

    @Override
    public Map<String, List> generateJobArgs(Map<String, List> mJobGroupArgs, List<WSProfileTemplate> lwsptTemplateStack, int nJobNumber) {
        LOGGER.entering(this.getClass().getName(), "generateJobArgs");
        Map<String, List> mBrokenDownArgs = WSProfileUtils.cloneMap(mJobGroupArgs);
        if (WSProfileDataStore.isArgSpecified("ignoreStack") || WSProfileDataStore.getFlowControllingModeInvoker().getModeFlag().equals("unaugmentAll")) {
            mBrokenDownArgs.put("ignoreStack", new Vector());
        }
        LOGGER.exiting(this.getClass().getName(), "generateJobArgs");
        return super.generateJobArgs(mBrokenDownArgs, lwsptTemplateStack, nJobNumber);
    }

    @Override
    public List<WSProfileJob> generateJobsForMode(Map<String, List> mJobGroupArgs, List<WSProfileTemplate> lwsptTemplateStack) {
        LOGGER.entering(this.getClass().getName(), "generateJobsForMode");
        Vector<WSProfileJob> lwspjFromGroup = new Vector();
        if (WSProfileDataStore.getFlowControllingModeInvoker().getModeFlag().equals("unaugmentAll")) {
            for (int i = lwsptTemplateStack.size() - 1; i >= 0; --i) {
                lwspjFromGroup.add(new WSProfileJob(this.generateJobArgs(mJobGroupArgs, lwsptTemplateStack, i)));
            }
        } else {
            lwspjFromGroup = super.generateJobsForMode(mJobGroupArgs, lwsptTemplateStack);
        }
        LOGGER.entering(this.getClass().getName(), "generateJobsForMode");
        return lwspjFromGroup;
    }

    @Override
    public boolean isPublicMode() {
        return this.fIsPublic;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int executeWSProfileAccordingToMode() {
        int nReturnCode;
        block12: {
            LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
            String sProfileName = this.getArgumentValue("profileName");
            String sTemplatePath = this.getArgumentValue("templatePath");
            String sIgnoreStack = this.getArgumentValue("ignoreStack");
            nReturnCode = 1;
            try {
                if (sTemplatePath != null) {
                    new WSProfileTemplate(sTemplatePath);
                }
            }
            catch (WSProfileException wspe) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle", Locale.getDefault(), Thread.currentThread().getContextClassLoader());
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getResourceBundleLocaleString(S_NO_TEMPLATE_FOUND_KEY, sTemplatePath, resourceBundle));
                OutputStreamHandler.println(ResourceBundleUtils.getResourceBundleLocaleString(S_NO_TEMPLATE_FOUND_KEY, sTemplatePath, resourceBundle));
                return 1;
            }
            try {
                if (sTemplatePath != null && sIgnoreStack != null) {
                    nReturnCode = WSProfile.unaugment(sProfileName, new File(sTemplatePath), CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
                    break block12;
                }
                if (sTemplatePath != null && sIgnoreStack == null) {
                    WSProfileTemplate wspt;
                    List listOfAugments = WSProfile.getAllAugmentationProfileTemplates(sProfileName);
                    if (listOfAugments.lastIndexOf(wspt = new WSProfileTemplate(sTemplatePath)) != listOfAugments.size() - 1) {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle", Locale.getDefault(), Thread.currentThread().getContextClassLoader());
                        String[] args = new String[]{sTemplatePath, sProfileName};
                        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getResourceBundleLocaleString(S_TEMPLATE_IS_NOT_ATTOP_OF_STACK, args, resourceBundle));
                        OutputStreamHandler.println(ResourceBundleUtils.getResourceBundleLocaleString(S_TEMPLATE_IS_NOT_ATTOP_OF_STACK, args, resourceBundle));
                        return 1;
                    }
                    nReturnCode = WSProfile.unaugment(sProfileName, CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
                } else {
                    nReturnCode = WSProfile.unaugment(sProfileName, CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
                }
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
                nReturnCode = 1;
            }
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    @Override
    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String sProfileName = this.getArgumentValue("profileName");
        String sTemplatePath = this.getArgumentValue("templatePath");
        if (sProfileName != null) {
            try {
                Vector<WSProfileTemplate> v_augmentors = new Vector<WSProfileTemplate>(WSProfile.getProfile(sProfileName, this.getProfileRegistryPath()).getAugmentationTemplates());
                if (v_augmentors.size() != 0) {
                    if (sTemplatePath == null) {
                        sTemplatePath = v_augmentors.get(v_augmentors.size() - 1).getProfileTemplatePath().getPath();
                    }
                    System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sTemplatePath, "deleteRegistry.xml").getAbsolutePath());
                    List listclaRequired = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(sTemplatePath));
                    vclaRet = this.mergeCommandLineArgs(vclaRet, listclaRequired);
                }
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    @Override
    protected Vector getListOfOptionalCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String sProfileName = this.getArgumentValue("profileName");
        String sTemplatePath = this.getArgumentValue("templatePath");
        if (sProfileName != null) {
            try {
                Vector<WSProfileTemplate> v_augmentors = new Vector<WSProfileTemplate>(WSProfile.getProfile(sProfileName, this.getProfileRegistryPath()).getAugmentationTemplates());
                if (v_augmentors.size() != 0) {
                    if (sTemplatePath == null) {
                        sTemplatePath = v_augmentors.get(v_augmentors.size() - 1).getProfileTemplatePath().getPath();
                    }
                    System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sTemplatePath, "deleteRegistry.xml").getAbsolutePath());
                    List listclaOptional = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(sTemplatePath));
                    vclaRet = this.mergeCommandLineArgs(vclaRet, listclaOptional);
                }
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    @Override
    public String getRegistryName() {
        return "deleteRegistry.xml";
    }
}

